/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing;

import com.paterva.maltego.typing.FormatAdapter;
import com.paterva.maltego.typing.convert.DefaultStringConverter;
import com.paterva.maltego.typing.convert.StringConverter;
import com.paterva.maltego.util.StringUtilities;
import java.text.Format;

public class TypeDescriptor {
    private String _typeName;
    private Class _class;
    private StringConverter _converter;
    private Object _defaultValue;
    private FormatAdapter _formatAdapter;

    public TypeDescriptor(String typeName, Class clazz) {
        this(typeName, clazz, null);
    }

    public TypeDescriptor(String typeName, Class clazz, Object defaultValue) {
        this(typeName, clazz, null, defaultValue);
    }

    public TypeDescriptor(String typeName, Class clazz, StringConverter converter) {
        this(typeName, clazz, converter, null);
    }

    public TypeDescriptor(String typeName, Class clazz, StringConverter converter, Object defaultValue) {
        this._typeName = typeName;
        this._class = clazz;
        this._converter = converter != null ? converter : DefaultStringConverter.instance();
        this._defaultValue = defaultValue;
    }

    public String getTypeName() {
        return this._typeName;
    }

    public Class getType() {
        return this._class;
    }

    public StringConverter getConverter() {
        return this._converter;
    }

    public Object getDefaultValue() {
        return this._defaultValue;
    }

    public boolean isArrayType() {
        return this._class.isArray();
    }

    public Class getComponentType() {
        if (this.isArrayType()) {
            return this._class.getComponentType();
        }
        return this.getType();
    }

    public Object convert(String value) throws IllegalArgumentException {
        return this.getConverter().convertFrom(value, this.getType());
    }

    public String convert(Object value) {
        if (value == null) {
            value = this.getDefaultValue();
        }
        if (value == null) {
            return null;
        }
        String converted = this.getConverter().convertTo(value, this.getType());
        converted = StringUtilities.escapeRTLBidiText((String)converted);
        return converted;
    }

    public Format getFormat(String formatString) {
        if (this._formatAdapter != null) {
            return this.getFormatAdapter().getFormat(formatString);
        }
        return null;
    }

    public String getFormatString(Format format) {
        if (this._formatAdapter != null) {
            return this.getFormatAdapter().getFormatString(format);
        }
        return null;
    }

    public FormatAdapter getFormatAdapter() {
        return this._formatAdapter;
    }

    public void setFormatAdapter(FormatAdapter formatAdapter) {
        this._formatAdapter = formatAdapter;
    }

    public String toString() {
        return this.getTypeName();
    }
}

