/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.provider.mappersync;

import java.util.Map;
import java.util.function.Consumer;
import org.jboss.logging.Logger;
import org.keycloak.broker.provider.mappersync.ConfigSynchronizer;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.utils.StringUtil;

public abstract class AbstractConfigPropertySynchronizer<T extends ProviderEvent>
implements ConfigSynchronizer<T> {
    private static final Logger LOG = Logger.getLogger(AbstractConfigPropertySynchronizer.class);

    protected abstract String getConfigPropertyName();

    protected abstract void updateConfigPropertyIfNecessary(T var1, String var2, Consumer<String> var3);

    @Override
    public final void handleEvent(T event, IdentityProviderMapperModel idpMapper) {
        Map config = idpMapper.getConfig();
        if (config == null) {
            return;
        }
        String configPropertyName = this.getConfigPropertyName();
        String configuredValue = (String)config.get(configPropertyName);
        if (StringUtil.isBlank((String)configuredValue)) {
            return;
        }
        Consumer<String> propertyUpdater = value -> config.put(configPropertyName, value);
        this.updateConfigPropertyIfNecessary(event, configuredValue, propertyUpdater);
        String newConfiguredValue = (String)config.get(configPropertyName);
        if (!configuredValue.equals(newConfiguredValue)) {
            RealmModel realm = this.extractRealm(event);
            LOG.infof("Reference of type '%s' changed from '%s' to '%s' in realm '%s'. Adjusting the reference from mapper '%s' of IDP '%s'.", new Object[]{configPropertyName, configuredValue, newConfiguredValue, realm.getName(), idpMapper.getName(), idpMapper.getIdentityProviderAlias()});
            realm.updateIdentityProviderMapper(idpMapper);
        }
    }
}

