/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.transactions.properties;

import com.paterva.maltego.core.GraphEntity;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.GraphLink;
import com.paterva.maltego.core.GraphPart;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.editing.UnsupportedEditorException;
import com.paterva.maltego.typing.editing.propertygrid.editors.DefaultPropertyFactory;
import com.paterva.maltego.ui.graph.transactions.properties.TransactionEntityProperty;
import com.paterva.maltego.ui.graph.transactions.properties.TransactionLinkProperty;
import com.paterva.maltego.ui.graph.transactions.properties.TransactionProperty;
import com.paterva.maltego.ui.graph.transactions.properties.TransactionPropertyBatcher;
import org.openide.nodes.Node;

public class TransactionPropertyFactory
extends DefaultPropertyFactory {
    private final TransactionPropertyBatcher _batcher;

    public TransactionPropertyFactory(GraphID graphID) {
        this._batcher = new TransactionPropertyBatcher(graphID);
    }

    public Node.Property<?> createProperty(DisplayDescriptor descriptor, DataSource data) throws UnsupportedEditorException {
        TransactionProperty property = super.createProperty(descriptor, data);
        GraphPart part = GraphStoreHelper.getPart((DataSource)data);
        if (part != null) {
            if (part instanceof GraphEntity) {
                MaltegoEntity entity = GraphStoreHelper.getEntity((GraphEntity)((GraphEntity)part));
                property = new TransactionEntityProperty(property, entity, (PropertyDescriptor)descriptor, this._batcher);
            } else if (part instanceof GraphLink) {
                MaltegoLink link = GraphStoreHelper.getLink((GraphLink)((GraphLink)part));
                property = new TransactionLinkProperty(property, link, (PropertyDescriptor)descriptor, this._batcher);
            }
        } else if (data instanceof MaltegoEntity) {
            property = new TransactionEntityProperty(property, (MaltegoEntity)data, (PropertyDescriptor)descriptor, this._batcher);
        } else if (data instanceof MaltegoLink) {
            property = new TransactionLinkProperty(property, (MaltegoLink)data, (PropertyDescriptor)descriptor, this._batcher);
        }
        return property;
    }
}

