/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.archive.mtz.GraphFileType;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import com.paterva.maltego.util.FileExtensionFileFilter;
import java.awt.HeadlessException;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.openide.ErrorManager;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.WindowManager;

public final class FileOpenAction
extends CallableSystemAction {
    public FileOpenAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public void performAction() {
        FileChooserBuilder chooserBuilder = new FileChooserBuilder(GraphDataObject.class).setTitle("Open graph");
        chooserBuilder.setFileFilter((FileFilter)new FileExtensionFileFilter(GraphFileType.getAllExtensions(), "Maltego graph files"));
        File[] files = this.showMultiOpenDialog(chooserBuilder);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                FileOpenAction.open(files[i]);
            }
        }
    }

    private File[] showMultiOpenDialog(FileChooserBuilder chooserBuilder) throws HeadlessException {
        File[] files = null;
        JFileChooser chooser = chooserBuilder.createFileChooser();
        chooser.setMultiSelectionEnabled(true);
        int result = chooser.showOpenDialog(WindowManager.getDefault().getMainWindow());
        if (0 == result) {
            files = chooser.getSelectedFiles();
        }
        return files;
    }

    public static void open(File f) {
        FileObject fob = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)f));
        if (fob == null) {
            return;
        }
        try {
            DataObject dob = DataObject.find((FileObject)fob);
            OpenCookie oc = (OpenCookie)dob.getCookie(OpenCookie.class);
            if (oc != null) {
                oc.open();
            }
        }
        catch (DataObjectNotFoundException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    public String getName() {
        return "Open";
    }

    protected String iconResource() {
        return "com/paterva/maltego/ui/graph/actions/Open.png";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

