/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.archive.mtz;

import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.archive.mtz.MaltegoWriter;
import com.paterva.maltego.archive.mtz.MtzVersion;
import com.paterva.maltego.archive.mtz.MtzVersionEntry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class MaltegoBackupWriter
implements MaltegoWriter {
    private final Set<String> _entries = new HashSet<String>();
    private final File backupDirectory;
    private final BackupInterrupt interrupt;

    public MaltegoBackupWriter(File backupDirectory, MtzVersion version, BackupInterrupt interrupt) throws IOException {
        this.backupDirectory = backupDirectory;
        this.interrupt = interrupt;
        this.writeVersion(version);
    }

    @Override
    public <T> void write(Entry<T> entry) throws BackupInterruptedException, IOException {
        this.interrupt.checkInterrupted();
        String name = entry.getName();
        if (!this._entries.contains(name)) {
            this.writeToFile(entry);
            this._entries.add(name);
        }
    }

    private <T> void writeToFile(Entry<T> entry) throws IOException {
        File folder = new File(this.backupDirectory, entry.getFolder());
        folder.mkdirs();
        try (FileOutputStream fos = new FileOutputStream(new File(this.backupDirectory, entry.getName()));){
            entry.write(entry.getData(), fos);
        }
    }

    private void writeVersion(MtzVersion version) throws IOException {
        this.write(new MtzVersionEntry(version));
    }

    @Override
    public void close() throws IOException {
    }

    public static class BackupInterruptedException
    extends IOException {
    }

    public static interface BackupInterrupt {
        public void checkInterrupted() throws BackupInterruptedException;
    }
}

