/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.graph.state;

import com.paterva.maltego.chatapi.conn.ConnectionInitiationCallback;
import com.paterva.maltego.collab.CollaborationException;
import com.paterva.maltego.collab.graph.state.AbstractState;
import com.paterva.maltego.util.NormalException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractStateMachine<TState extends AbstractState, TException extends Exception> {
    private static final Logger LOGGER = Logger.getLogger(AbstractStateMachine.class.getName());
    private ConnectionInitiationCallback _cb;
    private final Object _waitLock = new String();
    private TState _next;
    private TState _current;
    private TState _previous;
    private boolean _busy = false;
    private TException _lastError;
    private AtomicBoolean _done = new AtomicBoolean(true);
    private AtomicBoolean _stateMachineRunning = new AtomicBoolean(false);

    public AbstractStateMachine(TState start) {
        this._current = start;
    }

    protected abstract void handleException(Exception var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean run(TState start, ConnectionInitiationCallback cb) throws TException {
        if (this._stateMachineRunning.compareAndSet(false, true)) {
            try {
                this._done.set(false);
                this._cb = cb;
                this._lastError = null;
                try {
                    this.setNextState(start);
                    this.debug("State machine running - waiting");
                    Object object = this._waitLock;
                    synchronized (object) {
                        while (!this._done.get()) {
                            this._waitLock.wait();
                        }
                    }
                    this.debug("State machine run completed");
                    if (this._lastError != null && !this._cb.isCancelled()) {
                        TException e = this._lastError;
                        throw e;
                    }
                }
                catch (InterruptedException ex) {
                    this.debug("Interrupted exception, user cancelled");
                }
            }
            finally {
                this._done.set(true);
                this._stateMachineRunning.set(false);
            }
        }
        return !cb.isCancelled();
    }

    synchronized void setNextState(TState state) {
        if (this._lastError == null && this._cb.isCancelled() && !((AbstractState)state).isEndState()) {
            this.handleException((Exception)((Object)new CollaborationException("User cancelled", false)));
        } else {
            this.debug("setting next state to " + this.getName(state));
            this._next = state;
            if (this._lastError != null || !this._busy) {
                TState next = this._next;
                this._next = null;
                this.runState(next);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void runState(TState state) {
        try {
            this._busy = true;
            do {
                this._next = null;
                if (this._current != null) {
                    ((AbstractState)this._current).deinit();
                }
                this._previous = this._current;
                this._current = state;
                ((AbstractState)state).setStateMachine(this);
                this.onStateChanged(this._previous, this._current);
                this.debug("running state");
                try {
                    ((AbstractState)state).run();
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
                state = this._next;
            } while (this._next != null);
            this._busy = false;
        }
        finally {
            if (((AbstractState)this._current).isEndState()) {
                Object object = this._waitLock;
                synchronized (object) {
                    this._done.set(true);
                    this._waitLock.notifyAll();
                }
            }
        }
    }

    public synchronized TState getCurrentState() {
        return this._current;
    }

    protected synchronized void handleError(TException e, TState errorState) {
        if (this._lastError == null) {
            this.debug(String.format("handling error: %s - %s", e.getClass().getSimpleName(), ((Throwable)e).getMessage()));
            this._lastError = e;
        } else {
            this.debug(String.format("A new error was set while already dealing with %s. New error: %s", this._lastError.getClass().getSimpleName(), ((Throwable)e).toString()));
        }
        if (this._cb == null || !this._cb.isCancelled()) {
            NormalException.showStackTrace(e);
        } else {
            LOGGER.log(Level.INFO, ((Throwable)e).getMessage(), (Throwable)e);
        }
        this.setNextState(errorState);
    }

    ConnectionInitiationCallback getCallback() {
        return this._cb;
    }

    void debug(String message) {
        String machine = this.getClass().getSimpleName();
        String state = this.getName(this.getCurrentState());
        this.getCallback().debug(String.format("%s-%s: %s", machine, state, message));
    }

    private String getName(TState state) {
        return state == null ? "null" : state.getClass().getSimpleName();
    }

    protected void onStateChanged(TState previous, TState current) {
    }
}

