/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager.sets;

import com.paterva.maltego.transform.descriptor.TransformSet;
import com.paterva.maltego.transform.descriptor.TransformSetRepository;
import com.paterva.maltego.transform.manager.sets.TransformSetFormController;
import com.paterva.maltego.util.ui.dialog.EditDialogDescriptor;
import java.awt.Component;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public class EditTransformSetAction
extends NodeAction {
    protected void performAction(Node[] nodes) {
        TransformSet set;
        if (nodes.length == 1 && !(set = (TransformSet)nodes[0].getLookup().lookup(TransformSet.class)).isReadOnly()) {
            EditDialogDescriptor descriptor = new EditDialogDescriptor(new WizardDescriptor.Panel[]{new TransformSetFormController()});
            descriptor.setTitleFormat(new MessageFormat("Edit Transform Set"));
            descriptor.putProperty("editMode", (Object)Boolean.TRUE);
            descriptor.putProperty("setRepository", (Object)TransformSetRepository.getDefault());
            descriptor.putProperty("setName", (Object)set.getName());
            descriptor.putProperty("setDescription", (Object)set.getDescription());
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == EditDialogDescriptor.FINISH_OPTION) {
                set.setDescription((String)descriptor.getProperty("setDescription"));
                TransformSetRepository.getDefault().put(set);
            }
        }
    }

    protected boolean enable(Node[] nodes) {
        if (nodes.length == 1) {
            TransformSet set = (TransformSet)nodes[0].getLookup().lookup(TransformSet.class);
            return set != null && !set.isReadOnly();
        }
        return false;
    }

    public String getName() {
        return "Edit...";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected String iconResource() {
        return "com/paterva/maltego/transform/manager/sets/EditTransformSet.png";
    }

    public Component getToolbarPresenter() {
        Component c = super.getToolbarPresenter();
        if (c instanceof AbstractButton) {
            ((AbstractButton)c).setText(this.getName());
        }
        return c;
    }
}

