/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.treelist;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.runregistry.item.AbstractRunCategoryItem;
import com.paterva.maltego.runregistry.item.RunProviderItem;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.manager.api.TransformManager;
import com.paterva.maltego.transform.runner.TransformRequestProcessor;
import com.paterva.maltego.transform.runner.api.TransformRunOrigin;
import com.paterva.maltego.transform.runner.treelist.RunWithAllFilter;
import com.paterva.maltego.transform.runner.treelist.TransformRunItem;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TransformSetItem
extends AbstractRunCategoryItem {
    private final String _name;
    private final String _displayName;
    private final List<TransformRunItem> _children;
    private final boolean _hasSettings;
    private final String _lafPrefix;
    private final boolean _isRunnable;

    public TransformSetItem(String name, String displayName, List<TransformRunItem> children, boolean hasSettings) {
        this(name, displayName, children, hasSettings, null);
    }

    public TransformSetItem(String name, String displayName, List<TransformRunItem> children, boolean hasSettings, String lafPrefix) {
        this(name, displayName, children, hasSettings, lafPrefix, true);
    }

    public TransformSetItem(String name, String displayName, List<TransformRunItem> children, boolean hasSettings, String lafPrefix, boolean runnable) {
        this._name = name;
        this._displayName = displayName;
        this._children = children;
        this._hasSettings = hasSettings;
        this._lafPrefix = lafPrefix != null ? lafPrefix : "transforms-item-set";
        this._isRunnable = runnable;
    }

    public List<? extends RunProviderItem> getChildren() {
        return Collections.unmodifiableList(this._children);
    }

    public String getName() {
        return "transformset." + this._name;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public String getLafPrefix() {
        return this._lafPrefix;
    }

    public boolean hasSettings() {
        return this._hasSettings;
    }

    public void showSettings() {
        TransformManager.getDefault().openSet(this._name);
    }

    public boolean canRun() {
        return this._isRunnable;
    }

    public void run(GraphID graphID, Set<EntityID> entities) {
        if (!entities.isEmpty()) {
            Set<TransformDefinition> transforms = this.getTransforms();
            if (!(transforms = RunWithAllFilter.filter(transforms)).isEmpty()) {
                TransformRequestProcessor.getDefault().runTransforms(transforms, null, graphID, entities, true, TransformRunOrigin.fromSetRun((String)this._name));
            }
        }
    }

    Set<TransformDefinition> getTransforms() {
        HashSet<TransformDefinition> transforms = new HashSet<TransformDefinition>();
        for (TransformRunItem transformRunItem : this._children) {
            TransformDefinition transform = transformRunItem.getTransform();
            if (transform == null) continue;
            transforms.add(transform);
        }
        return transforms;
    }
}

