/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.config;

import flex.messaging.config.ConfigurationException;

public class ThrottleSettings {
    public static final int POLICY_NONE = 0;
    public static final int POLICY_ERROR = 1;
    public static final int POLICY_IGNORE = 2;
    public static final int POLICY_REPLACE = 3;
    public static final String POLICY_NONE_STRING = "NONE";
    public static final String POLICY_ERROR_STRING = "ERROR";
    public static final String POLICY_IGNORE_STRING = "IGNORE";
    public static final String POLICY_REPLACE_STRING = "REPLACE";
    public static final String ELEMENT_INBOUND = "throttle-inbound";
    public static final String ELEMENT_OUTBOUND = "throttle-outbound";
    public static final String ELEMENT_POLICY = "policy";
    public static final String ELEMENT_DEST_FREQ = "max-frequency";
    public static final String ELEMENT_CLIENT_FREQ = "max-client-frequency";
    private String destinationName;
    private int inClientMessagesPerSec = 0;
    private int inDestinationMessagesPerSec = 0;
    private int outClientMessagesPerSec;
    private int outDestinationMessagesPerSec = 0;
    private int inPolicy = 0;
    private int outPolicy = 0;

    public int parsePolicy(String s) {
        int n;
        if (s.equalsIgnoreCase(POLICY_IGNORE_STRING)) {
            n = 2;
        } else if (s.equalsIgnoreCase(POLICY_ERROR_STRING)) {
            n = 1;
        } else if (s.equalsIgnoreCase(POLICY_REPLACE_STRING)) {
            n = 3;
        } else {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage("Unsupported throttle policy '" + s + "'");
            throw ex;
        }
        return n;
    }

    public boolean isClientThrottleEnabled() {
        return this.getIncomingClientFrequency() > 0 || this.getOutgoingClientFrequency() > 0;
    }

    public boolean isDestinationThrottleEnabled() {
        return this.getIncomingDestinationFrequency() > 0 || this.getOutgoingDestinationFrequency() > 0;
    }

    public int getInboundPolicy() {
        return this.inPolicy;
    }

    public void setInboundPolicy(int inPolicy) {
        if (inPolicy == 3) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage("The REPLACE throttle policy applies to outbound throttling only");
            throw ex;
        }
        this.inPolicy = inPolicy;
    }

    public int getOutboundPolicy() {
        return this.outPolicy;
    }

    public void setOutboundPolicy(int outPolicy) {
        this.outPolicy = outPolicy;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public int getIncomingClientFrequency() {
        return this.inClientMessagesPerSec;
    }

    public void setIncomingClientFrequency(int n) {
        this.inClientMessagesPerSec = n;
    }

    public int getIncomingDestinationFrequency() {
        return this.inDestinationMessagesPerSec;
    }

    public void setIncomingDestinationFrequency(int n) {
        this.inDestinationMessagesPerSec = n;
    }

    public int getOutgoingClientFrequency() {
        return this.outClientMessagesPerSec;
    }

    public void setOutgoingClientFrequency(int n) {
        this.outClientMessagesPerSec = n;
    }

    public int getOutgoingDestinationFrequency() {
        return this.outDestinationMessagesPerSec;
    }

    public void setOutgoingDestinationFrequency(int n) {
        this.outDestinationMessagesPerSec = n;
    }
}

