/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.terminal.util;

import com.jsql.util.LogLevelUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockCaret
extends DefaultCaret {
    private static final Logger LOGGER = LogManager.getRootLogger();

    public BlockCaret() {
        this.setBlinkRate(500);
    }

    @Override
    protected synchronized void damage(Rectangle r) {
        if (r == null) {
            return;
        }
        this.x = r.x;
        this.y = r.y;
        this.height = r.height;
        if (this.width <= 0) {
            this.width = this.getComponent().getWidth();
        }
        this.repaint();
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        char dotChar;
        JTextComponent comp = this.getComponent();
        if (comp == null) {
            return;
        }
        int dot = this.getDot();
        Rectangle r = null;
        try {
            if (comp.modelToView2D(dot) != null) {
                r = comp.modelToView2D(dot).getBounds();
            }
            dotChar = comp.getText(dot, 1).charAt(0);
        }
        catch (BadLocationException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
            return;
        }
        if (r == null) {
            return;
        }
        if (Character.isWhitespace(dotChar)) {
            dotChar = '_';
        }
        if (this.x != r.x || this.y != r.y) {
            this.damage(r);
            return;
        }
        g.setColor(new Color(0, 255, 0));
        g.setXORMode(comp.getBackground());
        this.width = g.getFontMetrics().charWidth(dotChar);
        if (this.isVisible()) {
            g.fillRect(r.x, r.y, this.width, r.height);
        }
    }
}

