/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.bean.database;

import com.jsql.model.bean.database.AbstractElementDatabase;
import com.jsql.util.LogLevelUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Database
extends AbstractElementDatabase {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private String tableCount;

    public Database(String databaseName, String tableCount) {
        this.elementValue = databaseName;
        this.tableCount = tableCount;
    }

    @Override
    public AbstractElementDatabase getParent() {
        return null;
    }

    @Override
    public int getChildCount() {
        return Integer.parseInt(this.tableCount);
    }

    @Override
    public String getLabelWithCount() {
        String sPlural = "";
        try {
            if (Integer.parseInt(this.tableCount) > 1) {
                sPlural = "s";
            }
        }
        catch (NumberFormatException e) {
            this.tableCount = "0";
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Incorrect number of tables for [{}].", (Object)this);
        }
        return String.format("%s (%s table%s)", this.elementValue, this.tableCount, sPlural);
    }
}

