/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.util;

import com.aspect.snoop.FunctionHook;
import com.aspect.snoop.MethodWrapper;
import com.aspect.snoop.agent.AgentLogger;
import com.aspect.snoop.agent.manager.InstrumentationManager;
import com.aspect.snoop.agent.manager.LocalVariable;
import com.aspect.snoop.agent.manager.MethodChanges;
import com.aspect.snoop.util.ReflectionUtil;
import com.aspect.snoop.util.Unwrapper;
import java.util.ArrayList;
import java.util.HashMap;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;

public class Hook2JavaUtil {
    public static HashMap<String, Unwrapper> unwrappers = new HashMap();

    public static MethodChanges hook2Java(FunctionHook hook, InstrumentationManager manager) {
        StringBuilder javaCode = new StringBuilder();
        ArrayList<LocalVariable> vars = new ArrayList<LocalVariable>();
        int id = hook.getId();
        String nl = System.getProperty("line.separator");
        javaCode.append(nl);
        if (hook.shouldPrintParameters()) {
            javaCode.append("  com.aspect.snoop.agent.SnoopAgent.getMainView().printParameters(\"" + hook.getClazz().getName() + "\", " + id + ", $args, $sig);");
            javaCode.append(nl);
        }
        if (hook.shouldPrintStackTrace()) {
            javaCode.append("  com.aspect.snoop.agent.SnoopAgent.getMainView().printStackTrace(\"" + hook.getClazz().getName() + "\", " + id + ", $args, $sig);");
            javaCode.append(nl);
        }
        if (hook.shouldPause()) {
            javaCode.append("  com.aspect.snoop.agent.SnoopAgent.getMainView().pause(\"" + hook.getClazz().getName() + "\", " + id + ", $args, $sig);");
            javaCode.append(nl);
        }
        if (hook.shouldTamperParameters()) {
            try {
                Object[] o = new Object[]{};
                ClassPool cp = ClassPool.getDefault();
                cp.appendClassPath((ClassPath)new ClassClassPath(o.getClass()));
                CtClass type = cp.get(o.getClass().getName());
                vars.add(new LocalVariable("mods", type));
                javaCode.append("  mods = com.aspect.snoop.agent.SnoopAgent.getMainView().tamperWithParameters(\"" + hook.getClazz().getName() + "\", " + id + ", $args, $sig);");
                javaCode.append(nl);
                int argLength = hook.getParameterTypes().length;
                for (int i = 0; i < argLength; ++i) {
                    String argType = hook.getParameterTypes()[i].getName();
                    Unwrapper w = unwrappers.get(argType);
                    if (w == null) {
                        argType = Hook2JavaUtil.getCastString(argType);
                    }
                    String line = w == null ? "  $" + (i + 1) + " = (" + argType + ")mods[" + i + "];" : "  $" + (i + 1) + " = " + w.prefix + "mods[" + i + "]" + w.suffix + ";";
                    line = line + nl;
                    javaCode.append(line);
                }
            }
            catch (NotFoundException ex) {
                // empty catch block
            }
        }
        MethodWrapper method = MethodWrapper.getWrapper(hook.getClazz(), hook.getMethodName(), hook.getParameterTypes());
        MethodChanges changes = new MethodChanges(method.getActualMethod());
        changes.initialize(vars.toArray(new LocalVariable[vars.size()]), javaCode.toString(), "");
        if (hook.shouldRunScript()) {
            changes.setNewStartSrc(changes.getNewStartSrc() + hook.getStartScript());
            changes.setNewEndSrc(changes.getNewEndSrc() + hook.getEndScript());
        }
        if (hook.shouldTamperReturnValue()) {
            String returnType = hook.getReturnType().getName();
            Unwrapper w = unwrappers.get(returnType);
            if (w == null) {
                returnType = Hook2JavaUtil.getCastString(returnType);
            }
            String line = null;
            line = w == null ? "  $_ = (" + returnType + ")com.aspect.snoop.agent.SnoopAgent.getMainView().tamperWithReturnValue(\"" + hook.getClazz().getName() + "\", " + id + ", $args, $sig, $_, $type);" : "  $_ = " + w.prefix + "com.aspect.snoop.agent.SnoopAgent.getMainView().tamperWithReturnValue(\"" + hook.getClazz().getName() + "\", " + id + ", $args, $sig, com.aspect.snoop.util.ReflectionUtil.getObjectFrom($_), $type)" + w.suffix + ";";
            changes.setNewEndSrc(changes.getNewEndSrc() + nl + line);
        }
        AgentLogger.debug("START: " + changes.getNewStartSrc());
        AgentLogger.debug("END: " + changes.getNewEndSrc());
        return changes;
    }

    public static String getCastString(String argType) {
        String toReturn = argType;
        if (ReflectionUtil.primitiveArrayMap.containsKey(argType)) {
            toReturn = ReflectionUtil.primitiveArrayMap.get(argType);
        } else if (argType.startsWith("[L")) {
            int len = argType.length() - 1;
            toReturn = argType.substring(2, len) + "[]";
        }
        return toReturn;
    }

    static {
        unwrappers.put("boolean", new Unwrapper("((Boolean)", ").booleanValue()"));
        unwrappers.put("byte", new Unwrapper("((Byte)", ").byteValue()"));
        unwrappers.put("char", new Unwrapper("((Character)", ").charValue()"));
        unwrappers.put("short", new Unwrapper("((Short)", ").shortValue()"));
        unwrappers.put("int", new Unwrapper("((Integer)", ").intValue()"));
        unwrappers.put("float", new Unwrapper("((Float)", ").floatValue()"));
        unwrappers.put("long", new Unwrapper("((Long)", ").longValue()"));
        unwrappers.put("double", new Unwrapper("((Double)", ").doubleValue()"));
    }
}

