/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.ui.choose.process;

import com.aspect.org.jdesktop.application.Action;
import com.aspect.org.jdesktop.application.Application;
import com.aspect.org.jdesktop.application.ApplicationActionMap;
import com.aspect.org.jdesktop.application.ResourceMap;
import com.aspect.snoop.JavaSnoop;
import com.aspect.snoop.SnoopSession;
import com.aspect.snoop.agent.manager.SmartURLClassPath;
import com.aspect.snoop.ui.choose.process.ClassesTreeCellRenderer;
import com.aspect.snoop.ui.choose.process.ClassesTreeModel;
import com.aspect.snoop.ui.choose.process.ClasspathEntry;
import com.aspect.snoop.ui.choose.process.ClasspathTreeCellRenderer;
import com.aspect.snoop.ui.choose.process.ClasspathTreeModel;
import com.aspect.snoop.ui.choose.process.SearchMainMethodsView;
import com.aspect.snoop.ui.choose.process.Util;
import com.aspect.snoop.util.SimpleFileFilter;
import com.aspect.snoop.util.UIUtil;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.util.List;
import javassist.ClassPath;
import javassist.ClassPool;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class NewProcessInfoView
extends JDialog {
    private static final Logger logger = Logger.getLogger(NewProcessInfoView.class);
    private static final String userDir = System.getProperty("user.dir");
    public static boolean quitResolving;
    ClasspathTreeModel classpath;
    ClassPool cp = new ClassPool();
    SimpleFileFilter fileFilter = new SimpleFileFilter("jar", "JAR Java Archives");
    File lastSelectedDir;
    SnoopSession model;
    private JButton btnAddEntry;
    private JButton btnCancel;
    private JButton btnRemoveEntry;
    private JButton btnSearch;
    private JButton btnStartProcess;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabelMainClass;
    private JPanel pnlClassesView;
    private JScrollPane pnlClasspath;
    private JScrollPane pnlClasspath1;
    private JPanel pnlClasspathView;
    private JPanel pnlExecutionInfo;
    private JPanel pnlGui;
    private JPanel pnlJarView;
    private JPanel pnlMainClass;
    private JTabbedPane tabClasspath;
    private JTree treeClasses;
    private JTree treeClasspath;
    private JTextField txtArguments;
    private JTextField txtGuiDelay;
    private JTextField txtJvmArguments;
    private JTextField txtMainClass;
    private JTextField txtWorkingDir;

    public NewProcessInfoView(Frame parent, boolean modal) {
        super(parent, modal);
        File dir;
        this.initComponents();
        this.classpath = new ClasspathTreeModel(new DefaultMutableTreeNode(null));
        this.treeClasspath.setCellRenderer(new ClasspathTreeCellRenderer());
        this.treeClasses.setCellRenderer(new ClassesTreeCellRenderer());
        String lastCpDir = JavaSnoop.getProperty("last_classpath_dir");
        if (lastCpDir != null && (dir = new File(lastCpDir)).exists() && dir.isDirectory()) {
            this.lastSelectedDir = dir;
        }
    }

    private void initComponents() {
        this.txtMainClass = new JTextField();
        this.pnlMainClass = new JPanel();
        this.btnSearch = new JButton();
        this.jLabelMainClass = new JLabel();
        this.pnlClasspathView = new JPanel();
        this.tabClasspath = new JTabbedPane();
        this.pnlJarView = new JPanel();
        this.btnRemoveEntry = new JButton();
        this.btnAddEntry = new JButton();
        this.pnlClasspath = new JScrollPane();
        this.treeClasspath = new JTree();
        this.jLabel4 = new JLabel();
        this.pnlClassesView = new JPanel();
        this.pnlClasspath1 = new JScrollPane();
        this.treeClasses = new JTree();
        this.pnlExecutionInfo = new JPanel();
        this.jLabel3 = new JLabel();
        this.txtWorkingDir = new JTextField();
        this.jLabel1 = new JLabel();
        this.txtArguments = new JTextField();
        this.jLabel2 = new JLabel();
        this.txtJvmArguments = new JTextField();
        this.btnStartProcess = new JButton();
        this.btnCancel = new JButton();
        this.pnlGui = new JPanel();
        this.jLabel5 = new JLabel();
        this.txtGuiDelay = new JTextField();
        this.jLabel6 = new JLabel();
        ResourceMap resourceMap = Application.getInstance(JavaSnoop.class).getContext().getResourceMap(NewProcessInfoView.class);
        this.txtMainClass.setText(resourceMap.getString("txtMainClass.text", new Object[0]));
        this.txtMainClass.setName("txtMainClass");
        this.setDefaultCloseOperation(2);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setName("Form");
        this.pnlMainClass.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("pnlMainClass.border.title", new Object[0])));
        this.pnlMainClass.setName("pnlMainClass");
        ApplicationActionMap actionMap = Application.getInstance(JavaSnoop.class).getContext().getActionMap(NewProcessInfoView.class, this);
        this.btnSearch.setAction(actionMap.get("searchForMainClasses"));
        this.btnSearch.setText(resourceMap.getString("btnSearch.text", new Object[0]));
        this.btnSearch.setToolTipText(resourceMap.getString("btnSearch.toolTipText", new Object[0]));
        this.btnSearch.setName("btnSearch");
        this.jLabelMainClass.setText(resourceMap.getString("jLabelMainClass.text", new Object[0]));
        this.jLabelMainClass.setName("jLabelMainClass");
        GroupLayout pnlMainClassLayout = new GroupLayout(this.pnlMainClass);
        this.pnlMainClass.setLayout(pnlMainClassLayout);
        pnlMainClassLayout.setHorizontalGroup(pnlMainClassLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlMainClassLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelMainClass, -1, 524, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnSearch).addContainerGap()));
        pnlMainClassLayout.setVerticalGroup(pnlMainClassLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlMainClassLayout.createSequentialGroup().addGroup(pnlMainClassLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSearch).addComponent(this.jLabelMainClass, -2, 18, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pnlClasspathView.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("pnlClasspathView.border.title", new Object[0])));
        this.pnlClasspathView.setName("pnlClasspathView");
        this.tabClasspath.setName("tabClasspath");
        this.pnlJarView.setName("pnlJars");
        this.btnRemoveEntry.setAction(actionMap.get("removeClasspathEntry"));
        this.btnRemoveEntry.setText(resourceMap.getString("btnRemoveEntry.text", new Object[0]));
        this.btnRemoveEntry.setToolTipText(resourceMap.getString("btnRemoveEntry.toolTipText", new Object[0]));
        this.btnRemoveEntry.setName("btnRemoveEntry");
        this.btnAddEntry.setAction(actionMap.get("addClasspathEntry"));
        this.btnAddEntry.setText(resourceMap.getString("btnAddEntry.text", new Object[0]));
        this.btnAddEntry.setToolTipText(resourceMap.getString("btnAddEntry.toolTipText", new Object[0]));
        this.btnAddEntry.setName("btnAddEntry");
        this.pnlClasspath.setName("pnlClasspath");
        DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("root");
        this.treeClasspath.setModel(new DefaultTreeModel(treeNode1));
        this.treeClasspath.setToolTipText(resourceMap.getString("treeClasspath.toolTipText", new Object[0]));
        this.treeClasspath.setName("treeClasspath");
        this.treeClasspath.setRootVisible(false);
        this.pnlClasspath.setViewportView(this.treeClasspath);
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        GroupLayout pnlJarViewLayout = new GroupLayout(this.pnlJarView);
        this.pnlJarView.setLayout(pnlJarViewLayout);
        pnlJarViewLayout.setHorizontalGroup(pnlJarViewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlJarViewLayout.createSequentialGroup().addContainerGap().addGroup(pnlJarViewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlClasspath, -1, 574, Short.MAX_VALUE).addGroup(pnlJarViewLayout.createSequentialGroup().addComponent(this.btnAddEntry, -2, 63, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRemoveEntry).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4, -1, 438, Short.MAX_VALUE))).addContainerGap()));
        pnlJarViewLayout.setVerticalGroup(pnlJarViewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlJarViewLayout.createSequentialGroup().addContainerGap().addComponent(this.pnlClasspath, -2, 93, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlJarViewLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnAddEntry, -1, -1, Short.MAX_VALUE).addComponent(this.btnRemoveEntry).addComponent(this.jLabel4)).addGap(47, 47, 47)));
        this.tabClasspath.addTab(resourceMap.getString("pnlJars.TabConstraints.tabTitle", new Object[0]), this.pnlJarView);
        this.pnlClassesView.setName("pnlClassesView");
        this.pnlClasspath1.setName("pnlClasspath1");
        treeNode1 = new DefaultMutableTreeNode("root");
        this.treeClasses.setModel(new DefaultTreeModel(treeNode1));
        this.treeClasses.setName("treeClasses");
        this.treeClasses.setRootVisible(false);
        this.pnlClasspath1.setViewportView(this.treeClasses);
        GroupLayout pnlClassesViewLayout = new GroupLayout(this.pnlClassesView);
        this.pnlClassesView.setLayout(pnlClassesViewLayout);
        pnlClassesViewLayout.setHorizontalGroup(pnlClassesViewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 594, Short.MAX_VALUE).addGroup(pnlClassesViewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlClassesViewLayout.createSequentialGroup().addContainerGap().addComponent(this.pnlClasspath1, -1, 574, Short.MAX_VALUE).addContainerGap())));
        pnlClassesViewLayout.setVerticalGroup(pnlClassesViewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 152, Short.MAX_VALUE).addGroup(pnlClassesViewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlClassesViewLayout.createSequentialGroup().addContainerGap().addComponent(this.pnlClasspath1, -1, 130, Short.MAX_VALUE).addContainerGap())));
        this.tabClasspath.addTab(resourceMap.getString("pnlClassesView.TabConstraints.tabTitle", new Object[0]), this.pnlClassesView);
        GroupLayout pnlClasspathViewLayout = new GroupLayout(this.pnlClasspathView);
        this.pnlClasspathView.setLayout(pnlClasspathViewLayout);
        pnlClasspathViewLayout.setHorizontalGroup(pnlClasspathViewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlClasspathViewLayout.createSequentialGroup().addContainerGap().addComponent(this.tabClasspath, -1, 599, Short.MAX_VALUE).addContainerGap()));
        pnlClasspathViewLayout.setVerticalGroup(pnlClasspathViewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabClasspath, -2, 180, -2));
        this.pnlExecutionInfo.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("pnlExecutionInfo.border.title", new Object[0])));
        this.pnlExecutionInfo.setName("pnlExecutionInfo");
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.txtWorkingDir.setText(resourceMap.getString("txtWorkingDir.text", new Object[0]));
        this.txtWorkingDir.setName("txtWorkingDir");
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.txtArguments.setText(resourceMap.getString("txtArguments.text", new Object[0]));
        this.txtArguments.setName("txtArguments");
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.txtJvmArguments.setText(resourceMap.getString("txtJvmArguments.text", new Object[0]));
        this.txtJvmArguments.setName("txtJvmArguments");
        GroupLayout pnlExecutionInfoLayout = new GroupLayout(this.pnlExecutionInfo);
        this.pnlExecutionInfo.setLayout(pnlExecutionInfoLayout);
        pnlExecutionInfoLayout.setHorizontalGroup(pnlExecutionInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlExecutionInfoLayout.createSequentialGroup().addContainerGap().addGroup(pnlExecutionInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtWorkingDir, GroupLayout.Alignment.TRAILING, -1, 599, Short.MAX_VALUE).addComponent(this.jLabel3).addComponent(this.jLabel1).addComponent(this.txtArguments, -1, 599, Short.MAX_VALUE).addComponent(this.jLabel2).addComponent(this.txtJvmArguments, -1, 599, Short.MAX_VALUE)).addContainerGap()));
        pnlExecutionInfoLayout.setVerticalGroup(pnlExecutionInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlExecutionInfoLayout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtWorkingDir, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtArguments, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtJvmArguments, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.btnStartProcess.setAction(actionMap.get("startProcess"));
        this.btnStartProcess.setText(resourceMap.getString("btnStartProcess.text", new Object[0]));
        this.btnStartProcess.setToolTipText(resourceMap.getString("btnStartProcess.toolTipText", new Object[0]));
        this.btnStartProcess.setName("btnStartProcess");
        this.btnCancel.setAction(actionMap.get("close"));
        this.btnCancel.setText(resourceMap.getString("btnCancel.text", new Object[0]));
        this.btnCancel.setToolTipText(resourceMap.getString("btnCancel.toolTipText", new Object[0]));
        this.btnCancel.setName("btnCancel");
        this.pnlGui.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("pnlGui.border.title", new Object[0])));
        this.pnlGui.setName("pnlGui");
        this.jLabel5.setText(resourceMap.getString("jLabel5.text", new Object[0]));
        this.jLabel5.setName("jLabel5");
        this.txtGuiDelay.setHorizontalAlignment(4);
        this.txtGuiDelay.setText(resourceMap.getString("txtGuiDelay.text", new Object[0]));
        this.txtGuiDelay.setName("txtGuiDelay");
        this.jLabel6.setText(resourceMap.getString("jLabel6.text", new Object[0]));
        this.jLabel6.setName("jLabel6");
        GroupLayout pnlGuiLayout = new GroupLayout(this.pnlGui);
        this.pnlGui.setLayout(pnlGuiLayout);
        pnlGuiLayout.setHorizontalGroup(pnlGuiLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlGuiLayout.createSequentialGroup().addContainerGap().addGroup(pnlGuiLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addGroup(pnlGuiLayout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.txtGuiDelay, -2, 23, -2))).addContainerGap(32, Short.MAX_VALUE)));
        pnlGuiLayout.setVerticalGroup(pnlGuiLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlGuiLayout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlGuiLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.txtGuiDelay, -2, -1, -2)).addContainerGap(4, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlGui, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.pnlClasspathView, -1, -1, Short.MAX_VALUE).addComponent(this.pnlExecutionInfo, -1, -1, Short.MAX_VALUE).addComponent(this.pnlMainClass, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.btnStartProcess).addGap(5, 5, 5).addComponent(this.btnCancel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.pnlMainClass, -2, -1, -2).addGap(4, 4, 4).addComponent(this.pnlClasspathView, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlExecutionInfo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlGui, -1, 71, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnStartProcess).addComponent(this.btnCancel)).addContainerGap()));
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                NewProcessInfoView dialog = new NewProcessInfoView((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public SnoopSession getSnoopSession() {
        return this.model;
    }

    @Action
    public void addClasspathEntry() {
        File[] selectedFiles;
        JFileChooser fc = new JFileChooser();
        if (this.lastSelectedDir != null) {
            fc.setCurrentDirectory(this.lastSelectedDir);
        } else {
            fc.setCurrentDirectory(new File(userDir));
        }
        fc.setApproveButtonText("Select");
        fc.setDialogTitle("Select root folders or JAR files");
        fc.setFileSelectionMode(2);
        fc.setFileFilter(this.fileFilter);
        fc.setMultiSelectionEnabled(true);
        int rc = fc.showOpenDialog(this.getParent());
        if (rc != 0) {
            return;
        }
        for (File selectedFile : selectedFiles = fc.getSelectedFiles()) {
            if (selectedFile.isFile()) {
                try {
                    SmartURLClassPath entry = new SmartURLClassPath(selectedFile.toURL());
                    this.cp.appendClassPath((ClassPath)entry);
                    this.classpath.addEntry(new ClasspathEntry(selectedFile.getAbsolutePath(), entry));
                }
                catch (MalformedURLException ex) {
                    UIUtil.showErrorMessage(this, "Failed to add classpath entry: " + this.cp);
                    logger.error((Object)("Error adding to classpath: " + this.cp), (Throwable)ex);
                }
                continue;
            }
            if (!selectedFile.isDirectory()) continue;
            FileFilter jarFilter = new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isFile() && f.getName().endsWith(".jar");
                }
            };
            for (File file : selectedFile.listFiles(jarFilter)) {
                try {
                    SmartURLClassPath entry = new SmartURLClassPath(file.toURL());
                    this.cp.appendClassPath((ClassPath)entry);
                    this.classpath.addEntry(new ClasspathEntry(file.getAbsolutePath(), entry));
                }
                catch (MalformedURLException ex) {
                    UIUtil.showErrorMessage(this, "Failed to add classpath entry: " + this.cp);
                    logger.error((Object)("Error adding to classpath: " + this.cp), (Throwable)ex);
                }
            }
        }
        this.lastSelectedDir = selectedFiles[0].isDirectory() ? selectedFiles[0] : selectedFiles[0].getParentFile();
        JavaSnoop.setProperty("last_classpath_dir", this.lastSelectedDir.getAbsolutePath());
        JavaSnoop.saveProperties();
        this.classpath.reload();
        this.treeClasspath.setModel(null);
        this.treeClasspath.setModel(this.classpath);
        List<String> classes = this.classpath.getClassesSeen();
        ClassesTreeModel classModel = new ClassesTreeModel(new DefaultMutableTreeNode(null));
        classModel.setClasses(classes);
        classModel.reload();
        this.treeClasses.setModel(null);
        this.treeClasses.setModel(classModel);
    }

    @Action
    public void removeClasspathEntry() {
        TreePath[] paths = this.treeClasspath.getSelectionPaths();
        if (paths.length == 0) {
            return;
        }
        boolean changed = false;
        for (TreePath path : paths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node.getLevel() != 1) continue;
            ClasspathEntry entry = (ClasspathEntry)node.getUserObject();
            this.cp.removeClassPath(entry.getEntry());
            this.classpath.removeEntry(entry);
            changed = true;
        }
        if (changed) {
            this.classpath.reload();
            this.treeClasspath.setModel(null);
            this.treeClasspath.setModel(this.classpath);
            List<String> classes = this.classpath.getClassesSeen();
            ClassesTreeModel classModel = new ClassesTreeModel(new DefaultMutableTreeNode(null));
            classModel.setClasses(classes);
            classModel.reload();
            this.treeClasses.setModel(null);
            this.treeClasses.setModel(classModel);
        }
    }

    @Action
    public void searchForMainClasses() {
        if (this.classpath.getEntries().isEmpty()) {
            UIUtil.showErrorMessage(this, "Please add classpath entries before searching for a main class");
            return;
        }
        ClassPool pool = new ClassPool(true);
        for (ClasspathEntry entry : this.classpath.getEntries()) {
            try {
                pool.appendClassPath(entry.getStringEntry());
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        SearchMainMethodsView searchMainMethodsView = new SearchMainMethodsView((Frame)new JFrame(), true, pool, this.classpath.getClassesSeen());
        searchMainMethodsView.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                String selectedClass = (String)e.getSource();
                logger.trace((Object)("Setting program's main class to: " + selectedClass));
                NewProcessInfoView.this.jLabelMainClass.setText(selectedClass);
            }
        });
        searchMainMethodsView.setVisible(true);
    }

    @Action
    public void close() {
        this.model = null;
        this.dispose();
    }

    @Action
    public void startProcess() {
        String mainClass = this.jLabelMainClass.getText();
        if (mainClass.length() == 0 && this.classpath.getEntries().size() != 1) {
            UIUtil.showErrorMessage(this, "Please select a main class or a single jar");
            return;
        }
        this.model = new SnoopSession();
        this.model.setMainClass(mainClass);
        this.model.setArguments(this.txtArguments.getText());
        this.model.setJavaArguments(this.txtJvmArguments.getText());
        this.model.setWorkingDir(this.txtWorkingDir.getText());
        this.model.setClasspathString(Util.convertListToString(this.classpath.getEntries(), ";"));
        try {
            this.model.setGuiDelay(Integer.parseInt(this.txtGuiDelay.getText()));
        }
        catch (Exception e) {
            UIUtil.showErrorMessage(this, "Please enter an integer value for the GUI delay");
            return;
        }
        this.dispose();
    }
}

