/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.SyntaxConstants;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenMaker;
import org.fife.ui.rsyntaxtextarea.TokenMakerFactory;
import org.fife.ui.rsyntaxtextarea.modes.AbstractMarkupTokenMaker;
import org.fife.util.DynamicIntArray;

public class RSyntaxDocument
extends PlainDocument
implements SyntaxConstants {
    private transient TokenMakerFactory tokenMakerFactory;
    private TokenMaker tokenMaker;
    protected DynamicIntArray lastTokensOnLines;
    private transient Segment s;

    public RSyntaxDocument(String string) {
        this(null, string);
    }

    public RSyntaxDocument(TokenMakerFactory tokenMakerFactory, String string) {
        super(new RGapContent());
        this.putProperty("tabSize", new Integer(5));
        this.lastTokensOnLines = new DynamicIntArray(400);
        this.lastTokensOnLines.add(0);
        this.s = new Segment();
        this.setTokenMakerFactory(tokenMakerFactory);
        this.setSyntaxStyle(string);
    }

    public char charAt(int n) throws BadLocationException {
        return ((RGapContent)this.getContent()).charAt(n);
    }

    protected void fireInsertUpdate(DocumentEvent documentEvent) {
        int n;
        Element element = this.getDefaultRootElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        Element[] elementArray = elementChange == null ? null : elementChange.getChildrenAdded();
        int n2 = element.getElementCount();
        int n3 = element.getElementIndex(documentEvent.getOffset());
        int n4 = n3 - 1;
        int n5 = n = n4 > -1 ? this.lastTokensOnLines.get(n4) : 0;
        if (elementArray != null && elementArray.length > 0) {
            Element[] elementArray2 = elementChange.getChildrenRemoved();
            int n6 = elementArray2 != null ? elementArray2.length : 0;
            int n7 = n3 + elementArray.length - n6;
            for (int i = n3; i < n7; ++i) {
                this.setSharedSegment(i);
                int n8 = this.tokenMaker.getLastTokenTypeOnLine(this.s, n);
                this.lastTokensOnLines.add(i, n8);
                n = n8;
            }
            this.updateLastTokensBelow(n7, n2, n);
        } else {
            this.updateLastTokensBelow(n3, n2, n);
        }
        super.fireInsertUpdate(documentEvent);
    }

    protected void fireRemoveUpdate(DocumentEvent documentEvent) {
        Element[] elementArray;
        Element element = this.getDefaultRootElement();
        int n = element.getElementCount();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        Element[] elementArray2 = elementArray = elementChange == null ? null : elementChange.getChildrenRemoved();
        if (elementArray != null && elementArray.length > 0) {
            int n2 = elementChange.getIndex();
            int n3 = n2 - 1;
            int n4 = n3 > -1 ? this.lastTokensOnLines.get(n3) : 0;
            Element[] elementArray3 = elementChange.getChildrenAdded();
            int n5 = elementArray3 == null ? 0 : elementArray3.length;
            int n6 = n2 + elementArray.length - n5;
            this.lastTokensOnLines.removeRange(n2, n6);
            this.updateLastTokensBelow(n2, n, n4);
        } else {
            int n7 = element.getElementIndex(documentEvent.getOffset());
            if (n7 >= this.lastTokensOnLines.getSize()) {
                return;
            }
            int n8 = n7 - 1;
            int n9 = n8 > -1 ? this.lastTokensOnLines.get(n8) : 0;
            this.updateLastTokensBelow(n7, n, n9);
        }
        super.fireRemoveUpdate(documentEvent);
    }

    public boolean getCompleteMarkupCloseTags() {
        return this.getLanguageIsMarkup() && ((AbstractMarkupTokenMaker)this.tokenMaker).getCompleteCloseTags();
    }

    public boolean getCurlyBracesDenoteCodeBlocks() {
        return this.tokenMaker.getCurlyBracesDenoteCodeBlocks();
    }

    public boolean getLanguageIsMarkup() {
        return this.tokenMaker.isMarkupLanguage();
    }

    public int getLastTokenTypeOnLine(int n) {
        return this.lastTokensOnLines.get(n);
    }

    public String[] getLineCommentStartAndEnd() {
        return this.tokenMaker.getLineCommentStartAndEnd();
    }

    boolean getMarkOccurrencesOfTokenType(int n) {
        return this.tokenMaker.getMarkOccurrencesOfTokenType(n);
    }

    public boolean getShouldIndentNextLine(int n) {
        Token token = this.getTokenListForLine(n);
        token = token.getLastNonCommentNonWhitespaceToken();
        return this.tokenMaker.getShouldIndentNextLineAfter(token);
    }

    public final Token getTokenListForLine(int n) {
        Element element = this.getDefaultRootElement();
        Element element2 = element.getElement(n);
        int n2 = element2.getStartOffset();
        int n3 = element2.getEndOffset() - 1;
        try {
            this.getText(n2, n3 - n2, this.s);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return null;
        }
        int n4 = n == 0 ? 0 : this.getLastTokenTypeOnLine(n - 1);
        return this.tokenMaker.getTokenList(this.s, n4, n2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.s = new Segment();
    }

    private final void setSharedSegment(int n) {
        Element element = this.getDefaultRootElement();
        Element element2 = element.getElement(n);
        if (element2 == null) {
            throw new InternalError("Invalid line number: " + n);
        }
        int n2 = element2.getStartOffset();
        int n3 = element2.getEndOffset() - 1;
        try {
            this.getText(n2, n3 - n2, this.s);
        }
        catch (BadLocationException badLocationException) {
            throw new InternalError("Text range not in document: " + n2 + "-" + n3);
        }
    }

    public void setSyntaxStyle(String string) {
        this.tokenMaker = this.tokenMakerFactory.getTokenMaker(string);
        this.updateSyntaxHighlightingInformation();
    }

    public void setSyntaxStyle(TokenMaker tokenMaker) {
        this.tokenMaker = tokenMaker;
        this.updateSyntaxHighlightingInformation();
    }

    public void setTokenMakerFactory(TokenMakerFactory tokenMakerFactory) {
        this.tokenMakerFactory = tokenMakerFactory != null ? tokenMakerFactory : TokenMakerFactory.getDefaultInstance();
    }

    public void setWhitespaceVisible(boolean bl, RSyntaxTextArea rSyntaxTextArea) {
        this.tokenMaker.setWhitespaceVisible(bl, rSyntaxTextArea);
    }

    private int updateLastTokensBelow(int n, int n2, int n3) {
        int n4 = n;
        int n5 = n2 - 1;
        while (n < n5) {
            this.setSharedSegment(n);
            int n6 = this.lastTokensOnLines.get(n);
            int n7 = this.tokenMaker.getLastTokenTypeOnLine(this.s, n3);
            if (n6 == n7) {
                this.fireChangedUpdate(new AbstractDocument.DefaultDocumentEvent(this, n4, n, DocumentEvent.EventType.CHANGE));
                return n;
            }
            this.lastTokensOnLines.setUnsafe(n, n7);
            n3 = n7;
            ++n;
        }
        if (n > n4) {
            this.fireChangedUpdate(new AbstractDocument.DefaultDocumentEvent(this, n4, n, DocumentEvent.EventType.CHANGE));
        }
        return n;
    }

    protected void updateSyntaxHighlightingInformation() {
        Element element = this.getDefaultRootElement();
        int n = element.getElementCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            this.setSharedSegment(i);
            n2 = this.tokenMaker.getLastTokenTypeOnLine(this.s, n2);
            this.lastTokensOnLines.set(i, n2);
        }
        this.fireChangedUpdate(new AbstractDocument.DefaultDocumentEvent(this, 0, n - 1, DocumentEvent.EventType.CHANGE));
    }

    private static class RGapContent
    extends GapContent {
        public char charAt(int n) throws BadLocationException {
            if (n < 0 || n >= this.length()) {
                throw new BadLocationException("Invalid offset", n);
            }
            int n2 = this.getGapStart();
            char[] cArray = (char[])this.getArray();
            if (n < n2) {
                return cArray[n];
            }
            return cArray[this.getGapEnd() + n - n2];
        }
    }
}

