# Print the code snippet used to generate a symlinks farm prefix
# USAGE: prefix_symlinks_generate
prefix_symlinks_generate() {
	## TODO: env --chdir could be used instead of cd in subshells.
	## TODO: The ability to set some volatile writable paths should be added,
	##       similar to user persistent paths but without the diversion to persistent storage.
	cat  <<- 'EOF'
	# Generate a volatile game prefix relying on symbolic links

	mkdir --parents "$PATH_PREFIX"

	## Remove links to game directories
	(
	    cd "$PATH_GAME_DATA"
	    find . -type d | while read -r directory; do
	        if [ -h "${PATH_PREFIX}/${directory}" ]; then
	            rm "${PATH_PREFIX}/${directory}"
	        fi
	    done
	    unset directory
	)

	## Populate prefix with links to all game files
	cp \
	    --dereference --no-target-directory --recursive --remove-destination --symbolic-link \
	    "$PATH_GAME_DATA" "$PATH_PREFIX"

	## Remove dangling links and non-game empty directories
	(
	    cd "$PATH_PREFIX"
	    find . -type l | while read -r link; do
	        if [ ! -e "$link" ]; then
	            rm "$link"
	        fi
	    done
	    find . -depth -type d | while read -r directory; do
	        if [ ! -e "${PATH_GAME_DATA}/${directory}" ]; then
	            rmdir --ignore-fail-on-non-empty "$directory"
	        fi
	    done
	    unset link directory
	)

	EOF
}

