#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2019 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Gathering Sky
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250429.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='gathering-sky'
GAME_NAME='Gathering Sky'

ARCHIVE_BASE_0_NAME='GatheringSky_Linux_64bit.zip'
ARCHIVE_BASE_0_MD5='c590edce835070a1ac2ae47ac620dc48'
ARCHIVE_BASE_0_SIZE='1200000'
ARCHIVE_BASE_0_VERSION='1.0-humble1'
ARCHIVE_BASE_0_URL='https://www.humblebundle.com/store/gathering-sky'

CONTENT_PATH_DEFAULT='packr/linux/GatheringSky'
CONTENT_GAME_DATA_FILES='
desktop-0.1.jar'
CONTENT_GAME_BIN_SHIPPED_FILES='
config.json
GatheringSky
jre'

# Launchers

## Common

APPLICATIONS_LIST='APP_MAIN'

## Ensure settings can be stored
APP_MAIN_PRERUN='
# Ensure settings can be stored
mkdir --parents "${HOME}/.prefs"
'

## The icons are extracted from desktop-0.1.jar
APP_MAIN_ICONS_LIST='APP_MAIN_ICON_16 APP_MAIN_ICON_32 APP_MAIN_ICON_128'
APP_MAIN_ICON_16='../../../images/Icon_16.png'
APP_MAIN_ICON_32='../../../images/Icon_32.png'
APP_MAIN_ICON_128='../../../images/Icon_128.png'

## Using system-provided Java

APP_MAIN_TYPE_BIN_SYSTEM='java'
## FIXME: ./play.it 2.32 has no support for context-sensitive APP_xxx_JAVA_OPTIONS values.
APP_MAIN_JAVA_OPTIONS_BIN_SYSTEM='-Xmx1G'
APP_MAIN_EXE_BIN_SYSTEM='desktop-0.1.jar'

## Using shipped binaries

APP_MAIN_EXE_BIN_SHIPPED='GatheringSky'

# Packages

## Common

PACKAGES_LIST='
PKG_BIN_SHIPPED
PKG_BIN_SYSTEM
PKG_DATA'

PKG_BIN_ID="$GAME_ID"
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

## Using system-provided Java

PKG_BIN_SYSTEM_ID="${PKG_BIN_ID}-bin-system"
PKG_BIN_SYSTEM_PROVIDES="
$PKG_BIN_ID"
PKG_BIN_SYSTEM_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN_SYSTEM_DESCRIPTION='Using system-provided Java'

## Using shipped binaries

PKG_BIN_SHIPPED_ARCH='64'
PKG_BIN_SHIPPED_ID="${PKG_BIN_ID}-bin-shipped"
PKG_BIN_SHIPPED_PROVIDES="
$PKG_BIN_ID"
PKG_BIN_SHIPPED_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libpthread.so.0
libstdc++.so.6
libthread_db.so.1'
PKG_BIN_SYSTEM_DESCRIPTION='Using shipped binaries'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

## The archive includes the following entry, triggering an error during decompression:
## ?rwxr--r--  2.0 unx        0 bl defN 14-May-31 03:43 /
archive_extraction_default 2>/dev/null || true
ARCHIVE_INNER_PATH="${PLAYIT_WORKDIR}/gamedata/GatheringSky.tar.gz"
archive_extraction 'ARCHIVE_INNER'
rm "$ARCHIVE_INNER_PATH"

# Include game data

ARCHIVE_JAR_PATH="${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/desktop-0.1.jar"
ARCHIVE_JAR_TYPE='zip'
archive_extraction 'ARCHIVE_JAR'
content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

## This game expects an executable stack through dynamically loaded libraries
game_exec_line() {
	cat <<- 'EOF'
	GLIBC_TUNABLES=glibc.rtld.execstack=2 java -Xmx1G -jar desktop-0.1.jar "$@"
	EOF
}

launchers_generation 'PKG_BIN_SYSTEM'

## This game expects an executable stack through dynamically loaded libraries
game_exec_line() {
	cat <<- 'EOF'
	GLIBC_TUNABLES=glibc.rtld.execstack=2 ./GatheringSky "$@"
	EOF
}

launchers_generation 'PKG_BIN_SHIPPED'

# Build packages

packages_generation
case "$(messages_language)" in
	('fr')
		message='Utilisation des binaires fournis par %s :'
		bin_system='le système'
		bin_shipped='les développeurs'
	;;
	('en'|*)
		message='Using binaries provided by %s:'
		bin_system='the system'
		bin_shipped='the developers'
	;;
esac
printf '\n'
printf "$message" "$bin_system"
print_instructions 'PKG_BIN_SYSTEM' 'PKG_DATA'
printf "$message" "$bin_shipped"
print_instructions 'PKG_BIN_SHIPPED' 'PKG_DATA'

# Clean up

working_directory_cleanup

exit 0
