/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ant;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.Version;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.trace.XSLTTraceListener;
import net.sf.saxon.trans.CompilerInfo;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.XSLTLogger;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.XMLCatalog;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Resources;
import org.apache.tools.ant.types.resources.Union;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;

public class AntTransform
extends MatchingTask
implements XSLTLogger {
    private File destDir = null;
    private File baseDir = null;
    private String xslFile = null;
    private Resource xslResource = null;
    private String targetExtension = ".html";
    private String fileNameParameter = null;
    private String fileDirParameter = null;
    private Vector params = new Vector();
    private File inFile = null;
    private File outFile = null;
    private boolean schemaAware;
    private Path classpath = null;
    private boolean stylesheetLoaded = false;
    private boolean force = false;
    private Vector outputProperties = new Vector();
    private XMLCatalog xmlCatalog = new XMLCatalog();
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private boolean performDirectoryScan = true;
    private Configuration config;
    private boolean reuseLoadedStylesheet = true;
    private AntClassLoader loader = null;
    private Mapper mapperElement = null;
    private Union resources = new Union();
    private boolean useImplicitFileset = true;
    private Controller transformer = null;
    private String schemaValidation = "skip";
    private boolean dtdValidation = false;
    private boolean expandAttributeDefaults = true;
    private boolean allowExtensions = true;
    private String initialMode;
    private String initialTemplate;
    private boolean lineNumbering;
    private boolean tracing;
    private String recoveryPolicy;
    private String xmlVersion = "1.0";

    public void setScanIncludedDirectories(boolean bl) {
        this.performDirectoryScan = bl;
    }

    public void setReloadStylesheet(boolean bl) {
        this.reuseLoadedStylesheet = !bl;
    }

    public void addMapper(Mapper mapper) {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper", this.getLocation());
        }
        this.mapperElement = mapper;
    }

    public void add(ResourceCollection resourceCollection) {
        this.resources.add(resourceCollection);
    }

    public void addConfiguredStyle(Resources resources) {
        if (resources.size() != 1) {
            throw new BuildException("The style element must be specified with exactly one nested resource.");
        }
        this.setXslResource((Resource)resources.iterator().next());
    }

    public void setXslResource(Resource resource) {
        this.xslResource = resource;
    }

    public void add(FileNameMapper fileNameMapper) throws BuildException {
        Mapper mapper = new Mapper(this.getProject());
        mapper.add(fileNameMapper);
        this.addMapper(mapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        this.log("AntTransform.execute() schema-aware=" + this.schemaAware + " version " + Version.getProductVersion());
        if (this.schemaAware) {
            this.config = Configuration.makeSchemaAwareConfiguration(null, null);
            this.config.displayLicenseMessage();
        } else {
            this.config = new Configuration();
        }
        this.config.setAllowExternalFunctions(this.allowExtensions);
        this.config.setExpandAttributeDefaults(this.expandAttributeDefaults);
        this.config.setLineNumbering(this.lineNumbering);
        this.config.setValidation(this.dtdValidation);
        this.config.setCompileWithTracing(this.tracing);
        this.config.setXMLVersion("1.1".equals(this.xmlVersion) ? 11 : 10);
        if ("skip".equals(this.schemaValidation)) {
            this.config.setSchemaValidationMode(4);
        } else if ("strict".equals(this.schemaValidation)) {
            this.config.setSchemaValidationMode(1);
        } else if ("lax".equals(this.schemaValidation)) {
            this.config.setSchemaValidationMode(2);
        } else {
            throw new BuildException("Validation must be strict or lax or skip");
        }
        File file = this.baseDir;
        if (this.xslResource == null && this.xslFile == null) {
            throw new BuildException("specify the stylesheet either as a filename in style attribute or as a nested resource", this.getLocation());
        }
        if (this.xslResource != null && this.xslFile != null) {
            throw new BuildException("specify the stylesheet either as a filename in style attribute or as a nested resource but not as both", this.getLocation());
        }
        if (this.inFile != null && !this.inFile.exists()) {
            throw new BuildException("input file " + this.inFile.toString() + " does not exist", this.getLocation());
        }
        try {
            if (this.baseDir == null) {
                this.baseDir = this.getProject().resolveFile(".");
            }
            if (this.xslFile != null) {
                File file2 = this.getProject().resolveFile(this.xslFile);
                if (!file2.exists() && (file2 = FILE_UTILS.resolveFile(this.baseDir, this.xslFile)).exists()) {
                    this.log("DEPRECATED - the 'style' attribute should be relative to the project's");
                    this.log("             basedir, not the tasks's basedir.");
                }
                FileResource fileResource = new FileResource();
                fileResource.setProject(this.getProject());
                fileResource.setFile(file2);
                this.xslResource = fileResource;
            }
            if (this.inFile != null && this.outFile != null) {
                this.process(this.inFile, this.outFile, this.xslResource);
                return;
            }
            this.checkDest();
            if (this.useImplicitFileset) {
                int n;
                DirectoryScanner directoryScanner = this.getDirectoryScanner(this.baseDir);
                this.log("Transforming into " + this.destDir, 2);
                String[] stringArray = directoryScanner.getIncludedFiles();
                for (n = 0; n < stringArray.length; ++n) {
                    this.process(this.baseDir, stringArray[n], this.destDir, this.xslResource);
                }
                if (this.performDirectoryScan) {
                    String[] stringArray2 = directoryScanner.getIncludedDirectories();
                    for (n = 0; n < stringArray2.length; ++n) {
                        stringArray = new File(this.baseDir, stringArray2[n]).list();
                        for (int i = 0; i < stringArray.length; ++i) {
                            this.process(this.baseDir, stringArray2[n] + File.separator + stringArray[i], this.destDir, this.xslResource);
                        }
                    }
                }
            } else if (this.resources.size() == 0) {
                throw new BuildException("no resources specified");
            }
            this.processResources(this.xslResource);
        }
        finally {
            if (this.loader != null) {
                this.loader.resetThreadContextLoader();
                this.loader.cleanup();
                this.loader = null;
            }
            this.stylesheetLoaded = false;
            this.baseDir = file;
        }
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    public void setBasedir(File file) {
        this.baseDir = file;
    }

    public void setDestdir(File file) {
        this.destDir = file;
    }

    public void setExtension(String string) {
        this.targetExtension = string;
    }

    public void setStyle(String string) {
        this.xslFile = string;
    }

    public void setClasspath(Path path) {
        this.createClasspath().append(path);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void setSchemaAware(boolean bl) {
        this.schemaAware = bl;
    }

    public void setSchemaValidation(String string) {
        this.schemaValidation = string;
        if (!string.equals("skip")) {
            this.setSchemaAware(true);
        }
    }

    public void setDTDValidation(boolean bl) {
        this.dtdValidation = bl;
    }

    public void setExpandDefaults(boolean bl) {
        this.expandAttributeDefaults = bl;
    }

    public void setInitialMode(String string) {
        this.initialMode = string;
    }

    public void setInitialTemplate(String string) {
        this.initialTemplate = string;
    }

    public void setRecoveryPolicy(String string) {
        this.recoveryPolicy = string;
    }

    public void setTracing(boolean bl) {
        this.tracing = bl;
    }

    public void setLineNumbering(boolean bl) {
        this.lineNumbering = bl;
    }

    public void setXmlVersion(String string) {
        this.xmlVersion = string;
    }

    public void setUseImplicitFileset(boolean bl) {
        this.useImplicitFileset = bl;
    }

    public void addConfiguredXMLCatalog(XMLCatalog xMLCatalog) {
        this.xmlCatalog.addConfiguredXMLCatalog(xMLCatalog);
    }

    public void setFileNameParameter(String string) {
        this.fileNameParameter = string;
    }

    public void setFileDirParameter(String string) {
        this.fileDirParameter = string;
    }

    public void setOut(File file) {
        this.outFile = file;
    }

    public void setIn(File file) {
        this.inFile = file;
    }

    private void checkDest() {
        if (this.destDir == null) {
            String string = "destdir attributes must be set!";
            throw new BuildException(string);
        }
    }

    private void processResources(Resource resource) {
        for (Resource resource2 : this.resources) {
            FileResource fileResource;
            if (!resource2.isExists()) continue;
            File file = this.baseDir;
            String string = resource2.getName();
            if (resource2 instanceof FileResource && (file = (fileResource = (FileResource)resource2).getBaseDir()) == null) {
                string = fileResource.getFile().getAbsolutePath();
            }
            this.process(file, string, this.destDir, resource);
        }
    }

    private void process(File file, String string, File file2, Resource resource) throws BuildException {
        File file3 = null;
        if (this.fileNameParameter != null) {
            this.transformer.setParameter(this.fileNameParameter, (Object)string);
        }
        if (this.fileDirParameter != null) {
            this.transformer.setParameter(this.fileDirParameter, (Object)file.getAbsolutePath());
        }
        try {
            long l = resource.getLastModified();
            File file4 = new File(file, string);
            if (file4.isDirectory()) {
                this.log("Skipping " + file4 + " it is a directory.", 3);
                return;
            }
            Object object = this.mapperElement != null ? this.mapperElement.getImplementation() : new StyleMapper();
            String[] stringArray = object.mapFileName(string);
            if (stringArray == null || stringArray.length == 0) {
                this.log("Skipping " + this.inFile + " it cannot get mapped to output.", 3);
                return;
            }
            if (stringArray == null || stringArray.length > 1) {
                this.log("Skipping " + this.inFile + " its mapping is ambiguous.", 3);
                return;
            }
            file3 = new File(file2, stringArray[0]);
            if (this.force || file4.lastModified() > file3.lastModified() || l > file3.lastModified()) {
                this.ensureDirectoryFor(file3);
                this.log("Processing " + file4 + " to " + file3);
                this.configureLiaison(resource);
                this.transform(file4, file3);
            }
        }
        catch (Exception exception) {
            this.log("Failed to process " + this.inFile, 2);
            if (file3 != null) {
                file3.delete();
            }
            throw new BuildException((Throwable)exception);
        }
    }

    private void process(File file, File file2, Resource resource) throws BuildException {
        try {
            long l = resource.getLastModified();
            this.log("In file " + file + " time: " + file.lastModified(), 4);
            this.log("Out file " + file2 + " time: " + file2.lastModified(), 4);
            this.log("Style file " + this.xslFile + " time: " + l, 4);
            if (this.force || file.lastModified() >= file2.lastModified() || l >= file2.lastModified()) {
                this.ensureDirectoryFor(file2);
                this.log("Processing " + file + " to " + file2, 2);
                this.configureLiaison(resource);
                this.transform(file, file2);
            } else {
                this.log("Skipping input file " + file + " because it is older than output file " + file2 + " and so is the stylesheet " + resource, 4);
            }
        }
        catch (Exception exception) {
            this.log("Failed to process " + file, 2);
            if (file2 != null) {
                file2.delete();
            }
            throw new BuildException((Throwable)exception);
        }
    }

    private void transform(File file, File file2) {
        if (this.transformer == null) {
            throw new BuildException("No transformer has been created");
        }
        StreamSource streamSource = new StreamSource(file);
        StreamResult streamResult = new StreamResult(file2);
        try {
            this.transformer.transform((Source)streamSource, (Result)streamResult);
        }
        catch (TransformerException transformerException) {
            this.log("Failed to transform " + file, 2);
            if (file2 != null) {
                file2.delete();
            }
            throw new BuildException((Throwable)transformerException);
        }
    }

    private void ensureDirectoryFor(File file) throws BuildException {
        File file2 = file.getParentFile();
        if (!file2.exists() && !file2.mkdirs()) {
            throw new BuildException("Unable to create directory: " + file2.getAbsolutePath());
        }
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public XMLCatalog getXMLCatalog() {
        this.xmlCatalog.setProject(this.getProject());
        return this.xmlCatalog;
    }

    public Enumeration getOutputProperties() {
        return this.outputProperties.elements();
    }

    public Param createParam() {
        Param param = new Param();
        this.params.addElement(param);
        return param;
    }

    public OutputProperty createOutputProperty() {
        OutputProperty outputProperty = new OutputProperty();
        this.outputProperties.addElement(outputProperty);
        return outputProperty;
    }

    public void init() throws BuildException {
        super.init();
        this.xmlCatalog.setProject(this.getProject());
    }

    protected void configureLiaison(File file) throws BuildException {
        FileResource fileResource = new FileResource();
        fileResource.setProject(this.getProject());
        fileResource.setFile(file);
        this.configureLiaison((Resource)fileResource);
    }

    protected void configureLiaison(Resource resource) throws BuildException {
        if (this.stylesheetLoaded && this.reuseLoadedStylesheet) {
            return;
        }
        this.stylesheetLoaded = true;
        try {
            Object object;
            Object object2;
            this.log("Loading stylesheet " + resource, 2);
            if (resource instanceof FileResource) {
                object2 = ((FileResource)resource).getFile();
                object = new CompilerInfo();
                object.setURIResolver(this.config.getURIResolver());
                object.setErrorListener(this.config.getErrorListener());
                object.setCompileWithTracing(this.config.isCompileWithTracing());
                PreparedStylesheet preparedStylesheet = PreparedStylesheet.compile((Source)new StreamSource((File)object2), (Configuration)this.config, (CompilerInfo)object);
                this.transformer = (Controller)preparedStylesheet.newTransformer();
                this.transformer.setInitialMode(this.initialMode);
                this.transformer.setInitialTemplate(this.initialTemplate);
                if (this.tracing) {
                    this.transformer.addTraceListener((TraceListener)new XSLTTraceListener());
                }
                if (this.recoveryPolicy != null) {
                    if (this.recoveryPolicy.equals("silent")) {
                        this.transformer.setRecoveryPolicy(0);
                    } else if (this.recoveryPolicy.equals("recover")) {
                        this.transformer.setRecoveryPolicy(1);
                    } else {
                        this.transformer.setRecoveryPolicy(2);
                    }
                }
            } else {
                throw new BuildException("Saxon accepts the stylesheet only as a file", this.getLocation());
            }
            object2 = this.params.elements();
            while (object2.hasMoreElements()) {
                object = (Param)object2.nextElement();
                if (!((Param)object).shouldUse()) continue;
                this.transformer.setParameter(((Param)object).getName(), (Object)((Param)object).getExpression());
            }
        }
        catch (Exception exception) {
            this.log("Failed to transform using stylesheet " + resource, 2);
            throw new BuildException((Throwable)exception);
        }
    }

    private class StyleMapper
    implements FileNameMapper {
        private StyleMapper() {
        }

        public void setFrom(String string) {
        }

        public void setTo(String string) {
        }

        public String[] mapFileName(String string) {
            int n = string.lastIndexOf(46);
            if (n > 0) {
                string = string.substring(0, n);
            }
            return new String[]{string + AntTransform.this.targetExtension};
        }
    }

    public static class OutputProperty {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String string) {
            this.value = string;
        }
    }

    public static class Param {
        private String name = null;
        private String expression = null;
        private String ifProperty;
        private String unlessProperty;
        private Project project;

        public void setProject(Project project) {
            this.project = project;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setExpression(String string) {
            this.expression = string;
        }

        public String getName() throws BuildException {
            if (this.name == null) {
                throw new BuildException("Name attribute is missing.");
            }
            return this.name;
        }

        public String getExpression() throws BuildException {
            if (this.expression == null) {
                throw new BuildException("Expression attribute is missing.");
            }
            return this.expression;
        }

        public void setIf(String string) {
            this.ifProperty = string;
        }

        public void setUnless(String string) {
            this.unlessProperty = string;
        }

        public boolean shouldUse() {
            if (this.ifProperty != null && this.project.getProperty(this.ifProperty) == null) {
                return false;
            }
            return this.unlessProperty == null || this.project.getProperty(this.unlessProperty) == null;
        }
    }
}

