/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.number;

import com.icl.saxon.number.Numberer;

public class Numberer_en
implements Numberer {
    protected String westernDigits = "0123456789";
    protected String latinUpper = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    protected String latinLower = "abcdefghijklmnopqrstuvwxyz";
    protected String greekUpper = "\u0391\u0392\u0393\u0394\u0395\u0396\u0397\u0398\u0399\u039a\u039b\u039c\u039c\u039d\u039e\u039f\u03a0\u03a1\u03a3\u03a4\u03a5\u03a6\u03a7\u03a8\u03a9";
    protected String greekLower = "\u03b1\u03b2\u03b3\u03b4\u03b5\u03b6\u03b7\u03b8\u03b9\u03ba\u03bb\u03bc\u03bc\u03bd\u03be\u03bf\u03c0\u03c1\u03c3\u03c4\u03c5\u03c6\u03c7\u03c8\u03c9";
    protected String cyrillicUpper = "\u0410\u0411\u0412\u0413\u0414\u0415\u0416\u0417\u0418\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0421\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042b\u042d\u042e\u042f";
    protected String cyrillicLower = "\u0430\u0431\u0432\u0433\u0434\u0435\u0436\u0437\u0438\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0441\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044b\u044d\u044e\u044f";
    protected String hebrew = "\u05d0\u05d1\u05d2\u05d3\u05d4\u05d5\u05d6\u05d7\u05d8\u05d9\u05db\u05dc\u05de\u05e0\u05e1\u05e2\u05e4\u05e6\u05e7\u05e8\u05e9\u05ea";
    protected String hiraganaA = "\u3042\u3044\u3046\u3048\u304a\u304b\u304d\u304f\u3051\u3053\u3055\u3057\u3059\u305b\u305d\u305f\u3061\u3064\u3066\u3068\u306a\u306b\u306c\u306d\u306e\u306f\u3072\u3075\u3078\u307b\u307e\u307f\u3080\u3081\u3082\u3084\u3086\u3088\u3089\u308a\u308b\u308c\u308d\u308f\u3092\u3093";
    protected String katakanaA = "\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f2\u30f3";
    protected String hiraganaI = "\u3044\u308d\u306f\u306b\u307b\u3078\u3068\u3061\u308a\u306c\u308b\u3092\u308f\u304b\u3088\u305f\u308c\u305d\u3064\u306d\u306a\u3089\u3080\u3046\u3090\u306e\u304a\u304f\u3084\u307e\u3051\u3075\u3053\u3048\u3066\u3042\u3055\u304d\u3086\u3081\u307f\u3057\u3091\u3072\u3082\u305b\u3059";
    protected String katakanaI = "\u30a4\u30ed\u30cf\u30cb\u30db\u30d8\u30c8\u30c1\u30ea\u30cc\u30eb\u30f2\u30ef\u30ab\u30e8\u30bf\u30ec\u30bd\u30c4\u30cd\u30ca\u30e9\u30e0\u30a6\u30f0\u30ce\u30aa\u30af\u30e4\u30de\u30b1\u30d5\u30b3\u30a8\u30c6\u30a2\u30b5\u30ad\u30e6\u30e1\u30df\u30b7\u30f1\u30d2\u30e2\u30bb\u30b9";
    protected String kanjiDigits = "\u3007\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d";
    private static String[] romanThousands = new String[]{"", "m", "mm", "mmm", "mmmm", "mmmmm", "mmmmmm", "mmmmmmm", "mmmmmmmm", "mmmmmmmmm"};
    private static String[] romanHundreds = new String[]{"", "c", "cc", "ccc", "cd", "d", "dc", "dcc", "dccc", "cm"};
    private static String[] romanTens = new String[]{"", "x", "xx", "xxx", "xl", "l", "lx", "lxx", "lxxx", "xc"};
    private static String[] romanUnits = new String[]{"", "i", "ii", "iii", "iv", "v", "vi", "vii", "viii", "ix"};
    protected String[] englishUnits = new String[]{"", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen"};
    protected String[] englishTens = new String[]{"", "ten", "twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety"};

    public String format(int n, String string, int n2, String string2, String string3) {
        if (n <= 0) {
            return "" + n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char c = string.charAt(0);
        switch (c) {
            case '0': 
            case '1': {
                stringBuffer.append(this.toRadical(n, this.westernDigits, string, n2, string2));
                break;
            }
            case 'A': {
                stringBuffer.append(this.toAlphaSequence(n, this.latinUpper));
                break;
            }
            case 'a': {
                stringBuffer.append(this.toAlphaSequence(n, this.latinLower));
                break;
            }
            case 'i': {
                if (string3.equals("alphabetic")) {
                    this.alphaDefault(n, c, stringBuffer);
                    break;
                }
                stringBuffer.append(this.toRoman(n));
                break;
            }
            case 'I': {
                if (string3.equals("alphabetic")) {
                    this.alphaDefault(n, c, stringBuffer);
                    break;
                }
                stringBuffer.append(this.toRoman(n).toUpperCase());
                break;
            }
            case 'o': {
                if (string.equals("one")) {
                    stringBuffer.append(this.toWords(n));
                    break;
                }
                this.alphaDefault(n, c, stringBuffer);
                break;
            }
            case 'O': {
                if (string.equals("ONE")) {
                    stringBuffer.append(this.toWords(n).toUpperCase());
                    break;
                }
                this.alphaDefault(n, c, stringBuffer);
                break;
            }
            case '\u0391': {
                stringBuffer.append(this.toAlphaSequence(n, this.greekUpper));
                break;
            }
            case '\u03b1': {
                stringBuffer.append(this.toAlphaSequence(n, this.greekLower));
                break;
            }
            case '\u0410': {
                stringBuffer.append(this.toAlphaSequence(n, this.cyrillicUpper));
                break;
            }
            case '\u0430': {
                stringBuffer.append(this.toAlphaSequence(n, this.cyrillicLower));
                break;
            }
            case '\u05d0': {
                stringBuffer.append(this.toAlphaSequence(n, this.hebrew));
                break;
            }
            case '\u3042': {
                stringBuffer.append(this.toAlphaSequence(n, this.hiraganaA));
                break;
            }
            case '\u30a2': {
                stringBuffer.append(this.toAlphaSequence(n, this.katakanaA));
                break;
            }
            case '\u3044': {
                stringBuffer.append(this.toAlphaSequence(n, this.hiraganaI));
                break;
            }
            case '\u30a4': {
                stringBuffer.append(this.toAlphaSequence(n, this.katakanaI));
                break;
            }
            case '\u4e00': {
                stringBuffer.append(this.toRadical(n, this.kanjiDigits, string, n2, string2));
                break;
            }
            default: {
                if (Character.isDigit(c)) {
                    int n3 = c - Character.getNumericValue(c);
                    String string4 = "" + (char)n3 + (char)(n3 + 1) + (char)(n3 + 2) + (char)(n3 + 3) + (char)(n3 + 4) + (char)(n3 + 5) + (char)(n3 + 6) + (char)(n3 + 7) + (char)(n3 + 8) + (char)(n3 + 9);
                    stringBuffer.append(this.toRadical(n, string4, string, n2, string2));
                    break;
                }
                if (c < '\u1100') {
                    this.alphaDefault(n, c, stringBuffer);
                    break;
                }
                stringBuffer.append(this.toRadical(n, this.westernDigits, string, n2, string2));
            }
        }
        return stringBuffer.toString();
    }

    protected void alphaDefault(int n, char n2, StringBuffer stringBuffer) {
        int n3 = n2;
        int n4 = n2;
        while (Character.isLetterOrDigit((char)(n4 + '\u0001'))) {
            ++n4;
        }
        stringBuffer.append(this.toAlpha(n, n3, n4));
    }

    protected String toAlpha(int n, int n2, int n3) {
        if (n <= 0) {
            return "" + n;
        }
        int n4 = n3 - n2 + 1;
        char c = (char)((n - 1) % n4 + n2);
        if (n > n4) {
            return this.toAlpha((n - 1) / n4, n2, n3) + c;
        }
        return "" + c;
    }

    protected String toAlphaSequence(int n, String string) {
        if (n <= 0) {
            return "" + n;
        }
        int n2 = string.length();
        char c = string.charAt((n - 1) % n2);
        if (n > n2) {
            return this.toAlphaSequence((n - 1) / n2, string) + c;
        }
        return "" + c;
    }

    protected String toRadical(int n, String string, String string2, int n2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n3 = string.length();
        String string4 = "";
        int n4 = n;
        while (n4 > 0) {
            string4 = string.charAt(n4 % n3) + string4;
            n4 /= n3;
        }
        int n5 = 0;
        while (n5 < string2.length() - string4.length()) {
            stringBuffer2.append(string.charAt(0));
            ++n5;
        }
        stringBuffer2.append(string4);
        if (n2 > 0) {
            int n6 = 0;
            while (n6 < stringBuffer2.length()) {
                if (n6 != 0 && (stringBuffer2.length() - n6) % n2 == 0) {
                    stringBuffer.append(string3);
                }
                stringBuffer.append(stringBuffer2.charAt(n6));
                ++n6;
            }
        } else {
            stringBuffer = stringBuffer2;
        }
        return stringBuffer.toString();
    }

    protected String toRoman(int n) {
        if (n <= 0 || n > 9999) {
            return "" + n;
        }
        return romanThousands[n / 1000] + romanHundreds[n / 100 % 10] + romanTens[n / 10 % 10] + romanUnits[n % 10];
    }

    public String toWords(int n) {
        if (n >= 1000000000) {
            return this.toWords(n / 1000000000) + " billion " + this.toWords(n % 1000000000);
        }
        if (n >= 1000000) {
            return this.toWords(n / 1000000) + " million " + this.toWords(n % 1000000);
        }
        if (n >= 1000) {
            return this.toWords(n / 1000) + " thousand " + this.toWords(n % 1000);
        }
        if (n >= 100) {
            int n2 = n % 100;
            return this.toWords(n / 100) + " hundred" + (n2 == 0 ? "" : " and " + this.toWords(n2));
        }
        if (n < 20) {
            return this.englishUnits[n];
        }
        int n3 = n % 10;
        return this.englishTens[n / 10] + (n3 == 0 ? "" : " " + this.englishUnits[n3]);
    }
}

