/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;

public class StringJoin
extends SystemFunction {
    private boolean returnEmptyIfEmpty;

    public void setReturnEmptyIfEmpty(boolean option) {
        this.returnEmptyIfEmpty = option;
    }

    public Expression copy() {
        StringJoin sj = (StringJoin)super.copy();
        sj.returnEmptyIfEmpty = this.returnEmptyIfEmpty;
        return sj;
    }

    public int getImplementationMethod() {
        return super.getImplementationMethod() | 0x10;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression exp = super.optimize(visitor, contextItemType);
        if (exp instanceof StringJoin) {
            return ((StringJoin)exp).simplifySingleton();
        }
        return exp;
    }

    private Expression simplifySingleton() {
        int card = this.argument[0].getCardinality();
        if (!Cardinality.allowsMany(card)) {
            if (Cardinality.allowsZero(card)) {
                return SystemFunction.makeSystemFunction("string", new Expression[]{this.argument[0]});
            }
            return this.argument[0];
        }
        return this;
    }

    public Item evaluateItem(XPathContext c) throws XPathException {
        SequenceIterator iter = this.argument[0].iterate(c);
        Item it = iter.next();
        if (it == null) {
            return this.returnEmptyIfEmpty ? null : StringValue.EMPTY_STRING;
        }
        CharSequence first = it.getStringValueCS();
        it = iter.next();
        if (it == null) {
            return StringValue.makeStringValue(first);
        }
        FastStringBuffer sb = new FastStringBuffer(64);
        sb.append(first);
        if (this.argument.length == 1) {
            sb.append(it.getStringValueCS());
            while (true) {
                if ((it = iter.next()) == null) {
                    return StringValue.makeStringValue(sb.condense());
                }
                sb.append(it.getStringValueCS());
            }
        }
        CharSequence sep = this.argument[1].evaluateItem(c).getStringValueCS();
        sb.append(sep);
        sb.append(it.getStringValueCS());
        while ((it = iter.next()) != null) {
            sb.append(sep);
            sb.append(it.getStringValueCS());
        }
        return StringValue.makeStringValue(sb.condense());
    }

    public void process(XPathContext context) throws XPathException {
        SequenceReceiver out = context.getReceiver();
        if (out instanceof ComplexContentOutputter) {
            out.append(StringValue.EMPTY_STRING, 0, 0);
            SequenceIterator iter = this.argument[0].iterate(context);
            Item it = iter.next();
            if (it == null) {
                return;
            }
            CharSequence first = it.getStringValueCS();
            out.characters(first, 0, 0);
            it = iter.next();
            if (it == null) {
                out.append(StringValue.EMPTY_STRING, 0, 0);
                return;
            }
            if (this.argument.length == 1) {
                out.characters(it.getStringValueCS(), 0, 0);
                while ((it = iter.next()) != null) {
                    out.characters(it.getStringValueCS(), 0, 0);
                }
            } else {
                CharSequence sep = this.argument[1].evaluateItem(context).getStringValueCS();
                out.characters(sep, 0, 0);
                out.characters(it.getStringValueCS(), 0, 0);
                while ((it = iter.next()) != null) {
                    out.characters(sep, 0, 0);
                    out.characters(it.getStringValueCS(), 0, 0);
                }
            }
            out.append(StringValue.EMPTY_STRING, 0, 0);
        } else {
            out.append(this.evaluateItem(context), 0, 0);
        }
    }
}

