/*
    SPDX-FileCopyrightText: Milian Wolff <milian.wolff@kdab.com>
    SPDX-FileCopyrightText: 2016 Klarälvdalens Datakonsult AB, a KDAB Group company, info@kdab.com

    SPDX-License-Identifier: GPL-2.0-or-later
*/

#pragma once

#include <QAbstractItemModel>

#include "data.h"

class EventModel : public QAbstractItemModel
{
    Q_OBJECT
public:
    explicit EventModel(QObject* parent = nullptr);
    virtual ~EventModel();

    enum Columns
    {
        ThreadColumn = 0,
        EventsColumn,
        NUM_COLUMNS
    };
    enum Roles
    {
        EventsRole = Qt::UserRole,
        MaxTimeRole,
        MinTimeRole,
        ApplicationStartTimeRole,
        ApplicationEndTimeRole,
        ThreadStartRole,
        ThreadEndRole,
        ThreadNameRole,
        ThreadIdRole,
        ProcessIdRole,
        CpuIdRole,
        NumProcessesRole,
        NumThreadsRole,
        NumCpusRole,
        MaxCostRole,
        SortRole,
        TotalCostsRole,
        EventResultsRole,
    };

    int rowCount(const QModelIndex& parent = {}) const override;
    int columnCount(const QModelIndex& parent = {}) const override;

    QVariant headerData(int section, Qt::Orientation orientation, int role) const override;
    QVariant data(const QModelIndex& index, int role = Qt::DisplayRole) const override;

    QModelIndex index(int row, int column, const QModelIndex& parent = {}) const override;
    QModelIndex parent(const QModelIndex& child) const override;

    using QAbstractItemModel::setData;
    void setData(const Data::EventResults& data);
    void setApplicationTime(Data::TimeRange timeRange);

    Data::TimeRange timeRange() const;

    struct Process
    {
        Process(qint32 pid = Data::INVALID_PID, const QVector<qint32>& threads = {}, const QString& name = {})
            : pid(pid)
            , threads(threads)
            , name(name)
        {
        }
        qint32 pid;
        QVector<qint32> threads;
        QString name;
    };

private:
    Data::EventResults m_data;
    QVector<Process> m_processes;
    Data::TimeRange m_time;
    Data::TimeRange m_applicationTime;
    quint64 m_totalOnCpuTime = 0;
    quint64 m_totalOffCpuTime = 0;
    quint64 m_totalEvents = 0;
    quint64 m_maxCost = 0;
};

Q_DECLARE_TYPEINFO(EventModel::Process, Q_MOVABLE_TYPE);
