# Cucumber-ruby 4.0rc4 is out

We're super excited to announce the latest (and, we hope, last) release candidate for Cucumber-ruby 4.
This new release introduces the following changes:
 - a new formatter for `Cucumber::Messages`
 - `log` and `attach` methods for step definitions
 - `cucumber-compatibility-kit` compliance
 - some deprecations

## `message` formatter

The main change for this new release is the support of the new `message` formatter, which produces all the
information about the test execution in a `NDJSON` report.

This new formatter can be easily used with the command:

```shell
cucumber --format message
```

At the moment, we provide two tools supporting this new format:
 - the stand-alone [`json-formatter`](https://github.com/cucumber/cucumber/tree/master/json-formatter#cucumber-json-formatter)
 - the new [`html-formatter`](https://github.com/cucumber/cucumber/tree/master/html-formatter#cucumber-html-formatter)

This new message format is one of the most important building-blocks on which we are building the new versions of `cucumber`.

## `log` and `attach` in step definitions

In order to have [a more consistent API across different implementations of Cucumber](https://github.com/cucumber/cucumber/issues/897), we have introduced two new methods usable inside step definitions:
 - `log(message)` logs a String which will be handled by the formatters
 - `attach(data, media_type)` attaches a file alongside the report

## CCK compliance

This release is also the first one that complies with the [`cucumber-compatibility-kit`](https://github.com/cucumber/cucumber/tree/master/compatibility-kit#cucumber-compatibility-kit),
 which is a set of tests that ensures that all versions of Cucumber (Ruby, Java, Javascript ...) support the same set of features
 and produce the same messages.

## Deprecations

The built-in JSON formatter (when running `cucumber --format=json`) is now deprecated in favor of the the message formatter used with the stand-alone [`json-formatter`](https://github.com/cucumber/cucumber/tree/master/json-formatter#cucumber-json-formatter).

Attaching files to the report should be done with `attach`, and `embed` is now deprecated. The same goes with the `puts` methods, which should now be favored by `log`.
This means that, when version 5.0 is out, when you use `puts` inside a step definition, this will simply output to the console, without being passed to the formatters. In the meantime, a deprecation warning will be output -- you can use `Kernel.puts` to avoid that warning.
