/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import java.io.IOException;
import java.io.Writer;

public class TailWriter
extends Writer {
    private final Writer delegate;
    private int suppressLineCount;

    public TailWriter(Writer delegate, int suppressLineCount) {
        this.delegate = delegate;
        this.suppressLineCount = suppressLineCount;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int offset = off;
        int length = len;
        while (this.suppressLineCount > 0 && length > 0) {
            length = -1;
            int i = 0;
            while (i < len && this.suppressLineCount > 0) {
                if (cbuf[off + i] == '\n') {
                    offset = off + i + 1;
                    length = len - i - 1;
                    --this.suppressLineCount;
                }
                ++i;
            }
            if (length > 0) continue;
            return;
        }
        this.delegate.write(cbuf, offset, length);
    }
}

