/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.contentassist;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ide.editor.contentassist.CompletionPrefixProvider;
import org.eclipse.xtext.nodemodel.BidiTreeIterator;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.LineAndColumn;

public class IndentationAwareCompletionPrefixProvider
extends CompletionPrefixProvider {
    @Override
    public String getInputToParse(String completeInput, int offset, int completionOffset) {
        int fixedOffset = this.getOffsetIncludingWhitespace(completeInput, offset, Math.min(completeInput.length(), completionOffset));
        return super.getInputToParse(completeInput, fixedOffset, completionOffset);
    }

    protected int getOffsetIncludingWhitespace(String input, int startOffset, int max) {
        int result = startOffset;
        while (result < max && Character.isWhitespace(input.charAt(result))) {
            ++result;
        }
        return result;
    }

    @Override
    public INode getLastCompleteNodeByOffset(INode node, int offset, int completionOffset) {
        INode result = this.getLastCompleteNodeByOffset(node, offset);
        if (result.getTotalLength() == 0) {
            int completionColumn = NodeModelUtils.getLineAndColumn((INode)node, (int)completionOffset).getColumn();
            INode bestResult = this.findBestEndToken(node, result, completionColumn, true);
            return bestResult;
        }
        if (result.getTotalEndOffset() < completionOffset) {
            int completionColumn = NodeModelUtils.getLineAndColumn((INode)node, (int)completionOffset).getColumn();
            INode bestResult = this.findBestEndToken(node, result, completionColumn, false);
            return bestResult;
        }
        return result;
    }

    protected INode findBestEndToken(INode root, INode candidate, int completionColumn, boolean candidateIsEndToken) {
        LinkedList sameGrammarElement = Lists.newLinkedList();
        PeekingIterator<ILeafNode> iterator = this.createReversedLeafIterator(root, candidate, sameGrammarElement);
        if (!iterator.hasNext()) {
            return candidate;
        }
        LinkedList<ILeafNode> sameOffset = candidateIsEndToken ? this.collectLeafsWithSameOffset((ILeafNode)candidate, iterator) : Lists.newLinkedList();
        EObject grammarElement = this.tryGetGrammarElementAsRule(candidateIsEndToken || sameGrammarElement.isEmpty() ? candidate : (INode)sameGrammarElement.getLast());
        ILeafNode result = candidateIsEndToken ? null : (ILeafNode)candidate;
        int sameOffsetSize = sameOffset.size();
        while (iterator.hasNext()) {
            ILeafNode next = (ILeafNode)iterator.next();
            if (result == null || result.isHidden()) {
                result = next;
            }
            if (next.getTotalLength() != 0) continue;
            EObject rule = this.tryGetGrammarElementAsRule((INode)next);
            if (rule != grammarElement) {
                LineAndColumn lineAndColumn = NodeModelUtils.getLineAndColumn((INode)root, (int)next.getTotalOffset());
                if (lineAndColumn.getColumn() <= completionColumn) {
                    return result;
                }
                if (sameOffset.isEmpty()) {
                    if (sameGrammarElement.isEmpty()) {
                        result = null;
                        continue;
                    }
                    result = (ILeafNode)sameGrammarElement.removeLast();
                    continue;
                }
                if (sameOffsetSize >= sameOffset.size()) {
                    result = sameOffset.removeLast();
                    continue;
                }
                sameOffset.removeLast();
                continue;
            }
            sameOffset.add(next);
        }
        return candidate;
    }

    private PeekingIterator<ILeafNode> createReversedLeafIterator(INode root, INode candidate, LinkedList<ILeafNode> sameGrammarElement) {
        EObject grammarElement = null;
        PeekingIterator iterator = Iterators.peekingIterator((Iterator)Iterators.filter((Iterator)root.getAsTreeIterable().reverse().iterator(), ILeafNode.class));
        while (iterator.hasNext()) {
            ILeafNode next = (ILeafNode)iterator.next();
            if (candidate.equals(next)) break;
            if (next.getTotalLength() != 0) continue;
            EObject otherGrammarElement = this.tryGetGrammarElementAsRule((INode)next);
            if (grammarElement == null) {
                grammarElement = otherGrammarElement;
            }
            if (otherGrammarElement.equals(grammarElement)) {
                sameGrammarElement.add(next);
                continue;
            }
            sameGrammarElement.removeLast();
        }
        return iterator;
    }

    private LinkedList<ILeafNode> collectLeafsWithSameOffset(ILeafNode candidate, PeekingIterator<ILeafNode> iterator) {
        LinkedList sameOffset = Lists.newLinkedList();
        sameOffset.add(candidate);
        int offset = candidate.getTotalOffset();
        while (iterator.hasNext()) {
            ILeafNode peek = (ILeafNode)iterator.peek();
            if (peek.getTotalOffset() != offset) break;
            sameOffset.add(peek);
            iterator.next();
        }
        return sameOffset;
    }

    protected EObject tryGetGrammarElementAsRule(INode candidate) {
        EObject grammarElement = candidate.getGrammarElement();
        if (grammarElement instanceof RuleCall) {
            grammarElement = ((RuleCall)grammarElement).getRule();
        }
        return grammarElement;
    }

    protected INode getLastCompleteNodeByOffset(INode node, int offset) {
        BidiTreeIterator iterator = node.getRootNode().getAsTreeIterable().iterator();
        INode result = node;
        ITextRegion candidateTextRegion = node.getTextRegion();
        while (iterator.hasNext()) {
            INode candidate = (INode)iterator.next();
            ITextRegion textRegion = candidate.getTextRegion();
            if (textRegion.getOffset() >= offset && (textRegion.getOffset() != offset || textRegion.getLength() != 0) && !candidateTextRegion.equals(textRegion) && candidate instanceof ILeafNode && textRegion.getLength() + textRegion.getOffset() >= offset) break;
            if (!(candidate instanceof ILeafNode) || candidate.getGrammarElement() != null && !(candidate.getGrammarElement() instanceof AbstractElement) && !(candidate.getGrammarElement() instanceof ParserRule)) continue;
            if (textRegion.getLength() == 0) {
                if (candidateTextRegion.getOffset() + candidateTextRegion.getLength() >= offset && (candidateTextRegion.getLength() != 0 || candidateTextRegion.getOffset() > offset)) continue;
                result = candidate;
                candidateTextRegion = candidate.getTextRegion();
                continue;
            }
            result = candidate;
            candidateTextRegion = candidate.getTextRegion();
        }
        return result;
    }
}

