/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model.cache;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.ExasolSysTablePrefix;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableColumn;
import org.jkiss.dbeaver.ext.exasol.model.ExasolView;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;

public class ExasolViewCache
extends JDBCStructCache<ExasolSchema, ExasolView, ExasolTableColumn> {
    private static final String SQL_COLS_VIEW = "/*snapshot execution*/ SELECT c.* FROM SYS.%s_COLUMNS c WHERE COLUMN_SCHEMA = '%s' AND COLUMN_TABLE = '%s' ORDER BY COLUMN_ORDINAL_POSITION ";
    private static final String SQL_COLS_ALL = "/*snapshot execution*/ SELECT c.* FROM SYS.%s_COLUMNS c WHERE COLUMN_SCHEMA = '%s' AND COLUMN_OBJECT_TYPE = 'VIEW' ORDER BY COLUMN_ORDINAL_POSITION ";
    private static final String SQL_COLS_SYS_VIEW = "/*snapshot execution*/ SELECT OBJECT_ID as COLUMN_OBJECT_ID, \tTABLE_CAT, \tTABLE_SCHEM as COLUMN_SCHEMA, \tTABLE_NAME as COLUMN_TABLE, \tCOLUMN_NAME as COLUMN_NAME, \tDATA_TYPE as COLUMN_TYPE_ID, \t'VIEW' as COLUMN_OBJECT_TYPE, \tTYPE_NAME  , \tCOLUMN_SIZE as COLUMN_MAXSIZE, \tDECIMAL_DIGITS as COLUMN_NUM_SCALE, \tNUM_PREC_RADIX, \tNULLABLE, \tREMARKS, \tCOLUMN_DEF as COLUMN_DEFAULT, \tCHAR_OCTET_LENGTH, \tORDINAL_POSITION as COLUMN_ORDINAL_POSITION, \tIS_NULLABLE, \tSCOPE_CATALOG, \tSCOPE_SCHEMA, \tSCOPE_TABLE, \tSOURCE_DATA_TYPE, \tCOLUMN_TYPE, \tCOLUMN_IS_DISTRIBUTION_KEY as COLUMN_IS_DISTRIBUTION_KEY, \tCOLUMN_IDENTITY as COLUMN_IDENTITY, \tCOLUMN_COMMENT as COLUMN_COMMENT, \tCOLUMN_IS_NULLABLE as COLUMN_IS_NULLABLE\t, \t'SYS' as COLUMN_OWNER, \tCAST(null as varchar(128)) as STATUS, \tcast(null as integer) as COLUMN_PARTITION_KEY_ORDINAL_POSITION FROM  \"$ODBCJDBC\".ALL_COLUMNS  WHERE table_schem = '%s' AND table_name = '%s'";
    private static final String SQL_COLS_SYS_ALL = "/*snapshot execution*/ SELECT OBJECT_ID as COLUMN_OBJECT_ID, \tTABLE_CAT, \tTABLE_SCHEM as COLUMN_SCHEMA, \tTABLE_NAME as COLUMN_TABLE, \tCOLUMN_NAME as COLUMN_NAME, \tDATA_TYPE as COLUMN_TYPE_ID, \t'VIEW' as COLUMN_OBJECT_TYPE, \tTYPE_NAME  , \tCOLUMN_SIZE as COLUMN_MAXSIZE, \tDECIMAL_DIGITS as COLUMN_NUM_SCALE, \tNUM_PREC_RADIX, \tNULLABLE, \tREMARKS, \tCOLUMN_DEF as COLUMN_DEFAULT, \tCHAR_OCTET_LENGTH, \tORDINAL_POSITION as COLUMN_ORDINAL_POSITION, \tIS_NULLABLE, \tSCOPE_CATALOG, \tSCOPE_SCHEMA, \tSCOPE_TABLE, \tSOURCE_DATA_TYPE, \tCOLUMN_TYPE, \tCOLUMN_IS_DISTRIBUTION_KEY as COLUMN_IS_DISTRIBUTION_KEY, \tCOLUMN_IDENTITY as COLUMN_IDENTITY, \tCOLUMN_COMMENT as COLUMN_COMMENT, \tCOLUMN_IS_NULLABLE as COLUMN_IS_NULLABLE\t, \t'SYS' as COLUMN_OWNER, \tCAST(null as varchar(128)) as STATUS, \tcast(null as integer) as COLUMN_PARTITION_KEY_ORDINAL_POSITION FROM  \"$ODBCJDBC\".ALL_COLUMNS  WHERE table_schem = '%s' ";
    private static final String SQL_VIEWS = "/*snapshot execution*/ select OWNER,OBJECT_ID,TABLE_CAT,TABLE_SCHEM,TABLE_NAME as COLUMN_TABLE,TABLE_TYPE,REMARKS,TYPE_CAT,TYPE_SCHEM,TYPE_NAME,SELF_REFERENCING_COL_NAME,REF_GENERATION from \"$ODBCJDBC\".ALL_TABLES WHERE TABLE_SCHEM = '%s' and TABLE_TYPE = 'VIEW'  union all select 'SYS',-1,' ',SCHEMA_name, object_name as column_table, object_type,object_comment,null, null,null,null,null from EXA_SYSCAT where SCHEMA_NAME = '%s' order by TABLE_NAME";

    public ExasolViewCache() {
        super((Object)"COLUMN_TABLE");
    }

    @NotNull
    protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull ExasolSchema exasolSchema) throws SQLException {
        String sql = String.format(SQL_VIEWS, exasolSchema.getName(), exasolSchema.getName());
        JDBCStatement dbstat = session.createStatement();
        dbstat.setQueryString(sql);
        return dbstat;
    }

    protected ExasolView fetchObject(@NotNull JDBCSession session, @NotNull ExasolSchema exasolSchema, @NotNull JDBCResultSet dbResult) {
        return new ExasolView(session.getProgressMonitor(), exasolSchema, (ResultSet)dbResult);
    }

    protected JDBCStatement prepareChildrenStatement(@NotNull JDBCSession session, @NotNull ExasolSchema exasolSchema, @Nullable ExasolView forView) throws SQLException {
        String tablePrefix = exasolSchema.getDataSource().getTablePrefix(ExasolSysTablePrefix.ALL);
        String sql = exasolSchema.getName().equals("SYS") || exasolSchema.getName().equals("EXA_STATISTICS") ? (forView != null ? String.format(SQL_COLS_SYS_VIEW, ExasolUtils.quoteString(exasolSchema.getName()), ExasolUtils.quoteString(forView.getName())) : String.format(SQL_COLS_SYS_ALL, ExasolUtils.quoteString(exasolSchema.getName()))) : (forView != null ? String.format(SQL_COLS_VIEW, tablePrefix, ExasolUtils.quoteString(exasolSchema.getName()), ExasolUtils.quoteString(forView.getName())) : String.format(SQL_COLS_ALL, tablePrefix, ExasolUtils.quoteString(exasolSchema.getName())));
        JDBCStatement dbStat = session.createStatement();
        dbStat.setQueryString(sql);
        return dbStat;
    }

    protected ExasolTableColumn fetchChild(@NotNull JDBCSession session, @NotNull ExasolSchema exasolSchema, @NotNull ExasolView exasolView, @NotNull JDBCResultSet dbResult) throws DBException {
        return new ExasolTableColumn(session.getProgressMonitor(), exasolView, (ResultSet)dbResult);
    }
}

