o[![License](https://img.shields.io/badge/License-GPL%20v2-blue.svg)](https://gitlab.xfce.org/xfce/xfce4-power-manager/-/blob/master/COPYING)

# xfce4-power-manager

Xfce4-power-manager manages the power sources of the computer and connected 
devices (wireless mice, keyboards, media players etc.). It also allows users 
to control the display backlight brightness and set power-saving modes for 
displays and monitors.
In addition, xfce4-power-manager provides a set of freedesktop-compliant DBus
interfaces to inform other applications about the current power level so that 
they can adjust their power consumption.

----

### Homepage

[Xfce4-power-manager documentation](https://docs.xfce.org/xfce/xfce4-power-manager/start)

### Changelog

See [NEWS](https://gitlab.xfce.org/xfce/xfce4-power-manager/-/blob/master/NEWS) for details on changes and fixes made in the current release.

### Source Code Repository

[Xfce4-power-manager source code](https://gitlab.xfce.org/xfce/xfce4-power-manager)

### Download a Release Tarball

[Xfce4-power-manager archive](https://archive.xfce.org/src/xfce/xfce4-power-manager)
    or
[Xfce4-power-manager tags](https://gitlab.xfce.org/xfce/xfce4-power-manager/-/tags)

### Installation

From source: 

    % cd xfce4-power-manager
    % meson setup build
    % meson compile -C build
    % meson install -C build

From release tarball:

    % tar xf xfce4-power-manager-<version>.tar.xz
    % cd xfce4-power-manager-<version>
    % meson setup build
    % meson compile -C build
    % meson install -C build

### Uninstallation

    % ninja uninstall -C build

### Reporting Bugs

Visit the [reporting bugs](https://docs.xfce.org/xfce/xfce4-power-manager/bugs) page to view currently open bug reports and instructions on reporting new bugs or submitting bugfixes.
