/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.print.provider;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.print.provider.ComponentDocument;
import org.netbeans.modules.print.provider.ComponentPanel;
import org.netbeans.modules.print.provider.ComponentProvider;
import org.netbeans.modules.print.util.Config;
import org.openide.cookies.EditorCookie;
import org.openide.util.Lookup;

public final class EditorProvider
extends ComponentProvider {
    private EditorCookie myEditor;

    public EditorProvider(EditorCookie editorCookie, Date date) {
        super(null, EditorProvider.getName(editorCookie), date);
        this.myEditor = editorCookie;
    }

    @Override
    protected JComponent getComponent() {
        int n;
        int n2;
        JTextComponent jTextComponent = this.getTextComponent();
        if (jTextComponent == null) {
            return null;
        }
        if (Config.getDefault().isAsEditor()) {
            return this.getEditorComponent(jTextComponent);
        }
        StyledDocument styledDocument = this.myEditor.getDocument();
        if (styledDocument == null) {
            return null;
        }
        if (Config.getDefault().isSelection()) {
            n2 = jTextComponent.getSelectionStart();
            n = jTextComponent.getSelectionEnd();
        } else {
            n2 = 0;
            n = styledDocument.getLength();
        }
        AttributedCharacterIterator[] attributedCharacterIteratorArray = this.getIterators(styledDocument, n2, n);
        if (attributedCharacterIteratorArray != null) {
            return new ComponentDocument(attributedCharacterIteratorArray);
        }
        try {
            return new ComponentDocument(jTextComponent.getText(n2, n - n2));
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private AttributedCharacterIterator[] getIterators(Document document, int n, int n2) {
        ActionListener actionListener = (ActionListener)Lookup.getDefault().lookup(ActionListener.class);
        if (actionListener == null) {
            return null;
        }
        if (!actionListener.getClass().getName().contains(".print.")) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(document);
        arrayList.add(n);
        arrayList.add(n2);
        ActionEvent actionEvent = new ActionEvent(arrayList, 0, null);
        actionListener.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (!(object instanceof List)) {
            return null;
        }
        List list = (List)object;
        if (list.size() != 4) {
            return null;
        }
        Object e = list.get(3);
        if (!(e instanceof AttributedCharacterIterator[])) {
            return null;
        }
        return (AttributedCharacterIterator[])e;
    }

    private static String getName(EditorCookie editorCookie) {
        StyledDocument styledDocument = editorCookie.getDocument();
        if (styledDocument == null) {
            return null;
        }
        String string = (String)styledDocument.getProperty("title");
        if (string == null) {
            return null;
        }
        return string.replace('\\', '/');
    }

    private JTextComponent getTextComponent() {
        JEditorPane[] jEditorPaneArray = this.myEditor.getOpenedPanes();
        if (jEditorPaneArray == null || jEditorPaneArray.length == 0) {
            return null;
        }
        return jEditorPaneArray[0];
    }

    private JComponent getEditorComponent(JComponent jComponent) {
        if (!Config.getDefault().isLineNumbers()) {
            return jComponent;
        }
        JComponent jComponent2 = this.getLineNumberComponent(this.getParent(jComponent));
        if (jComponent2 == null) {
            return jComponent;
        }
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        arrayList.add(jComponent2);
        arrayList.add(jComponent);
        return new ComponentPanel(arrayList);
    }

    private JComponent getLineNumberComponent(Component component) {
        Component[] componentArray;
        if (component == null) {
            return null;
        }
        if (component.getClass().getName().equals("org.netbeans.editor.GlyphGutter") && component instanceof JComponent) {
            return (JComponent)component;
        }
        if (!(component instanceof Container)) {
            return null;
        }
        Container container = (Container)component;
        for (Component component2 : componentArray = container.getComponents()) {
            JComponent jComponent = this.getLineNumberComponent(component2);
            if (jComponent == null) continue;
            return jComponent;
        }
        return null;
    }

    private Component getParent(Component component) {
        Container container = component.getParent();
        if (container == null) {
            return component;
        }
        return this.getParent(container);
    }
}

