\page README_HowToRunMT Tips how to run an example in multi-threading mode

Only migrated examples or user applications can be run in multi-threading (MT) mode. 
The instructions for migrating user applications can be found in Geant4 documentation guides 
and a short howto is available here:

https://twiki.cern.ch/twiki/bin/view/Geant4/QuickMigrationGuideForGeant4V10 

In this file, we give just useful tips for running already migrated examples
(or user applications).

## Run example in multi-threading mode

No special steps are needed to build an example in multi-threading (MT) mode.
The examples which has been migrated to multi-threading will automatically 
run in MT when they are built against the Geant4 libraries built with MT mode
activated, otherwise they will run in sequential mode.
Not migrated examples will run in sequential mode even when built against
Geant4 libraries built with MT mode activated.

The examples which do NOT support MT can be easily recognized by the following line
of code in main ():
```
G4RunManager* runManager = new G4RunManager;
```
or
```
auto* runManager = G4RunManagerFactory::CreateRunManager(G4RunManagerType::SerialOnly);
```

## Set number of threads

When the number of threads is not selected in the application, the default number
(which is actually 2) will be used. Another number of threads can be set in several
ways:

- in the code
```
  auto* runManager = ...;
  runManager->SetNumberOfThreads(4);
```

- in a macro file via UI command added just before /run/initialize
```
/run/numberOfThreads 4
```

- by setting the environment variable 
```
export G4FORCENUMBEROFTHREADS = 4  
or
setenv G4FORCENUMBEROFTHREADS 4
```

The environment variable value is forced and it cannot be changed from a code 
call or a macro. A warning is issued in such situation.

## Output from threads

In MT processing each worker produces its output and these messages are interlayed
on the screen. The messeges from threads are preceded with a predefined string 
G4WTi> where i is the thread number.  Users can change this default behaviour 
and choose

- to limit the output from threads to one selected thread only: 
```
/control/cout/ignoreThreadsExcept 0
```

- to redirect the output from threads in a file:
```
/control/cout/setCoutFile coutFileName
/control/cout/setCerrFile cerrFileName
```

- to buffer the output from each thread at a time, so that the output of each
  thread is grouped and printed at the end of the job
```
/control/cout/useBuffer true|false
```
