//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfbundle?language=objc)
#[doc(alias = "CFBundleRef")]
#[repr(C)]
pub struct CFBundle {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CFBundle {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CFBundle"> for CFBundle {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfplugin?language=objc)
#[doc(alias = "CFPlugInRef")]
#[repr(C)]
pub struct CFPlugIn {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CFPlugIn {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CFBundle"> for CFPlugIn {}
);

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfbundleinfodictionaryversionkey?language=objc)
    pub static kCFBundleInfoDictionaryVersionKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfbundleexecutablekey?language=objc)
    pub static kCFBundleExecutableKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfbundleidentifierkey?language=objc)
    pub static kCFBundleIdentifierKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfbundleversionkey?language=objc)
    pub static kCFBundleVersionKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfbundledevelopmentregionkey?language=objc)
    pub static kCFBundleDevelopmentRegionKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfbundlenamekey?language=objc)
    pub static kCFBundleNameKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfbundlelocalizationskey?language=objc)
    pub static kCFBundleLocalizationsKey: Option<&'static CFString>;
}

impl CFBundle {
    #[doc(alias = "CFBundleGetMainBundle")]
    #[inline]
    pub fn main_bundle() -> Option<CFRetained<CFBundle>> {
        extern "C-unwind" {
            fn CFBundleGetMainBundle() -> Option<NonNull<CFBundle>>;
        }
        let ret = unsafe { CFBundleGetMainBundle() };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    #[doc(alias = "CFBundleGetBundleWithIdentifier")]
    #[inline]
    pub fn bundle_with_identifier(bundle_id: Option<&CFString>) -> Option<CFRetained<CFBundle>> {
        extern "C-unwind" {
            fn CFBundleGetBundleWithIdentifier(
                bundle_id: Option<&CFString>,
            ) -> Option<NonNull<CFBundle>>;
        }
        let ret = unsafe { CFBundleGetBundleWithIdentifier(bundle_id) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    #[doc(alias = "CFBundleGetAllBundles")]
    #[cfg(feature = "CFArray")]
    #[inline]
    pub unsafe fn all_bundles() -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CFBundleGetAllBundles() -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { CFBundleGetAllBundles() };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }
}

unsafe impl ConcreteType for CFBundle {
    #[doc(alias = "CFBundleGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFBundleGetTypeID() -> CFTypeID;
        }
        unsafe { CFBundleGetTypeID() }
    }
}

impl CFBundle {
    #[doc(alias = "CFBundleCreate")]
    #[cfg(feature = "CFURL")]
    #[inline]
    pub fn new(
        allocator: Option<&CFAllocator>,
        bundle_url: Option<&CFURL>,
    ) -> Option<CFRetained<CFBundle>> {
        extern "C-unwind" {
            fn CFBundleCreate(
                allocator: Option<&CFAllocator>,
                bundle_url: Option<&CFURL>,
            ) -> Option<NonNull<CFBundle>>;
        }
        let ret = unsafe { CFBundleCreate(allocator, bundle_url) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFBundleCreateBundlesFromDirectory")]
    #[cfg(all(feature = "CFArray", feature = "CFURL"))]
    #[inline]
    pub fn new_bundles_from_directory(
        allocator: Option<&CFAllocator>,
        directory_url: Option<&CFURL>,
        bundle_type: Option<&CFString>,
    ) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CFBundleCreateBundlesFromDirectory(
                allocator: Option<&CFAllocator>,
                directory_url: Option<&CFURL>,
                bundle_type: Option<&CFString>,
            ) -> Option<NonNull<CFArray>>;
        }
        let ret =
            unsafe { CFBundleCreateBundlesFromDirectory(allocator, directory_url, bundle_type) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFBundleCopyBundleURL")]
    #[cfg(feature = "CFURL")]
    #[inline]
    pub fn bundle_url(&self) -> Option<CFRetained<CFURL>> {
        extern "C-unwind" {
            fn CFBundleCopyBundleURL(bundle: &CFBundle) -> Option<NonNull<CFURL>>;
        }
        let ret = unsafe { CFBundleCopyBundleURL(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFBundleGetValueForInfoDictionaryKey")]
    #[inline]
    pub fn value_for_info_dictionary_key(
        &self,
        key: Option<&CFString>,
    ) -> Option<CFRetained<CFType>> {
        extern "C-unwind" {
            fn CFBundleGetValueForInfoDictionaryKey(
                bundle: &CFBundle,
                key: Option<&CFString>,
            ) -> Option<NonNull<CFType>>;
        }
        let ret = unsafe { CFBundleGetValueForInfoDictionaryKey(self, key) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    #[doc(alias = "CFBundleGetInfoDictionary")]
    #[cfg(feature = "CFDictionary")]
    #[inline]
    pub fn info_dictionary(&self) -> Option<CFRetained<CFDictionary>> {
        extern "C-unwind" {
            fn CFBundleGetInfoDictionary(bundle: &CFBundle) -> Option<NonNull<CFDictionary>>;
        }
        let ret = unsafe { CFBundleGetInfoDictionary(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    #[doc(alias = "CFBundleGetLocalInfoDictionary")]
    #[cfg(feature = "CFDictionary")]
    #[inline]
    pub fn local_info_dictionary(&self) -> Option<CFRetained<CFDictionary>> {
        extern "C-unwind" {
            fn CFBundleGetLocalInfoDictionary(bundle: &CFBundle) -> Option<NonNull<CFDictionary>>;
        }
        let ret = unsafe { CFBundleGetLocalInfoDictionary(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// # Safety
    ///
    /// - `package_type` must be a valid pointer.
    /// - `package_creator` must be a valid pointer.
    #[doc(alias = "CFBundleGetPackageInfo")]
    #[inline]
    pub unsafe fn package_info(&self, package_type: *mut u32, package_creator: *mut u32) {
        extern "C-unwind" {
            fn CFBundleGetPackageInfo(
                bundle: &CFBundle,
                package_type: *mut u32,
                package_creator: *mut u32,
            );
        }
        unsafe { CFBundleGetPackageInfo(self, package_type, package_creator) }
    }

    #[doc(alias = "CFBundleGetIdentifier")]
    #[inline]
    pub fn identifier(&self) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CFBundleGetIdentifier(bundle: &CFBundle) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CFBundleGetIdentifier(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    #[doc(alias = "CFBundleGetVersionNumber")]
    #[inline]
    pub fn version_number(&self) -> u32 {
        extern "C-unwind" {
            fn CFBundleGetVersionNumber(bundle: &CFBundle) -> u32;
        }
        unsafe { CFBundleGetVersionNumber(self) }
    }

    #[doc(alias = "CFBundleGetDevelopmentRegion")]
    #[inline]
    pub fn development_region(&self) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CFBundleGetDevelopmentRegion(bundle: &CFBundle) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CFBundleGetDevelopmentRegion(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    #[doc(alias = "CFBundleCopySupportFilesDirectoryURL")]
    #[cfg(feature = "CFURL")]
    #[inline]
    pub fn support_files_directory_url(&self) -> Option<CFRetained<CFURL>> {
        extern "C-unwind" {
            fn CFBundleCopySupportFilesDirectoryURL(bundle: &CFBundle) -> Option<NonNull<CFURL>>;
        }
        let ret = unsafe { CFBundleCopySupportFilesDirectoryURL(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFBundleCopyResourcesDirectoryURL")]
    #[cfg(feature = "CFURL")]
    #[inline]
    pub fn resources_directory_url(&self) -> Option<CFRetained<CFURL>> {
        extern "C-unwind" {
            fn CFBundleCopyResourcesDirectoryURL(bundle: &CFBundle) -> Option<NonNull<CFURL>>;
        }
        let ret = unsafe { CFBundleCopyResourcesDirectoryURL(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFBundleCopyPrivateFrameworksURL")]
    #[cfg(feature = "CFURL")]
    #[inline]
    pub fn private_frameworks_url(&self) -> Option<CFRetained<CFURL>> {
        extern "C-unwind" {
            fn CFBundleCopyPrivateFrameworksURL(bundle: &CFBundle) -> Option<NonNull<CFURL>>;
        }
        let ret = unsafe { CFBundleCopyPrivateFrameworksURL(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFBundleCopySharedFrameworksURL")]
    #[cfg(feature = "CFURL")]
    #[inline]
    pub fn shared_frameworks_url(&self) -> Option<CFRetained<CFURL>> {
        extern "C-unwind" {
            fn CFBundleCopySharedFrameworksURL(bundle: &CFBundle) -> Option<NonNull<CFURL>>;
        }
        let ret = unsafe { CFBundleCopySharedFrameworksURL(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFBundleCopySharedSupportURL")]
    #[cfg(feature = "CFURL")]
    #[inline]
    pub fn shared_support_url(&self) -> Option<CFRetained<CFURL>> {
        extern "C-unwind" {
            fn CFBundleCopySharedSupportURL(bundle: &CFBundle) -> Option<NonNull<CFURL>>;
        }
        let ret = unsafe { CFBundleCopySharedSupportURL(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFBundleCopyBuiltInPlugInsURL")]
    #[cfg(feature = "CFURL")]
    #[inline]
    pub fn built_in_plug_ins_url(&self) -> Option<CFRetained<CFURL>> {
        extern "C-unwind" {
            fn CFBundleCopyBuiltInPlugInsURL(bundle: &CFBundle) -> Option<NonNull<CFURL>>;
        }
        let ret = unsafe { CFBundleCopyBuiltInPlugInsURL(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFBundleCopyInfoDictionaryInDirectory")]
    #[cfg(all(feature = "CFDictionary", feature = "CFURL"))]
    #[inline]
    pub fn info_dictionary_in_directory(
        bundle_url: Option<&CFURL>,
    ) -> Option<CFRetained<CFDictionary>> {
        extern "C-unwind" {
            fn CFBundleCopyInfoDictionaryInDirectory(
                bundle_url: Option<&CFURL>,
            ) -> Option<NonNull<CFDictionary>>;
        }
        let ret = unsafe { CFBundleCopyInfoDictionaryInDirectory(bundle_url) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// # Safety
    ///
    /// - `url` might not allow `None`.
    /// - `package_type` must be a valid pointer.
    /// - `package_creator` must be a valid pointer.
    #[doc(alias = "CFBundleGetPackageInfoInDirectory")]
    #[cfg(feature = "CFURL")]
    #[inline]
    pub unsafe fn package_info_in_directory(
        url: Option<&CFURL>,
        package_type: *mut u32,
        package_creator: *mut u32,
    ) -> bool {
        extern "C-unwind" {
            fn CFBundleGetPackageInfoInDirectory(
                url: Option<&CFURL>,
                package_type: *mut u32,
                package_creator: *mut u32,
            ) -> Boolean;
        }
        let ret = unsafe { CFBundleGetPackageInfoInDirectory(url, package_type, package_creator) };
        ret != 0
    }

    #[doc(alias = "CFBundleCopyResourceURL")]
    #[cfg(feature = "CFURL")]
    #[inline]
    pub fn resource_url(
        &self,
        resource_name: Option<&CFString>,
        resource_type: Option<&CFString>,
        sub_dir_name: Option<&CFString>,
    ) -> Option<CFRetained<CFURL>> {
        extern "C-unwind" {
            fn CFBundleCopyResourceURL(
                bundle: &CFBundle,
                resource_name: Option<&CFString>,
                resource_type: Option<&CFString>,
                sub_dir_name: Option<&CFString>,
            ) -> Option<NonNull<CFURL>>;
        }
        let ret =
            unsafe { CFBundleCopyResourceURL(self, resource_name, resource_type, sub_dir_name) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFBundleCopyResourceURLsOfType")]
    #[cfg(feature = "CFArray")]
    #[inline]
    pub fn resource_urls_of_type(
        &self,
        resource_type: Option<&CFString>,
        sub_dir_name: Option<&CFString>,
    ) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CFBundleCopyResourceURLsOfType(
                bundle: &CFBundle,
                resource_type: Option<&CFString>,
                sub_dir_name: Option<&CFString>,
            ) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { CFBundleCopyResourceURLsOfType(self, resource_type, sub_dir_name) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFBundleCopyLocalizedString")]
    #[inline]
    pub fn localized_string(
        &self,
        key: Option<&CFString>,
        value: Option<&CFString>,
        table_name: Option<&CFString>,
    ) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CFBundleCopyLocalizedString(
                bundle: &CFBundle,
                key: Option<&CFString>,
                value: Option<&CFString>,
                table_name: Option<&CFString>,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CFBundleCopyLocalizedString(self, key, value, table_name) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Returns a localized string given a list of possible localizations. The one most suitable to use with the given ``bundle`` is returned.
    /// - Parameters:
    /// - bundle: The bundle to examine.
    /// - key: The key for the localized string to retrieve.
    /// - value: A default value to return if no value exists for ``key``.
    /// - tableName: The name of the strings file to search.
    /// - localizations: An array of BCP 47 language codes corresponding to available localizations. Bundle compares the array against its available localizations, and uses the best result to retrieve the localized string. If empty, we treat it as no localization is available, and may return a fallback.
    /// - Returns: A localized version of the string designated by ``key`` in table ``tableName``.
    ///
    /// # Safety
    ///
    /// - `key` might not allow `None`.
    /// - `value` might not allow `None`.
    /// - `table_name` might not allow `None`.
    /// - `localizations` generic must be of the correct type.
    /// - `localizations` might not allow `None`.
    #[doc(alias = "CFBundleCopyLocalizedStringForLocalizations")]
    #[cfg(feature = "CFArray")]
    #[inline]
    pub unsafe fn localized_string_for_localizations(
        &self,
        key: Option<&CFString>,
        value: Option<&CFString>,
        table_name: Option<&CFString>,
        localizations: Option<&CFArray>,
    ) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CFBundleCopyLocalizedStringForLocalizations(
                bundle: &CFBundle,
                key: Option<&CFString>,
                value: Option<&CFString>,
                table_name: Option<&CFString>,
                localizations: Option<&CFArray>,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe {
            CFBundleCopyLocalizedStringForLocalizations(self, key, value, table_name, localizations)
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFBundleCopyResourceURLInDirectory")]
    #[cfg(feature = "CFURL")]
    #[inline]
    pub fn resource_url_in_directory(
        bundle_url: Option<&CFURL>,
        resource_name: Option<&CFString>,
        resource_type: Option<&CFString>,
        sub_dir_name: Option<&CFString>,
    ) -> Option<CFRetained<CFURL>> {
        extern "C-unwind" {
            fn CFBundleCopyResourceURLInDirectory(
                bundle_url: Option<&CFURL>,
                resource_name: Option<&CFString>,
                resource_type: Option<&CFString>,
                sub_dir_name: Option<&CFString>,
            ) -> Option<NonNull<CFURL>>;
        }
        let ret = unsafe {
            CFBundleCopyResourceURLInDirectory(
                bundle_url,
                resource_name,
                resource_type,
                sub_dir_name,
            )
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFBundleCopyResourceURLsOfTypeInDirectory")]
    #[cfg(all(feature = "CFArray", feature = "CFURL"))]
    #[inline]
    pub fn resource_urls_of_type_in_directory(
        bundle_url: Option<&CFURL>,
        resource_type: Option<&CFString>,
        sub_dir_name: Option<&CFString>,
    ) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CFBundleCopyResourceURLsOfTypeInDirectory(
                bundle_url: Option<&CFURL>,
                resource_type: Option<&CFString>,
                sub_dir_name: Option<&CFString>,
            ) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe {
            CFBundleCopyResourceURLsOfTypeInDirectory(bundle_url, resource_type, sub_dir_name)
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFBundleCopyBundleLocalizations")]
    #[cfg(feature = "CFArray")]
    #[inline]
    pub fn bundle_localizations(&self) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CFBundleCopyBundleLocalizations(bundle: &CFBundle) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { CFBundleCopyBundleLocalizations(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// # Safety
    ///
    /// - `loc_array` generic must be of the correct type.
    /// - `loc_array` might not allow `None`.
    #[doc(alias = "CFBundleCopyPreferredLocalizationsFromArray")]
    #[cfg(feature = "CFArray")]
    #[inline]
    pub unsafe fn preferred_localizations_from_array(
        loc_array: Option<&CFArray>,
    ) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CFBundleCopyPreferredLocalizationsFromArray(
                loc_array: Option<&CFArray>,
            ) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { CFBundleCopyPreferredLocalizationsFromArray(loc_array) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// # Safety
    ///
    /// - `loc_array` generic must be of the correct type.
    /// - `loc_array` might not allow `None`.
    /// - `pref_array` generic must be of the correct type.
    /// - `pref_array` might not allow `None`.
    #[doc(alias = "CFBundleCopyLocalizationsForPreferences")]
    #[cfg(feature = "CFArray")]
    #[inline]
    pub unsafe fn localizations_for_preferences(
        loc_array: Option<&CFArray>,
        pref_array: Option<&CFArray>,
    ) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CFBundleCopyLocalizationsForPreferences(
                loc_array: Option<&CFArray>,
                pref_array: Option<&CFArray>,
            ) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { CFBundleCopyLocalizationsForPreferences(loc_array, pref_array) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFBundleCopyResourceURLForLocalization")]
    #[cfg(feature = "CFURL")]
    #[inline]
    pub fn resource_url_for_localization(
        &self,
        resource_name: Option<&CFString>,
        resource_type: Option<&CFString>,
        sub_dir_name: Option<&CFString>,
        localization_name: Option<&CFString>,
    ) -> Option<CFRetained<CFURL>> {
        extern "C-unwind" {
            fn CFBundleCopyResourceURLForLocalization(
                bundle: &CFBundle,
                resource_name: Option<&CFString>,
                resource_type: Option<&CFString>,
                sub_dir_name: Option<&CFString>,
                localization_name: Option<&CFString>,
            ) -> Option<NonNull<CFURL>>;
        }
        let ret = unsafe {
            CFBundleCopyResourceURLForLocalization(
                self,
                resource_name,
                resource_type,
                sub_dir_name,
                localization_name,
            )
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFBundleCopyResourceURLsOfTypeForLocalization")]
    #[cfg(feature = "CFArray")]
    #[inline]
    pub fn resource_urls_of_type_for_localization(
        &self,
        resource_type: Option<&CFString>,
        sub_dir_name: Option<&CFString>,
        localization_name: Option<&CFString>,
    ) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CFBundleCopyResourceURLsOfTypeForLocalization(
                bundle: &CFBundle,
                resource_type: Option<&CFString>,
                sub_dir_name: Option<&CFString>,
                localization_name: Option<&CFString>,
            ) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe {
            CFBundleCopyResourceURLsOfTypeForLocalization(
                self,
                resource_type,
                sub_dir_name,
                localization_name,
            )
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFBundleCopyInfoDictionaryForURL")]
    #[cfg(all(feature = "CFDictionary", feature = "CFURL"))]
    #[inline]
    pub fn info_dictionary_for_url(url: Option<&CFURL>) -> Option<CFRetained<CFDictionary>> {
        extern "C-unwind" {
            fn CFBundleCopyInfoDictionaryForURL(
                url: Option<&CFURL>,
            ) -> Option<NonNull<CFDictionary>>;
        }
        let ret = unsafe { CFBundleCopyInfoDictionaryForURL(url) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFBundleCopyLocalizationsForURL")]
    #[cfg(all(feature = "CFArray", feature = "CFURL"))]
    #[inline]
    pub fn localizations_for_url(url: Option<&CFURL>) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CFBundleCopyLocalizationsForURL(url: Option<&CFURL>) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { CFBundleCopyLocalizationsForURL(url) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFBundleCopyExecutableArchitecturesForURL")]
    #[cfg(all(feature = "CFArray", feature = "CFURL"))]
    #[inline]
    pub fn executable_architectures_for_url(url: Option<&CFURL>) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CFBundleCopyExecutableArchitecturesForURL(
                url: Option<&CFURL>,
            ) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { CFBundleCopyExecutableArchitecturesForURL(url) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFBundleCopyExecutableURL")]
    #[cfg(feature = "CFURL")]
    #[inline]
    pub fn executable_url(&self) -> Option<CFRetained<CFURL>> {
        extern "C-unwind" {
            fn CFBundleCopyExecutableURL(bundle: &CFBundle) -> Option<NonNull<CFURL>>;
        }
        let ret = unsafe { CFBundleCopyExecutableURL(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfbundleexecutablearchitecturei386?language=objc)
pub const kCFBundleExecutableArchitectureI386: c_uint = 0x00000007;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfbundleexecutablearchitectureppc?language=objc)
pub const kCFBundleExecutableArchitecturePPC: c_uint = 0x00000012;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfbundleexecutablearchitecturex86_64?language=objc)
pub const kCFBundleExecutableArchitectureX86_64: c_uint = 0x01000007;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfbundleexecutablearchitectureppc64?language=objc)
pub const kCFBundleExecutableArchitecturePPC64: c_uint = 0x01000012;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfbundleexecutablearchitecturearm64?language=objc)
pub const kCFBundleExecutableArchitectureARM64: c_uint = 0x0100000c;

impl CFBundle {
    #[doc(alias = "CFBundleCopyExecutableArchitectures")]
    #[cfg(feature = "CFArray")]
    #[inline]
    pub fn executable_architectures(&self) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CFBundleCopyExecutableArchitectures(bundle: &CFBundle) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { CFBundleCopyExecutableArchitectures(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// # Safety
    ///
    /// `error` must be a valid pointer.
    #[doc(alias = "CFBundlePreflightExecutable")]
    #[cfg(feature = "CFError")]
    #[inline]
    pub unsafe fn preflight_executable(&self, error: *mut *mut CFError) -> bool {
        extern "C-unwind" {
            fn CFBundlePreflightExecutable(bundle: &CFBundle, error: *mut *mut CFError) -> Boolean;
        }
        let ret = unsafe { CFBundlePreflightExecutable(self, error) };
        ret != 0
    }

    /// # Safety
    ///
    /// `error` must be a valid pointer.
    #[doc(alias = "CFBundleLoadExecutableAndReturnError")]
    #[cfg(feature = "CFError")]
    #[inline]
    pub unsafe fn load_executable_and_return_error(&self, error: *mut *mut CFError) -> bool {
        extern "C-unwind" {
            fn CFBundleLoadExecutableAndReturnError(
                bundle: &CFBundle,
                error: *mut *mut CFError,
            ) -> Boolean;
        }
        let ret = unsafe { CFBundleLoadExecutableAndReturnError(self, error) };
        ret != 0
    }

    #[doc(alias = "CFBundleLoadExecutable")]
    #[inline]
    pub unsafe fn load_executable(&self) -> bool {
        extern "C-unwind" {
            fn CFBundleLoadExecutable(bundle: &CFBundle) -> Boolean;
        }
        let ret = unsafe { CFBundleLoadExecutable(self) };
        ret != 0
    }

    #[doc(alias = "CFBundleIsExecutableLoaded")]
    #[inline]
    pub fn is_executable_loaded(&self) -> bool {
        extern "C-unwind" {
            fn CFBundleIsExecutableLoaded(bundle: &CFBundle) -> Boolean;
        }
        let ret = unsafe { CFBundleIsExecutableLoaded(self) };
        ret != 0
    }

    #[doc(alias = "CFBundleUnloadExecutable")]
    #[inline]
    pub unsafe fn unload_executable(&self) {
        extern "C-unwind" {
            fn CFBundleUnloadExecutable(bundle: &CFBundle);
        }
        unsafe { CFBundleUnloadExecutable(self) }
    }

    #[doc(alias = "CFBundleGetFunctionPointerForName")]
    #[inline]
    pub fn function_pointer_for_name(&self, function_name: Option<&CFString>) -> *mut c_void {
        extern "C-unwind" {
            fn CFBundleGetFunctionPointerForName(
                bundle: &CFBundle,
                function_name: Option<&CFString>,
            ) -> *mut c_void;
        }
        unsafe { CFBundleGetFunctionPointerForName(self, function_name) }
    }

    /// # Safety
    ///
    /// - `function_names` generic must be of the correct type.
    /// - `function_names` might not allow `None`.
    /// - `ftbl` must be a valid pointer.
    #[doc(alias = "CFBundleGetFunctionPointersForNames")]
    #[cfg(feature = "CFArray")]
    #[inline]
    pub unsafe fn function_pointers_for_names(
        &self,
        function_names: Option<&CFArray>,
        ftbl: *mut *mut c_void,
    ) {
        extern "C-unwind" {
            fn CFBundleGetFunctionPointersForNames(
                bundle: &CFBundle,
                function_names: Option<&CFArray>,
                ftbl: *mut *mut c_void,
            );
        }
        unsafe { CFBundleGetFunctionPointersForNames(self, function_names, ftbl) }
    }

    #[doc(alias = "CFBundleGetDataPointerForName")]
    #[inline]
    pub fn data_pointer_for_name(&self, symbol_name: Option<&CFString>) -> *mut c_void {
        extern "C-unwind" {
            fn CFBundleGetDataPointerForName(
                bundle: &CFBundle,
                symbol_name: Option<&CFString>,
            ) -> *mut c_void;
        }
        unsafe { CFBundleGetDataPointerForName(self, symbol_name) }
    }

    /// # Safety
    ///
    /// - `symbol_names` generic must be of the correct type.
    /// - `symbol_names` might not allow `None`.
    /// - `stbl` must be a valid pointer.
    #[doc(alias = "CFBundleGetDataPointersForNames")]
    #[cfg(feature = "CFArray")]
    #[inline]
    pub unsafe fn data_pointers_for_names(
        &self,
        symbol_names: Option<&CFArray>,
        stbl: *mut *mut c_void,
    ) {
        extern "C-unwind" {
            fn CFBundleGetDataPointersForNames(
                bundle: &CFBundle,
                symbol_names: Option<&CFArray>,
                stbl: *mut *mut c_void,
            );
        }
        unsafe { CFBundleGetDataPointersForNames(self, symbol_names, stbl) }
    }

    #[doc(alias = "CFBundleCopyAuxiliaryExecutableURL")]
    #[cfg(feature = "CFURL")]
    #[inline]
    pub fn auxiliary_executable_url(
        &self,
        executable_name: Option<&CFString>,
    ) -> Option<CFRetained<CFURL>> {
        extern "C-unwind" {
            fn CFBundleCopyAuxiliaryExecutableURL(
                bundle: &CFBundle,
                executable_name: Option<&CFString>,
            ) -> Option<NonNull<CFURL>>;
        }
        let ret = unsafe { CFBundleCopyAuxiliaryExecutableURL(self, executable_name) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFBundleIsExecutableLoadable")]
    #[inline]
    pub fn is_executable_loadable(&self) -> bool {
        extern "C-unwind" {
            fn CFBundleIsExecutableLoadable(bundle: &CFBundle) -> Boolean;
        }
        let ret = unsafe { CFBundleIsExecutableLoadable(self) };
        ret != 0
    }

    #[doc(alias = "CFBundleIsExecutableLoadableForURL")]
    #[cfg(feature = "CFURL")]
    #[inline]
    pub fn is_executable_loadable_for_url(url: Option<&CFURL>) -> bool {
        extern "C-unwind" {
            fn CFBundleIsExecutableLoadableForURL(url: Option<&CFURL>) -> Boolean;
        }
        let ret = unsafe { CFBundleIsExecutableLoadableForURL(url) };
        ret != 0
    }

    #[doc(alias = "CFBundleIsArchitectureLoadable")]
    #[cfg(feature = "libc")]
    #[inline]
    pub fn is_architecture_loadable(arch: libc::cpu_type_t) -> bool {
        extern "C-unwind" {
            fn CFBundleIsArchitectureLoadable(arch: libc::cpu_type_t) -> Boolean;
        }
        let ret = unsafe { CFBundleIsArchitectureLoadable(arch) };
        ret != 0
    }

    #[doc(alias = "CFBundleGetPlugIn")]
    #[inline]
    pub fn plug_in(&self) -> Option<CFRetained<CFPlugIn>> {
        extern "C-unwind" {
            fn CFBundleGetPlugIn(bundle: &CFBundle) -> Option<NonNull<CFPlugIn>>;
        }
        let ret = unsafe { CFBundleGetPlugIn(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    #[doc(alias = "CFBundleOpenBundleResourceMap")]
    #[deprecated = "The Carbon Resource Manager is deprecated. This should only be used to access Resource Manager-style resources in old bundles."]
    #[inline]
    pub fn open_bundle_resource_map(&self) -> CFBundleRefNum {
        extern "C-unwind" {
            fn CFBundleOpenBundleResourceMap(bundle: &CFBundle) -> CFBundleRefNum;
        }
        unsafe { CFBundleOpenBundleResourceMap(self) }
    }

    /// # Safety
    ///
    /// - `ref_num` must be a valid pointer.
    /// - `localized_ref_num` must be a valid pointer.
    #[doc(alias = "CFBundleOpenBundleResourceFiles")]
    #[deprecated = "The Carbon Resource Manager is deprecated. This should only be used to access Resource Manager-style resources in old bundles."]
    #[inline]
    pub unsafe fn open_bundle_resource_files(
        &self,
        ref_num: *mut CFBundleRefNum,
        localized_ref_num: *mut CFBundleRefNum,
    ) -> i32 {
        extern "C-unwind" {
            fn CFBundleOpenBundleResourceFiles(
                bundle: &CFBundle,
                ref_num: *mut CFBundleRefNum,
                localized_ref_num: *mut CFBundleRefNum,
            ) -> i32;
        }
        unsafe { CFBundleOpenBundleResourceFiles(self, ref_num, localized_ref_num) }
    }

    #[doc(alias = "CFBundleCloseBundleResourceMap")]
    #[deprecated = "The Carbon Resource Manager is deprecated. This should only be used to access Resource Manager-style resources in old bundles."]
    #[inline]
    pub fn close_bundle_resource_map(&self, ref_num: CFBundleRefNum) {
        extern "C-unwind" {
            fn CFBundleCloseBundleResourceMap(bundle: &CFBundle, ref_num: CFBundleRefNum);
        }
        unsafe { CFBundleCloseBundleResourceMap(self, ref_num) }
    }
}

#[deprecated = "renamed to `CFBundle::main_bundle`"]
#[inline]
pub extern "C-unwind" fn CFBundleGetMainBundle() -> Option<CFRetained<CFBundle>> {
    extern "C-unwind" {
        fn CFBundleGetMainBundle() -> Option<NonNull<CFBundle>>;
    }
    let ret = unsafe { CFBundleGetMainBundle() };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `CFBundle::bundle_with_identifier`"]
#[inline]
pub extern "C-unwind" fn CFBundleGetBundleWithIdentifier(
    bundle_id: Option<&CFString>,
) -> Option<CFRetained<CFBundle>> {
    extern "C-unwind" {
        fn CFBundleGetBundleWithIdentifier(
            bundle_id: Option<&CFString>,
        ) -> Option<NonNull<CFBundle>>;
    }
    let ret = unsafe { CFBundleGetBundleWithIdentifier(bundle_id) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[cfg(feature = "CFArray")]
#[deprecated = "renamed to `CFBundle::all_bundles`"]
#[inline]
pub unsafe extern "C-unwind" fn CFBundleGetAllBundles() -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CFBundleGetAllBundles() -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CFBundleGetAllBundles() };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[cfg(feature = "CFURL")]
#[deprecated = "renamed to `CFBundle::new`"]
#[inline]
pub extern "C-unwind" fn CFBundleCreate(
    allocator: Option<&CFAllocator>,
    bundle_url: Option<&CFURL>,
) -> Option<CFRetained<CFBundle>> {
    extern "C-unwind" {
        fn CFBundleCreate(
            allocator: Option<&CFAllocator>,
            bundle_url: Option<&CFURL>,
        ) -> Option<NonNull<CFBundle>>;
    }
    let ret = unsafe { CFBundleCreate(allocator, bundle_url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFArray", feature = "CFURL"))]
#[deprecated = "renamed to `CFBundle::new_bundles_from_directory`"]
#[inline]
pub extern "C-unwind" fn CFBundleCreateBundlesFromDirectory(
    allocator: Option<&CFAllocator>,
    directory_url: Option<&CFURL>,
    bundle_type: Option<&CFString>,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CFBundleCreateBundlesFromDirectory(
            allocator: Option<&CFAllocator>,
            directory_url: Option<&CFURL>,
            bundle_type: Option<&CFString>,
        ) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CFBundleCreateBundlesFromDirectory(allocator, directory_url, bundle_type) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFURL")]
#[deprecated = "renamed to `CFBundle::bundle_url`"]
#[inline]
pub extern "C-unwind" fn CFBundleCopyBundleURL(bundle: &CFBundle) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFBundleCopyBundleURL(bundle: &CFBundle) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe { CFBundleCopyBundleURL(bundle) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFBundle::value_for_info_dictionary_key`"]
#[inline]
pub extern "C-unwind" fn CFBundleGetValueForInfoDictionaryKey(
    bundle: &CFBundle,
    key: Option<&CFString>,
) -> Option<CFRetained<CFType>> {
    extern "C-unwind" {
        fn CFBundleGetValueForInfoDictionaryKey(
            bundle: &CFBundle,
            key: Option<&CFString>,
        ) -> Option<NonNull<CFType>>;
    }
    let ret = unsafe { CFBundleGetValueForInfoDictionaryKey(bundle, key) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[cfg(feature = "CFDictionary")]
#[deprecated = "renamed to `CFBundle::info_dictionary`"]
#[inline]
pub extern "C-unwind" fn CFBundleGetInfoDictionary(
    bundle: &CFBundle,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn CFBundleGetInfoDictionary(bundle: &CFBundle) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { CFBundleGetInfoDictionary(bundle) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[cfg(feature = "CFDictionary")]
#[deprecated = "renamed to `CFBundle::local_info_dictionary`"]
#[inline]
pub extern "C-unwind" fn CFBundleGetLocalInfoDictionary(
    bundle: &CFBundle,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn CFBundleGetLocalInfoDictionary(bundle: &CFBundle) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { CFBundleGetLocalInfoDictionary(bundle) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFBundle::package_info`"]
    pub fn CFBundleGetPackageInfo(
        bundle: &CFBundle,
        package_type: *mut u32,
        package_creator: *mut u32,
    );
}

#[deprecated = "renamed to `CFBundle::identifier`"]
#[inline]
pub extern "C-unwind" fn CFBundleGetIdentifier(bundle: &CFBundle) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFBundleGetIdentifier(bundle: &CFBundle) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFBundleGetIdentifier(bundle) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `CFBundle::version_number`"]
#[inline]
pub extern "C-unwind" fn CFBundleGetVersionNumber(bundle: &CFBundle) -> u32 {
    extern "C-unwind" {
        fn CFBundleGetVersionNumber(bundle: &CFBundle) -> u32;
    }
    unsafe { CFBundleGetVersionNumber(bundle) }
}

#[deprecated = "renamed to `CFBundle::development_region`"]
#[inline]
pub extern "C-unwind" fn CFBundleGetDevelopmentRegion(
    bundle: &CFBundle,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFBundleGetDevelopmentRegion(bundle: &CFBundle) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFBundleGetDevelopmentRegion(bundle) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[cfg(feature = "CFURL")]
#[deprecated = "renamed to `CFBundle::support_files_directory_url`"]
#[inline]
pub extern "C-unwind" fn CFBundleCopySupportFilesDirectoryURL(
    bundle: &CFBundle,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFBundleCopySupportFilesDirectoryURL(bundle: &CFBundle) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe { CFBundleCopySupportFilesDirectoryURL(bundle) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFURL")]
#[deprecated = "renamed to `CFBundle::resources_directory_url`"]
#[inline]
pub extern "C-unwind" fn CFBundleCopyResourcesDirectoryURL(
    bundle: &CFBundle,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFBundleCopyResourcesDirectoryURL(bundle: &CFBundle) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe { CFBundleCopyResourcesDirectoryURL(bundle) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFURL")]
#[deprecated = "renamed to `CFBundle::private_frameworks_url`"]
#[inline]
pub extern "C-unwind" fn CFBundleCopyPrivateFrameworksURL(
    bundle: &CFBundle,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFBundleCopyPrivateFrameworksURL(bundle: &CFBundle) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe { CFBundleCopyPrivateFrameworksURL(bundle) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFURL")]
#[deprecated = "renamed to `CFBundle::shared_frameworks_url`"]
#[inline]
pub extern "C-unwind" fn CFBundleCopySharedFrameworksURL(
    bundle: &CFBundle,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFBundleCopySharedFrameworksURL(bundle: &CFBundle) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe { CFBundleCopySharedFrameworksURL(bundle) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFURL")]
#[deprecated = "renamed to `CFBundle::shared_support_url`"]
#[inline]
pub extern "C-unwind" fn CFBundleCopySharedSupportURL(
    bundle: &CFBundle,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFBundleCopySharedSupportURL(bundle: &CFBundle) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe { CFBundleCopySharedSupportURL(bundle) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFURL")]
#[deprecated = "renamed to `CFBundle::built_in_plug_ins_url`"]
#[inline]
pub extern "C-unwind" fn CFBundleCopyBuiltInPlugInsURL(
    bundle: &CFBundle,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFBundleCopyBuiltInPlugInsURL(bundle: &CFBundle) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe { CFBundleCopyBuiltInPlugInsURL(bundle) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFDictionary", feature = "CFURL"))]
#[deprecated = "renamed to `CFBundle::info_dictionary_in_directory`"]
#[inline]
pub extern "C-unwind" fn CFBundleCopyInfoDictionaryInDirectory(
    bundle_url: Option<&CFURL>,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn CFBundleCopyInfoDictionaryInDirectory(
            bundle_url: Option<&CFURL>,
        ) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { CFBundleCopyInfoDictionaryInDirectory(bundle_url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFURL")]
#[deprecated = "renamed to `CFBundle::package_info_in_directory`"]
#[inline]
pub unsafe extern "C-unwind" fn CFBundleGetPackageInfoInDirectory(
    url: Option<&CFURL>,
    package_type: *mut u32,
    package_creator: *mut u32,
) -> bool {
    extern "C-unwind" {
        fn CFBundleGetPackageInfoInDirectory(
            url: Option<&CFURL>,
            package_type: *mut u32,
            package_creator: *mut u32,
        ) -> Boolean;
    }
    let ret = unsafe { CFBundleGetPackageInfoInDirectory(url, package_type, package_creator) };
    ret != 0
}

#[cfg(feature = "CFURL")]
#[deprecated = "renamed to `CFBundle::resource_url`"]
#[inline]
pub extern "C-unwind" fn CFBundleCopyResourceURL(
    bundle: &CFBundle,
    resource_name: Option<&CFString>,
    resource_type: Option<&CFString>,
    sub_dir_name: Option<&CFString>,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFBundleCopyResourceURL(
            bundle: &CFBundle,
            resource_name: Option<&CFString>,
            resource_type: Option<&CFString>,
            sub_dir_name: Option<&CFString>,
        ) -> Option<NonNull<CFURL>>;
    }
    let ret =
        unsafe { CFBundleCopyResourceURL(bundle, resource_name, resource_type, sub_dir_name) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFArray")]
#[deprecated = "renamed to `CFBundle::resource_urls_of_type`"]
#[inline]
pub extern "C-unwind" fn CFBundleCopyResourceURLsOfType(
    bundle: &CFBundle,
    resource_type: Option<&CFString>,
    sub_dir_name: Option<&CFString>,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CFBundleCopyResourceURLsOfType(
            bundle: &CFBundle,
            resource_type: Option<&CFString>,
            sub_dir_name: Option<&CFString>,
        ) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CFBundleCopyResourceURLsOfType(bundle, resource_type, sub_dir_name) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFBundle::localized_string`"]
#[inline]
pub extern "C-unwind" fn CFBundleCopyLocalizedString(
    bundle: &CFBundle,
    key: Option<&CFString>,
    value: Option<&CFString>,
    table_name: Option<&CFString>,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFBundleCopyLocalizedString(
            bundle: &CFBundle,
            key: Option<&CFString>,
            value: Option<&CFString>,
            table_name: Option<&CFString>,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFBundleCopyLocalizedString(bundle, key, value, table_name) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFArray")]
#[deprecated = "renamed to `CFBundle::localized_string_for_localizations`"]
#[inline]
pub unsafe extern "C-unwind" fn CFBundleCopyLocalizedStringForLocalizations(
    bundle: &CFBundle,
    key: Option<&CFString>,
    value: Option<&CFString>,
    table_name: Option<&CFString>,
    localizations: Option<&CFArray>,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFBundleCopyLocalizedStringForLocalizations(
            bundle: &CFBundle,
            key: Option<&CFString>,
            value: Option<&CFString>,
            table_name: Option<&CFString>,
            localizations: Option<&CFArray>,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe {
        CFBundleCopyLocalizedStringForLocalizations(bundle, key, value, table_name, localizations)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFURL")]
#[deprecated = "renamed to `CFBundle::resource_url_in_directory`"]
#[inline]
pub extern "C-unwind" fn CFBundleCopyResourceURLInDirectory(
    bundle_url: Option<&CFURL>,
    resource_name: Option<&CFString>,
    resource_type: Option<&CFString>,
    sub_dir_name: Option<&CFString>,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFBundleCopyResourceURLInDirectory(
            bundle_url: Option<&CFURL>,
            resource_name: Option<&CFString>,
            resource_type: Option<&CFString>,
            sub_dir_name: Option<&CFString>,
        ) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe {
        CFBundleCopyResourceURLInDirectory(bundle_url, resource_name, resource_type, sub_dir_name)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFArray", feature = "CFURL"))]
#[deprecated = "renamed to `CFBundle::resource_urls_of_type_in_directory`"]
#[inline]
pub extern "C-unwind" fn CFBundleCopyResourceURLsOfTypeInDirectory(
    bundle_url: Option<&CFURL>,
    resource_type: Option<&CFString>,
    sub_dir_name: Option<&CFString>,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CFBundleCopyResourceURLsOfTypeInDirectory(
            bundle_url: Option<&CFURL>,
            resource_type: Option<&CFString>,
            sub_dir_name: Option<&CFString>,
        ) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe {
        CFBundleCopyResourceURLsOfTypeInDirectory(bundle_url, resource_type, sub_dir_name)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFArray")]
#[deprecated = "renamed to `CFBundle::bundle_localizations`"]
#[inline]
pub extern "C-unwind" fn CFBundleCopyBundleLocalizations(
    bundle: &CFBundle,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CFBundleCopyBundleLocalizations(bundle: &CFBundle) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CFBundleCopyBundleLocalizations(bundle) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFArray")]
#[deprecated = "renamed to `CFBundle::preferred_localizations_from_array`"]
#[inline]
pub unsafe extern "C-unwind" fn CFBundleCopyPreferredLocalizationsFromArray(
    loc_array: Option<&CFArray>,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CFBundleCopyPreferredLocalizationsFromArray(
            loc_array: Option<&CFArray>,
        ) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CFBundleCopyPreferredLocalizationsFromArray(loc_array) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFArray")]
#[deprecated = "renamed to `CFBundle::localizations_for_preferences`"]
#[inline]
pub unsafe extern "C-unwind" fn CFBundleCopyLocalizationsForPreferences(
    loc_array: Option<&CFArray>,
    pref_array: Option<&CFArray>,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CFBundleCopyLocalizationsForPreferences(
            loc_array: Option<&CFArray>,
            pref_array: Option<&CFArray>,
        ) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CFBundleCopyLocalizationsForPreferences(loc_array, pref_array) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFURL")]
#[deprecated = "renamed to `CFBundle::resource_url_for_localization`"]
#[inline]
pub extern "C-unwind" fn CFBundleCopyResourceURLForLocalization(
    bundle: &CFBundle,
    resource_name: Option<&CFString>,
    resource_type: Option<&CFString>,
    sub_dir_name: Option<&CFString>,
    localization_name: Option<&CFString>,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFBundleCopyResourceURLForLocalization(
            bundle: &CFBundle,
            resource_name: Option<&CFString>,
            resource_type: Option<&CFString>,
            sub_dir_name: Option<&CFString>,
            localization_name: Option<&CFString>,
        ) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe {
        CFBundleCopyResourceURLForLocalization(
            bundle,
            resource_name,
            resource_type,
            sub_dir_name,
            localization_name,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFArray")]
#[deprecated = "renamed to `CFBundle::resource_urls_of_type_for_localization`"]
#[inline]
pub extern "C-unwind" fn CFBundleCopyResourceURLsOfTypeForLocalization(
    bundle: &CFBundle,
    resource_type: Option<&CFString>,
    sub_dir_name: Option<&CFString>,
    localization_name: Option<&CFString>,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CFBundleCopyResourceURLsOfTypeForLocalization(
            bundle: &CFBundle,
            resource_type: Option<&CFString>,
            sub_dir_name: Option<&CFString>,
            localization_name: Option<&CFString>,
        ) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe {
        CFBundleCopyResourceURLsOfTypeForLocalization(
            bundle,
            resource_type,
            sub_dir_name,
            localization_name,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFDictionary", feature = "CFURL"))]
#[deprecated = "renamed to `CFBundle::info_dictionary_for_url`"]
#[inline]
pub extern "C-unwind" fn CFBundleCopyInfoDictionaryForURL(
    url: Option<&CFURL>,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn CFBundleCopyInfoDictionaryForURL(url: Option<&CFURL>) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { CFBundleCopyInfoDictionaryForURL(url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFArray", feature = "CFURL"))]
#[deprecated = "renamed to `CFBundle::localizations_for_url`"]
#[inline]
pub extern "C-unwind" fn CFBundleCopyLocalizationsForURL(
    url: Option<&CFURL>,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CFBundleCopyLocalizationsForURL(url: Option<&CFURL>) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CFBundleCopyLocalizationsForURL(url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFArray", feature = "CFURL"))]
#[deprecated = "renamed to `CFBundle::executable_architectures_for_url`"]
#[inline]
pub extern "C-unwind" fn CFBundleCopyExecutableArchitecturesForURL(
    url: Option<&CFURL>,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CFBundleCopyExecutableArchitecturesForURL(
            url: Option<&CFURL>,
        ) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CFBundleCopyExecutableArchitecturesForURL(url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFURL")]
#[deprecated = "renamed to `CFBundle::executable_url`"]
#[inline]
pub extern "C-unwind" fn CFBundleCopyExecutableURL(bundle: &CFBundle) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFBundleCopyExecutableURL(bundle: &CFBundle) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe { CFBundleCopyExecutableURL(bundle) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFArray")]
#[deprecated = "renamed to `CFBundle::executable_architectures`"]
#[inline]
pub extern "C-unwind" fn CFBundleCopyExecutableArchitectures(
    bundle: &CFBundle,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CFBundleCopyExecutableArchitectures(bundle: &CFBundle) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CFBundleCopyExecutableArchitectures(bundle) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFError")]
#[deprecated = "renamed to `CFBundle::preflight_executable`"]
#[inline]
pub unsafe extern "C-unwind" fn CFBundlePreflightExecutable(
    bundle: &CFBundle,
    error: *mut *mut CFError,
) -> bool {
    extern "C-unwind" {
        fn CFBundlePreflightExecutable(bundle: &CFBundle, error: *mut *mut CFError) -> Boolean;
    }
    let ret = unsafe { CFBundlePreflightExecutable(bundle, error) };
    ret != 0
}

#[cfg(feature = "CFError")]
#[deprecated = "renamed to `CFBundle::load_executable_and_return_error`"]
#[inline]
pub unsafe extern "C-unwind" fn CFBundleLoadExecutableAndReturnError(
    bundle: &CFBundle,
    error: *mut *mut CFError,
) -> bool {
    extern "C-unwind" {
        fn CFBundleLoadExecutableAndReturnError(
            bundle: &CFBundle,
            error: *mut *mut CFError,
        ) -> Boolean;
    }
    let ret = unsafe { CFBundleLoadExecutableAndReturnError(bundle, error) };
    ret != 0
}

#[deprecated = "renamed to `CFBundle::load_executable`"]
#[inline]
pub unsafe extern "C-unwind" fn CFBundleLoadExecutable(bundle: &CFBundle) -> bool {
    extern "C-unwind" {
        fn CFBundleLoadExecutable(bundle: &CFBundle) -> Boolean;
    }
    let ret = unsafe { CFBundleLoadExecutable(bundle) };
    ret != 0
}

#[deprecated = "renamed to `CFBundle::is_executable_loaded`"]
#[inline]
pub extern "C-unwind" fn CFBundleIsExecutableLoaded(bundle: &CFBundle) -> bool {
    extern "C-unwind" {
        fn CFBundleIsExecutableLoaded(bundle: &CFBundle) -> Boolean;
    }
    let ret = unsafe { CFBundleIsExecutableLoaded(bundle) };
    ret != 0
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFBundle::unload_executable`"]
    pub fn CFBundleUnloadExecutable(bundle: &CFBundle);
}

#[deprecated = "renamed to `CFBundle::function_pointer_for_name`"]
#[inline]
pub extern "C-unwind" fn CFBundleGetFunctionPointerForName(
    bundle: &CFBundle,
    function_name: Option<&CFString>,
) -> *mut c_void {
    extern "C-unwind" {
        fn CFBundleGetFunctionPointerForName(
            bundle: &CFBundle,
            function_name: Option<&CFString>,
        ) -> *mut c_void;
    }
    unsafe { CFBundleGetFunctionPointerForName(bundle, function_name) }
}

extern "C-unwind" {
    #[cfg(feature = "CFArray")]
    #[deprecated = "renamed to `CFBundle::function_pointers_for_names`"]
    pub fn CFBundleGetFunctionPointersForNames(
        bundle: &CFBundle,
        function_names: Option<&CFArray>,
        ftbl: *mut *mut c_void,
    );
}

#[deprecated = "renamed to `CFBundle::data_pointer_for_name`"]
#[inline]
pub extern "C-unwind" fn CFBundleGetDataPointerForName(
    bundle: &CFBundle,
    symbol_name: Option<&CFString>,
) -> *mut c_void {
    extern "C-unwind" {
        fn CFBundleGetDataPointerForName(
            bundle: &CFBundle,
            symbol_name: Option<&CFString>,
        ) -> *mut c_void;
    }
    unsafe { CFBundleGetDataPointerForName(bundle, symbol_name) }
}

extern "C-unwind" {
    #[cfg(feature = "CFArray")]
    #[deprecated = "renamed to `CFBundle::data_pointers_for_names`"]
    pub fn CFBundleGetDataPointersForNames(
        bundle: &CFBundle,
        symbol_names: Option<&CFArray>,
        stbl: *mut *mut c_void,
    );
}

#[cfg(feature = "CFURL")]
#[deprecated = "renamed to `CFBundle::auxiliary_executable_url`"]
#[inline]
pub extern "C-unwind" fn CFBundleCopyAuxiliaryExecutableURL(
    bundle: &CFBundle,
    executable_name: Option<&CFString>,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFBundleCopyAuxiliaryExecutableURL(
            bundle: &CFBundle,
            executable_name: Option<&CFString>,
        ) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe { CFBundleCopyAuxiliaryExecutableURL(bundle, executable_name) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFBundle::is_executable_loadable`"]
#[inline]
pub extern "C-unwind" fn CFBundleIsExecutableLoadable(bundle: &CFBundle) -> bool {
    extern "C-unwind" {
        fn CFBundleIsExecutableLoadable(bundle: &CFBundle) -> Boolean;
    }
    let ret = unsafe { CFBundleIsExecutableLoadable(bundle) };
    ret != 0
}

#[cfg(feature = "CFURL")]
#[deprecated = "renamed to `CFBundle::is_executable_loadable_for_url`"]
#[inline]
pub extern "C-unwind" fn CFBundleIsExecutableLoadableForURL(url: Option<&CFURL>) -> bool {
    extern "C-unwind" {
        fn CFBundleIsExecutableLoadableForURL(url: Option<&CFURL>) -> Boolean;
    }
    let ret = unsafe { CFBundleIsExecutableLoadableForURL(url) };
    ret != 0
}

#[cfg(feature = "libc")]
#[deprecated = "renamed to `CFBundle::is_architecture_loadable`"]
#[inline]
pub extern "C-unwind" fn CFBundleIsArchitectureLoadable(arch: libc::cpu_type_t) -> bool {
    extern "C-unwind" {
        fn CFBundleIsArchitectureLoadable(arch: libc::cpu_type_t) -> Boolean;
    }
    let ret = unsafe { CFBundleIsArchitectureLoadable(arch) };
    ret != 0
}

#[deprecated = "renamed to `CFBundle::plug_in`"]
#[inline]
pub extern "C-unwind" fn CFBundleGetPlugIn(bundle: &CFBundle) -> Option<CFRetained<CFPlugIn>> {
    extern "C-unwind" {
        fn CFBundleGetPlugIn(bundle: &CFBundle) -> Option<NonNull<CFPlugIn>>;
    }
    let ret = unsafe { CFBundleGetPlugIn(bundle) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `CFBundle::open_bundle_resource_map`"]
#[inline]
pub extern "C-unwind" fn CFBundleOpenBundleResourceMap(bundle: &CFBundle) -> CFBundleRefNum {
    extern "C-unwind" {
        fn CFBundleOpenBundleResourceMap(bundle: &CFBundle) -> CFBundleRefNum;
    }
    unsafe { CFBundleOpenBundleResourceMap(bundle) }
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFBundle::open_bundle_resource_files`"]
    pub fn CFBundleOpenBundleResourceFiles(
        bundle: &CFBundle,
        ref_num: *mut CFBundleRefNum,
        localized_ref_num: *mut CFBundleRefNum,
    ) -> i32;
}

#[deprecated = "renamed to `CFBundle::close_bundle_resource_map`"]
#[inline]
pub extern "C-unwind" fn CFBundleCloseBundleResourceMap(
    bundle: &CFBundle,
    ref_num: CFBundleRefNum,
) {
    extern "C-unwind" {
        fn CFBundleCloseBundleResourceMap(bundle: &CFBundle, ref_num: CFBundleRefNum);
    }
    unsafe { CFBundleCloseBundleResourceMap(bundle, ref_num) }
}
