/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model.cache;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.DB2Table;
import org.jkiss.dbeaver.ext.db2.model.DB2TableColumn;
import org.jkiss.dbeaver.ext.db2.model.DB2TableKeyColumn;
import org.jkiss.dbeaver.ext.db2.model.DB2TableUniqueKey;
import org.jkiss.dbeaver.ext.db2.model.cache.DB2TableCache;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2ConstraintType;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCCompositeCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;

public final class DB2TableUniqueKeyCache
extends JDBCCompositeCache<DB2Schema, DB2Table, DB2TableUniqueKey, DB2TableKeyColumn> {
    private static final String SQL_UK_TAB;
    private static final String SQL_UK_ALL;

    static {
        StringBuilder sb = new StringBuilder(512);
        sb.append(" SELECT C.*");
        sb.append("      , KCU.COLNAME");
        sb.append("      , KCU.COLSEQ");
        sb.append("   FROM SYSCAT.TABCONST C");
        sb.append("       ,SYSCAT.KEYCOLUSE KCU");
        sb.append("  WHERE C.TABSCHEMA = ?");
        sb.append("    AND C.TABNAME = ?");
        sb.append("    AND C.TYPE IN ('P','U')");
        sb.append("    AND KCU.CONSTNAME = C.CONSTNAME");
        sb.append("    AND KCU.TABSCHEMA = C.TABSCHEMA");
        sb.append("    AND KCU.TABNAME   = C.TABNAME");
        sb.append("  ORDER BY C.CONSTNAME");
        sb.append("         , KCU.COLSEQ");
        sb.append(" WITH UR");
        SQL_UK_TAB = sb.toString();
        sb.setLength(0);
        sb.append(" SELECT C.*");
        sb.append("      , KCU.COLNAME");
        sb.append("      , KCU.COLSEQ");
        sb.append("   FROM SYSCAT.TABCONST C");
        sb.append("       ,SYSCAT.KEYCOLUSE KCU");
        sb.append("  WHERE C.TABSCHEMA = ?");
        sb.append("    AND C.TYPE IN ('P','U')");
        sb.append("    AND KCU.CONSTNAME = C.CONSTNAME");
        sb.append("    AND KCU.TABSCHEMA = C.TABSCHEMA");
        sb.append("    AND KCU.TABNAME   = C.TABNAME");
        sb.append("  ORDER BY C.CONSTNAME");
        sb.append("         , KCU.COLSEQ");
        sb.append(" WITH UR");
        SQL_UK_ALL = sb.toString();
    }

    public DB2TableUniqueKeyCache(DB2TableCache tableCache) {
        super((JDBCStructCache)tableCache, DB2Table.class, (Object)"TABNAME", (Object)"CONSTNAME");
    }

    @NotNull
    protected JDBCStatement prepareObjectsStatement(JDBCSession session, DB2Schema db2Schema, DB2Table forTable) throws SQLException {
        String sql = forTable != null ? SQL_UK_TAB : SQL_UK_ALL;
        JDBCPreparedStatement dbStat = session.prepareStatement(sql);
        dbStat.setString(1, db2Schema.getName());
        if (forTable != null) {
            dbStat.setString(2, forTable.getName());
        }
        return dbStat;
    }

    @Nullable
    protected DB2TableUniqueKey fetchObject(JDBCSession session, DB2Schema db2Schema, DB2Table db2Table, String indexName, JDBCResultSet dbResult) throws SQLException, DBException {
        DBSEntityConstraintType type = DB2ConstraintType.getConstraintType(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TYPE"));
        return new DB2TableUniqueKey(session.getProgressMonitor(), db2Table, (ResultSet)dbResult, type);
    }

    @Nullable
    protected DB2TableKeyColumn[] fetchObjectRow(JDBCSession session, DB2Table db2Table, DB2TableUniqueKey object, JDBCResultSet dbResult) throws SQLException, DBException {
        String colName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLNAME");
        DB2TableColumn tableColumn = db2Table.getAttribute(session.getProgressMonitor(), colName);
        if (tableColumn == null) {
            log.debug((Object)("Column '" + colName + "' not found in table '" + db2Table.getFullyQualifiedName(DBPEvaluationContext.UI) + "' ??"));
            return null;
        }
        return new DB2TableKeyColumn[]{new DB2TableKeyColumn((AbstractTableConstraint<DB2Table, ? extends DB2TableKeyColumn>)object, tableColumn, JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"COLSEQ"))};
    }

    protected void cacheChildren(DBRProgressMonitor monitor, DB2TableUniqueKey constraint, List<DB2TableKeyColumn> rows) {
        constraint.setAttributeReferences(rows);
    }
}

