/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.core.text;

import java.io.CharConversionException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.internal.core.SearchCoreMessages;
import org.eclipse.search.internal.core.text.DirtyFileProvider;
import org.eclipse.search.internal.core.text.FileCharSequenceProvider;

public class TextSearchVisitor {
    public static final boolean TRACING = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.search/perf"));
    private static final int NUMBER_OF_LOGICAL_THREADS = Runtime.getRuntime().availableProcessors();
    private final Queue<List<IFile>> fileBatches;
    private final TextSearchRequestor fCollector;
    private final Pattern fSearchPattern;
    private volatile IProgressMonitor fProgressMonitor;
    private int fNumberOfScannedFiles;
    private IFile fCurrentFile;
    private final Object fLock = new Object();
    private final MultiStatus fStatus;
    private volatile boolean fFatalError;
    private volatile boolean fIsLightweightAutoRefresh;
    private DirtyFileProvider fDirtyDiscovery;
    private final IContentType TEXT_TYPE = Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text");

    public TextSearchVisitor(TextSearchRequestor collector, Pattern searchPattern, DirtyFileProvider dirtyDiscovery) {
        this.fCollector = collector;
        this.fDirtyDiscovery = dirtyDiscovery;
        this.fStatus = new MultiStatus("org.eclipse.search.core", 0, SearchCoreMessages.TextSearchEngine_statusMessage, null);
        this.fSearchPattern = searchPattern;
        this.fIsLightweightAutoRefresh = Platform.getPreferencesService().getBoolean("org.eclipse.core.resources", "refresh.lightweight.enabled", false, null);
        this.fileBatches = new ConcurrentLinkedQueue<List<IFile>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public IStatus search(IFile[] files, IProgressMonitor monitor) {
        if (files.length == 0) {
            return this.fStatus;
        }
        this.fProgressMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        Object object = this.fLock;
        synchronized (object) {
            this.fNumberOfScannedFiles = 0;
            this.fCurrentFile = null;
        }
        int threadsNeeded = Math.min(files.length, NUMBER_OF_LOGICAL_THREADS);
        int jobCount = this.fCollector.canRunInParallel() && threadsNeeded > 1 ? threadsNeeded - 1 : 1;
        long startTime = TRACING ? System.currentTimeMillis() : 0L;
        String taskName = this.fSearchPattern.pattern().isEmpty() ? SearchCoreMessages.TextSearchVisitor_filesearch_task_label : "";
        try {
            this.fCollector.beginReporting();
            if (this.fProgressMonitor.isCanceled()) {
                throw new OperationCanceledException(SearchCoreMessages.TextSearchVisitor_canceled);
            }
            Map<IFile, IDocument> documentsInEditors = this.findDirtyFiles();
            LinkedHashMap<String, List> localFilesByLocation = new LinkedHashMap<String, List>();
            LinkedHashMap remoteFilesByLocation = new LinkedHashMap();
            IFile[] iFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                IPath path = file.getLocation();
                String key = path == null ? file.getLocationURI().toString() : path.toString();
                LinkedHashMap<String, List> filesByLocation = path != null ? localFilesByLocation : remoteFilesByLocation;
                filesByLocation.computeIfAbsent(key, k -> new ArrayList()).add(file);
                ++n2;
            }
            localFilesByLocation.values().forEach(this.fileBatches::offer);
            remoteFilesByLocation.values().forEach(this.fileBatches::offer);
            int numberOfFilesToScan = this.fileBatches.size();
            this.fProgressMonitor.beginTask(taskName, numberOfFilesToScan);
            boolean seed = true;
            TextSearchJobGroup jobGroup = new TextSearchJobGroup("Text Search", jobCount, 1);
            int i = 0;
            while (i < jobCount) {
                TextSearchJob job = new TextSearchJob(documentsInEditors, jobCount);
                job.setJobGroup(jobGroup);
                job.schedule();
                ++i;
            }
            int numberOfScannedFiles = 0;
            int lastNumberOfScannedFiles = 0;
            while (!this.fProgressMonitor.isCanceled() && !jobGroup.getActiveJobs().isEmpty() && numberOfScannedFiles != numberOfFilesToScan) {
                IFile file;
                Object object2 = this.fLock;
                synchronized (object2) {
                    try {
                        this.fLock.wait(100L);
                    }
                    catch (InterruptedException e) {
                        this.fProgressMonitor.setCanceled(true);
                        break;
                    }
                    file = this.fCurrentFile;
                    numberOfScannedFiles = this.fNumberOfScannedFiles;
                }
                if (file == null) continue;
                String fileName = file.getName();
                Object[] args = new Object[]{fileName, numberOfScannedFiles, numberOfFilesToScan};
                this.fProgressMonitor.subTask(MessageFormat.format(SearchCoreMessages.TextSearchVisitor_scanning, args));
                int steps = numberOfScannedFiles - lastNumberOfScannedFiles;
                this.fProgressMonitor.worked(steps);
                lastNumberOfScannedFiles += steps;
            }
            if (this.fProgressMonitor.isCanceled()) {
                jobGroup.cancel();
            }
            jobGroup.join(0L, null);
            if (this.fProgressMonitor.isCanceled()) {
                throw new OperationCanceledException(SearchCoreMessages.TextSearchVisitor_canceled);
            }
            this.fStatus.addAll((IStatus)jobGroup.getResult());
            MultiStatus multiStatus = this.fStatus;
            return multiStatus;
        }
        catch (InterruptedException e) {
            throw new OperationCanceledException(SearchCoreMessages.TextSearchVisitor_canceled);
        }
        finally {
            this.fileBatches.clear();
        }
        {
            catch (Throwable throwable) {
                this.fProgressMonitor.done();
                this.fCollector.endReporting();
                if (TRACING) {
                    Object[] args = new Object[]{this.fNumberOfScannedFiles, jobCount, NUMBER_OF_LOGICAL_THREADS, System.currentTimeMillis() - startTime};
                    System.out.println(MessageFormat.format("[TextSearch] Search duration for {0} files in {1} jobs using {2} threads: {3}ms", args));
                }
                throw throwable;
            }
        }
    }

    private Map<IFile, IDocument> findDirtyFiles() {
        Map<IFile, IDocument> ret;
        if (this.fDirtyDiscovery != null && (ret = this.fDirtyDiscovery.dirtyFiles()) != null) {
            return ret;
        }
        return Collections.emptyMap();
    }

    public IStatus search(TextSearchScope scope, IProgressMonitor monitor) {
        return this.search(scope.evaluateFilesInScope(this.fStatus), monitor);
    }

    private boolean hasBinaryContentType(IFile file) {
        IContentType[] contentTypes;
        IContentType[] iContentTypeArray = contentTypes = Platform.getContentTypeManager().findContentTypesFor(file.getName());
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType contentType = iContentTypeArray[n2];
            if (contentType.isKindOf(this.TEXT_TYPE)) {
                return false;
            }
            ++n2;
        }
        return contentTypes.length > 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasBinaryContent(CharSequence seq) {
        if (seq instanceof String) {
            String s = (String)seq;
            return s.contains("\u0000");
        }
        try {
            int limit = FileCharSequenceProvider.BUFFER_SIZE;
            int i = 0;
            while (true) {
                if (i >= limit) {
                    return false;
                }
                if (seq.charAt(i) == '\u0000') {
                    return true;
                }
                ++i;
            }
        }
        catch (IndexOutOfBoundsException limit) {
            return false;
        }
        catch (FileCharSequenceProvider.FileCharSequenceException ex) {
            if (!(ex.getCause() instanceof CharConversionException)) throw ex;
            return true;
        }
    }

    private List<TextSearchMatchAccess> locateMatches(IFile file, CharSequence searchInput, Matcher matcher, IProgressMonitor monitor) throws CoreException {
        List<TextSearchMatchAccess> occurences = null;
        matcher.reset(searchInput);
        while (!monitor.isCanceled() && matcher.find()) {
            if (occurences == null) {
                occurences = new ArrayList<TextSearchMatchAccess>();
            }
            int start = matcher.start();
            int end = matcher.end();
            if (end == start) continue;
            ReusableMatchAccess access = new ReusableMatchAccess();
            access.initialize(file, start, end - start, searchInput);
            occurences.add(access);
            boolean res = this.fCollector.acceptPatternMatch(access);
            if (res) continue;
            return occurences;
        }
        if (occurences == null) {
            occurences = Collections.emptyList();
        }
        return occurences;
    }

    private String getExceptionMessage(Exception e) {
        String message = e.getLocalizedMessage();
        if (message == null) {
            return e.getClass().getName();
        }
        return message;
    }

    private IDocument getOpenDocument(IFile file, Map<IFile, IDocument> documentsInEditors) {
        ITextFileBufferManager bufferManager;
        ITextFileBuffer textFileBuffer;
        IDocument document = documentsInEditors.get(file);
        if (document == null && (textFileBuffer = (bufferManager = FileBuffers.getTextFileBufferManager()).getTextFileBuffer(file.getFullPath(), LocationKind.IFILE)) != null) {
            document = textFileBuffer.getDocument();
        }
        return document;
    }

    private String getCharSetName(IFile file) {
        try {
            return file.getCharset();
        }
        catch (CoreException e) {
            return "unknown";
        }
    }

    public static class ReusableMatchAccess
    extends TextSearchMatchAccess {
        private int fOffset;
        private int fLength;
        private IFile fFile;
        private CharSequence fContent;

        public void initialize(IFile file, int offset, int length, CharSequence content) {
            this.fFile = file;
            this.fOffset = offset;
            this.fLength = length;
            this.fContent = content;
        }

        @Override
        public IFile getFile() {
            return this.fFile;
        }

        @Override
        public int getMatchOffset() {
            return this.fOffset;
        }

        @Override
        public int getMatchLength() {
            return this.fLength;
        }

        @Override
        public int getFileContentLength() {
            return this.fContent.length();
        }

        @Override
        public char getFileContentChar(int offset) {
            return this.fContent.charAt(offset);
        }

        @Override
        public String getFileContent(int offset, int length) {
            return this.fContent.subSequence(offset, offset + length).toString();
        }
    }

    private class TextSearchJob
    extends Job {
        private final Map<IFile, IDocument> fDocumentsInEditors;
        private FileCharSequenceProvider fileCharSequenceProvider;
        private final int jobCount;

        public TextSearchJob(Map<IFile, IDocument> documentsInEditors, int jobCount) {
            super("File Search Worker");
            this.jobCount = jobCount;
            this.setSystem(true);
            this.fDocumentsInEditors = documentsInEditors;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor inner) {
            List<IFile> sameFiles;
            MultiStatus multiStatus = new MultiStatus("org.eclipse.search.core", 0, SearchCoreMessages.TextSearchEngine_statusMessage, null);
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)inner, (int)(TextSearchVisitor.this.fileBatches.size() / this.jobCount));
            this.fileCharSequenceProvider = new FileCharSequenceProvider();
            while ((sameFiles = TextSearchVisitor.this.fileBatches.poll()) != null && !TextSearchVisitor.this.fFatalError && !TextSearchVisitor.this.fProgressMonitor.isCanceled()) {
                IStatus status = this.processFile(sameFiles, (IProgressMonitor)subMonitor.split(1));
                if (status.isOK()) continue;
                multiStatus.add(status);
            }
            this.fileCharSequenceProvider = null;
            Object object = TextSearchVisitor.this.fLock;
            synchronized (object) {
                TextSearchVisitor.this.fLock.notify();
            }
            return multiStatus;
        }

        /*
         * Exception decompiling
         */
        public IStatus processFile(List<IFile> sameFiles, IProgressMonitor monitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public Map<IFile, IDocument> getDocumentsInEditors() {
            return this.fDocumentsInEditors;
        }
    }

    private static class TextSearchJobGroup
    extends JobGroup {
        public TextSearchJobGroup(String name, int maxThreads, int initialJobCount) {
            super(name, maxThreads, initialJobCount);
        }

        protected boolean shouldCancel(IStatus lastCompletedJobResult, int numberOfFailedJobs, int numberOfCancelledJobs) {
            return false;
        }
    }
}

