/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai;

import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.ai.AIContextSettings;
import org.jkiss.dbeaver.model.ai.AIDatabaseScope;
import org.jkiss.dbeaver.model.impl.preferences.BundlePreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class AICompletionSettings
extends AIContextSettings {
    public static final String AI_DS_EXTENSION = "ai.assistant";
    public static final String AI_META_TRANSFER_CONFIRMED = "ai.meta.transferConfirmed";
    public static final String AI_META_SCOPE = "ai.meta.scope";
    public static final String AI_META_CUSTOM = "ai.meta.customObjects";
    private static final Log log = Log.getLog(AICompletionSettings.class);
    private final DBPDataSourceContainer dataSourceContainer;
    protected final DBPPreferenceStore preferenceStore;

    public AICompletionSettings(@NotNull DBPDataSourceContainer dataSourceContainer) {
        this((DBPPreferenceStore)AICompletionSettings.getPreferenceStore(), dataSourceContainer);
    }

    public AICompletionSettings(@NotNull DBPPreferenceStore preferenceStore, @NotNull DBPDataSourceContainer dataSourceContainer) {
        this.dataSourceContainer = dataSourceContainer;
        this.preferenceStore = preferenceStore;
        this.loadSettings();
    }

    @Override
    @NotNull
    public DBPDataSourceContainer getDataSourceContainer() {
        return this.dataSourceContainer;
    }

    protected void loadSettings() {
        Object dsConfig = this.dataSourceContainer.getExtension(AI_DS_EXTENSION);
        if (dsConfig == null) {
            this.loadLegacySettings();
        } else if (dsConfig instanceof Map) {
            Map map = (Map)dsConfig;
            this.loadSettingsFromMap(map);
        } else {
            log.error((Object)("Unknown AI settings format: " + String.valueOf(dsConfig)));
        }
    }

    @Override
    public void saveSettings() {
        this.dataSourceContainer.setExtension(AI_DS_EXTENSION, this.saveSettingsToMap());
        this.dataSourceContainer.persistConfiguration();
    }

    private void loadLegacySettings() {
        this.settings.confirmed = this.preferenceStore.getBoolean(this.getParameterName(AI_META_TRANSFER_CONFIRMED));
        this.settings.scope = (AIDatabaseScope)CommonUtils.valueOf(AIDatabaseScope.class, (String)this.preferenceStore.getString(this.getParameterName(AI_META_SCOPE)), (Enum)AIDatabaseScope.CURRENT_SCHEMA);
        String csString = this.preferenceStore.getString(this.getParameterName(AI_META_CUSTOM));
        this.settings.objects = CommonUtils.isEmpty((String)csString) ? new String[]{} : csString.split(",");
    }

    public void saveSettingsToPreferenceStore(DBPPreferenceStore preferenceStore) {
        preferenceStore.setValue(this.getParameterName(AI_META_TRANSFER_CONFIRMED), this.settings.confirmed);
        preferenceStore.setValue(this.getParameterName(AI_META_SCOPE), this.settings.scope.name());
        if (ArrayUtils.isEmpty((Object[])this.settings.objects)) {
            preferenceStore.setToDefault(this.getParameterName(AI_META_CUSTOM));
        } else {
            preferenceStore.setValue(this.getParameterName(AI_META_CUSTOM), String.join((CharSequence)",", this.settings.objects));
        }
    }

    @NotNull
    private static BundlePreferenceStore getPreferenceStore() {
        return new BundlePreferenceStore("org.jkiss.dbeaver.model.ai");
    }

    @NotNull
    protected String getParameterName(@NotNull String postfix) {
        return "ai-" + this.dataSourceContainer.getId() + "." + postfix;
    }
}

