/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.task;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.elements.WelcomeFileModel;
import org.ops4j.pax.web.service.spi.task.BatchVisitor;
import org.ops4j.pax.web.service.spi.task.Change;
import org.ops4j.pax.web.service.spi.task.OpCode;

public class WelcomeFileModelChange
extends Change {
    private final WelcomeFileModel welcomeFileModel;
    private final List<OsgiContextModel> newModels = new LinkedList<OsgiContextModel>();

    public WelcomeFileModelChange(OpCode op, WelcomeFileModel model, OsgiContextModel ... newModels) {
        super(op);
        this.welcomeFileModel = model;
        this.newModels.addAll(Arrays.asList(newModels));
    }

    public List<OsgiContextModel> getNewModels() {
        return this.newModels;
    }

    @Override
    public void uninstall(List<Change> operations) {
        if (this.getKind() == OpCode.ADD) {
            operations.add(new WelcomeFileModelChange(OpCode.DELETE, this.welcomeFileModel, new OsgiContextModel[0]));
        }
    }

    @Override
    public void accept(BatchVisitor visitor) {
        visitor.visitWelcomeFileModelChange(this);
    }

    @Override
    public List<OsgiContextModel> getContextModels() {
        return this.newModels.size() > 0 ? this.newModels : this.welcomeFileModel.getContextModels();
    }

    public WelcomeFileModel getWelcomeFileModel() {
        return this.welcomeFileModel;
    }
}

