/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.commands;

import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smackx.commands.AbstractAdHocCommand;
import org.jivesoftware.smackx.commands.AdHocCommandResult;
import org.jivesoftware.smackx.commands.packet.AdHocCommandData;
import org.jivesoftware.smackx.commands.packet.AdHocCommandDataBuilder;
import org.jivesoftware.smackx.xdata.form.FillableForm;
import org.jivesoftware.smackx.xdata.form.SubmitForm;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jxmpp.jid.Jid;

public class AdHocCommand
extends AbstractAdHocCommand {
    private final XMPPConnection connection;
    private final Jid jid;

    protected AdHocCommand(XMPPConnection connection, String node, Jid jid) {
        super(node);
        this.connection = Objects.requireNonNull(connection);
        this.jid = Objects.requireNonNull(jid);
    }

    public Jid getOwnerJID() {
        return this.jid;
    }

    @Override
    public final void cancel() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        this.executeAction(AdHocCommandData.Action.cancel);
    }

    public final AdHocCommandResult execute() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.executeAction(AdHocCommandData.Action.execute);
    }

    public final AdHocCommandResult next(SubmitForm filledForm) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.executeAction(AdHocCommandData.Action.next, filledForm.getDataForm());
    }

    public AdHocCommandResult complete(SubmitForm filledForm) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.executeAction(AdHocCommandData.Action.complete, filledForm.getDataForm());
    }

    public final AdHocCommandResult prev() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.executeAction(AdHocCommandData.Action.prev);
    }

    public final AdHocCommandResult execute(FillableForm form) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.executeAction(AdHocCommandData.Action.execute, form.getDataFormToSubmit());
    }

    private AdHocCommandResult executeAction(AdHocCommandData.Action action) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.executeAction(action, null);
    }

    private synchronized AdHocCommandResult executeAction(AdHocCommandData.Action action, DataForm form) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        AdHocCommandData request = ((AdHocCommandDataBuilder)((AdHocCommandDataBuilder)AdHocCommandData.builder(this.getNode(), this.connection).ofType(IQ.Type.set)).to(this.getOwnerJID())).setSessionId(this.getSessionId()).setAction(action).setForm(form).build();
        this.addRequest(request);
        AdHocCommandData response = (AdHocCommandData)this.connection.sendIqRequestAndWaitForResponse(request);
        String sessionId = response.getSessionId();
        if (sessionId != null) {
            this.setSessionId(sessionId);
        }
        AdHocCommandResult result = AdHocCommandResult.from(response);
        this.addResult(result);
        return result;
    }
}

