/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2Object;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.DB2Table;
import org.jkiss.dbeaver.ext.db2.model.DB2TableColumn;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2PeriodType;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class DB2TablePeriod
extends DB2Object<DB2Table> {
    private DB2TableColumn beginColumn;
    private DB2TableColumn endColumn;
    private DB2PeriodType type;
    private DB2Schema historyTableSchema;
    private DB2Table historyTable;

    public DB2TablePeriod(DB2Table db2Table, ResultSet dbResult) throws DBException {
        super(db2Table, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PERIODNAME"), true);
        DB2DataSource db2DataSource = (DB2DataSource)db2Table.getDataSource();
        String beginColumnName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"BEGINCOLNAME");
        String endColumnName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ENDCOLNAME");
        String historyTabSchemaName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"HISTORYTABSCHEMA");
        String historyTabName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"HISTORYTABNAME");
        this.type = (DB2PeriodType)CommonUtils.valueOf(DB2PeriodType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PERIODTYPE"));
        VoidProgressMonitor vpm = new VoidProgressMonitor();
        this.beginColumn = db2Table.getAttribute((DBRProgressMonitor)vpm, beginColumnName);
        this.endColumn = db2Table.getAttribute((DBRProgressMonitor)vpm, endColumnName);
        this.historyTableSchema = db2DataSource.getSchema((DBRProgressMonitor)vpm, historyTabSchemaName.trim());
        this.historyTable = this.historyTableSchema.getTable((DBRProgressMonitor)vpm, historyTabName);
    }

    @Override
    @Property(viewable=true, editable=false, order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Property(viewable=true, order=2)
    public DB2Table getTable() {
        return (DB2Table)this.parent;
    }

    @Property(viewable=true, order=3)
    public DB2PeriodType getType() {
        return this.type;
    }

    @Property(viewable=true, order=10)
    public DB2TableColumn getBeginColumn() {
        return this.beginColumn;
    }

    @Property(viewable=true, order=11)
    public DB2TableColumn getEndColumn() {
        return this.endColumn;
    }

    @Property(viewable=true, order=30)
    public DB2Schema getHistoryTableSchema() {
        return this.historyTableSchema;
    }

    @Property(viewable=true, order=31)
    public DB2Table getHistoryTable() {
        return this.historyTable;
    }
}

