/* the main goal of the list is to identify 
   roms
    currently not used
	bad dumps
	merged, combined, modified sets */

static struct {
	int crc32; int size; const char *text;
} roms[]= {
	{ 0x5be0a51f,  0x200, "VIP monitor" },
	{ 0x3e0f50f0,  0x200, "VIP chip8 interpreter" },
	{ 0xa494b339,  0x800, "STUDIO2 bios" },

	{ 0x279e33d1 , 0x400, "ADVENTURE VISION bios" },

	{ 0x04694ed9 , 0x400, "31253 CHANNELF" },
	{ 0x9c047ba3 , 0x400, "31254 CHANNELF" },
	{ 0x2882c02d , 0x800, "MERGED! CHANNELF 31253+31254" },

	{ 0xebc77f3a , 0x2000, "ASTROCADE" },

	{ 0x3aa93ef3 , 0x2000, "COLECO" },
	{ 0x39bb16fc , 0x2000, "COLECO alternate" },
	{ 0x05a37a34, 0x2000, "ADAM eos" },
	{ 0x58d86a2a, 0x8000, "ADAM wp" },

	{ 0xba13fb57 , 0x2000, "VECTREX" },
	{ 0x20af7f3f , 0x8000, "RAASPEC" },

	{ 0x8016a315 , 0x400, "ODYSSEY2" },

	{ 0x5e607dcf, 0x2000, "FAMICOM disk" },
	{ 0x38000b6b, 0x40, "SNES" },

	{ 0xcbce86f7, 0x2000, "INTV" },
	{ 0x683a4158, 0x800, "INTV" },

	{ 0xe6ef1ee1, 0x800, "TV-Spielcomputer" },

	{ 0x05602697, 0x800, "FUNVISION/CREATIVISION" },

/* Sony Playstation ***********************************************************/
	{ 0x37157331, 0x80000, "Sony Playstation DTHL-3000 v2.2A (95.12.04)" },
	{ 0x1e26792f, 0x80000, "Sony Playstation DTHL-3002 v2.2E (95.12.04)" },
	{ 0x3b601fc8, 0x80000, "Sony Playstation SCPH-1000 J (94.09.22)" },
	{ 0x37157331, 0x80000, "Sony Playstation SCPH-1001 v2.2A (95.12.04)" },
	{ 0x24fc7e17, 0x80000, "Sony Playstation SCPH-5000 v2.2J (95.12.04)" },
	{ 0x8c93a399, 0x80000, "Sony Playstation SCPH-5000 v2.2J (95.12.04) (alt)" },
	{ 0xff3eeb8c, 0x80000, "Sony Playstation SCPH-5500 v3.0J (96.09.09)" },
	{ 0x4d9e7c86, 0x80000, "Sony Playstation SCPH-5502 v3.0E (97.01.06)" },
	{ 0xec541cd0, 0x80000, "Sony Playstation SCPH-7000 v4.0J (97.08.18)" },
	{ 0x502224b6, 0x80000, "Sony Playstation SCPH-7001 v4.1A (97.12.16)" },
	{ 0x8d8cb7e4, 0x80000, "Sony Playstation SCPH-7003 v3.0A (97.11.18)" },
	{ 0x318178bf, 0x80000, "Sony Playstation SCPH-7502 v4.1E (97.12.16)" },

	{ 0x39bff762, 0x80000, "Sony Playstation Bleem! v5.1" },


/* Sega Consoles **************************************************************/
	{ 0xf691f9c7, 0x8000, "SC3000 basic 2j" },
	{ 0x155fd01f, 0x8000, "SC3000 basic 31" },

	{ 0x3f888cf4, 0x800, "Sega Genesis" },                    	

	{ 0x5c12eae8, 0x100, "Sega 32X (M68000)" },
	{ 0xdd9c46b8, 0x800, "Sega 32X (master SH2)" },                    	
	{ 0xbfda1fe5, 0x400, "Sega 32X (slave SH2)" },

	{ 0x9d2da8f2, 0x20000, "Sega Mega CD 1.00J (911217)" },
	{ 0xd344f125, 0x20000, "Sega Mega CD 2.00E (930106)" },

	{ 0xc6d10268, 0x20000, "Sega CD 1.10U (921110)" },

	{ 0x2aba43c2, 0x80000, "Sega Saturn 1.00 (940921)" },
	{ 0x4afcf0fa, 0x80000, "Sega Saturn 1.00 (941115)" },
	{ 0x224b752c, 0x80000, "Sega Saturn 1.01 (941228)" },

	{ 0x574fd2c3, 0x80000, "Sega ST-V 1.13J (950425)" },
	{ 0xbf7dbdd7, 0x80000, "Sega ST-V 1.13U (950425)" },

/* NEC ***********(************************************************************/
	{ 0xf82771f1, 0x2000, "PCEngine cdrom bios" },

	{ 0xe983ad21, 0x8000, "BAD DUMP PC6001 (2nd half 0xff)" },
	{ 0x1a63a57a, 0x2000, "BAD DUMP PC6001 (1st and 2nd half equal)" },
	{ 0x950ac401, 0x8000, "PC6001 basic" }, //62?
	{ 0xb5364f8b, 0x2000, "PC6001 char" },
	{ 0x20c8f3eb, 0x8000, "PC6001 kanji" },
	{ 0x49b4f917, 0x4000, "PC6001 voice" },

	{ 0xc0b01772, 0x8000, "PC6601 basic" },
	{ 0xd2434f29, 0x2000, "PC6601 char" },
	{ 0x3ce48c33, 0x2000, "PC6601 char" },
	{ 0xf952b567, 0x8000, "PC6601 kanji" },
	{ 0x91d078c1, 0x4000, "PC6601 voice" },

	{ 0x516b1be3, 0x8000, "PC6601 basic" }, //68??
	{ 0x331473a9, 0x2000, "PC6601 char" },
	{ 0x03ba2cf1, 0x2000, "PC6601 char" },
	{ 0x07318218, 0x2000, "PC6601 system2" },
	{ 0x37ff3829, 0x4000, "PC6601 voice" },

	{ 0x27e1857d , 0x8000, "PC8801mk2sr 00000 PC-8001 basic 1.5 debug 1.0c" },
	{ 0xa0fc0473 , 0x8000, "PC8801mk2sr 08000 N-88 basic 1.4" },
	{ 0x710a63ec , 0x2000, "PC8801mk2sr 10000" },
	{ 0xc0bd2aa6 , 0x2000, "PC8801mk2sr 12000" },
	{ 0xaf2b6efa , 0x2000, "PC8801mk2sr 14000" },
	{ 0x7713c519 , 0x2000, "PC8801mk2sr 16000" },
	{ 0x2158d307 , 0x800, "PC8801 disk" },
	{ 0x6178bd43 , 0x20000, "PC8801 charrom" },
	{ 0x154803cc , 0x20000, "PC8801 charrom (empty 0xff)" },
	{ 0xeb1d90ca, 0x1c000, "PC8801? (32kb N-88 basic 1.9 08000,8kb 0e000, 8kb?, 8kb 10000, 8kb 12000,8kb 14000,8kb 16000,8kb ?,24kb PC-8001 Basic 1.8 00000" },
	{ 0x7a6edb47, 0x1800, "PC8801 char?" },
	{ 0x0f60c51f, 0x20000, "PC8801 kanji1?" },
	{ 0x8e67a330, 0x20000, "PC8801 kanji2?" },
	{ 0x04f60f50 , 0x420, "OVERDUMP PC8801 disk extension? (remove first 32 bytes)" },

	{ 0x6e299128 , 0x8000, "BAD DUMP/ROM? PC9821 00000" },
	{ 0xf2a262b0 , 0x8000, "BAD DUMP/ROM? PC9821 c8000" },
	{ 0x5dda57cc , 0x8000, "BAD DUMP/ROM? PC9821 d8000" },
	{ 0x4e32081e , 0x8000, "PC9821 e8000" },
	{ 0x4da85a6c , 0x8000, "PC9821 f0000" },
	{ 0x2b1e45b1 , 0x8000, "MODIFIED? PC9821 f8000" },

/* Apple Computers ************************************************************/

/* apple I */
	{ 0xa30b6af5 , 0x100, "APPLE1 bios" },
	{ 0xbe70bb85 , 0x400, "APPLE1 characterset bad dump?" },
	{ 0xa3f2d66f , 0x400, "APPLE1 characterset" },

/* apple II */
	{ 0x24d73c7b, 0x1000, "APPLE2 d000" },
	{ 0x0d494efd, 0x1000, "APPLE2 e000" },
	{ 0xb58f1ca1, 0x1000, "APPLE2 f000" },
	{ 0xf66f9c26 , 0x3000, "MERGED APPLE2? (0x24d73c7b+0x0d494efd+0xb58f1ca1)" },

	{ 0xe248835e , 0x2000, "APPLE2E bios c000 (?+0x24d73c7b)" },
	{ 0xfc3d59d8 , 0x2000, "APPLE2E bios e000 (0x0d494efd+?)" },
	{ 0x443aa7c4 , 0x2000, "APPLE2EE bios c000" },
	{ 0x95e10034 , 0x2000, "APPLE2EE bios e000" },

	{ 0x65989942, 0x4000, "BAD DUMP APPLE2E (0x?+0x95e10034!+0x443aa7c4+0x95e10034!)" },

	{ 0x02b648c8 , 0x4000, "APPLE2EP bios c000" },
	{ 0xf0edaa1b , 0x4000, "APPLE2C bios" },
	{ 0xc8b979b3 , 0x8000, "APPLE2C0 bios" },
	{ 0x0b996420 , 0x8000, "APPLE2CP bios" },

	{ 0xce7144f6 , 0x100, "APPLE2E disk" },
	{ 0x816a86f1 , 0x1000, "APPLE2E characterset" },
	{ 0x2651014d , 0x1000, "APPLE2C characterset" },

	{ 0x42f124b0 , 0x20000, "APPLE2GS" },

	{ 0xecfceb45 , 0x800, "INCOMPLETE? APPLE characterset ???" },
	{ 0xc506efb9 , 0x800, "INCOMPLETE? APPLE characterset ???" },
	{ 0x2b6da315 , 0x1000, "BAD DUMP? APPLE characterset 0xc506efb9+0xc506efb9!" },
	{ 0x0b0759cc , 0x1000, "BAD DUMP? APPLE characterset (first half 0xff)+0xc506efb9" },

/* apple III */

/* lisa */
	{ 0xadfd4516 , 0x2000, "LISA2 hi" },
	{ 0x546d6603 , 0x2000, "LISA2 lo" },
	{ 0xbc6364f1 , 0x1000, "LISA2 6504" },
	{ 0x75904783 , 0x100, "LISA2 vidprom" },

	{ 0xb72a2c70, 0x100, "lisa vidprom ??" },
	{ 0x223f3917, 0x100, "lisa vidprom few differences to 0xb72a2c70 ??" },
	{ 0xe343fe74, 0x1000, "lisa ??" },
	{ 0x8c67959a, 0x1000, "lisa ??" },
	{ 0xef19130f, 0x1000, "lisa ??" },
	{ 0xa26ef1c6, 0x800, "lisa ??" },
	{ 0x25e86e95, 0x2000, "lisa ??" },
	{ 0xe693057b, 0x2000, "lisa ??" },
	{ 0x80add605, 0x2000, "lisa 68000 hi??" },
	{ 0xedf5222f, 0x2000, "lisa 68000 lo??" },

/* macintosh */
	{ 0x7cacd18f , 0x020000, "Macintosh Plus v2 Lonely Heifers 342-0341+342-0342 (4d1eeae1)" },
	{ 0xb2102e8e , 0x020000, "Macintosh Plus v3 Loud Harmonicas 342-0341+342-0342 (4d1f8172)" },
	{ 0xf69697e6 , 0x010000, "Macintosh Plus v3 Loud Harmonicas 342-0341 (4d1f8172) EVEN" },
	{ 0x49f25913 , 0x010000, "Macintosh Plus v3 Loud Harmonicas 342-0342 (4d1f8172) ODD" },
	{ 0xce3b966f , 0x040000, "Macintosh II(HDFD), IIx, IIcx, SE/30 342-0639+342-0640+342-0641+342-0642 (97221136)" },
	{ 0x71681726 , 0x080000, "Macintosh LC 342-0392+342-0393+342-0394+342-0395 (350eacf0)" },
	{ 0xa92145b3 , 0x080000, "Macintosh IIci, LC-II 342-0476+342-0475+342-0474+342-0473 (35c28f5f)" },
	{ 0x46adbf74 , 0x080000, "Macintosh IIci 342-0736+342-0735+342-0734+342-0733 (368cadfe)" },
	{ 0x1735e7a5 , 0x100000, "Macintosh LC 630, Performa 630 (06684214)" },
	{ 0x88ea2081 , 0x100000, "Macintosh Quadra 700, Quadra 900 (420dbff3)" },
	{ 0xa893cb0f , 0x100000, "Macintosh Performa 450, Performa 550 (?) (ede66cbd)" },
	{ 0xb8514689 , 0x100000, "Macintosh LC 475, Performa 475, Quadra 605 (ff7439ee)" },
	{ 0x4e70e3c0 , 0x100000, "Macintosh Centris 650, Quadra 650 (f1acad13)" },
	{ 0xe578f5f3 , 0x100000, "Macintosh LC-III, Performa 460 (ecbbc41c)" },
	{ 0x59e6960f , 0x100000, "Macintosh LC 580, Performa 580 (064dc91d)" },
	{ 0x66cf9f2f , 0x200000, "Macintosh PowerBook 520 (b6909089)" },

	{ 0xb86ed854 , 0x100000, "Macintosh Unknown (ecfa989b)" },

	{ 0x6eb97aff , 0x010000, "BAD DUMP Macintosh Plus v2 Lonely Heifers 342-0341 (4d1eeae1) EVEN" },
	{ 0xbfdc37d1 , 0x010000, "BAD DUMP Macintosh Plus v2 Lonely Heifers 342-0342 (4d1eeae1) ODD" },
	{ 0x7624ef58 , 0x020000, "BAD DUMP Macintosh Plus v2 Lonely Heifers 342-0341+342-0342 (4d1eeae1)" },
	{ 0xf7c4b876 , 0x01ffff, "INCOMPLETE BAD DUMP Macintosh Plus v2 Lonely Heifers 342-0341+342-0342 (4d1eeae1)" },
	{ 0xe133094a , 0x021d50, "OVER DUMP Macintosh Plus v3 Loud Harmonicas 342-0341+342-0342 (4d1f8172)" },
	{ 0xa39fb2b9 , 0x400000, "BAD DUMP Power Mac (96cd923d)" },


/* Acorn **********************************************************************/
	{ 0xc604db3d , 0x1000, "ATOM kernel" },
	{ 0x81d86af7 , 0x1000, "ATOM floating point" },
	{ 0x43798b9b , 0x1000, "ATOM basic" },
	{ 0xc431a9b7 , 0x1000, "ATOM dos" },
	{ 0x3c14fc70 , 0x4000, "PROTON kernel" },
	{ 0x79434781 , 0x4000, "PROTON basic" },
	{ 0xe7e2a294 , 0x4000, "PROTON advromm" },
	{ 0x9a50231f , 0x4000, "PROTON exmon" },
	{ 0xc1505821 , 0x4000, "PROTON help" },
	{ 0x557ce483 , 0x4000, "PROTON toolkit" },
	{ 0x4345359f , 0x4000, "PROTON view" },
	{ 0x9fb8d13f , 0x4000, "PROTON dfs144" },

	{ 0xc1adde84 , 0x80000, "ARCHIMEDES 310 bios 20000" },
	{ 0x15d89664 , 0x80000, "ARCHIMEDES 310 bios 28000" },
	{ 0xa81ceb7c , 0x80000, "ARCHIMEDES 310 bios 30000" },
	{ 0x707b0c6c , 0x80000, "ARCHIMEDES 310 bios 38000" },

/* Atari 400/800 Computers *****************************************************/
	{ 0x6a5d766e , 0x0800, "Atari 400/800 floating point d800 (CO12399B?)" },
	{ 0x8e547f56 , 0x1000, "Atari 400/800 PAL A e000 (CO15199?)" },
	{ 0xbe55b413 , 0x1000, "Atari 400/800 PAL A f000 (CO15299?)" },
	{ 0x6ea08467 , 0x1000, "Atari 400/800 PAL B? (few differences to NTSC B) e000" },
	{ 0x7509ffc4 , 0x1000, "Atari 400/800 PAL B? (few differences to NTSC B) f000" },
	{ 0xd818f3e8 , 0x1000, "Atari 400/800 NTSC B e000 (CO12499B?)" },
	{ 0xc1690a9b , 0x1000, "Atari 400/800 NTSC B f000 (CO14599B?)" },

	{ 0x72b3fed4 , 0x2800, "MERGED Atari 400/800 PAL A (CO12399B+CO15199+CO15299?)" },
	{ 0xcb4db9af , 0x2000, "MERGED Atari 400/800 PAL B? (e000+f000)" },
	{ 0x3e28a1fe , 0x2800, "MERGED Atari 400/800 PAL B? (d000+e000+f000)" },
	{ 0x0e86d61d , 0x2800, "MERGED Atari 400/800 NTSC B (CO12399B+CO12499B+CO14599B?)" },

/* Atari XL/XE Computers *****************************************************/
	{ 0x643bcc98 , 0x4000, "Atari 600XL rev. 01 (CO62024)" },
	{ 0x1f9cd270 , 0x4000, "Atari XL/XE rev. 02 (CO61598B)" },
	{ 0x29f133f7 , 0x4000, "Atari 800XE rev. 03 (C300717)" },
	{ 0x0391386b , 0x2000, "Atari 1200XL rev. 10 part 1 (CO60616A)" },
	{ 0xb502f1e7 , 0x2000, "Atari 1200XL rev. 10 part 2 (CO60617A)" },
	{ 0x89d5661d , 0x1000, "Atari XL/XE BASIC rev. A part 1 (co12402)" },
	{ 0x4b4e6762 , 0x1000, "Atari XL/XE BASIC rev. A part 2 (co14502)" },
	{ 0xf0202fb3 , 0x2000, "Atari XL/XE BASIC rev. B (CO60302A)" },
	{ 0x7d684184 , 0x2000, "Atari XL/XE BASIC rev. C (CO24947A)" },

	{ 0xc5c11546 , 0x4000, "MERGED Atari 1200XL rev. 10 (CO60616A+CO60617A)" },
	{ 0x4bec4de2 , 0x2000, "MERGED Atari XL/XE BASIC rev. A (CO12402+CO14502)" },
	{ 0x1eaf4002 , 0x4000, "PART Atari XEGS rev. 04 (C101687)" },

/* Atari 800/800XL OS replacements *********************************************/
	{ 0xa1fb9bfa , 0x4000 , "Atari 800XL Qmeg OS ver. 2.3" },
	{ 0xbe14e47e , 0x4000 , "Atari 800XL Qmeg OS ver. 3.0" },
	{ 0x8cd48719 , 0x4000 , "Atari 800XL Qmeg OS ver. 3.2" },
	{ 0x78f2c102 , 0x4000 , "Atari 800XL Qmeg OS ver. 3.8" },
	{ 0x64ccfc53 , 0x4000 , "Atari 800XL Qmeg OS ver. 4.2" },
	{ 0xbe2242da , 0x4000 , "Atari 800XL Qmeg OS ver. 4.3" },

/* Atari 8-bit computers external devices **************************************/
	{ 0xf10064a3 , 0x1000 , "Atari 1060 CP/M Module boot ROM"},
	{ 0xd1c68dda , 0x1000 , "Atari 1060 CP/M Module character set ROM"},

/* Atari ST/STF/SFM/STFM/Mega ST/Mega STE/Stacey *******************************/
	/* info on Atari ST TOS dumps taken from dat by TOSEC team */
	/* not verified, probably needs many corrections */
	{ 0x16e3e979 , 0x30000 , "Atari 520/1040ST TOS v1.0 (De) (1985)" },
	{ 0x2b7f2117 , 0x30000 , "Atari 520/1040ST TOS v1.0 (Fr) (1985)" },
	{ 0x1a586c64 , 0x30000 , "Atari 520/1040ST TOS v1.0 (Uk) (1985)" },
	{ 0xd331af30 , 0x30000 , "Atari 520/1040ST TOS v1.0 (Us) (1985)" },
	{ 0x5fe16c66 , 0x30000 , "Atari 520/1040ST/STF/SFM/STFM, Mega ST 2/4 TOS v1.2 (later 1.02) (Ch) (1987)" },
	{ 0x8688fce6 , 0x30000 , "Atari 520/1040ST/STF/SFM/STFM, Mega ST 2/4 TOS v1.2 (later 1.02) (Fr) (1987)" },
	{ 0x673fd0c2 , 0x30000 , "Atari 520/1040ST/STF/SFM/STFM, Mega ST 2/4 TOS v1.2 (later 1.02) (Sw) (1987)" },
	{ 0x3b5cd0c5 , 0x30000 , "Atari 520/1040ST/STF/SFM/STFM, Mega ST 2/4 TOS v1.2 (later 1.02) (Uk) (1987)" },
	{ 0xd3c32283 , 0x30000 , "Atari 520/1040ST/STF/SFM/STFM, Mega ST 2/4 TOS v1.2 (later 1.02) (Us) (1987)" },
	{ 0xe58f0bdf , 0x30000 , "Atari Stacey, 520/1040STFM, Mega ST 1/2/4 TOS v1.4 (later 1.04) (Ch) (1989)" },
	{ 0xf4e8ecd2 , 0x30000 , "Atari Stacey, 520/1040STFM, Mega ST 1/2/4 TOS v1.4 (later 1.04) (Sp) (1989)" },
	{ 0x80ecfdce , 0x30000 , "Atari Stacey, 520/1040STFM, Mega ST 1/2/4 TOS v1.4 (later 1.04) (Sw) (1989)" },
	{ 0xa50d1d43 , 0x30000 , "Atari Stacey, 520/1040STFM, Mega ST 1/2/4 TOS v1.4 (later 1.04) (Uk) (1989)" },
	{ 0x90f4fbff , 0x30000 , "Atari Stacey, 520/1040STFM, Mega ST 1/2/4 TOS v1.4 (later 1.04) (Us) (1989)" },
	{ 0x7c67c5c9 , 0x40000 , "Atari 1040STE TOS v1.6 (De) (1989)" },
	{ 0xb6e58a46 , 0x40000 , "Atari 1040STE TOS v1.6 (Fr) (1989)" },
	{ 0x2cdeb5e5 , 0x40000 , "Atari 1040STE TOS v1.62 (De) (1990)" },
	{ 0x90f124b1 , 0x40000 , "Atari 1040STE TOS v1.62 (Sw) (1990)" },
	{ 0xd1c6f2fa , 0x40000 , "Atari 1040STE TOS v1.62 (Uk) (1990)" },
	{ 0x1c1a4eba , 0x40000 , "Atari 1040STE TOS v1.62 (Uk) (1990) (alt)" },
	{ 0x6372e5bd , 0x40000 , "Atari 1040STE TOS v1.62 (Us) (1990)" },
	{ 0x27b83d2f , 0x40000 , "Atari Mega STE TOS v2.05 (Fr) (1990)" },
	{ 0xb28bf5a1 , 0x40000 , "Atari Mega STE TOS v2.05 (It) (1990)" },
	{ 0x6d49ccbe , 0x40000 , "Atari Mega STE TOS v2.05 (Sw) (1990)" },
	{ 0xd8845f8d , 0x40000 , "Atari Mega STE TOS v2.05 (Us) (1990)" },
	{ 0x8c4fe57d , 0x40000 , "Atari Mega STE TOS v2.06 (Ch) (1991)" },
	{ 0x143cd2ab , 0x40000 , "Atari Mega STE TOS v2.06 (De) (1991)" },
	{ 0xe3a99ca7 , 0x40000 , "Atari Mega STE TOS v2.06 (Fr) (1991)" },
	{ 0xbe61906d , 0x40000 , "Atari Mega STE TOS v2.06 (Sw) (1991)" },
	{ 0x08538e39 , 0x40000 , "Atari Mega STE TOS v2.06 (Uk) (1991)" },
	{ 0x3f2f840f , 0x40000 , "Atari Mega STE TOS v2.06 (Us) (1991)" },
	{ 0x3c3e811c , 0x30000 , "Atari ST Kaos TOS v1.4 (De) (1989)" },
	{ 0x2efbfd7e , 0x30000 , "Atari ST Kaos TOS v1.4.3 (Ch) (1991)" },

	{ 0xe50e6bf9 , 0x2ff80 , "BAD DUMP Atari 520/1040ST TOS v1.0 (Ch) (1985)" },
	{ 0xa2e25337 , 0x40000 , "BAD DUMP Atari 1040STE TOS v1.6 (Fr) (1989)" },
	{ 0xde62800c , 0x30000 , "BAD DUMP Atari 1040STE TOS v1.6 (Uk) (1989)" },
	{ 0xcf40329c , 0x40000 , "BAD DUMP Atari Mega STE TOS v2.06 (Uk) (1991)" },

/* Atari consoles **************************************************************/
	{ 0x4248d3e3 , 0x0800, "Atari 5200 BIOS" },
	{ 0x649913e5 , 0x1000, "Atari 7800 BIOS" },

	{ 0xe1ffecb6, 0x200, "Atari Lynx saved (fff9 not authentic)" },
	{ 0x0d973c9d, 0x200, "Atari Lynx saved (fff9 not authentic) (alt)" },
	{ 0x7a91840c, 0x200, "Atari Lynx dummy boot image" },

	{ 0xfb731aaa, 0x20000, "Atari Jaguar (boot)" },
	{ 0x687068d5, 0x40000, "Atari Jaguar (cd)" },

/* amstrad *********************************************************************/
	{ 0x0219bb74 , 0x4000, "CPC6128 os" },
	{ 0xcdb86700 , 0x4000, "CPC6128 os french" },
	{ 0xa9937f75 , 0x4000, "CPC6128 os spanish" },
	{ 0x7f9ab3f7 , 0x4000, "KCCOMPACT os" },
	{ 0xca6af63d , 0x4000, "CPC basic" },
	{ 0x4ff8190c , 0x4000, "CPC6128 basic french" },
	{ 0xb6e4acd2 , 0x4000, "CPC6128 basic spanish" },
	{ 0x40852f25, 0x8000, "CPC464" },
	{ 0x39185397, 0x8000, "CPC464 Danish (homebrew?)" },
	{ 0x9ab5a036, 0x8000, "CPC664" },
	{ 0x9e827fe1, 0x8000, "MERGED CPC6128 0x0219bb74+0xca6af63d" },
	{ 0x1fe22ecd, 0x4000, "CPC Disk" },
	{ 0x37f1bb31, 0x4000, "BAD DUMP CPC Disk (1st half equal 0x1fe22ecd, 2nd half 0)" },
	{ 0xf36086de, 0x2000, "CPC Multiface" },

	{ 0xbec456b1, 0x4000, "CPC464+ os" },
	{ 0xc0cb1145, 0x4000, "CPC464+ basic" },
	{ 0xf6159e18, 0x4000, "BAD DUMP CPC464+ disk (2nd half ff)" },

	{ 0xdf31eb22, 480, "REPROGRAMMED PCW8256 older than 0x679b0287" },
	{ 0x621d58a7, 589, "REPROGRAMMED PCW8256 older than 0x679b0287" },
	{ 0xb3140dcb, 608, "REPROGRAMMED PCW8256 older than 0x679b0287" },
	{ 0x679b0287, 608, "REPROGRAMMED PCW8256" },
	{ 0xc642f498 , 0x80000, "PCW16 045" },

	{ 0x849884f9, 0x40000, "NC100" },
	{ 0xa699eca3, 0x40000, "NC100a" },
	{ 0xbb8180e7, 0x80000, "NC200" },

/* commodore pet series *******************************************************************/
	{ 0xa055e33a, 0x800, "901447-01, 901439-01, maybe 6540-011 PET basic1 c000" },	
	{ 0x03cf16d0, 0x800, "901447-09, 901439-09, 6540-019 PET basic1 c000 newer revision" },
	{ 0x69fd8a8f, 0x800, "901447-02, 901439-05, 6540-012 PET basic1 c800" },
	{ 0xd349f2d4, 0x800, "901447-03, 901439-02, 6540-013 PET basic1 d000" },
	{ 0x850544eb, 0x800, "901447-04, 901439-06, 6540-014 PET basic1 d800" },
	{ 0x9e1c5cea, 0x800, "901447-05, 901439-03, 6540-015 PET e000" },
	{ 0x661a814a, 0x800, "901447-06, 901439-04, 6540-016 PET f000" },
	{ 0xc4f47ad1, 0x800, "901447-07, 904139-07, 6540-018 PET f800" },

	{ 0x63a7fe4a, 0x1000, "901465-01 PET basic2 c000" },
	{ 0xae4cb035, 0x1000, "901465-02 PET basic2 d000" },
	{ 0xe459ab32, 0x800, "901447-24, 6540-024 PET e000" },
	{ 0x05db957e, 0x800, "901474-01 PET business keyboard e000" }, 
	{ 0xf02238e2, 0x1000, "901465-03 PET f000" },
	
	{ 0x3a5f5721, 0x1000, "901465-19 PET basic4 b000" },
	{ 0xae3deac0, 0x1000, "901465-23 PET basic4 b000 newer revision" },
	{ 0x0fc17b9c, 0x1000, "901465-20 PET basic4 c000" },
	{ 0x36d91855, 0x1000, "901465-21 PET basic4 d000" },
	{ 0x5f85bdf8, 0x800, "901499-01 PET crtc 60hertz e000" },
	{ 0x3370e359, 0x800, "901498-01 PET crtc 50hertz e000" },
	{ 0x75ff4af7, 0x800, "901474-02 PET business keyboard e000" },
	{ 0x5674dd5e, 0x800, "901474-03 PET 80columns business keyboard, 60 hertz e000" },
	{ 0xc1ffca3a, 0x800, "901474-04-3681 PET 80columns business keyboard, 50 hertz e000 (1981, week36)" },
	{ 0x845a44e6, 0x800, "901474-04? PET 80columns business keyboard, 50 hertz e000" },
	{ 0xabb000e7, 0x800, "901474-04 PET 80columns business keyboard, 50 hertz e000" },
	{ 0x1c1e597d, 0x800, "? PET 80columns business keyboard, 50 Hertz, german e000" },
	{ 0x75901dd7, 0x800, "? PET 80columns business keyboard, 50 Hertz, swedish e000" },
	{ 0xcc5298a1, 0x1000, "901465-22 PET f000" },

	{ 0x54f32f45, 0x800, "901447-08 PET 8x8 petscii character set" },/* 6540-010 = 901439-08 */
	{ 0xd8408674, 0x800, "901447-10 PET 8x8 business character set" },
	{ 0x3bb8cb87, 0x800, "? PET 8x8 business german character set" },
	{ 0x48c77d29, 0x800, "901447-14 PET 8x8 business swedish character set" },
	{ 0xa02d8122, 0x800, "? PET 8x8 business hungarian character set" }, // Editor rom missing

	{ 0xd262bacd, 0x2000, "BAD DUMP! 324878-01 PET cost reduced set" },
	{ 0x5e00476d, 0x2000, "BAD DUMP! 324878-02 PET cost reduced set" },

	{ 0xaff78300, 0x2000, "MERGED! PET 901447-09 + 901447-02 + 901447-03 + 901447-04" },
	{ 0xf0186492, 0x1000, "MERGED! PET 901447-06 + 901447-07" },
	{ 0xcf35e68b, 0x2000, "MERGED! PET 901465-01 + 901465-02" },
	{ 0x2a940f0a, 0x3000, "MERGED! PET 901465-23 + 901465-20 + 901465-21" },
		
	{ 0x728a998b, 0x1000, "901898-01 SUPERPET m6809 a000" },
	{ 0x6beb7c62, 0x1000, "901898-02 SUPERPET m6809 b000" },
	{ 0x5db4983d, 0x1000, "901898-03 SUPERPET m6809 c000" },
	{ 0xf55fc559, 0x1000, "901898-04 SUPERPET m6809 d000" },
	{ 0xb2cee903, 0x800, "901897-01 SUPERPET m6809 e000" },
	{ 0xf42df0cb, 0x1000, "901898-05 SUPERPET m6809 f000" },

	{ 0xee8229c4, 0x1000, "901640-01 SUPERPET 8x8chars 256 PETSCII, 256 ASCII" },
	{ 0xda1cd630, 0x1000, "? SUPERPET 8x8chars 256 PETSCII Swedish, 256 ASCII\n9014147-14+256 chars ascii from above)" },

/* Commodore C16/C116/Plus4/1551 *************************************************************/
	{ 0x74eaae87, 0x4000, "318006.01 PLUS4 Basic 8000" },
	{ 0xdbdc3319, 0x4000, "318004.01 PLUS4 Kernel PAL R1 c000" },
	{ 0x77bab934, 0x4000, "318004.03 PLUS4 Kernel Pal R3 c000" },
	{ 0xbe54ed79, 0x4000, "318004.04 PLUS4 Kernel Pal R4 c000" },
	{ 0x71c07bd4, 0x4000, "318004.05 PLUS4 Kernel Pal R5 c000" },
	{ 0x775f60c5, 0x4000, "318004.05 PLUS4 Kernel Pal R5, hungarian character set, HACK? c000" },
	{ 0x84fd4f7a, 0x4000, "? PLUS4 Kernel NTSC R1 c000" },
	{ 0x799a633d, 0x4000, "318005.04 PLUS4 Kernel NTSC R4 c000" },
	{ 0x70295038, 0x4000, "318005.05 PLUS4 Kernel NTSC R5 c000" },
	{ 0x4fd1d8cb, 0x4000, "317053.01 PLUS4 3PLUS1 8000/bank2" },
	{ 0x109de2fc, 0x4000, "317054.01 PLUS4 3PLUS1 c000/bank2" },
	{ 0x5227c2ee, 0x4000, "? PLUS4 voice 8000/bank4" },
	{ 0x6d16d024, 0x4000, "318008.01 C1551/PLUS4 Floppy c000" },
	{ 0xaab61387, 0x4000, "BAD DUMP of 317054.01 (from running machine) PLUS4 3PLUS1 c000/bank2" },
	{ 0x7d464449, 0x8000, "BAD DUMP of 317053.01 + 317054.01 (from running machine) PLUS4 3PLUS1 8000/bank2" },
	{ 0xf284199b, 0x800, "UNUSEABLE PART PLUS4 character set d000" },
	{ 0x5b6a2b88, 0x800, "UNUSEABLE PART PLUS4 hungarian character set d000" },

/* Commodore VIC20 **************************************************************************/
	{ 0xdb4c43c1, 0x2000, "901486.01 VIC20 Basic c000" },
	{ 0xe5e7c174, 0x2000, "901486.06 VIC20 Kernel NTSC e000" },
	{ 0x4be07cb4, 0x2000, "901486.07 VIC20 Kernel PAL e000" },
	{ 0x83e032a6, 0x1000, "901460.03 VIC20 character set 8000" },
	{ 0xd808551d, 0x1000, "nec22101.207 VIC20 swedish character set 8000" },
	{ 0xb2a60662, 0x2000, "nec22081.206 VIC20 swedish Kernel e000" },
	{ 0xfcfd8a4b, 0x1000, "901460.02 VIC1001 character set 8000" },
	{ 0x336900d7, 0x2000, "901486.02 VIC1001 NTSC-M e000" },
	{ 0xd37b6335, 0x800, "325329-04 VIC20 IEEE Cartridge b000" },

/* Commodore 65 Prototype ******************************************************************/
	{ 0x0888b50f, 0x20000, "C65 911001" },
	{ 0x3ee40b06, 0x20000, "C65 910828" },
	{ 0x12527742, 0x20000, "C65 910626" },
	{ 0xe8235dd4, 0x20000, "C65 910523" },
	{ 0xb025805c, 0x20000, "C65 910429 German" },
	{ 0xc5d8d32e, 0x20000, "C65 910111" },
	{ 0x0670b3b6, 0x2000, "UNUSEABLE PART C65 c64 basic" },
	{ 0xc85f9781, 0x2000, "UNUSEABLE PART C65 c64 kernel" },

/* commodore b series *********************************************************************/
	{ 0x9d0366f9, 0x2000, "901243-02b CBMB basic 128kb f8000" },
	{ 0x837978b5, 0x2000, "901242-02b CBMB basic 128kb fa000" },
	{ 0xb0dcb56d, 0x2000, "901243-04a CBMB basic 128kb f8000" },
	{ 0xde04ea4f, 0x2000, "901242-04a CBMB basic 128kb fa000" },
	{ 0x5a680d2a, 0x2000, "?901242-04 CBMB some additions to 901242-04a fa000" },
	{ 0x8eed0d7e, 0x4000, "? CBMB basic 256kb f8000" },
	{ 0x5c1f3347, 0x2000, "901241-03 CBMB basic 256kb f8000" },
	{ 0x72aa44e1, 0x2000, "901240-03 CBMB basic 256kb fa000" },
	{ 0x4276dbba, 0x2000, "901244-03b CBMB kernel monitor instead of tape fe000" },
	{ 0x87bc142b, 0x2000, "901244-03 CBMB Kernel swedish/finish fe000" },
	{ 0x19bf247e, 0x2000, "? CBMB kernel fe000" },
	{ 0x09a5667e, 0x2000, "901244-04a CBMB kernel fe000" },
	{ 0x0ea8ca4d, 0x2000, "? CBMB hungarian kernel fe000" },
	{ 0x1acf5098, 0x1000, "901237-01 CBMB 8x8 in 8x16 2x128 character set (needs inversion hardware)" },
	{ 0x1fb5e596, 0x2000, "? CBMB 8x8 in 8x16 2x256 hungarian character" },
	{ 0x3a350bc3, 0x1000, "901232-01 CBMB 9x14 in 8x16 2x128 character set (needs inversion hardware)" },
	{ 0x09518b19, 0x1000, "901233-03 CBMB swedish/finnish 9x14 in 8x16 2x128 character set (needs inversion hardware)" },
	{ 0xc62ab16f, 0x2000, "901236-02 CBM500 basic 128kb f8000" },
	{ 0x20b7df33, 0x2000, "901235-02 CBM500 basic 128kb fa000" },
	{ 0xf46bbd2b, 0x2000, "901234-02 CBM500 kernal monitor instead of type fe000" },
	{ 0xec4272ee, 0x1000, "901225-01 CBM500 8x8 character set" },
	{ 0x9a468e5d, 0x4000, "MERGED! CBM500 901236-02 + 901235-02" },
	{ 0xdf83bbb9, 0x4000, "MERGED! CBMB 901243-02b + 901242-02b" },
	{ 0xa8ff9372, 0x4000, "MERGED! CBMB 901243-04a + 901242-04a" },
	{ 0x5db15870, 0x4000, "MERGED! CBMB 901241-03 + 901240-03" },

/* commodore 64 ********************************************************************/
	{ 0xf833d117 , 0x2000, "901226.01 C64 basic a000" },
	{ 0x2b1b7381 , 0x2000, "SCRAP? C64 kernel e000" }, // modified for alec 64 
	{ 0xb8f49365 , 0x2000, "SCRAP C64 kernel speeddos, unique copyright" },
	{ 0xbeed6d49 , 0x2000, "SCRAP? C64 kernel" },
	{ 0xcfb58230 , 0x2000, "SCRAP? C64 kernel" },
	{ 0x6ec94629 , 0x2000, "SCRAP? C64 kernel (basic x 2)" },
	{ 0xdce782fa , 0x2000, "901227.01 C64 kernel r1" },
	{ 0xa5c687b3 , 0x2000, "901227.02 C64 kernel r2" },
	{ 0xdbe3e7c7 , 0x2000, "901227.03 C64 kernel r3" },
	{ 0xf1098d37 , 0x2000, "BAD DUMP, UNUSEABLE PART! C64 901227.03" },
	{ 0x8f294c51 , 0x2000, "325017-02 C64 swedish kernel r2?" },
	{ 0xf10c2c25 , 0x2000, "901227-03? C64 swedish kernel r3?" },
	{ 0x789c8cc5 , 0x2000, "901246.01 C64 pet64 kernel" },
	{ 0x2c5965d4 , 0x4000, "251104.04 C64 SX64 kernel" },
	{ 0x7858d3d7 , 0x4000, "251104.04? C64 SX64 swedish kernel" },
	{ 0x58065128 , 0x4000, "??? C64 DX64 kernel" },
	{ 0xf80eb87b , 0x2000, "??? C64 kernel few differences to 901227.02" },
	{ 0x8e5c500d , 0x2000, "??? C64 kernel few differences to 901227.03" },
	{ 0xc13310c2 , 0x2000, "??? C64 kernel few differences 901227.03" },
	{ 0x97d9a4df , 0x2000, "??? C64 kernel 64er system v1" },
	{ 0x5096b3bd , 0x2000, "??? C64 kernel 64er system v3" },
	{ 0x4e54d020 , 0x2000, "??? C64 kernel Exos v3" },
	{ 0x26f3339e , 0x2000, "??? C64 kernel Exos v3 2 bytes different to 0x4e54d020" },
	{ 0x2f79984c , 0x2000, "??? C64 kernel Jiffydos v6.01" },
	{ 0xc9bb21bc , 0x2000, "??? C64 kernel Dolphin mager" },
	{ 0xffaeb9bc , 0x2000, "??? C64 kernel Dolphin dos20" },
	{ 0x8438e77b , 0x2000, "??? C64 kernel speeddos plus" },
	{ 0x10aee0ae , 0x2000, "??? C64 kernel speeddos plus + 2.0" },
	{ 0xe801dadc , 0x2000, "??? C64 kernel 80 column" },
	{ 0xe6c763a2 , 0x2000, "??? C64 kernel cockroach turbo-rom v1" },
	{ 0x41dad9fe , 0x2000, "??? C64 kernel mikrotronic system professional dos" },
	{ 0x0010ec31 , 0x4000, "251913-01 C64 cost reduced (901225-01 + 901227-03)" },
	{ 0xb0a9c2da , 0x4000, "390852.01 C64GS a000,e000" },
	{ 0xec4272ee , 0x1000, "901225.01 C64 8x8 character set d000" },
	{ 0x2bc73556 , 0x1000, "BAD DUMP, UNUSEABLE PART! C64 901225.01" },
	{ 0xbee9b3fd , 0x1000, "325018-02 C64 swedish character set d000" },

/* commodore 128 *************************************************************************/
	{ 0x2ee6e2fa , 0x4000, "318018-02 C128 basic r0 4000" },
	{ 0xd551fce0 , 0x4000, "318019-02 C128 basic r0 8000" },
	{ 0xe857df90 , 0x8000, "318022-01 C128 basic r0 4000 (318018-02 + 318019-02)" },
	{ 0xbc07ed87 , 0x8000, "252343-03 C128 basic r? 4000 (maybe 318018-03 + 318019-03)" },
	{ 0x9f9c355b , 0x4000, "318018-04 C128 basic r1 1986 4000" },
	{ 0x6e2c91a7 , 0x4000, "318019-04 C128 basic r1 1986 8000" },
	{ 0xaf1ae1e8 , 0x8000, "318022-02 C128 basic r1 1986 4000 (318018-04 + 318019-04)" },
	{ 0x1e94bb02 , 0x4000, "318020-03 C128 Kernel r0 c000" },
	{ 0xba456b8e , 0x4000, "318020-05 C128 Kernel r1 1986 c000" },
	{ 0xa51e2168 , 0x4000, "315078-01 C128 Kernel german c000" },
	{ 0xb275bb2e , 0x4000, "315078-02 C128 Kernel german c000" },
	{ 0x2df282b8 , 0x4000, "? C128 Kernel french (0x3e086a24 z80bios 0xca5e1179)" },
	{ 0xd3ecea84 , 0x4000, "? C128 Kernel finish1 (0x71002a97 z80bios 0x167b8364)" },
	{ 0x9526fac4 , 0x4000, "? C128 Kernel finish2 (0xb7ff5efe z80bios 0x5ce42fc8)" },
	{ 0x74d6b084 , 0x4000, "? C128 Kernel italian (0x8df58148 z80bios 0x7b0d2140)" },
	{ 0x66673e8b , 0x4000, "318079-01? C128 Kernal italian newer (0x155e9ed6 z80bios 0x922c6c49)" },
	{ 0xa5406848 , 0x4000, "? C128 Kernel norwegian (0x84c55911 z80bios 0x3ba48012)" },
	{ 0xeedc120a , 0x8000, "318023-02 C128 c64+kernel (252913-01+318020-05=" },
	{ 0xcc6bdb69 , 0x8000, "252343-04 C128 c64+kernel (252913-01+0x98f2a2ed maybe 318020-04)" },
	{ 0xeb6e2c8f , 0x8000, "318077-01 C128 c64+kernel german(251913-01+0xbff7550b)" },
	{ 0xcb4e1719 , 0x8000, "318034-01 Ker.Sw/Fi C128 c64+kernel swedish (901226.01+ 0xf10c2c25 +0x1cf7f729)" },
	{ 0x0a5928b0 , 0x9000, "UNUSEABLE PART! C128 318022-01+kernal ? c000" },
	{ 0xd65ebc56 , 0x2000, "UNUSEABLE PART! C128 Kernel ? e000" },
	{ 0x3e086a24 , 0x1000, "UNUSEABLE PART! C128 Kernel french c000" },
	{ 0xca5e1179 , 0x2000, "UNUSEABLE PART! C128 Kernel french e000" },
	{ 0x71002a97 , 0x1000, "UNUSEABLE PART! C128 Kernel finish1 c000" },
	{ 0x167b8364 , 0x2000, "UNUSEABLE PART! C128 Kernel finish1 e000" },
	{ 0xb7ff5efe , 0x1000, "UNUSEABLE PART! C128 Kernel finish2 c000" },
	{ 0x5ce42fc8 , 0x2000, "UNUSEABLE PART! C128 Kernel finish2 e000" },
	{ 0x8df58148 , 0x1000, "UNUSEABLE PART! C128 Kernel italian c000" },
	{ 0x7b0d2140 , 0x2000, "UNUSEABLE PART! C128 Kernel italian e000" },
	{ 0x155e9ed6 , 0x1000, "UNUSEABLE PART! C128 Kernal italian c000 newer" },
	{ 0x922c6c49 , 0x2000, "UNUSEABLE PART! C128 Kernal italian e000 newer" },
	{ 0x84c55911 , 0x1000, "UNUSEABLE PART! C128 Kernel norwegian c000" },
	{ 0x3ba48012 , 0x2000, "UNUSEABLE PART! C128 Kernel norwegian e000" },
	{ 0xc38d83c6 , 0x1000, "UNUSEABLE PART! C128 Z80 Bios d000" },
	{ 0xae33c5a3 , 0x1000, "UNUSEABLE PART! C128 character set (2nd half 390059-01)" },
	{ 0x6aaaafe6 , 0x2000, "390059-01 C128 8x8 character set c64, c128" },
	{ 0xfe5a2db1 , 0x2000, "315079-01 C128 8x8 character set c64, c128 german" },
	{ 0x7a70d9b8 , 0x2000, "325181-01 C128 8x8 character set c64, c128 swedish" },
	{ 0xbad36b88 , 0x2000, "325167-01 I/F/B C128 8x8 characters sets" }, //italian and french verified to be the same

/* commodore ieee bus devices ******************************************************/
	{ 0x0ab338dc, 0x400, "901466-04 CBM2040 dos 2 6530" },
	{ 0x25b5eed5, 0x1000, "901468-06 CBM2040 dos 1 e000" },
	{ 0x9b09ae83, 0x1000, "901468-07 CBM2040 dos 1 f000" },
	{ 0xb7157458, 0x1000, "901468-11 CBM2040 dos 2 d000" },
	{ 0x02c44ff9, 0x1000, "901468-12 CBM2040 dos 2 e000" },
	{ 0xcbd785b3, 0x1000, "901468-13 CBM2040 dos 2 f000" },
	{ 0xbc4d4872, 0x1000, "901468-14 CBM2040 dos 2r d000" },
	{ 0xb6970533, 0x1000, "901468-15 CBM2040 dos 2r e000" },
	{ 0x1f5eefb7, 0x1000, "901468-16 CBM2040 dos 2r f000" },
	{ 0xd04c1fbb , 0x2000, "MERGED! 901468-06+901468-07" },
	{ 0xf4967a7f , 0x3000, "MERGED! 901468-11+901468-12+901468-13" },
	{ 0x40e0ebaa , 0x3000, "MERGED! 901468-14+901468-15+901468-16" },

	{ 0xee4b893b, 0x2000, "901484-03 CBM2031 C000" },
	{ 0x6a629054, 0x2000, "901484-05 CBM2031 E000" },
	{ 0x21b80fdf , 0x4000, "MERGED! 901484-03+901484-05" },

	{ 0xf0aa31bd,  0x400,  "251257-02A CBM1001 FDC" },
	{ 0x0073b8b2, 0x2000, "901887-01 CBM8050 DOS 2.7 c000" },
	{ 0xde9b6132, 0x2000, "901888-01 CBM8050 DOS 2.7 e000" },
	{ 0xa23337eb, 0x800, "901467-01 CBM8050 ?" },
	{ 0x09a609b9, 0x2000, "901482-03 CBM8050 dos 2.5 c000" },
	{ 0x1bcf9df9, 0x2000, "901482-04 CBM8050 dos 2.5 e000" },
	{ 0x3cbd2756, 0x2000, "901482-06 CBM8050 dos 2.5r c000" },
	{ 0xc7532d90, 0x2000, "901482-07 CBM8050 dos 2.5r e000" },
	{ 0x9e83fa70, 0x400, "901483-03 CBM8050 dos2.5 micropolis" },
	{ 0x2915327a, 0x400, "901869-01 CBM8050 dos2.7 mpi" },
	{ 0xbab998c9, 0x400, "901885-04 CBM8050 dos2.7 micropolis" },
	{ 0x87e6a94e , 0x4000, "MERGED! 901887-01+901888-01" },

	{ 0xcb07b2db, 0x800, "BADDUMP! 300541-001 CBM8280" },
	{ 0x3c6eee1e, 0x2000, "300542-001 CBM8280 c000" },
	{ 0xf58e665e, 0x2000, "300543-001 CBM8280 e000" },

	{ 0x99e096f7, 0x800, "300515-001 CBM9090 4c" },
	{ 0x566df630, 0x2000, "BADDUMP! 300517-001? CBM9090 7d" },
	{ 0x49adf4fb, 0x800, "300515-002 CBM9060 4c" },
	{ 0x2d758a14, 0x2000, "300516-002 CBM9060 7c" },
	{ 0xf0382bc3, 0x2000, "300517-002 CBM9060 7d" },

	{ 0xc6bb0977 , 0x2000, "? CBM4023 printer 4023 /P 360-02 (1526 hardware?)" },
	{ 0xb6d8519c , 0x1000, "901472-06 CBM3022 printer" },
	{ 0xe5c4a58c , 0x2000, "325320-02 CBM8023P printer" },
	{ 0x9d662c74 , 0x2000, "? CBM8028 printer german cpu" },
	{ 0x209e70a1 , 0x800, "? CBM8028 printer german car" },
	{ 0x05d30d5f , 0x800, "? CBM8028 printer german dsy" },

/* commodore serial bus devices ************************************************/
	{ 0x29ae9752 , 0x2000, "325302-01 CBM1540 c000" },
	{ 0x10b39158 , 0x2000, "325303-01 CBM1540 e000" },
	{ 0x9a48d3f0 , 0x2000, "901229-01 CBM1541 e000" },
	{ 0xb29bab75 , 0x2000, "901229-02 CBM1541 e000" },
	{ 0x9126e74a , 0x2000, "901229-03 CBM1541 e000" },
	{ 0x361c9f37 , 0x2000, "901229-05 CBM1541 e000" },
	{ 0x899fa3c5 , 0x4000, "251968-03 CBM1541II c000" },
	{ 0x1b3ca08d , 0x4000, "251968-01 CBM1541C c000" },
	{ 0x2d862d20 , 0x4000, "251968-02 CBM1541C c000" },
	{ 0x5b84bcef , 0x2000, "? CBM1541 c000 (with 0x2d8c1fde gives CBM1541II rom)" },
	{ 0x2d8c1fde , 0x2000, "? CBM1541 e000 (with 0x5b84bcef gives CBM1541II rom" },
	{ 0x57224cde , 0x4000, "MERGED! (0x29ae9752 + 0x361c9f37)" },
	{ 0xd3a5789c , 0x4000, "MERGED! (0x29ae9752 + 0xb29bab75)" },
	{ 0xdd409902 , 0x4000, "? CBM1541 jiffydos upgrade (together with c64 v6.01?)" },
	{ 0x71708062 , 0x4000, "? CBM1541 64er upgrade (together with 64er system v3?)" },
	{ 0xf9db1eac , 0x4000, "? CBM1541 Speeddos upgrade (together with speeddos plus +?)" },
	{ 0xbd8e42b2 , 0x6000, "? Dolphin (CBM1541 compatible) a000" },
	{ 0x5a0c7937 , 0x8000, "315090.01 CBM1570 bios 8000" },
	{ 0x3889b8b8 , 0x8000, "310654.03 CBM1571 bios 8000" },
	{ 0x5755bae3 , 0x8000, "310654-05 CBM1571 8000" },
	{ 0xf24efcc4 , 0x8000, "318047-01 CBM1571 8000" },
	{ 0x113af078 , 0x8000, "318045-01 CBM1581 bios 8000" },
	{ 0xa9011b84 , 0x8000, "318045-02 CBM1581 bios 8000" },
	{ 0xecc223cd , 0x8000, "? CBM1581 beta 8000" },
	{ 0xe08801d7 , 0x8000, "? CBM1581 modified 8000" },

	{ 0x3ef63c59 , 0x2000, "? CBM1526 printer rev05?" },
	{ 0x21051f69 , 0x2000, "? CBM1526 printer rev07b scandinavian?" },
	{ 0x38f85b4a , 0x2000, "? CBM1526 printer rev07c?" },
	{ 0xf8a9f45c , 0x10000, "? CBM1230 printer pdl2 german" },

	{ 0xecc43f0f , 0x1000, "Wiesemann Interface (CBM Serial bus to Centronics Printer)" },

/* Commodore AMIGA *************************************************************/
	/* info on AMIGA Kickstart dumps taken from dats by TOSEC team */
	/* not verified, probably needs many corrections */
	{ 0x428a9a4b , 0x40000 , "Amiga Kickstart 0.7 (27.3) (NTSC) (A1000) (Commodore) (1985)" },
	{ 0x299790ff , 0x40000 , "Amiga Kickstart 1.0 (NTSC) (A1000) (Commodore) (1985)" },
	{ 0xd060572a , 0x40000 , "Amiga Kickstart 1.1 (31.34) (NTSC) (A1000) (Commodore) (1985)" },
	{ 0xec86dae2 , 0x40000 , "Amiga Kickstart 1.1 (31.34) (PAL) (A1000) (Commodore) (1986)" },
	{ 0x9ed783d0 , 0x40000 , "Amiga Kickstart 1.2 (33.166) (A1000) (Commodore) (1986)" },
	{ 0xa6ce1636 , 0x40000 , "Amiga Kickstart 1.2 (33.180) (A500-A2000) (Commodore) (1986)" },
	{ 0xc4f0f55f , 0x40000 , "Amiga Kickstart 1.3 (34.5) (A500-A2500-A3000-CDTV) (Commodore) (1987)" },
	{ 0xa3ba6116 , 0x40000 , "Amiga Kickstart 1.4 (36.015) (A500-A2000) Alpha Release 15 (Commodore) (1989)" },
	{ 0x39779507 , 0x80000 , "Amiga Kickstart 1.4 (36.02.20) (A3000) Alpha Release 18 (Commodore) (1989)" },
	{ 0xb333d3c6 , 0x80000 , "Amiga Kickstart 2.0 (36.143) (A3000) (Commodore) (1990)" },
	{ 0x234a7233 , 0x80000 , "Amiga Kickstart 2.0 (37.175) (A3000) (Commodore) (1991)" },
	{ 0x8da9bd72 , 0x80000 , "Amiga Kickstart 2.0 (37.175.20) Development (Commodore) (1991)" },
	{ 0xca2685fd , 0x80000 , "Amiga Kickstart 2.0 (37.210) (A2500) (Commodore) (1991)" },
	{ 0x4c0c1603 , 0x80000 , "Amiga Kickstart 2.0 (37.210) (A3000) (Commodore) (1991)" },
	{ 0x83028fb5 , 0x80000 , "Amiga Kickstart 2.0 (37.299) (A600) (Commodore) (1991)" },
	{ 0x64466c2a , 0x80000 , "Amiga Kickstart 2.0 (37.300) (A600) (Commodore) (1991)" },
	{ 0x43b0df7b , 0x80000 , "Amiga Kickstart 2.0 (37.350) (A600) (Commodore) (1992)" },
	{ 0xc3bdb240 , 0x80000 , "Amiga Kickstart 2.04 (37.175) (A500+) (Commodore) (1991)" },
	{ 0x6c9b07d2 , 0x80000 , "Amiga Kickstart 3.0 (39.106) (A1200) (Commodore) (1992)" },
	{ 0x9e6ac152 , 0x80000 , "Amiga Kickstart 3.0 (39.106) (A4000) (Commodore) (1992)" },
	{ 0xbcec8e55 , 0x80000 , "Amiga Kickstart 3.1 (40.055) (A3000) (Commodore) (1993)" },
	{ 0x1e62d4a5 , 0x80000 , "Amiga Kickstart 3.1 (40.060) (CD32) (Commodore) (1993)" },
	{ 0xfc24ae0d , 0x80000 , "Amiga Kickstart 3.1 (40.063) (A600) (Commodore) (1993)" },
	{ 0xb506177b , 0x80000 , "Amiga Kickstart 3.1 (40.063) (A600) (Commodore) (1993) (alt)" },
	{ 0x1483a091 , 0x80000 , "Amiga Kickstart 3.1 (40.068) (A1200) (Commodore) (1993)" },
	{ 0x4d1575a6 , 0x80000 , "Amiga Kickstart 3.1 (40.068) (A1200) (Commodore) (1993) (alt)" },
	{ 0xd6bae334 , 0x80000 , "Amiga Kickstart 3.1 (40.068) (A4000) (Commodore) (1993)" },
	{ 0x88136ca9 , 0x80000 , "Amiga Kickstart 3.1 (40.068) (A600) (Commodore) (1993)" },
	{ 0x1d9aa278 , 0x80000 , "Amiga Kickstart 3.1 (40.069) (A1200) (Commodore) (1993)" },
	{ 0x917100a0 , 0x80000 , "Amiga Kickstart 3.1 (40.070) (A4000) (Commodore) (1993) (alt)" },
	{ 0x3f0056d3 , 0x80000 , "Amiga Kickstart 3.1 (40.070) (A4000T) (Commodore) (1993)" },
	{ 0xe75a53f4 , 0x80000 , "Amiga Kickstart 3.5 (40.071) (OS3.5) (Commodore) (1996)" },

	{ 0xda979111 , 0x40000 , "MODIFIED Amiga Kickstart 1.3 (34.5) (A500-A2500-A3000-CDTV) (Commodore) (1987)" },
	{ 0xe0f37258 , 0x40000 , "MODIFIED Amiga Kickstart 1.3 (34.5) (A500-A2500-A3000-CDTV) (Commodore-Cloanto) (1987)" },
	{ 0x74680d37 , 0x40000 , "MODIFIED Amiga Kickstart 1.3 (34.5) (A500-A2500-A3000-CDTV) (Guardian 1.2) (Commodore-Transactor) (1988)" },
	{ 0x43b6dd22 , 0x80000 , "MODIFIED Amiga Kickstart 3.1 (40.068) (A4000) (Commodore-Cloanto) (1993)" },
	{ 0xbabd04c5 , 0x80000 , "MODIFIED Amiga Kickstart 3.1 (40.068) (A4000) (ShapeShifter) (Commodore) (1993)" },

	{ 0xb95e1d73 , 0x40000 , "BAD DUMP Amiga Kickstart 1.2 (33.166) (A1000) (Commodore) (1986)" },
	{ 0x42baa124 , 0x40000 , "BAD DUMP Amiga Kickstart 1.3 (34.1001) (CDTV) (Commodore) (1991)" },
	{ 0x09a9fab2 , 0x40000 , "BAD DUMP Amiga Kickstart 1.3 (34.5) (A500-A2500-A3000-CDTV) (Commodore) (1987) (early build)" },
	{ 0x63f473ab , 0x80000 , "BAD DUMP Amiga Kickstart 3.1 (40.070) (A4000) (Commodore) (1993) (alt)" },

	{ 0x1cb4eb2f , 0x6F980 , "BAD/OVER DUMP Amiga Kickstart 1.2 (33.180) (A500-A2000) (Commodore) (1986)" },

	{ 0xde142fa9 , 0x80000 , "OVER DUMP Amiga Kickstart 1.1 (31.34) (NTSC) (A1000) (Commodore) (1985)" },
	{ 0xdcc0b32f , 0x80000 , "OVER DUMP Amiga Kickstart 1.1 (31.34) (PAL) (A1000) (Commodore-Cloanto) (1986)" },
	{ 0xb5f86782 , 0x80000 , "OVER DUMP Amiga Kickstart 1.2 (33.180) (A500-A2000) (Commodore) (1986)" },
	{ 0xf6290043 , 0x80000 , "OVER DUMP Amiga Kickstart 1.3 (34.5) (A500-A2500-A3000-CDTV) (Commodore) (1987)" },
	{ 0x3cac66c7 , 0x80a00 , "OVER DUMP Amiga Kickstart 3.1 (40.055) (A3000) (Commodore) (1993)" },

	{ 0xad01f2fe , 0x80000 , "OVER DUMP, MODIFIED Amiga Kickstart 1.3 (34.5) (A500-A2500-A3000-CDTV) (Commodore) (1987) { 0xh]" },
	{ 0xfbb4799d , 0x80000 , "OVER DUMP, MODIFIED Amiga Kickstart 1.3 (34.5) (A500-A2500-A3000-CDTV) (Commodore-Cloanto) (1987)" },

/* ibm pc and compatibles ******************************************************/
	{ 0x80d3cf5d , 0x2000, "IBM PC basic c1.10 f6000" },
	{ 0x673a4acc , 0x2000, "IBM PC basic c1.10 f8000" },
	{ 0xaac3fc37 , 0x2000, "IBM PC basic c1.10 fa000" },
	{ 0x3062b3fc , 0x2000, "IBM PC basic c1.10 fc000" },
	{ 0xebacb791 , 0x8000, "MERGED! (0x80d3cf5d + 0x673a4acc + 0xaac3fc37 + 0x5c3f0256)" },
	{ 0x5c3f0256 , 0x2000, "IBM PC bios fe000 5000-026 08/16/82" },
	{ 0xe88792b3 , 0x2000, "IBM PC bios fe000 1501-476 10/27/82" },
	{ 0x031aafad , 0x2000, "PC bios fe000" },
	{ 0xd435a405 , 0x2000, "Bondwell PC fe000" },
	{ 0x1775a11d , 0x8000, "50145 Europc bios f8000 V2.07" },
	{ 0x1305dcf5 , 0x2000, "50146 Europc character sets" },
	{ 0xecca89c8 , 0x8000, "50145? Europc II bios V3.01" },
	{ 0x0c19c1a8 , 0x8000, "INCOMPLETE IBM PC Junior basic c1.2 f6000 (f0000-f5fff missing)" },
	{ 0x98463f95 , 0x2000, "INCOMPLETE IBM PC Junior bios fe000 (f0000-f5fff missing)" },
	{ 0xc3bcb418 , 0x8002, "OVERDUMP IBM PC Junior basic cartridge (additional 2 bytes)" },
	{ 0x850276fc , 0x4000, "Tandy 1000/a/hd 1.01.00" },
	{ 0xb6760881 , 0x10000, "OVERDUMP Tandy 1000 1.01.00" },
	{ 0x7cde748a , 0x4000, "Tandy 1000ex/sx 1.02.00" },
	{ 0x0e016ecf , 0x10000, "OVERDUMP Tandy 1000 1.02.00 (last 16kbyte)" },
	{ 0x1ae69276 , 0x10000, "OVERDUMP Tandy 1000 1.02.00 (last 16kbyte)(different fillbyte)" },
	{ 0x9b34765c , 0x8000, "Tandy 1000tx 1.03.00" }, // most likely 2 16kbyte chips
	{ 0xf607533b , 0x10000, "OVERDUMP Tandy 1000 1.03.00 (last 32kbyte)" },
	{ 0x6f3acd80 , 0x20000, "Tandy 1000 HX bios (2.00.00)" },
	// tandy 1000rl 2.00.01
	{ 0xe5e534e6 , 0x1000, "RECONSTRUCTED Tandy 1000 HX characterset" },
	{ 0x61dbf242 , 0x10000, "UNUSEABLE PART Tandy 1000 HX bios (1st half of 0x6f3acd80)" },
	{ 0xd37a1d5f , 0x10000, "UNUSEABLE PART Tandy 1000 HX bios (2nd half of 0x6f3acd80)" },
	{ 0x83727c42 , 0x8000, "IBM XT bios even f0000" },
	{ 0x2a629953 , 0x8000, "IBM XT bios odd f0000" },
	{ 0x71b84616 , 0x2000, "Amstrad PC20 bios even fc000 (v2)" },
	{ 0x41302eb8 , 0x2000, "Amstrad PC20 bios odd fc000 (v2)" },
	{ 0x668fcc94 , 0x2000, "40044 Amstrad PC1512 bios even fc000 (v1)" },
	{ 0xf72f1582 , 0x2000, "40043 Amstrad PC1512 bios odd fc000 (v1)" },
	{ 0xd2d1f1ae,  0x8000, "40100 Amstrad PC1640 ega bios c0000" },
	{ 0xe40a1513 , 0x2000, "40043 Amstrad PC1640 bios odd fc000 (v3)" },
	{ 0xf1c074f3 , 0x2000, "40044 Amstrad PC1640 bios even fc000 (v3)" },
	{ 0x664f5360 , 0x80000, "Tandy 1000 RLX (2.00.00)" },
	{ 0x11cb1983, 0x10000, "UNUSEABLE PART TANDY 1000 RLX (last 64kbyte)" },
	{ 0xf518ab17 , 0x10000, "INCOMPLETE Tandy1td? (DAC) (2.00.00)" },
	{ 0xe288f12c , 0x10000, "INCOMPLETE Tandy 1000TL/2? (2.00.00)" },
	{ 0x4995be7a , 0x8000, "IBM AT bios even f0000" },
	{ 0xc32713e4 , 0x8000, "IBM AT bios odd f0000" },
	{ 0x679296a7 , 0x8000, "AT ami bios even f0000" },
	{ 0x65ae1f97 , 0x8000, "AT ami bios odd f0000" },
	{ 0x4c36e61d , 0x8000, "NEAT ami bios even f0000" },
	{ 0x4e90f294 , 0x8000, "NEAT ami bios odd f0000" },
	{ 0x1a81237c , 0x8000, "INCOMPLETE Tandy 2500XL" },
	{ 0x819377af , 0x20000, "INCOMPLETE Tandy 2500XL" },
	{ 0x3df9732a , 0x10000, "AT386 bios f0000" },
	{ 0x31214616 , 0x10000, "AT486 bios f0000" },
	{ 0x8e9e2bd4 , 0x2000, "PC harddisk controller bios c8000" },
	{ 0xa96317da , 0x2000, "PC harddisk controller bios c8000" },
	{ 0x318c5f43 , 0x8000, "PC oak vga bios c0000" },
	{ 0xa903540d , 0x8000, "PC et4000 vga bios oem c0000" },
	{ 0xf01e4be0 , 0x8000, "PC et4000 vga vios c0000" },
	{ 0xaca81498 , 0x2000, "PC aga character sets" },
	{ 0x7e8c9d76 , 0x1000, "AUTHENTIC? PC hercules character set" },
	{ 0xac1686f3 , 0x1000, "NOT AUTHENTIC PC hercules character set" },
	{ 0xa362ffe6 , 0x800, "AUTHENTIC? PC cga character set" },
	{ 0x42009069 , 0x1000, "AUTHENTIC? PC cga character set" },

/* applied computer techniques (act)/ apricot */
	{ 0x30b3f803 , 0x1000, "Sirius1 rom fe000" },
	{ 0x2bf3c0e4 , 0x1000, "Sirius1 rom ff000" },
	{ 0x0da581b7 , 0x2000, "Sirius1 rom newer" },
	{ 0x9bf49f7d , 0x400, "Sirius1 disk controller" },
	{ 0xadc601bd , 0x800, "Sirius1 gcr en-/decoder? rom" },

	{ 0xbfd46ada, 0x4000, "Apricot F bios 3.1.1 even" },
	{ 0x67ad5b3a, 0x4000, "Apricot F Bios 3.1.1 odd" },
	{ 0xfecfad9b, 0x8000, "COMBINED Apricot F bios 3.1.1" },

/* Sinclair ZX-80 Computer and Clones ******************************************/
	{ 0x4c7fc597 , 0x1000 , "Sinclair ZX-80" },
	{ 0x6c123536 , 0x1000 , "ZX Aszmic" },


/* Sinclair ZX-81 Computer and Clones ******************************************/
	{ 0x4b1dd6eb , 0x2000 , "Sinclair ZX-81" },
	{ 0x71616238 , 0x2000 , "Sinclair ZX-81 Tree-Forth by Tree Systems" },
	{ 0x257d5a32 , 0x2000 , "Sinclair ZX-81 Forth by David Husband" },
	{ 0x4b1dd6eb , 0x2000 , "Timex TS-1000" },
	{ 0xa350f2b1 , 0x2000 , "Your Computer PC-8300" },
	{ 0x6bd0408c , 0x0100 , "Your Computer PC-8300 (font)" },
	{ 0x8a49b2c3 , 0x2000 , "Creon Enterprises Power 3000" },
	{ 0x1c42fe46 , 0x0100 , "Creon Enterprises Power 3000 (font)" },


/* Sinclair ZX Spectrum Computers and Clones ***********************************/

/* original roms */
	{ 0xddee531f , 0x4000 , "ZX Spectrum 48K" },
	{ 0xf051746e , 0x4000 , "ZX Spectrum 48K (spanish)" },

	{ 0xe76799d2 , 0x4000 , "ZX Spectrum 128K (0000h)" },
	{ 0xb96a36be , 0x4000 , "ZX Spectrum 128K (4000h)" },
	{ 0x453d86b2 , 0x4000 , "ZX Spectrum 128K (spanish) (0000h)" },
	{ 0x6010e796 , 0x4000 , "ZX Spectrum 128K (spanish) (4000h)" },
	{ 0x5d2e8c66 , 0x4000 , "ZX Spectrum 128K Plus 2 (0000h)" },
	{ 0x98b1320b , 0x4000 , "ZX Spectrum 128K Plus 2 (4000h)" },
	{ 0xc684c535 , 0x4000 , "ZX Spectrum 128K Plus 2 (0000h) (french)" },
	{ 0xf5e509c5 , 0x4000 , "ZX Spectrum 128K Plus 2 (4000h) (french)" },
	{ 0xe807d06e , 0x4000 , "ZX Spectrum 128K Plus 2 (0000h) (spanish)" },
	{ 0x41981d4b , 0x4000 , "ZX Spectrum 128K Plus 2 (4000h) (spanish)" },
	{ 0x30c9f490 , 0x4000 , "ZX Spectrum 128K Plus 2A v4.1 (0000h)" },
	{ 0xa7916b3f , 0x4000 , "ZX Spectrum 128K Plus 2A v4.1 (4000h)" },
	{ 0xc9a0b748 , 0x4000 , "ZX Spectrum 128K Plus 2A v4.1 (8000h)" },
	{ 0xb88fd6e3 , 0x4000 , "ZX Spectrum 128K Plus 2A v4.1 (c000h)" },
	{ 0x17373da2 , 0x4000 , "ZX Spectrum 128K Plus 3 v4.0 (0000h)" },
	{ 0xf1d1d99e , 0x4000 , "ZX Spectrum 128K Plus 3 v4.0 (4000h)" },
	{ 0x3dbf351d , 0x4000 , "ZX Spectrum 128K Plus 3 v4.0 (8000h)" },
	{ 0x04448eaa , 0x4000 , "ZX Spectrum 128K Plus 3 v4.0 (c000h)" },
	{ 0x1f86147a , 0x4000 , "ZX Spectrum 128K Plus 3 v4.0 (0000h) (spanish)" },
	{ 0xa8ac4966 , 0x4000 , "ZX Spectrum 128K Plus 3 v4.0 (4000h) (spanish)" },
	{ 0xf6bb0296 , 0x4000 , "ZX Spectrum 128K Plus 3 v4.0 (8000h) (spanish)" },
	{ 0xf6d25389 , 0x4000 , "ZX Spectrum 128K Plus 3 v4.0 (c000h) (spanish)" },
	{ 0x2cbe8995 , 0x8000 , "MERGED ZX Spectrum 128K" },
	{ 0x0437b160 , 0x8000 , "MERGED ZX Spectrum 128K (spanish)" },
	{ 0xe7a517dc , 0x8000 , "MERGED ZX Spectrum 128K Plus 2" },
	{ 0x8f769de7 , 0x8000 , "MERGED ZX Spectrum 128K Plus 2 (french)" },
	{ 0x5660f4b4 , 0x8000 , "MERGED ZX Spectrum 128K Plus 2 (spanish)" },
	{ 0x80808d82 , 0x8000 , "MERGED ZX Spectrum 128K Plus 2A v4.1 (0000h+4000h)" },
	{ 0x61f2b50c , 0x8000 , "MERGED ZX Spectrum 128K Plus 2A v4.1 (8000h+c000h)" },
	{ 0xbe0d9ec4 , 0x10000, "MERGED ZX Spectrum 128K Plus 2A v4.1" },
	{ 0x96e3c17a , 0x10000, "MERGED ZX Spectrum 128K Plus 3 v4.0" },
	{ 0x0ade13f8 , 0x10000, "MERGED ZX Spectrum 128K Plus 3 v4.0 (spanish)" },

/* hacks and modified roms */ 
	{ 0x1511cddb , 0x4000 , "ZX Spectrum 48K by Busysoft v1.18 (13.03.1994)" },
	{ 0x07017c6d , 0x4000 , "ZX Spectrum 48K by Busysoft v1.40 (22.04.1997)" },
	{ 0xb8db4c06 , 0x4000 , "ZX Spectrum 48K by Busysoft v3.08 for MB-02 interface" },
	{ 0xabf18c45 , 0x4000 , "ZX Spectrum 48K by De Groot" },
	{ 0x56189781 , 0x4000 , "ZX Spectrum 48K Turbo by (c)Rak" },
	{ 0x3f5c87b1 , 0x4000 , "ZX Spectrum 48K by Pera Putnik for FDD" },
	{ 0xbd48db54 , 0x4000 , "ZX Spectrum 48K by Pera Putnik for IDE HDD" },
	{ 0x7e0f47cb , 0x4000 , "ZX Spectrum 48K Plus 4 by Andrew Owen" },
	{ 0xd1be99ee , 0x4000 , "ZX Spectrum 48K IMC by Ian Collier" },
	{ 0x5b5c92b1 , 0x4000 , "ZX Spectrum 48K by Lec v1.6 for 80kB" },
	{ 0xcd60b589 , 0x4000 , "ZX Spectrum 48K Psycho by Maly of Illuson Rules" },
	{ 0xb81c570c , 0x4000 , "ZX Spectrum 48K HDT" },
	{ 0xcdb52350 , 0x4000 , "ZX Spectrum 48K back-up ROM by REX" },
	{ 0xfd3b0413 , 0x4000 , "ZX Spectrum 48K Turbo v2.3" },
	{ 0x338b6e87 , 0x4000 , "ZX Spectrum 48K Turbo+ v4.4" },
	{ 0x20634416 , 0x4000 , "ZX Spectrum 128K Plus 2 ZXVGS v0.22 by Yarek (0000h)" },
	{ 0xf3736047 , 0x4000 , "ZX Spectrum 128K Plus 2 ZXVGS v0.22 by Yarek (4000h)" },
	{ 0x994acbd9 , 0x4000 , "ZX Spectrum 128K Plus 2c by Namco (0000h)" },
	{ 0x95eb4751 , 0x4000 , "ZX Spectrum 128K Plus 2c by Namco (4000h)" },
	{ 0xeea9ac71 , 0x4000 , "ZX Spectrum 128K Plus 2A v4.1 (0000h) modified Cristian Secara" },
	{ 0x64a2098c , 0x4000 , "ZX Spectrum 128K Plus 2A v4.1 (4000h) modified Cristian Secara" },
	{ 0xad99380a , 0x8000 , "MERGED ZX Spectrum 128K Plus 2A v4.1 (0000h+4000h) modified by Cristian Secara" },
	{ 0x07727895 , 0x8000 , "MERGED ZX Spectrum 128K Plus 2A v4.1 (8000h+c000h) modified by Cristian Secara with 4ms head stepper motor timing" },
	{ 0x72a54e75 , 0x8000 , "MERGED ZX Spectrum 128K Plus 2c by Namco" },
	{ 0x7c20e2c9 , 0x8000 , "MERGED ZX Spectrum 128K Plus 3e by Gary Lancaster v0.62 for HD EIDE (8bit) (0000h+4000h)" },
	{ 0x4a700c7e , 0x8000 , "MERGED ZX Spectrum 128K Plus 3e by Gary Lancaster v0.62 for HD EIDE (8bit) (8000h+c000h)" },
	{ 0xc60852ae , 0x8000 , "MERGED ZX Spectrum 128K Plus 3e by Gary Lancaster v0.87 for HD EIDE (8bit) (0000h+4000h)" },
	{ 0xe73a7797 , 0x8000 , "MERGED ZX Spectrum 128K Plus 3e by Gary Lancaster v0.87 for HD EIDE (8bit) (8000h+c000h)" },
	{ 0x17c28286 , 0x10000, "MERGED ZX Spectrum 128K Plus 3e by Gary Lancaster v0.62 for HD EIDE (8bit)" },
	{ 0xe585879d , 0x10000, "MERGED ZX Spectrum 128K Plus 3e by Gary Lancaster v0.87 for HD EIDE (8bit)" },

/* homebrew roms replacemts ****************************************************/
	{ 0xea8c760b , 0x4000 , "Mr Gluk Reset Service v5.1 128K (Edit)" },
	{ 0xfe44b86a , 0x4000 , "Mr Gluk Reset Service v5.2i 128K (Edit)" },
	{ 0x479515ef , 0x4000 , "Mr Gluk Reset Service v5.3 128K (Edit)" },

	{ 0x0f186d59 , 0x8000 , "MERGED Real Commander v1.96 128K (0000h+4000h)" },

	{ 0x801a9522 , 0x8000 , "MERGED Quick Commander v2.6 128K (0000h+4000h)" },
	{ 0xe0286f40 , 0x8000 , "MERGED Quick Commander v2.61 128K (0000h+4000h)" },
	{ 0x8fa43b6a , 0x8000 , "MERGED Quick Commander v2.6fix 128K (0000h+4000h)" },

	{ 0xad2ebd9b , 0x4000 , "NEOS v1.0 128K 32c" },
	{ 0xa3bcfaab , 0x4000 , "NEOS v1.0 128K 64c" },
	{ 0x1657fa43 , 0x4000 , "NEOS v1.0 Pentagon 512K 64c" },
	{ 0x364ae09a , 0x4000 , "NEOS v1.0 Scorpion 256 64c" },

	{ 0x62ab3640 , 0x4000 , "ISO-ROM 48K v2.2" },
	{ 0x0dbdc78b , 0x4000 , "ISO-ROM 128K (Ramramis 128K) (8000h)" },
	{ 0x9a06aaaf , 0x4000 , "ISO-ROM 128K (Ramramis 48K) (c000h)" },
	{ 0xd43fce83 , 0x8000 , "MERGED ISO-ROM 128K (1993)" },
	{ 0x1f24cbed , 0x8000 , "MERGED ISO-ROM 128K (1994)" },
	{ 0xa5b614b9 , 0x8000 , "MERGED ISO-ROM 128K (1994) (alt 1)" },
	{ 0x2ffdef36 , 0x8000 , "MERGED ISO-ROM 128K (1994) (alt 2)" },

/* clones */
	{ 0x8ff7a4d1 , 0x4000 , "INVES Spectrum 48K+ (spanish)" },
	{ 0x1a401bbc , 0x4000 , "Halley Computaction SP v4.1" },

	{ 0x3e785f6f , 0x4000 , "Micro Digital TK-90x Color Computer" },
	{ 0x17368e07 , 0x4000 , "Micro Digital TK-95 Color Computer" },

	{ 0x6ab16f36 , 0x2000 , "Elwro 800-3 Junior basic (0000h)" },
	{ 0xa743eb80 , 0x2000 , "Elwro 800-3 Junior basic (2000h)" },
	{ 0xde5fa37d , 0x2000 , "Elwro 800-3 Junior boot" },

	{ 0xf1b5fa67 , 0x4000 , "Timex TC-2048" },

	{ 0xbf44ec3f , 0x4000 , "Timex TS-2068 (main)" },
	{ 0xae16233a , 0x2000 , "Timex TS-2068 (shadow)" },

	{ 0x5ddc0ca2 , 0x4000 , "Unipolbrit UK-2086 (main)" },
	{ 0xae16233a , 0x2000 , "Unipolbrit UK-2086 (shadow)" },

	{ 0x2ee3a992 , 0x4000 , "Didaktik Gama" },
	{ 0x5e3f1f66 , 0x4000 , "Didaktik Gama Polak" },
	{ 0x76f2db1e , 0x4000 , "Didaktik Skalica" },
	{ 0x16bca748 , 0x8000 , "MERGED Didaktik M 128K" },
	{ 0x6079a929 , 0x4000 , "Didaktik Tape Emulator for D40" },
                                              
	{ 0x124ad9e0 , 0x4000 , "Pentagon 128K (0000h)" },
	{ 0x08ad241c , 0x4000 , "Pentagon 128K 1993 (0000h)" },
	{ 0xa41575ba , 0x4000 , "Pentagon 128K 1990 with monitor (4000h)" },
	{ 0x04e910f5 , 0x4000 , "Pentagon 128K 1991 by (c)RaK with Monitor (0000h)" },
	{ 0xceb4005d , 0x4000 , "Pentagon 128K 1991 by (c)RaK with Monitor (4000h)" },
	{ 0x09c9e7e1 , 0x4000 , "Pentagon 128K 1991 SOS89R (4000h)" },
	{ 0x63041c61 , 0x4000 , "Pentagon 128K ZXVGS v0.22 by Yarek (0000h)" },
	{ 0xf3736047 , 0x4000 , "Pentagon 128K ZXVGS v0.22 by Yarek (4000h)" },
	{ 0xaa1ce4bd , 0x8000 , "MERGED Pentagon 128K" },
	{ 0x34d04bae , 0x8000 , "MERGED Pentagon 128K (spanish)" },
	{ 0x4e142f83 , 0x8000 , "MERGED Pentagon 128K 1991 by (c)RaK with Monitor" },

	{ 0x0eb40a09 , 0x4000 , "ZS Scorpion 256K with Service Monitor v2.92 (0000h)" },
	{ 0x9d513013 , 0x4000 , "ZS Scorpion 256K with Service Monitor v2.92 (4000h)" },
	{ 0xfd0d3ce1 , 0x4000 , "ZS Scorpion 256K with Service Monitor v2.92 (8000h)" },
	{ 0x1fe1d003 , 0x4000 , "ZS Scorpion 256K with Service Monitor v2.92 (c000h)" },
	{ 0xfef73c28 , 0x10000, "MERGED ZS Scorpion 256K with Service Monitor v2.92" },
	{ 0x99f57ce1 , 0x10000, "MERGED ZS Scorpion 256K with Service Monitor v2.94" },
	{ 0x9fcf893d , 0x20000, "MERGED ZS Scorpion 256K with Service Monitor and SMUC support v4.02" },
	{ 0x19a45d83 , 0x20000, "MERGED ZS Scorpion 256K with Service Monitor and SMUC support v4.02 (supplied with z80s)" },
	{ 0x2bbe25f9 , 0x8000 , "MERGED ZS Scorpion 256K Professional Extension (00000h+04000h)" },
	{ 0xc704b419 , 0x8000 , "MERGED ZS Scorpion 256K Professional Extension (08000h+0C000h)" },
	{ 0x0ae7fa29 , 0x8000 , "MERGED ZS Scorpion 256K Professional Extension (10000h+14000h)" },
	{ 0x94f10136 , 0x8000 , "MERGED ZS Scorpion 256K Professional Extension (18000h+1C000h)" },
	{ 0x66e427bc , 0x8000 , "MERGED ZS Scorpion 256K Professional Extension (20000h+24000h)" },
	{ 0x7305005c , 0x8000 , "MERGED ZS Scorpion 256K Professional Extension (28000h+2C000h)" },
	{ 0x1c38a7d9 , 0x8000 , "MERGED ZS Scorpion 256K Professional Extension (30000h+34000h)" },
	{ 0xf5bcc64a , 0x8000 , "MERGED ZS Scorpion 256K Professional Extension (38000h+3C000h)" },
	{ 0x3c7e1a68 , 0x8000 , "MERGED ZS Scorpion 256K Professional Extension (40000h+44000h)" },
	{ 0xc704b419 , 0x8000 , "MERGED ZS Scorpion 256K Professional Extension (48000h+4C000h)" },
	{ 0xfee49fa2 , 0x8000 , "MERGED ZS Scorpion 256K Professional Extension (50000h+54000h)" },
	{ 0x6b42f7f2 , 0x8000 , "MERGED ZS Scorpion 256K Professional Extension (58000h+5C000h)" },
	{ 0xd988ed6e , 0x8000 , "MERGED ZS Scorpion 256K Professional Extension (60000h+64000h)" },
	{ 0x81e72164 , 0x8000 , "MERGED ZS Scorpion 256K Professional Extension (68000h+6C000h)" },
	{ 0x71363ff7 , 0x8000 , "MERGED ZS Scorpion 256K Professional Extension (70000h+74000h)" },
	{ 0xe980585f , 0x8000 , "MERGED ZS Scorpion 256K Professional Extension (78000h+7C000h)" },
	{ 0xb02d89de , 0x80000, "MERGED ZS Scorpion 256K Professional Extension" },

	{ 0x2b31851d , 0x4000 , "Profi 48K" },
	{ 0x314f6b57 , 0x10000, "MERGED Profi 1024K by T-REX" },
	{ 0xa932676f , 0x10000, "MERGED Profi 1024K by Micco Software v2.0" },

	{ 0x7fbf2d43 , 0x8000 , "MERGED Kay 1024 1998" },
	{ 0xab99c31e , 0x10000, "MERGED Kay 1024 2000 v0.2" },
	{ 0x67351caa , 0x10000, "MERGED Kay 1024 2000 v0.3" },

	{ 0x658c98f1 , 0x4000 , "ATM v1.06 (0000h)" },
	{ 0x8fe367f9 , 0x4000 , "ATM v1.06 (4000h)" },
	{ 0x124ad9e0 , 0x4000 , "ATM v1.06 (8000h)" }, 
	{ 0xf352f2ab , 0x4000 , "ATM v1.06 (c000h)" }, 
	{ 0x658c98f1 , 0x4000 , "ATM Turbo 2 (0000h)" },
	{ 0xbc3f6b2b , 0x4000 , "ATM Turbo 2 (4000h)" },
	{ 0x124ad9e0 , 0x4000 , "ATM Turbo 2 (8000h)" },
	{ 0x5869d8c4 , 0x4000 , "ATM Turbo 2 (c000h)" },
	{ 0x4912e249 , 0x10000, "MERGED ATM v1.03" },
	{ 0x75350b37 , 0x10000, "MERGED ATM v1.06" },   
	{ 0xd2afed84 , 0x0800 , "ATM Test ROM" },
	{ 0x3da62267 , 0x0f00 , "ATM Test ROM v3.0" },
	
	{ 0x9cb9c060 , 0x20000, "MERGED Sprinter (1999.10.05)" },
	{ 0x6a6df9d0 , 0x8000 , "MERGED Sprinter (1999.10.05) (08000h+0c000h)" },
	{ 0x3f6a3e29 , 0x4000 , "Sprinter (1999.10.05) (04000h)" },

	{ 0xc40aefbd , 0x10000, "MERGED GrandRomMax 1995" },
	{ 0xb7860784 , 0x10000, "MERGED GrandRomMax 2001 with QuickCommander 2.6 and TRDOS 5.04 (english)" },   

	{ 0x9954cf1a , 0x4000 , "Sam Coupe (part 1)" },
	{ 0xf031aed4 , 0x4000 , "Sam Coupe (part 2)" },
	{ 0xc8310db2 , 0x4000 , "Sam Coupe ZXVGS 0.16 by Yarek" },

/* external devices ************************************************************/
	{ 0x262bd888 , 0x4000 , "SamRam (part 1)" },
	{ 0x793b7eb7 , 0x4000 , "SamRam (part 2)" },
	{ 0x60efaf07 , 0x4000 , "SamRam (part 2) (alt)" },

	{ 0xe72a12ae , 0x2000 , "Interface 1 v1" },
	{ 0xbb66dd1e , 0x2000 , "Interface 1 v2" },
	{ 0x85ae5586 , 0x4000 , "Interface 1 v2 modified by Ian Collier 1985" },
	{ 0x10f51133 , 0x4000 , "MERGED Interface 1 (v2+v1)" },

	{ 0x4b31a971 , 0x2000 , "Multiface 1 (Romantic Robot)" },
	{ 0x8d8cfd39 , 0x2000 , "Multiface 128 v3.5 (87.1) (Romantic Robot)" },
	{ 0x78ec8cfd , 0x2000 , "Multiface 128 v3.6 (87.2) (Romantic Robot)" },
	{ 0x2d594640 , 0x2000 , "Multiface 3 v3.c (Romantic Robot)" },
	{ 0x3a26e84b , 0x2000 , "Multiprint v1987.5 (Romantic Robot)" },

	{ 0x3b9bbca3 , 0x4000 , "Genie 128K Disassembler v2.1" },

	{ 0x82047489 , 0x2000 , "Disciple GDOS3 v3.0" },
	{ 0x569f7e55 , 0x2000 , "Disciple +D G+DOS v1.A" },
	{ 0x1fe7f4fa , 0x2000 , "Disciple Uni-DOS" },
	{ 0x60920496 , 0x2000 , "Disciple +D Uni-DOS" },

	{ 0x619973f9 , 0x2000 , "Opus Discovery v1.2" },
	{ 0x50f0eae0 , 0x2000 , "Opus Discovery v2.2" },
	{ 0xd042b32a , 0x2000 , "Opus Discovery QuickDOS for FDD 720Kb" },

	{ 0x1ccf4add , 0x0800 , "Timex FDD-3000 Internal ROM" },
	{ 0xe9db941c , 0x1000 , "Timex FDD-3000 Interface" },
	{ 0xa0a9779c , 0x1000 , "Timex FDD-3000 Interface modified for +3" },
	{ 0x77c517f4 , 0x1000 , "Timex FDD-3000 Interface with square ULA modified for 128K" },

	{ 0xe6de2629 , 0x0800 , "MB-02 BootRom" },
 	{ 0x513accb2 , 0x4000 , "MB-02 Interface v3.08 by Busysoft" },

	{ 0x179d4600 , 0x2000 , "Rotronics Wafadrive v1.08" },

	{ 0x27547714 , 0x4000 , "D80 Didaktik Disk Interface" },

	{ 0x3e3cdd4c , 0x4000 , "Beta 128 TR-DOS v5.01" },
	{ 0x121889b0 , 0x4000 , "Beta 128 TR-DOS v5.03" },
	{ 0xb90ee684 , 0x4000 , "Beta 128 TR-DOS v5.03 ZXVGS v0.22 by Yaro" },
	{ 0x10751aba , 0x4000 , "Beta 128 TR-DOS v5.03 (supplied with r80)" },
	{ 0xc43d717f , 0x4000 , "Beta 128 TR-DOS v5.03 (supplied with x128)" },
	{ 0x561662f2 , 0x4000 , "Beta 128 TR-DOS v5.03 (supplied with speccy)" },
	{ 0x23dbc387 , 0x4000 , "Beta 128 TR-DOS v5.03 (supplied with z80)" },
	{ 0x1c5a25b1 , 0x4000 , "Beta 128 TR-DOS v5.03 (supplied with z80) (alt)" },
	{ 0x2f97fe06 , 0x4000 , "Beta 128 TR-DOS v5.03M" },
 	{ 0xba310874 , 0x4000 , "Beta 128 TR-DOS v5.04" },
 	{ 0xda170c65 , 0x4000 , "Beta 128 TR-DOS v5.04.1 & LPrint-III for Profi by Michael Markowsky" },
	{ 0x0d3f8b43 , 0x4000 , "Beta 128 TR-DOS v5.04EM by Elsy Corp" },
	{ 0xab3100d8 , 0x4000 , "Beta 128 TR-DOS v5.04F" },
	{ 0x2f2cb630 , 0x4000 , "Beta 128 TR-DOS v5.04M" },
	{ 0x522ebbd6 , 0x4000 , "Beta 128 TR-DOS v5.04S" },
	{ 0xe212d1e0 , 0x4000 , "Beta 128 TR-DOS v5.04T" },
	{ 0x8d943e6b , 0x4000 , "Beta 128 TR-DOS v5.04T (supplied with ZX Emulator)" },
	{ 0x2334b8c6 , 0x4000 , "Beta 128 TR-DOS v5.04TM" },
	{ 0xfdff3810 , 0x4000 , "Beta 128 TR-DOS v5.05" },
	{ 0x03b76c8f , 0x4000 , "Beta 128 TR-DOS v5.05 (alt)" },
	{ 0x9ba15549 , 0x4000 , "Beta 128 TR-DOS v5.05H by Rst7" },
 	{ 0xb615d6c4 , 0x4000 , "Beta 128 TR-DOS v5.12" },
	{ 0xedb74f8c , 0x4000 , "Beta 128 TR-DOS v5.12F" },
	{ 0x6b1c17f3 , 0x4000 , "Beta 128 TR-DOS v5.13F" },
	{ 0xbad0c0a0 , 0x4000 , "Beta 128 TR-DOS v5.13FM" },
	{ 0xd8882a8c , 0x4000 , "Beta 128 TR-DOS v6.04 by PoS" },
	{ 0xe73394cb , 0x4000 , "Beta 128 TR-DOS v6.04M Profi+ by PoS" },
 	{ 0x56d3c2db , 0x4000 , "Beta 128 TR-DOS v6.05E 1024K C.W. Remix for Resident" },
	{ 0x6b44fdd7 , 0x4000 , "Beta 128 TR-DOS v6.06H Profi+ by PCCC" },
	{ 0x5c998d53 , 0x4000 , "Beta 128 TR-DOS v6.08 Profi+ by PCCC" },
	{ 0x91028924 , 0x4000 , "Beta 128 TR-DOS v6.09 Profi+ by PoS" },

	{ 0x3c3483e5 , 0x0800 , "ZX Lprint EuroElectronics Interface" },
	{ 0xa5014f40 , 0x0800 , "ZX Lprint MKIII Interface" },
 
	{ 0xce7cf52e , 0x0800 , "Currah microSpeech" },
	{ 0x1431505c , 0x2000 , "Modem Prism VTX 5000 v3.1" },
 	{ 0x7a365ba6 , 0x8000 , "General Sound v1.04" },
 	{ 0xe938a510 , 0x1000 , "ZS Scorpion 256K AT-XT Keyboard & Mouse Interface" },

/* probably useless roms *******************************************************/
	{ 0x2959719b , 0x02000 , "PART ZX Spectrum 48K (0000h-1fffh)" },
	{ 0x87369b50 , 0x03000 , "MERGED Sinclair ZX-80 & ZX-81" },
	{ 0x05ad8750 , 0x0a000 , "MERGED ZX Spectrum roms (262bd888+60efaf07+9e5392aa)" },
	{ 0x6d96f172 , 0x10000 , "MERGED ZX Spectrum roms (help screen+124ad9e0+b96a36be+c43d717f)" },
	{ 0xe640a642 , 0x10000 , "MERGED ZX Spectrum roms (help screen+124ad9e0+b96a36be+561662f2)" },
	{ 0x863c7e0b , 0x10000 , "MERGED ZX Spectrum roms (help screen+124ad9e0+b96a36be+2f97fe06)" },
	{ 0xf8a79acc , 0x16000 , "MERGED ZX Spectrum roms (ddee531f+9e5392aa+262bd888+793b7eb7+b96a36be+e76799d2)" },
	{ 0x23af5893 , 0x20000 , "MERGED ZX Spectrum roms (ddee531f+9e5392aa+262bd888+793b7eb7+b96a36be+e76799d2+8c7e6a55+9191480c+78ec8cfd)" },
	{ 0x9f54a710 , 0x20000 , "MERGED ZX Spectrum roms (ddee531f+9e5392aa+262bd888+793b7eb7+b96a36be+e76799d2+dd6f66ca+05b041fc+78ec8cfd)" },
	{ 0xad99f054 , 0x20000 , "MERGED ZX Spectrum roms (ddee531f+9e5392aa+262bd888+793b7eb7+b96a36be+e76799d2+27d4c5f6+4250c4cd+78ec8cfd)" },
	{ 0xf8635431 , 0x20000 , "MERGED ZX Spectrum roms (ddee531f+bb66dd1e+262bd888+793b7eb7+b96a36be+e76799d2+dd6f66ca+05b041fc+78ec8cfd)" },
	{ 0xe0fda867 , 0x20000 , "MERGED ZX Spectrum roms (ddee531f+9e5392aa+262bd888+793b7eb7+b96a36be+124ad9e0+8c7e6a55+9191480c+78ec8cfd)" },
	{ 0x2ae772ba , 0x30000 , "MERGED ZX Spectrum roms (ddee531f+e76799d2+b96a36be+5d2e8c66+98b1320b+17373da2+f1d1d99e+3dbf351d+04448eaa+bf44ec3f+ae16233a+filled with 00h)" },
	{ 0xe55b40f8 , 0x0c000 , "MERGED ZX Spectrum 48K + ZX Spectrum 128K" },
	{ 0x545f8520 , 0x04000 , "MODIFIED ZX Spectrum 48K by Lec v1.6 for 80kB (modified for Psim)" },
	{ 0x996bc458 , 0x04000 , "MODIFIED ZX Spectrum 48K (modified for ZX Spectrum Simulator)" },
	{ 0x705192c7 , 0x04000 , "MODIFIED ZX Spectrum 128K (4000h) (modified to be use as 48K ROM in SpecEm)" },
	{ 0x9e5392aa , 0x02000 , "MODIFIED Interface 1 v2 (modified for z80 pre-v4)" },
	{ 0xeed3e349 , 0x04000 , "MODIFIED ISO-ROM 128K (Ramramis 128K) (8000h) (modified for X128)" },
	{ 0xf473991e , 0x02000 , "MODIFIED Multiface 128 v3.6 (87.2) (Romantic Robot)" },
	{ 0xca7622c1 , 0x04000 , "OVERDUMP Multiface 1 (Romantic Robot)" },
	{ 0xff83b282 , 0x04000 , "Disciple GDOS3 v3.0 with System 3b" },
 	{ 0x27d4c5f6 , 0x04000 , "Disciple GDOS3 v3.0 with System 3b & Epson printer code" },
	{ 0x4250c4cd , 0x04000 , "Disciple GDOS3 v3.0 with System 3b & HP printer code" },
 	{ 0xdd6f66ca , 0x04000 , "Disciple GDOS3 v3.0 with System 3b & Epson printer code (alt)" },
	{ 0x05b041fc , 0x04000 , "Disciple GDOS3 v3.0 with System 3b & HP printer code (alt)" },
 	{ 0x8c7e6a55 , 0x04000 , "Disciple GDOS3 v3.0 with System 3b & Epson printer code (alt 2)" },
	{ 0x9191480c , 0x04000 , "Disciple GDOS3 v3.0 with System 3b & HP printer code (alt 2)" },
	{ 0x6edbf20a , 0x04000 , "Disciple +D G+DOS v1.A with System 2a" },
	{ 0x44c8e6ce , 0x04000 , "Disciple +D G+DOS v1.A with System 2a (alt)" },
 

/* Sinclair QL Computer ********************************************************/
	{ 0xc7143fc7, 0xc000 , "Sinclair QL ah" },
	{ 0xe2b94296, 0xc000 , "Sinclair QL jm" },
	{ 0xe2ac3b71, 0xc000 , "Sinclair QL tb" },
	{ 0x0f95aab5, 0xc000 , "Sinclair QL js" },
	{ 0x953f8f51, 0xc000 , "Sinclair QL js (patched for use with 4MB memory systems)" },
	{ 0xfa74b1e8, 0xc000 , "Sinclair QL mg" },
	{ 0x5cc6b3ac, 0xc000 , "Sinclair QL mg (german)" },
	{ 0x15931c02, 0xc000 , "Sinclair QL mg (italian)" },
	{ 0x7cba78d3, 0xc000 , "Sinclair QL mguk (mg with new facilites by John Alexander)" },
	{ 0x54e93572, 0xc000 , "Sinclair QL mf (german)" },
	{ 0x930befe3, 0xc000 , "Sinclair QL Minerva 1.89 (QDOS replacement)" },


/* Cambridge Computer Z88 Personal Organiser *********************************************/
	{ 0x0ae7d0fc, 0x20000, "Cambridge Computer Z88 v2.2" },
	{ 0xdad01338, 0x20000, "Cambridge Computer Z88 v2.5 (swedish)" },
	{ 0x293f35c8, 0x20000, "Cambridge Computer Z88 v2.6 (norwegian)" },
	{ 0x802cb9aa, 0x20000, "Cambridge Computer Z88 v3.0" },
	{ 0xa56d732c, 0x20000, "Cambridge Computer Z88 v3.13 (swiss)" },
	{ 0x9468d677, 0x20000, "Cambridge Computer Z88 v3.17 (turkish)" },
	{ 0xd7eaf937, 0x20000, "Cambridge Computer Z88 v3.18 (german)" },
	{ 0x7a08af73, 0x20000, "Cambridge Computer Z88 v3.19 (spanish)" },
	{ 0xbaa80408, 0x20000, "Cambridge Computer Z88 v3.21 (danish)" },
	{ 0x13f54308, 0x20000, "Cambridge Computer Z88 v3.23 (italian)" },
	{ 0x218fbb72, 0x20000, "Cambridge Computer Z88 v3.26 (french)" },
	{ 0x1356d440, 0x20000, "Cambridge Computer Z88 v4.0" },


/* tandy *************************************************************************/
	{ 0x73316e3e , 0x2000, "NOT AUTHENTIC? COCO basic 1.0" },
	{ 0x6270955a , 0x2000, "COCO basic 1.1" },
	{ 0x54368805 , 0x2000, "COCO basic 1.2" },
	{ 0xd8f4d15e , 0x2000, "COCO basic 1.3" },
	{ 0xa04a8732 , 0x2000, "COCO basic 1.3 (1byte different to 0xd8f4d15e" },
	{ 0x6111a086 , 0x2000, "NOT AUTHENTIC? COCO extbasic 1.0" },
	{ 0xa82a6254 , 0x2000, "COCO extbasic 1.1" },
	{ 0x2ea0fb7f , 0x4000, "MERGED! COCO extbasic 1.1 0xa82a6254+0x54368805" },
	{ 0x318ba789 , 0x4010, "OVERDUMP COCO extbasic 1.1 (remove first 16bytes)=0x2ea0fb7f" },
	{ 0xb4f9968e , 0x2000, "COCO disk 1.0" },
	{ 0x0b9c5415 , 0x2000, "COCO disk 1.1" },
	{ 0x7eaa44e3 , 0x2000, "COCO disk (2bytes different to 0x0b9c5415" },
	{ 0x5fb295a7 , 0x6000, "MERGED! 0xa82a6254+0x54368805+0x7eaa44e3" },
	{ 0xb4c88d6c , 0x8000, "COCO3" },
	{ 0x31aec822 , 0x7e00, "INCOMPLETE COCO3 saved from running machine 0xb4c88d6c without end" },
	{ 0xdfce21e5 , 0x7f00, "INCOMPLETE COCO3 saved from running machine" },
	{ 0x7d48ba8e , 0x2000, "??? COCO3 disk?" },
	{ 0xe3879310 , 0x4000, "DRAGON32" },
	{ 0xdcab048d , 0x4010, "Overdump DRAGON32 (remove first 16bytes)=0xe3879310" },
	{ 0xb44536f6 , 0x2000, "DRAGON DOS 1.0" },
	{ 0x878396a5 , 0x4000, "CP400 basic" },
	{ 0xe9ad60a0 , 0x2000, "CP400 disk" },
	{ 0x11fda97e , 0x2000, "MC10" },
	{ 0x17893a42 , 0x4000, "Dragon64? d64rom2 1.0 1983" },
	{ 0x84f68bf9 , 0x4000, "Dragon64? dragrom 1.0 1982" },
	{ 0xcedc6a52 , 0x4010, "Overdump Dragon64? (remove first 16bytes)=0x17893a42" },
	{ 0x615236cc , 0x4010, "Overdump Dragon64? (remove first 16bytes)=0x84f68bf9" },

	{ 0x70d06dff , 0x1000, "TRS80 Level1 0000" },
	{ 0x83dbbbe2 , 0x1000, "TRS80 0000" },
	{ 0x05818718 , 0x1000, "TRS80 1000" },
	{ 0x306e5d66 , 0x1000, "TRS80 2000" },
	{ 0xd6fd9041 , 0x3000, "MERGED! 0x83dbbbe2+0x05818718+0x306e5d66" },
	{ 0xbe46faf5 , 0x1000, "TRS80 alternate 0000" },
	{ 0x6c791c2d , 0x1000, "TRS80 alternate 1000" },
	{ 0x55b3ad13 , 0x1000, "TRS80 alternate 2000" },
	{ 0xa8e60d9a , 0x3000, "MERGED! 0xbe46faf5+0x6c791c2d+0x55b3ad13" },
	{ 0x8f5214de , 0x1000, "SYS80 0000" },
	{ 0x46e88fbf , 0x1000, "SYS80 1000" },
	{ 0x2bfef8f7 , 0x3000, "MERGED! 0x8f5214de+0x46e88fbf+0x306e5d66" },
	{ 0x37c59db2 , 0x1000, "TRS80 level 2 (7 differences to 0x83dbbbe2)" },
	{ 0x0d8a132e , 0x3000, "MERGED TRS80 level 2 (0x37c59db2+0x05818718+306e5d66)" },
	{ 0xbddbf843 , 0x3800, "MERGED! trs80 model 3" },
	{ 0x1a92d54d , 0x3800, "TRS80 model 4 (first 0x3000 byte same as 0xbddbf843" },
	{ 0x7ff336f4 , 504, "SCRAP? TRS80 disk?" },
	{ 0x0033f2b9 , 0x400, "TRS80 char 128 6x8 char Arrows (should be the same as 0xac21c5a2)" },
	{ 0x2d9b8d3d , 0xc00, "MODIFIED? 256 TRS81 6x12 char [/]" },
	{ 0xac21c5a2 , 0xc00, "MODIFIED? 256 TRS81 6x12 char Arrows" },
	{ 0xacfc3200 , 0xc00, "MODIFIED? 256 TRS81 6x12 char real lower case letters, 0-31 are also big letters" },
	{ 0xc7039103 , 0x1500, "TRS80 448 8x12 char" },
	{ 0xddd8f7b2 , 0x1500, "TRS80 448 8x12 char international" },
	{ 0x9820d71a , 0x1500, "TRS80 448 8x12 char linegraphics" },

	{ 0xe09f7e91 , 0x800, "TRS80 lnw80 0000" },
	{ 0xac297d99 , 0x800, "TRS80 lnw80 0800" },
	{ 0xc4303568 , 0x800, "TRS80 lnw80 1000" },
	{ 0x3a5ea239 , 0x800, "TRS80 lnw80 1800" },
	{ 0x2ba025d7 , 0x800, "TRS80 lnw80 2000" },
	{ 0xed547445 , 0x800, "TRS80 lnw80 2800" },
	{ 0xc89b27df , 0x800, "TRS80 lnw80 chars" },
	{ 0xade91df3 , 0x800, "TRS80 lnw80a 0000" },
	{ 0xf94b094a , 0x800, "TRS80 lnw80a 0800" },
	{ 0x5ebe7fa7 , 0x800, "TRS80 lnw80a 1000" },
	{ 0xf97391f5 , 0x800, "TRS80 lnw80a 1800" },
	{ 0x3f7fe632 , 0x800, "TRS80 lnw80a 2000" },
	{ 0x70772471 , 0x800, "TRS80 lnw80a 2800" },
	{ 0x9f6e5c16 , 0x800, "TRS80 lnw80a bad dump?" },

/* msx ***************************************************************************/
	{ 0xd9ec9db7 , 0x4000, "MSX basic" },
	{ 0x2f74e2c5 , 0x4000, "MSX basic 0xd9ec9db7 with some modifications" },
	{ 0x86f11f42 , 0x4007, "MODIFIED MSX 0x2f74e2c5 with 7 byte header" },
	{ 0xdaec9af0 , 0x4000, "MSX bios" },
	{ 0x94ee12f3 , 0x8000, "MERGED MSX 0xd9ec9db7+0xdaec9af0" },
	{ 0xb3cbf2cd , 0x8000, "MSX casema? differences to 0x94ee12f3 in the first 16k" },
	{ 0xee229390 , 0x8000, "MSXJ" },
	{ 0xe9ccd789 , 0x8000, "MSXUK" },
	{ 0x3ab0cd3b , 0x8000, "MSXKR" },
	{ 0xa781f7ca , 0x8000, "MSXKR 0x3ab0cd3b hacked to boot like jap/eu msx for increased compatiblity" },

	{ 0x97478efb , 0x4000, "BAD DUMP? MSXKR han" },

	{ 0x2949cb19 , 0x4000, "MSX ru disk" },
	{ 0xaf445c3d , 0x4000, "MSX shrpdisk" },
	{ 0x6704ef81 , 0x4000, "MSX gradisk" },
	{ 0xeb8e1d5b , 0x4000, "MSX fmsxdisk" },
	{ 0x71162b96 , 0x4000, "MSX disk" },

	{ 0x07610d77, 0x8000, "EXPERT 1.0" },
	{ 0xefb4b972, 0x8000, "EXPERT 1.1" },
	{ 0xb6942694, 0x8000, "HOTBIT 1.1" },
	{ 0xf59a4a0c, 0x8000, "HOTBIT 1.2" },

	{ 0x77b94ae0,0x8000, "MSXTR" },
	{ 0x937c8dbb,0x8000, "MSXTR" },
	{ 0x70aea0fe,0x4000, "MSXTR ext" },
	{ 0xf5f93437,0x4000, "MSXTR mus" },
	{ 0xa068cba9,0x8000, "MSXTR kanji" },
	{ 0x7016dfd0,0x40000, "MSXTR kanji 256k" },

	{ 0xf05ed518,0x8000, "MSX2" },
	{ 0x95db2959,0x4000, "MSX2 ext" },
	{ 0x6cdaf3a5,0x8000, "MSX21" },
	{ 0x66237ecf,0x4000, "MSX21 ext" },
	{ 0x9b3e7b97,0x8000, "MSX2 japan" },
	{ 0x43e7a7fc,0x4000, "MSX2 japan X" },
	{ 0x0531dea4,0x8000, "MSX2 casema" },
	{ 0x53850907,0x8000, "MSX2 k" },

	{ 0x00870134,0x8000, "MSX2+" },
	{ 0xb8ba44d3,0x4000, "MSX2+ ext" },
	{ 0xc9651b32,0x20000, "MSX2+ kanji 128k" },

	{ 0x98d48655,0x8000, "SVI 1.0" },
	{ 0x709904e9,0x8000, "SVI 1.1" },
	{ 0xbc433df6,0x8000, "SVI 1.11" },

/* sharp ***************************************************************************/
	{ 0x4c6c6b7b , 0x1000, "MZ700" },
	{ 0x42b9e8fb , 0x1000, "MZ700 font" },
	{ 0x425eedf5 , 0x1000, "MZ700 font japan" },
	{ 0x0c281675 , 0x2000, "MZ800" },

	{ 0xdca8f879 , 0x4000, "PC1500A rom" },

	{ 0x44bee438 , 0x2000, "SC61860A08 5H 13LD PC1401 cpu rom" },
	{ 0x69b9d587 , 0x8000, "5S1 SC613256 D30 PC1401" },
	{ 0xf7287aca , 0x2000, "PC1251 cpu rom" },
	{ 0x93ecb629 , 0x4000, "PC1251 basic rom" },
	{ 0x79a924bc , 0x2000, "PC1350 cpu rom" },
	{ 0x158b28e2 , 0x8000, "PC1350 basic rom" },

	{ 0x588c500b, 0x2000, "PC1403 internal" },
	{ 0x1fa65140, 0x4000, "PC1403 external 1of4" },
	{ 0x4a7da6ab, 0x4000, "PC1403 external 2of4" },
	{ 0x9925174f, 0x4000, "PC1403 external 3of4" },
	{ 0xfa5df9ec, 0x4000, "PC1403 external 4of4" },

	{ 0x9f3195f1 ,0xc0000, "X68000 charset" },
	{ 0x72bdf532 ,0x20000, "X68000 1.00 1987/05/07" },

/* texas instruments ****************************************************************/
	{ 0xdb8f33e5 , 0x2000, "TI99_4A arom" },
	{ 0x8f7df93f , 0x2000, "TI99_4A disk" },
	{ 0xaf5c2449 , 0x6000, "TI99_4A agrom" },
	{ 0x58b155f7 , 0x8000, "TI99_4A speech" },
	{ 0x0a0b0c42 , 0x100, "94519209 TI990_4" },
	{ 0xd078af61 , 0x100, "94519210 TI990_4" },
	{ 0x6cf7d4a0 , 0x100, "94519211 TI990_4" },
	{ 0xd9522458 , 0x100, "94519212 TI990_4" },
	{ 0x8719b04e , 0x100, "94519113 TI990_4" },
	{ 0x72a040e0 , 0x100, "94519114 TI990_4" },
	{ 0x9ccf8cca , 0x100, "94519115 TI990_4" },
	{ 0xfa387bf3 , 0x100, "94519116 TI990_4" },

/* Texas Instruments Personal Organisers ***************************************/
	{ 0x160ee4a6 , 0x150000, "Texas Instruments AVIGO v1.004 (english)" },
	{ 0x8180d674 , 0x150000, "Texas Instruments AVIGO v1.004 (french)" },
	{ 0x124a5679 , 0x160000, "Texas Instruments AVIGO v1.004 (german)" },
	{ 0x3eb41e47 , 0x150000, "Texas Instruments AVIGO v1.004 (spainish)" },
	{ 0x24b4076f , 0x160000, "Texas Instruments AVIGO v1.004 (italian)" },

/* Texas Instruments Calculators ***********************************************/
	{ 0x94ac58e2 , 0x08000 , "Texas Instruments TI-81 v1.8" },

	{ 0xe2f5721c , 0x20000 , "Texas Instruments TI-82 v16.0" },
	{ 0x0fc956d4 , 0x20000 , "Texas Instruments TI-82 v17.0" },
	{ 0x6a320f03 , 0x20000 , "Texas Instruments TI-82 v18.0" },
	{ 0xed4cf9ff , 0x20000 , "Texas Instruments TI-82 v19.0" },

	{ 0x7ee5d27b , 0x40000 , "Texas Instruments TI-83 v1.0200" },
	{ 0x926f72a4 , 0x40000 , "Texas Instruments TI-83 v1.0300" },
	{ 0xdccb73d3 , 0x40000 , "Texas Instruments TI-83 v1.0400" },
	{ 0x2eae1cf0 , 0x40000 , "Texas Instruments TI-83 v1.0600" },
	{ 0x4bf05697 , 0x40000 , "Texas Instruments TI-83 v1.07000" },
	{ 0x0c6aafcc , 0x40000 , "Texas Instruments TI-83 v1.08000" },
	{ 0x7faee2d2 , 0x40000 , "Texas Instruments TI-83 v1.10" },

	{ 0x281c9375 , 0x80000 , "Texas Instruments TI-83+ v1.03" },
	{ 0x690d9d30 , 0x80000 , "Texas Instruments TI-83+ v1.03 (alt)" },
	{ 0x62683990 , 0x80000 , "Texas Instruments TI-83+ v1.10" },
	{ 0xddca5026 , 0x80000 , "Texas Instruments TI-83+ v1.12" },

	{ 0xde4c0b1a , 0x20000 , "Texas Instruments TI-85 v3.0a" },
	{ 0xa1723a17 , 0x20000 , "Texas Instruments TI-85 v4.0" },
	{ 0x781fa403 , 0x20000 , "Texas Instruments TI-85 v5.0" },
	{ 0xb694a117 , 0x20000 , "Texas Instruments TI-85 v6.0" },
	{ 0x7f296338 , 0x20000 , "Texas Instruments TI-85 v8.0" },
	{ 0x6a0a94d0 , 0x20000 , "Texas Instruments TI-85 v9.0" },
	{ 0x053325b0 , 0x20000 , "Texas Instruments TI-85 v10.0" },

	{ 0xbdf16105 , 0x40000 , "Texas Instruments TI-86 v1.2" },
	{ 0x073ef70f , 0x40000 , "Texas Instruments TI-86 v1.3" },
	{ 0xfe6e2986 , 0x40000 , "Texas Instruments TI-86 v1.4" },
	{ 0x37e02acc , 0x40000 , "Texas Instruments TI-86 v1.6" },
	{ 0xd2c67280 , 0x40000 , "Texas Instruments TI-86 GROM (homebrew rom by Daniel Foesch)" },

	{ 0x264b34ad , 0x200000 , "Texas Instruments TI-89 (hardware 1) v1.00" },
	{ 0x95199934 , 0x200000 , "Texas Instruments TI-89 (hardware 1) v1.00 (alt 1)" },
	{ 0xb9059e06 , 0x200000 , "Texas Instruments TI-89 (hardware 1) v1.00 (alt 2)" },
	{ 0x3bc0b474 , 0x200000 , "Texas Instruments TI-89 (hardware 1) v1.05" },
	{ 0xfa6745e9 , 0x200000 , "Texas Instruments TI-89 (hardware 1) v2.01" },
	{ 0xa3a74eca , 0x200000 , "Texas Instruments TI-89 (hardware 1) v2.03" },
	{ 0x83817402 , 0x200000 , "Texas Instruments TI-89 (hardware 2) v1.05" },
	{ 0x5e0400a9 , 0x200000 , "Texas Instruments TI-89 (hardware 2) v2.03" },

	{ 0x4a343833 , 0x100000 , "Texas Instruments TI-92 v1.11 (external)" },
	{ 0x67878d52 , 0x100000 , "Texas Instruments TI-92 v1.11 (internal)" },
	{ 0x9a6947a0 , 0x100000 , "Texas Instruments TI-92 v1.12 (external)" },
	{ 0x316c8196 , 0x100000 , "Texas Instruments TI-92 v1.3 (external)" },
	{ 0x239e9405 , 0x100000 , "Texas Instruments TI-92 v1.4 (external)" },
	{ 0x83e27cc5 , 0x100000 , "Texas Instruments TI-92 v1.7 (external)" },
	{ 0x5afb5863 , 0x200000 , "Texas Instruments TI-92 v2.1 (external)" },

	{ 0xc651a586 , 0x200000 , "Texas Instruments TI-92+ v1.00" },
	{ 0x18f9002f , 0x200000 , "Texas Instruments TI-92+ v1.01" },
	{ 0x826b1539 , 0x200000 , "Texas Instruments TI-92+ v1.01 (alt 1)" },
	{ 0xcd945824 , 0x200000 , "Texas Instruments TI-92+ v1.05" },

	{ 0xda466be0 , 0x80000 , "BAD DUMP Texas Instruments TI-83+ v1.03" },
	{ 0xad770061 , 0x80000 , "BAD DUMP Texas Instruments TI-83+ v1.12" },
	{ 0x889dadc7 , 0x20000 , "BAD DUMP Texas Instruments TI-85 v4.0" },
	{ 0xd723e107 , 0x20000 , "BAD DUMP Texas Instruments TI-85 v5.0" },
	{ 0xcd13d4f1 , 0x20000 , "BAD DUMP Texas Instruments TI-85 v6.0" },
	{ 0x32ad5c28 , 0x20000 , "BAD DUMP Texas Instruments TI-85 v8.0" },
	{ 0xceed0ef5 , 0x20000 , "BAD DUMP Texas Instruments TI-85 v9.0" },
	{ 0x706fd864 , 0x20000 , "BAD DUMP Texas Instruments TI-85 v10.0" },
	{ 0xe6e10546 , 0x40000 , "BAD DUMP Texas Instruments TI-86 v1.5" },
	{ 0x5f1c2391 , 0x100000 , "BAD DUMP Texas Instruments TI-92 v1.11 (internal)" },
	{ 0xfe2b6e77 , 0x200000 , "BAD DUMP Texas Instruments TI-92+ v1.01" },
	{ 0x1ed2f479 , 0x100000 , "OVER DUMP Texas Instruments TI-83+ v1.10" },

/*******************************************************************************/
	{ 0xd359ead7 , 0x4000, "CGENIE bios" },
	{ 0x2a96cf74 , 0x2000, "CGENIE dos" },
	{ 0x4fed774a , 0x800, "CGENIE font" },

	{ 0xa2d15bcf , 0x2000, "AQUARIUS" },
	{ 0x5cfa5b42 , 0x2000, "AQUARIUS radofin? (1byte different to 0xa2d15bcf)" },
	{ 0x0b3edeed , 0x800, "AQUARIUS character" },

	{ 0x9ca858cc , 0x2000, "MTX ???" },
	{ 0x87b4e59c , 0x2000, "MTX ???" },
	{ 0x9d7538c3 , 0x2000, "MTX ???" },

	{ 0xe371b58a , 0x400, "NASCOM 1 nasbugt2" },
	{ 0xb6300716 , 0x800, "NASCOM 2 nassys1" },
	{ 0x5cb5197b , 0x2000, "NASCOM 2 basic" },
	{ 0x33e92a04 , 0x800, "NOT BAD DUMP! NASCOM 1 nascom1.chr" },
	{ 0x2bc09d32 , 0x800, "NASCOM 2 nasgra.chr" },

	{ 0xdc7cf06a , 0x1000, "MERGED NASCOM nascom1.chr 0x33e92a04+?" },
	{ 0xacaa3a31 , 0x1000, "MERGED NASCOM nasgra.chr 0x33e92a04+0x2bc09d32" },
	{ 0x3da17373 , 0x800, "NASCOM nassys3" },
	{ 0xf391df68 , 0x800, "NASCOM nasbugt4" },
	{ 0x6c144399 , 0x800, "NASCOM sysex" },
	{ 0xac4d33b0 , 0x0500, "BAD DUMP NASCOM nascom1.chr" },

	{ 0x99412d43 , 0x2000, "LASER110" },
	{ 0xe4c24e8b , 0x2000, "LASER110" },
	{ 0xead006a1 , 0xc00, "LASER110 characters" },
	{ 0xcc854fe9 , 0x2000, "LASER210" },
	{ 0x7060f91a , 0x2000, "LASER210" },
	{ 0x613de12c , 0x4000, "LASER310" },
	{ 0x9bed01f7 , 0x8000, "LASER350" },
	{ 0xed6bfb2a , 0x800, "LASER350 chars" },

	{ 0xdfe34b08 , 0x2000, "KC85 basic" },
	{ 0xfe2932e3 , 0x2000, "KC85_3? basic (1 byte different to 0xdfe34b08)" },
	{ 0xbd30cd2d , 0x2000, "KC85_3? bios" },
	{ 0x52bc2199 , 0x2000, "KC85_3 bios?" },
	{ 0x57d9ab02 , 0x1000, "KC85_4 os c000" },
	{ 0xd64cd50b , 0x2000, "KC85_4 os e000" },
	{ 0x4a6c9a47 , 0x2000, "KC85_3 disk" },
	{ 0x639e4864 , 0x2000, "KC85_3 tape" },
	{ 0x37cc2080 , 0x2000, "KC85_4 disk" },
	{ 0xee273933 , 0x2000, "KC85_4 tape" },

	{ 0x7896a696 , 0x2000, "MBEE basic 8000" },
	{ 0xb21d9679 , 0x2000, "MBEE basic a000" },
	{ 0x0fc21cb5 , 0x2000, "MBEE" },
	{ 0x47a56a9a , 0x1000, "BAD DUMP? MBEE char" },
	{ 0x28211224 , 0x1000, "MBEE 56k" },
	{ 0x1f9fcee4 , 0x1000, "MBEE 128k char" },
	{ 0x995c53db , 0x2000, "MBEE 128k" },
	{ 0x1af1b3a9 , 0x2000, "MBEE edasm" },
	{ 0x15b9d2df , 0x2000, "MBEE telc321" },

	{ 0x5f72da5b , 0x1000, "KAYPRO char" },
	{ 0xd10cd036 , 5632, "REPROGRAMMED? KAYPRO" },

	{ 0xd421795f , 0x8000, "ENTERPRISE128 os" },
	{ 0x683cf455 , 0x4000, "ENTERPRISE128 basic" },
	{ 0xd1d7e157 , 0x8000, "ENTERPRISE128 dos" },
	{ 0x982a3b44 , 0x8000, "ENTERPRIES128 os 21" },

	{ 0xdc8438a5 , 0x1000, "JUPITER " },
	{ 0x4009f636 , 0x1000, "JUPITER" },
	{ 0xe5b1f5f6 , 0x2000, "MERGED! JUPITER 0xdc8438a5+0x4009f636" },

	{ 0x650784a3 , 0x1000, "P2000 bios" },
	{ 0x9d9d38f9 , 0x4000, "P2000 basic" },
	{ 0x873e81c1 , 2240, "BAD DUMP P2000 character" },

	{ 0x3e09d384 , 0x1000, "MICROTAN" },
	{ 0x75105113 , 0x1000, "MICROTAN" },
	{ 0xee6e8412 , 0x800, "MICROTAN" },
	{ 0xbd87fd34 , 0x800, "MICROTAN" },
	{ 0x9fd233ee , 0x800, "MICROTAN" },
	{ 0x7e215313 , 0x400, "MICROTAN" },
	{ 0xc8221d9e , 0x400, "MICROTAN" },
	{ 0x3b3c5360 , 0x800, "MICROTAN character" },

	{ 0xf18710b4 , 0x4000, "ORIC1 basic 10" },
	{ 0x07a5a667 , 0x4000, "ORIC basic 11 de" },
	{ 0x2539bb8d , 0x4000, "ORIC basic 11 es" },
	{ 0x02bd82f5 , 0x4000, "ORIC basic 11 fr" },
	{ 0xc593bee6 , 0x4000, "ORIC basic 11 se" },
	{ 0x52b5ed9b , 0x4000, "ORIC basic 11 uk" },
	{ 0xc3a92bef , 0x4000, "ORICA basic 11b (few differences to uk)" },
	{ 0xa9664a9c , 0x2000, "ORIC microdisk" },
	{ 0x37220e89 , 0x800, "ORIC jasmin" },
	{ 0x58079502 , 0x4000, "PRAVETZ8D" },
	{ 0xb48973ef , 0x4000, "PRAVETZ8Dd" },
	{ 0xf8d23821 , 0x4000, "PRAVETZ8Dda" },
	{ 0x94358dc6 , 0x2000, "STRATOS telmatic" },
	{ 0x68b0fde6 , 0x4000, "STRATOS teleass" },
	{ 0x1d96ab50 , 0x4000, "STRATOS hyperbas" },
	{ 0xaa727c5d , 0x4000, "STRATOS telmon24" },
	{ 0xcda92497 , 0x4000, "STRATOS telmon24 fr" },

	{ 0x32f0d1ef , 0x4000, "Scrap Einstein" },
	{ 0xec134953 , 0x2000, "Einstein" },

	{ 0x5c3b5bb5, 0x800, "BAD DUMP? Galaxy char" },
	{ 0x365f3e24, 0x1000, "Galaxy" },
	{ 0x5dc5a100, 0x1000, "Galaxy" },

	{ 0xfae922cb, 0x20, "SORCERER address decoding prom" },
	{ 0x4a7e1cdd, 0x400, "SORCERER character set" },
	{ 0xac924f67, 0x800, "SORCERER monitor e000" },
	{ 0xead1d0f6, 0x800, "SORCERER monitor e800" },
	{ 0x1dd20d80, 0x800, "SORCERER basic c000" },
	{ 0x1068a3f8, 0x800, "SORCERER basic c800" },
	{ 0xe6332518, 0x800, "SORCERER basic d000" },
	{ 0xa370cb19, 0x800, "SORCERER basic d800" },

	{ 0xe6ea96dc ,0x1000, "ZRT80" },
	{ 0x4dbdc60f ,0x800, "ZRT80 char" },

	{ 0x44a347d9 ,0x4000, "PK-01 Lviv" },
	{ 0x551622f5 ,0x4000, "PK-01 Lviv (alternate)" },
	{ 0xf171c282 ,0x4000, "PK-01 Lviv (prototype)" },

/* Palm OS PDA *****************************************************************/
	/* some of this roms may be modified */
	/* most of them are probably hacked to turn off flash support */
	/* only USR Pilot and Palm Pilot have ROMS */
	/* the rest have flash memory, which can be mmodified by user */

	{ 0x82030062 , 0x080000, "USR Pilot 1000/5000 OS v1.0" },
	{ 0x6ed137b1 , 0x080000, "USR Pilot 1000/5000 OS v1.0.3 (german)" },
	{ 0xbaa5b36a , 0x100000, "Palm Pilot Professional OS v2.0 Pro" },
	{ 0x40ea8baa , 0x100000, "Palm Pilot Professional OS v2.0 Pro (modified)" },
	{ 0x0c6f533e , 0x0ea000, "Palm Pilot Professional OS v2.0.2+ Pro (debug)" },
	{ 0x4f31e1c9 , 0x119000, "Palm III OS v3.0" },
	{ 0xfaaafc62 , 0x130000, "Palm III OS v3.0 (french)" },
	{ 0x8a2f7468 , 0x130000, "Palm III OS v3.0 (german)" },
	{ 0x60cb2ae7 , 0x130000, "Palm III OS v3.0 (spanish)" },
	{ 0xa0b059f9 , 0x119000, "Palm III OS v3.0 (debug)" },
	{ 0x467ff0de , 0x148000, "Palm III OS v3.3" },
	{ 0x785e771b , 0x150000, "Palm III OS v3.3 (german) (ID 00X00XX00XXX-C)" },
	{ 0xedb269d8 , 0x180000, "Palm III OS v3.5" },
	{ 0x50961ee6 , 0x180000, "Palm III OS v3.5 (debug)" },
	{ 0x280f1090 , 0x198000, "Palm III OS v4.0" },
	{ 0x70bedb7e , 0x180000, "Palm IIIc OS v3.5" },
	{ 0x38a191e2 , 0x180000, "Palm IIIc OS v3.5 (debug)" },
	{ 0x922dd0fa , 0x180000, "Palm IIIc OS v3.5 beta" },
	{ 0xefb05a31 , 0x198000, "Palm IIIc OS v4.0" },
	{ 0xc3ea0bb7 , 0x258000, "Palm IIIc OS v4.0 (EFIGS)" },
	{ 0xd5e03642 , 0x278000, "Palm IIIc OS v4.0 (EFIGS) (debug)" },
	{ 0x695f379e , 0x258000, "Palm IIIc OS v4.0 (EFIGS) (alt)" },
	{ 0x006a977f , 0x268000, "Palm IIIc OS v4.0 (japanese)" },
	{ 0x53cb10a2 , 0x280000, "Palm IIIc OS v4.0 (japanese) (debug)" },
	{ 0x5a64ef2b , 0x128000, "Palm IIIe/IIIx/V OS v3.1" },
	{ 0xb1db61b8 , 0x128000, "Palm IIIe/IIIx/V OS v3.1 E31" },
	{ 0xdc560ed1 , 0x138000, "Palm IIIx/V/Vx OS v3.3" },
	{ 0x0011f920 , 0x140000, "Palm IIIx/V/Vx OS v3.3 (ID 00X000X00000-R)" },
	{ 0x08ee205e , 0x150000, "Palm IIIx/V/Vx OS v3.3 (german) (ID 00X000X00000-R)" },
	{ 0x20c79493 , 0x140000, "Palm IIIx/V/Vx OS v3.3 (ID 10EV19Q96BTW-V)" },
	{ 0x30da34a1 , 0x148000, "Palm IIIx/V/Vx OS v3.3 (debug)" },
	{ 0xb9fdb1ce , 0x178000, "Palm IIIx/V/Vx OS v3.5" },
	{ 0x85412370 , 0x180000, "Palm IIIx/V/Vx OS v3.5 (alt)" },
	{ 0xc8ddb563 , 0x180000, "Palm IIIx/V/Vx OS v3.5 (german)" },
	{ 0x1f0f5841 , 0x188000, "Palm IIIx/V/Vx OS v3.5 (ID 10HA14M07KHB-J)" },
	{ 0x4c700386 , 0x178000, "Palm IIIx/V/Vx OS v3.5 (debug)" },
	{ 0x9531c50c , 0x118000, "Palm IIIx/V/Vx OS v3.5.2 (modified)" },
	{ 0xcfbdef34 , 0x198000, "Palm IIIx/V/Vx OS v4.0" },
	{ 0xb7b0eb15 , 0x258000, "Palm IIIx/V/Vx OS v4.0 (EFIGS)" },
	{ 0xe06cfa55 , 0x1b8000, "Palm V/Vx OS v4.0 (debug)" },
	{ 0x0c53d604 , 0x238000, "Palm V/Vx OS v4.0 (full) (debug)" },
	{ 0x39f24dc0 , 0x358000, "Palm V/Vx OS v4.0 (EFIGS)" },
	{ 0x80b78ab7 , 0x338000, "Palm V/Vx OS v4.0 (EFIGS) (debug)" },
	{ 0x0fe71ec1 , 0x350000, "Palm V/Vx OS v4.0 (japanese) (full) (debug)" },
	{ 0x29b5d84e , 0x1F0000, "Palm VII OS v3.2" },
	{ 0x9bd7c6fe , 0x178000, "Palm m100 OS v3.5.1" },
	{ 0xdd93b80f , 0x1f0000, "Palm m505 OS v4.0" },
	{ 0xd1f37309 , 0x210000, "Palm m505 OS v4.0 (debug)" },

	{ 0xb47295a8 , 0x200000, "Handspring Visor OS v3.1" },
	{ 0x93cded38 , 0x200000, "Handspring Visor OS v3.1H2" },
	{ 0xc9e55271 , 0x200000, "Handspring Visor Platinum/Prism/Edge OS v3.5.2H1.1" },

	{ 0x482c4e3b , 0x190000, "Sony CLIE PEG-S300 OS v3.5.0" },
	{ 0x361ba712 , 0x190000, "Sony CLIE PEG-S300 OS v3.5.1" },
	{ 0xd39dc1e2 , 0x3b0000, "Sony CLIE PEG-S300 OS v3.5.1 (japanese)" },
	{ 0x566d18ec , 0x3b0000, "Sony CLIE PEG-S500c OS v3.5.1 (japanese)" },

	{ 0x382e2432 , 0x1c0000, "TRG Pro OS v3.5.3 (16.07.2001)" },
	{ 0x7aa24b38 , 0x1c0000, "TRG Pro OS v3.5.3 (21.06.2000)" },
	{ 0xfab125a9 , 0x1f8000, "HandEra 330 OS v3.5.3" },

	{ 0xd0bdba79 , 0x1f8000, "IBM WorkPad OS v3.1 (japanese)" },


/* Hewlett Packard Calculators *************************************************/
	{ 0x3f2d9469 , 0x400000, "Hewlett Packard HP-39G (1 nibble stored in byte)" },
	{ 0xa87696c7 , 0x40000 , "Hewlett Packard HP-48S ver. a" },
	{ 0x034f6ce4 , 0x40000 , "Hewlett Packard HP-48S ver. b" },
	{ 0xa9a0279d , 0x40000 , "Hewlett Packard HP-48S ver. c" },
	{ 0x6e71244e , 0x40000 , "Hewlett Packard HP-48S ver. d" },
	{ 0x704ffa08 , 0x40000 , "Hewlett Packard HP-48S ver. e" },
	{ 0x1a6378ef , 0x40000 , "Hewlett Packard HP-48S ver. j" },
	{ 0xbdd5d2ee , 0x80000 , "Hewlett Packard HP-48G ver. k" },
	{ 0x70958e6b , 0x80000 , "Hewlett Packard HP-48G ver. l" },
	{ 0xe21a09e4 , 0x80000 , "Hewlett Packard HP-48G ver. m" },
	{ 0x27f90428 , 0x80000 , "Hewlett Packard HP-48G ver. p" },
	{ 0x00ee1a62 , 0x80000 , "Hewlett Packard HP-48G ver. r" },

	{ 0xd4f1390b , 0x40000 , "SAVE Hewlett Packard HP-48S ver. e (diffs only in hardware window)" },

	{ 0x5619ccaf , 0x40000 , "BAD DUMP Hewlett Packard HP-48S ver. e" },
	{ 0xd6bb68c5 , 0x80000 , "BAD DUMP Hewlett Packard HP-48G ver. r" },


	{ 0xa2a56502 , 0x400, "6530-003 KIM1 1800" },
	{ 0x2b08e923 , 0x400, "6530-002 KIM1 1c00" },

	{ 0x075b0bbd , 0x2000, "SYM1 basic ???" },
	{ 0x7a4b1e12 , 0x1000, "SYM1 ???" },

	{ 0x0878b399 , 0x1000, "AIM65" },
	{ 0xd7b42d2a , 0x1000, "AIM65" },
	{ 0x36a61f39 , 0x1000, "AIM65" },
	{ 0xd01914b0 , 0x1000, "AIM65" },
	{ 0x90e44afe , 0x1000, "AIM65" },

	{ 0xa2a56502 , 0x400, "MEKD" },

	{ 0x9d3caa92 , 0x800, "UK101" },
	{ 0x0d011242 , 0x800, "UK101" },
	{ 0x667223e8 , 0x800, "UK101" },
	{ 0x04ac5822 , 0x800, "UK101" },
	{ 0xfce2c84a , 0x800, "UK101" },
	{ 0xf4f5dec0 , 0x800, "SUPERBRD" },
	{ 0x0039ef6a , 0x800, "SUPERBRD/UK101" },
	{ 0xca25f8c1 , 0x800, "SUPERBRD" },
	{ 0x8ee6030e , 0x800, "SUPERBRD" },
	{ 0xe5b7028d , 0x800, "SUPERBRD" },
	{ 0xec94afe7 , 0x800, "SUPERBRD" },

	{ 0x278f7bf3 , 0x800, "7916E C48091 82c210-1 Chess Champion MK1 (2716 compatible)" },
	{ 0x4f28c443 , 0x400, "MOS6530 024 1879 Chess Champion MK2" },
	{ 0x6f10991b , 0x1000, "MOS6332 005 2179 Chess Champion MK2 (not full 2732 compatible)" },
	{ 0x9ea46ed3 , 0x1000, "Signetics c19081e Chess Champion MK3 (not full 2732 compatible)" },
	{ 0x52741e0b , 0x1000, "Signetics c19082 Chess Champion MK3 (not full 2732 compatible)" },

	{ 0x2bf4b1a8 , 0x80000, "Epoxy DIL32 Comquest Plus German (dumped as 278001, gave 2 identical halfes" },

	/* centronics based devices */
	{ 0x62ba054e, 0x10000, "Printer Star LC10 nx1p 2.1" },
	{ 0x191384a6, 0x10000, "Printer Star LC10 Color nx1p 1.6 c l" },

#if 0
	{ 0x , 0x000, "" },
#endif

};
