/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ka extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "გრინვიჩის საშუალო დრო",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "აპიას სტანდარტული დრო",
               "",
               "აპიას ზაფხულის დრო",
               "",
               "აპიას დრო",
               "",
            };
        final String[] Cook = new String[] {
               "კუკის კუნძულების სტანდარტული დრო",
               "",
               "კუკის კუნძულების ნახევრად ზაფხულის დრო",
               "",
               "კუკის კუნძულების დრო",
               "",
            };
        final String[] Cuba = new String[] {
               "კუბის სტანდარტული დრო",
               "CST",
               "კუბის ზაფხულის დრო",
               "CDT",
               "კუბის დრო",
               "CT",
            };
        final String[] Fiji = new String[] {
               "ფიჯის სტანდარტული დრო",
               "",
               "ფიჯის ზაფხულის დრო",
               "",
               "ფიჯის დრო",
               "",
            };
        final String[] Gulf = new String[] {
               "სპარსეთის ყურის სტანდარტული დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "ჰოვდის სტანდარტული დრო",
               "",
               "ჰოვდის ზაფხულის დრო",
               "",
               "ჰოვდის დრო",
               "",
            };
        final String[] Iran = new String[] {
               "ირანის სტანდარტული დრო",
               "",
               "ირანის დროის სარტყელი",
               "",
               "ირანის დრო",
               "",
            };
        final String[] Niue = new String[] {
               "ნიუეს დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "ომსკის სტანდარტული დრო",
               "",
               "ომსკის ზაფხულის დრო",
               "",
               "ომსკის დრო",
               "",
            };
        final String[] Peru = new String[] {
               "პერუს სტანდარტული დრო",
               "",
               "პერუს ზაფხულის დრო",
               "",
               "პერუს დრო",
               "",
            };
        final String[] Truk = new String[] {
               "ჩუუკის დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "ვეიკის კუნძულის დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "ჩილეს სტანდარტული დრო",
               "",
               "ჩილეს ზაფხულის დრო",
               "",
               "ჩილეს დრო",
               "",
            };
        final String[] China = new String[] {
               "ჩინეთის სტანდარტული დრო",
               "CST",
               "ჩინეთის დროის სარტყელი",
               "CDT",
               "ჩინეთის დრო",
               "CT",
            };
        final String[] Cocos = new String[] {
               "ქოქოსის კუნძულების დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "დევისის დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "ინდოეთის დრო",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "იაპონიის სტანდარტული დრო",
               "JST",
               "იაპონიის ზაფხულის დრო",
               "JDT",
               "იაპონიის დრო",
               "JT",
            };
        final String[] Korea = new String[] {
               "კორეის სტანდარტული დრო",
               "KST",
               "კორეის ზაფხულის დრო",
               "KST",
               "კორეის დრო",
               "KST",
            };
        final String[] Nauru = new String[] {
               "ნაურუს დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "ნეპალის დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "პალაუს დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "სამოას სტანდარტული დრო",
               "SST",
               "სამოას ზაფხულის დრო",
               "SST",
               "სამოას დრო",
               "SST",
            };
        final String[] Syowa = new String[] {
               "სიოვას დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "ტონგის სტანდარტული დრო",
               "",
               "ტონგის ზაფხულის დრო",
               "",
               "ტონგის დრო",
               "",
            };
        final String[] Yukon = new String[] {
               "იუკონის დრო",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "ალასკის სტანდარტული დრო",
               "AKST",
               "ალასკის ზაფხულის დრო",
               "AKDT",
               "ალასკის დრო",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "ამაზონიის სტანდარტული დრო",
               "",
               "ამაზონიის ზაფხულის დრო",
               "",
               "ამაზონიის დრო",
               "",
            };
        final String[] Azores = new String[] {
               "აზორის კუნძულების სტანდარტული დრო",
               "",
               "აზორის კუნძულების ზაფხულის დრო",
               "",
               "აზორის კუნძულების დრო",
               "",
            };
        final String[] Bhutan = new String[] {
               "ბუტანის დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "ბრუნეი-დარუსალამის დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "აღდგომის კუნძულის სტანდარტული დრო",
               "",
               "აღდგომის კუნძულის ზაფხულის დრო",
               "",
               "აღდგომის კუნძულის დრო",
               "",
            };
        final String[] Guyana = new String[] {
               "გაიანის დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "ჰავაისა და ალეუტის სტანდარტული დრო",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "ისრაელის სტანდარტული დრო",
               "IST",
               "ისრაელის ზაფხულის დრო",
               "IDT",
               "ისრაელის დრო",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "კოსრეს დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "მოუსონის დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "მოსკოვის სტანდარტული დრო",
               "MSK",
               "მოსკოვის ზაფხულის დრო",
               "MSK",
               "მოსკოვის დრო",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "პონაპეს დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "ტაიტის დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "ტაიბეის სტანდარტული დრო",
               "CST",
               "ტაიბეის ზაფხულის დრო",
               "CDT",
               "ტაიბეის დრო",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "ტუვალუს დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "ვოსტოკის დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "ვოლისი და ფუტუნას დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "არაბეთის სტანდარტული დრო",
               "",
               "არაბეთის ზაფხულის დრო",
               "",
               "არაბეთის დრო",
               "",
            };
        final String[] Armenia = new String[] {
               "სომხეთის სტანდარტული დრო",
               "",
               "სომხეთის ზაფხულის დრო",
               "",
               "სომხეთის დრო",
               "",
            };
        final String[] Bolivia = new String[] {
               "ბოლივიის დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "ჩატემის სტანდარტული დრო",
               "",
               "ჩატემის ზაფხულის დრო",
               "",
               "ჩატემის დრო",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "მსოფლიო კოორდინირებული დრო",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "ეკვადორის დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "გამბიერის დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "საქართველოს სტანდარტული დრო",
               "",
               "საქართველოს ზაფხულის დრო",
               "",
               "საქართველოს დრო",
               "",
            };
        final String[] Irkutsk = new String[] {
               "ირკუტსკის სტანდარტული დრო",
               "",
               "ირკუტსკის ზაფხულის დრო",
               "",
               "ირკუტსკის დრო",
               "",
            };
        final String[] Magadan = new String[] {
               "მაგადანის სტანდარტული დრო",
               "",
               "მაგადანის ზაფხულის დრო",
               "",
               "მაგადანის დრო",
               "",
            };
        final String[] Myanmar = new String[] {
               "მიანმარის დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "ნორფოლკის კუნძულის სტანდარტული დრო",
               "",
               "ნორფოლკის კუნძულის ზაფხულის დრო",
               "",
               "ნორფოლკის კუნძულის დრო",
               "",
            };
        final String[] Noronha = new String[] {
               "ფერნანდო-დე-ნორონიას სტანდარტული დრო",
               "",
               "ფერნანდო-დე-ნორონიას ზაფხულის დრო",
               "",
               "ფერნანდო-დე-ნორონიას დრო",
               "",
            };
        final String[] Reunion = new String[] {
               "რეიუნიონის დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "როთერის დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "სოლომონის კუნძულების დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "ტოკელაუს დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "ურუგვაის სტანდარტული დრო",
               "",
               "ურუგვაის ზაფხულის დრო",
               "",
               "ურუგვაის დრო",
               "",
            };
        final String[] Vanuatu = new String[] {
               "ვანუატუს სტანდარტული დრო",
               "",
               "ვანუატუს ზაფხულის დრო",
               "",
               "ვანუატუს დრო",
               "",
            };
        final String[] Yakutsk = new String[] {
               "იაკუტსკის სტანდარტული დრო",
               "",
               "იაკუტსკის ზაფხულის დრო",
               "",
               "იაკუტსკის დრო",
               "",
            };
        final String[] Atlantic = new String[] {
               "ატლანტიკის ოკეანის სტანდარტული დრო",
               "AST",
               "ატლანტიკის ოკეანის ზაფხულის დრო",
               "AST",
               "ატლანტიკის ოკეანის დრო",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "ბრაზილიის სტანდარტული დრო",
               "",
               "ბრაზილიის ზაფხულის დრო",
               "",
               "ბრაზილიის დრო",
               "",
            };
        final String[] Chamorro = new String[] {
               "ჩამოროს დრო",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "კოლუმბიის სტანდარტული დრო",
               "",
               "კოლუმბიის ზაფხულის დრო",
               "",
               "კოლუმბიის დრო",
               "",
            };
        final String[] Falkland = new String[] {
               "ფოლკლენდის კუნძულების სტანდარტული დრო",
               "",
               "ფოლკლენდის კუნძულების ზაფხულის დრო",
               "",
               "ფოლკლენდის კუნძულების დრო",
               "",
            };
        final String[] Malaysia = new String[] {
               "მალაიზიის დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "მალდივების დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "ულან-ბატორის სტანდარტული დრო",
               "",
               "ულან-ბატორის ზაფხულის დრო",
               "",
               "ულან-ბატორის დრო",
               "",
            };
        final String[] Pakistan = new String[] {
               "პაკისტანის სტანდარტული დრო",
               "PKT",
               "პაკისტანის ზაფხულის დრო",
               "PKST",
               "პაკისტანის დრო",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "პარაგვაის სტანდარტული დრო",
               "",
               "პარაგვაის ზაფხულის დრო",
               "",
               "პარაგვაის დრო",
               "",
            };
        final String[] Pitcairn = new String[] {
               "პიტკერნის დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "სურინამის დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "არგენტინის სტანდარტული დრო",
               "",
               "არგენტინის ზაფხულის დრო",
               "",
               "არგენტინის დრო",
               "",
            };
        final String[] Christmas = new String[] {
               "შობის კუნძულის დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "გალაპაგოსის დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "ჰონკონგის სტანდარტული დრო",
               "HKT",
               "ჰონკონგის ზაფხულის დრო",
               "HKST",
               "ჰონკონგის დრო",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "ინდოჩინეთის დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "ყირგიზეთის დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "ლორდ-ჰაუს სტანდარტული დრო",
               "",
               "ლორდ-ჰაუს ზაფხულის დრო",
               "",
               "ლორდ-ჰაუს დრო",
               "",
            };
        final String[] Marquesas = new String[] {
               "მარკიზის კუნძულების დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "მავრიკის სტანდარტული დრო",
               "",
               "მავრიკის ზაფხულის დრო",
               "",
               "მავრიკის დრო",
               "",
            };
        final String[] Singapore = new String[] {
               "სინგაპურის დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "ვენესუელის დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "აზერბაიჯანის სტანდარტული დრო",
               "",
               "აზერბაიჯანის ზაფხულის დრო",
               "",
               "აზერბაიჯანის დრო",
               "",
            };
        final String[] Bangladesh = new String[] {
               "ბანგლადეშის სტანდარტული დრო",
               "",
               "ბანგლადეშის ზაფხულის დრო",
               "",
               "ბანგლადეშის დრო",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "კაბო-ვერდეს სტანდარტული დრო",
               "",
               "კაბო-ვერდეს ზაფხულის დრო",
               "",
               "კაბო-ვერდეს დრო",
               "",
            };
        final String[] East_Timor = new String[] {
               "აღმოსავლეთ ტიმორის დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "ყაზახეთის დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "სეიშელის კუნძულების დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "ტაჯიკეთის დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "უზბეკეთის სტანდარტული დრო",
               "",
               "უზბეკეთის ზაფხულის დრო",
               "",
               "უზბეკეთის დრო",
               "",
            };
        final String[] Afghanistan = new String[] {
               "ავღანეთის დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "კრასნოიარსკის სტანდარტული დრო",
               "",
               "კრასნოიარსკის ზაფხულის დრო",
               "",
               "კრასნოიარსკის დრო",
               "",
            };
        final String[] New_Zealand = new String[] {
               "ახალი ზელანდიის სტანდარტული დრო",
               "NZST",
               "ახალი ზელანდიის ზაფხულის დრო",
               "NZDT",
               "ახალი ზელანდიის დრო",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "ფილიპინების სტანდარტული დრო",
               "PST",
               "ფილიპინების ზაფხულის დრო",
               "PDT",
               "ფილიპინების დრო",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "ვლადივოსტოკის სტანდარტული დრო",
               "",
               "ვლადივოსტოკის ზაფხულის დრო",
               "",
               "ვლადივოსტოკის დრო",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "ინდოეთის ოკეანის კუნძულების დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "ლაინის კუნძულების დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "ნიუფაუნდლენდის სტანდარტული დრო",
               "NST",
               "ნიუფაუნდლენდის ზაფხულის დრო",
               "NDT",
               "ნიუფაუნდლენდის დრო",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "თურქმენეთის სტანდარტული დრო",
               "",
               "თურქმენეთის ზაფხულის დრო",
               "",
               "თურქმენეთის დრო",
               "",
            };
        final String[] French_Guiana = new String[] {
               "საფრანგეთის გვიანის დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "ახალი კალედონიის სტანდარტული დრო",
               "",
               "ახალი კალედონიის ზაფხულის დრო",
               "",
               "ახალი კალედონიის დრო",
               "",
            };
        final String[] South_Georgia = new String[] {
               "სამხრეთ გეორგიის დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "ეკატერინბურგის სტანდარტული დრო",
               "",
               "ეკატერინბურგის ზაფხულის დრო",
               "",
               "ეკატერინბურგის დრო",
               "",
            };
        final String[] Africa_Central = new String[] {
               "ცენტრალური აფრიკის დრო",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "აღმოსავლეთ აფრიკის დრო",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "დასავლეთ აფრიკის დრო",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "დუმონ-დურვილის დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "ცენტრალური ევროპის სტანდარტული დრო",
               "CET",
               "ცენტრალური ევროპის ზაფხულის დრო",
               "CEST",
               "ცენტრალური ევროპის დრო",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "აღმოსავლეთ ევროპის სტანდარტული დრო",
               "EET",
               "აღმოსავლეთ ევროპის ზაფხულის დრო",
               "EEST",
               "აღმოსავლეთ ევროპის დრო",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "დასავლეთ ევროპის სტანდარტული დრო",
               "WET",
               "დასავლეთ ევროპის ზაფხულის დრო",
               "WEST",
               "დასავლეთ ევროპის დრო",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "მექსიკის წყნარი ოკეანის სტანდარტული დრო",
               "MST",
               "მექსიკის წყნარი ოკეანის ზაფხულის დრო",
               "MDT",
               "მექსიკის წყნარი ოკეანის დრო",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "სამხრეთ აფრიკის დრო",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "ჩრდილოეთ ამერიკის ცენტრალური სტანდარტული დრო",
               "CST",
               "ჩრდილოეთ ამერიკის ცენტრალური ზაფხულის დრო",
               "CDT",
               "ჩრდილოეთ ამერიკის ცენტრალური დრო",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "ჩრდილოეთ ამერიკის აღმოსავლეთის სტანდარტული დრო",
               "EST",
               "ჩრდილოეთ ამერიკის აღმოსავლეთის ზაფხულის დრო",
               "EST",
               "ჩრდილოეთ ამერიკის აღმოსავლეთის დრო",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "ჩრდილოეთ ამერიკის წყნარი ოკეანის სტანდარტული დრო",
               "PST",
               "ჩრდილოეთ ამერიკის წყნარი ოკეანის ზაფხულის დრო",
               "PDT",
               "ჩრდილოეთ ამერიკის წყნარი ოკეანის დრო",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "ფრანგული სამხრეთის და ანტარქტიკის დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "გილბერტის კუნძულების დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "ჰავაისა და ალეუტის სტანდარტული დრო",
               "HST",
               "ჰავაისა და ალეუტის ზაფხულის დრო",
               "HDT",
               "ჰავაისა და ალეუტის დრო",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "ფენიქსის კუნძულების დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "სენ-პიერის და მიკელონის სტანდარტული დრო",
               "",
               "სენ-პიერის და მიკელონის ზაფხულის დრო",
               "",
               "სენ-პიერის და მიკელონის დრო",
               "",
            };
        final String[] America_Mountain = new String[] {
               "ჩრდილოეთ ამერიკის მაუნთინის სტანდარტული დრო",
               "MST",
               "ჩრდილოეთ ამერიკის მაუნთინის ზაფხულის დრო",
               "MST",
               "ჩრდილოეთ ამერიკის მაუნთინის დრო",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "მარშალის კუნძულების დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "პაპუა-ახალი გვინეის დრო",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "ავსტრალიის ცენტრალური სტანდარტული დრო",
               "ACST",
               "ავსტრალიის ცენტრალური ზაფხულის დრო",
               "ACDT",
               "ცენტრალური ავსტრალიის დრო",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "აღმოსავლეთ ავსტრალიის სტანდარტული დრო",
               "AEST",
               "აღმოსავლეთ ავსტრალიის ზაფხულის დრო",
               "AEDT",
               "აღმოსავლეთ ავსტრალიის დრო",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "დასავლეთ ავსტრალიის სტანდარტული დრო",
               "AWST",
               "დასავლეთ ავსტრალიის ზაფხულის დრო",
               "AWDT",
               "დასავლეთ ავსტრალიის დრო",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "ცენტრალური ინდონეზიის დრო",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "აღმოსავლეთ ინდონეზიის დრო",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "დასავლეთ ინდონეზიის დრო",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "ცენტრალური და დასავლეთ ავსტრალიის სტანდარტული დრო",
               "",
               "ცენტრალური და დასავლეთ ავსტრალიის ზაფხულის დრო",
               "",
               "ცენტრალური და დასავლეთ ავსტრალიის დრო",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "გრინვიჩის საშუალო დრო",
                    "GMT",
                    "ბრიტანეთის ზაფხულის დრო",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "მსოფლიო კოორდინირებული დრო",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "გრინვიჩის საშუალო დრო",
                    "GMT",
                    "ირლანდიის სტანდარტული დრო",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "მსოფლიო კოორდინირებული დრო",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "მსოფლიო კოორდინირებული დრო",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "გრინვიჩის საშუალო დრო",
                    "GMT",
                    "ბრიტანეთის ზაფხულის დრო",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "მსოფლიო კოორდინირებული დრო",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "მსოფლიო კოორდინირებული დრო",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "მსოფლიო კოორდინირებული დრო",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "გრინვიჩის საშუალო დრო",
                    "GMT",
                    "ირლანდიის სტანდარტული დრო",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "გრინვიჩის საშუალო დრო",
                    "GMT",
                    "ბრიტანეთის ზაფხულის დრო",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "გრინვიჩის საშუალო დრო",
                    "GMT",
                    "ბრიტანეთის ზაფხულის დრო",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "გრინვიჩის საშუალო დრო",
                    "GMT",
                    "ბრიტანეთის ზაფხულის დრო",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "გრინვიჩის საშუალო დრო",
                    "GMT",
                    "ბრიტანეთის ზაფხულის დრო",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "გრინვიჩის საშუალო დრო",
                    "GMT",
                    "ბრიტანეთის ზაფხულის დრო",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "ადენი" },
            { "timezone.excity.Asia/Baku", "ბაქო" },
            { "timezone.excity.Asia/Dili", "დილი" },
            { "timezone.excity.Asia/Gaza", "გაზა" },
            { "timezone.excity.Asia/Hovd", "ჰოვდი" },
            { "timezone.excity.Asia/Omsk", "ომსკი" },
            { "timezone.excity.Asia/Oral", "ორალი" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "ამანი" },
            { "timezone.excity.Asia/Aqtau", "აქტაუ" },
            { "timezone.excity.Asia/Chita", "ჩიტა" },
            { "timezone.excity.Asia/Dhaka", "დაკა" },
            { "timezone.excity.Asia/Dubai", "დუბაი" },
            { "timezone.excity.Asia/Kabul", "ქაბული" },
            { "timezone.excity.Asia/Macau", "მაკაო" },
            { "timezone.excity.Asia/Qatar", "კატარი" },
            { "timezone.excity.Asia/Seoul", "სეული" },
            { "timezone.excity.Asia/Tokyo", "ტოკიო" },
            { "timezone.excity.Asia/Tomsk", "ტომსკი" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "ჯუბა" },
            { "timezone.excity.Africa/Lome", "ლომე" },
            { "timezone.excity.Asia/Almaty", "ალმატი" },
            { "timezone.excity.Asia/Anadyr", "ანადირი" },
            { "timezone.excity.Asia/Aqtobe", "აქტობე" },
            { "timezone.excity.Asia/Atyrau", "ატირაუ" },
            { "timezone.excity.Asia/Beirut", "ბეირუთი" },
            { "timezone.excity.Asia/Brunei", "ბრუნეი" },
            { "timezone.excity.Asia/Hebron", "ჰებრონი" },
            { "timezone.excity.Asia/Kuwait", "ქუვეითი" },
            { "timezone.excity.Asia/Manila", "მანილა" },
            { "timezone.excity.Asia/Muscat", "მუსკატი" },
            { "timezone.excity.Asia/Riyadh", "ერ-რიადი" },
            { "timezone.excity.Asia/Saigon", "ჰოჩიმინი" },
            { "timezone.excity.Asia/Taipei", "ტაიპეი" },
            { "timezone.excity.Asia/Tehran", "თეირანი" },
            { "timezone.excity.Asia/Urumqi", "ურუმქი" },
            { "timezone.excity.Etc/Unknown", "უცნობი ქალაქი" },
            { "timezone.excity.Europe/Kiev", "კიევი" },
            { "timezone.excity.Europe/Oslo", "ოსლო" },
            { "timezone.excity.Europe/Riga", "რიგა" },
            { "timezone.excity.Europe/Rome", "რომი" },
            { "timezone.excity.Indian/Mahe", "მაჰე" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "აკრა" },
            { "timezone.excity.Africa/Cairo", "კაირო" },
            { "timezone.excity.Africa/Ceuta", "სეუტა" },
            { "timezone.excity.Africa/Dakar", "დაკარი" },
            { "timezone.excity.Africa/Lagos", "ლაგოსი" },
            { "timezone.excity.Africa/Tunis", "ტუნისი" },
            { "timezone.excity.America/Adak", "ადაკი" },
            { "timezone.excity.America/Lima", "ლიმა" },
            { "timezone.excity.America/Nome", "ნომი" },
            { "timezone.excity.Asia/Baghdad", "ბაღდადი" },
            { "timezone.excity.Asia/Bahrain", "ბაჰრეინი" },
            { "timezone.excity.Asia/Bangkok", "ბანგკოკი" },
            { "timezone.excity.Asia/Barnaul", "ბარნაული" },
            { "timezone.excity.Asia/Bishkek", "ბიშკეკი" },
            { "timezone.excity.Asia/Colombo", "კოლომბო" },
            { "timezone.excity.Asia/Irkutsk", "ირკუტსკი" },
            { "timezone.excity.Asia/Jakarta", "ჯაკარტა" },
            { "timezone.excity.Asia/Karachi", "კარაჩი" },
            { "timezone.excity.Asia/Kuching", "კუჩინგი" },
            { "timezone.excity.Asia/Magadan", "მაგადანი" },
            { "timezone.excity.Asia/Nicosia", "ნიკოსია" },
            { "timezone.excity.Asia/Rangoon", "რანგუნი" },
            { "timezone.excity.Asia/Tbilisi", "თბილისი" },
            { "timezone.excity.Asia/Thimphu", "თხიმფხუ" },
            { "timezone.excity.Asia/Yakutsk", "იაკუტსკი" },
            { "timezone.excity.Asia/Yerevan", "ერევანი" },
            { "timezone.excity.Europe/Kirov", "კიროვი" },
            { "timezone.excity.Europe/Malta", "მალტა" },
            { "timezone.excity.Europe/Minsk", "მინსკი" },
            { "timezone.excity.Europe/Paris", "პარიზი" },
            { "timezone.excity.Europe/Sofia", "სოფია" },
            { "timezone.excity.Europe/Vaduz", "ვადუცი" },
            { "timezone.excity.Indian/Cocos", "ქოქოსი" },
            { "timezone.excity.Pacific/Apia", "აპია" },
            { "timezone.excity.Pacific/Fiji", "ფიჯი" },
            { "timezone.excity.Pacific/Guam", "გუამი" },
            { "timezone.excity.Pacific/Niue", "ნიუე" },
            { "timezone.excity.Pacific/Truk", "ჩუუკი" },
            { "timezone.excity.Pacific/Wake", "უეიკი" },
            { "timezone.excity.Africa/Asmera", "ასმარა" },
            { "timezone.excity.Africa/Bamako", "ბამაკო" },
            { "timezone.excity.Africa/Bangui", "ბანგი" },
            { "timezone.excity.Africa/Banjul", "ბანჯული" },
            { "timezone.excity.Africa/Bissau", "ბისაუ" },
            { "timezone.excity.Africa/Douala", "დუალა" },
            { "timezone.excity.Africa/Harare", "ჰარარე" },
            { "timezone.excity.Africa/Kigali", "კიგალი" },
            { "timezone.excity.Africa/Luanda", "ლუანდა" },
            { "timezone.excity.Africa/Lusaka", "ლუსაკა" },
            { "timezone.excity.Africa/Malabo", "მალაბო" },
            { "timezone.excity.Africa/Maputo", "მაპუტო" },
            { "timezone.excity.Africa/Maseru", "მასერუ" },
            { "timezone.excity.Africa/Niamey", "ნიამეი" },
            { "timezone.excity.America/Aruba", "არუბა" },
            { "timezone.excity.America/Bahia", "ბაია" },
            { "timezone.excity.America/Belem", "ბელემი" },
            { "timezone.excity.America/Boise", "ბუასი" },
            { "timezone.excity.America/Jujuy", "ჯუჯუი" },
            { "timezone.excity.America/Sitka", "სიტკა" },
            { "timezone.excity.America/Thule", "თულე" },
            { "timezone.excity.Asia/Ashgabat", "აშხაბადი" },
            { "timezone.excity.Asia/Calcutta", "კალკუტა" },
            { "timezone.excity.Asia/Damascus", "დამასკი" },
            { "timezone.excity.Asia/Dushanbe", "დუშანბე" },
            { "timezone.excity.Asia/Jayapura", "ჯაიაპურა" },
            { "timezone.excity.Asia/Katmandu", "კატმანდუ" },
            { "timezone.excity.Asia/Khandyga", "ხანდიგა" },
            { "timezone.excity.Asia/Makassar", "მაკასარი" },
            { "timezone.excity.Asia/Qostanay", "კოსტანაი" },
            { "timezone.excity.Asia/Sakhalin", "სახალინი" },
            { "timezone.excity.Asia/Shanghai", "შანხაი" },
            { "timezone.excity.Asia/Tashkent", "ტაშკენტი" },
            { "timezone.excity.Asia/Ust-Nera", "უსტ-ნერა" },
            { "timezone.excity.Europe/Athens", "ათენი" },
            { "timezone.excity.Europe/Berlin", "ბერლინი" },
            { "timezone.excity.Europe/Dublin", "დუბლინი" },
            { "timezone.excity.Europe/Jersey", "ჯერსი" },
            { "timezone.excity.Europe/Lisbon", "ლისაბონი" },
            { "timezone.excity.Europe/London", "ლონდონი" },
            { "timezone.excity.Europe/Madrid", "მადრიდი" },
            { "timezone.excity.Europe/Monaco", "მონაკო" },
            { "timezone.excity.Europe/Moscow", "მოსკოვი" },
            { "timezone.excity.Europe/Prague", "პრაღა" },
            { "timezone.excity.Europe/Samara", "სამარა" },
            { "timezone.excity.Europe/Skopje", "სკოპიე" },
            { "timezone.excity.Europe/Tirane", "ტირანა" },
            { "timezone.excity.Europe/Vienna", "ვენა" },
            { "timezone.excity.Europe/Warsaw", "ვარშავა" },
            { "timezone.excity.Europe/Zagreb", "ზაგრები" },
            { "timezone.excity.Europe/Zurich", "ციურიხი" },
            { "timezone.excity.Indian/Chagos", "ჩაგოსი" },
            { "timezone.excity.Indian/Comoro", "კომორო" },
            { "timezone.excity.Pacific/Efate", "ეფატე" },
            { "timezone.excity.Pacific/Nauru", "ნაურუ" },
            { "timezone.excity.Pacific/Palau", "პალაუ" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "აბიჯანი" },
            { "timezone.excity.Africa/Algiers", "ალჟირი" },
            { "timezone.excity.Africa/Conakry", "კონაკრი" },
            { "timezone.excity.Africa/Kampala", "კამპალა" },
            { "timezone.excity.Africa/Mbabane", "მბაბანე" },
            { "timezone.excity.Africa/Nairobi", "ნაირობი" },
            { "timezone.excity.Africa/Tripoli", "ტრიპოლი" },
            { "timezone.excity.America/Belize", "ბელიზი" },
            { "timezone.excity.America/Bogota", "ბოგოტა" },
            { "timezone.excity.America/Cancun", "კანკუნი" },
            { "timezone.excity.America/Cayman", "კაიმანი" },
            { "timezone.excity.America/Cuiaba", "კუიაბა" },
            { "timezone.excity.America/Dawson", "დოუსონი" },
            { "timezone.excity.America/Denver", "დენვერი" },
            { "timezone.excity.America/Guyana", "გაიანა" },
            { "timezone.excity.America/Havana", "ჰავანა" },
            { "timezone.excity.America/Inuvik", "ინუვიკი" },
            { "timezone.excity.America/Juneau", "ჯუნო" },
            { "timezone.excity.America/La_Paz", "ლა-პაზი" },
            { "timezone.excity.America/Maceio", "მასეიო" },
            { "timezone.excity.America/Manaus", "მანაუსი" },
            { "timezone.excity.America/Merida", "მერიდა" },
            { "timezone.excity.America/Nassau", "ნასაუ" },
            { "timezone.excity.America/Panama", "პანამა" },
            { "timezone.excity.America/Recife", "რეციფე" },
            { "timezone.excity.America/Regina", "რეჯინა" },
            { "timezone.excity.Asia/Famagusta", "ფამაგუსტა" },
            { "timezone.excity.Asia/Hong_Kong", "ჰონკონგი" },
            { "timezone.excity.Asia/Jerusalem", "იერუსალიმი" },
            { "timezone.excity.Asia/Kamchatka", "კამჩატკა" },
            { "timezone.excity.Asia/Pontianak", "პონტიანაკი" },
            { "timezone.excity.Asia/Pyongyang", "ფხენიანი" },
            { "timezone.excity.Asia/Qyzylorda", "ყიზილორდა" },
            { "timezone.excity.Asia/Samarkand", "სამარყანდი" },
            { "timezone.excity.Asia/Singapore", "სინგაპური" },
            { "timezone.excity.Asia/Vientiane", "ვიენტიანი" },
            { "timezone.excity.Europe/Andorra", "ანდორა" },
            { "timezone.excity.Europe/Saratov", "სარატოვი" },
            { "timezone.excity.Europe/Tallinn", "ტალინი" },
            { "timezone.excity.Europe/Vatican", "ვატიკანი" },
            { "timezone.excity.Europe/Vilnius", "ვილნიუსი" },
            { "timezone.excity.Indian/Mayotte", "მაიოტი" },
            { "timezone.excity.Indian/Reunion", "რეიუნიონი" },
            { "timezone.excity.Pacific/Easter", "ისთერი" },
            { "timezone.excity.Pacific/Kosrae", "კოსრაე" },
            { "timezone.excity.Pacific/Majuro", "მახურო" },
            { "timezone.excity.Pacific/Midway", "მიდუეი" },
            { "timezone.excity.Pacific/Noumea", "ნუმეა" },
            { "timezone.excity.Pacific/Ponape", "პონპეი" },
            { "timezone.excity.Pacific/Saipan", "საიპანი" },
            { "timezone.excity.Pacific/Tahiti", "ტაიტი" },
            { "timezone.excity.Pacific/Tarawa", "ტარაუა" },
            { "timezone.excity.Pacific/Wallis", "ვალისი" },
            { "timezone.excity.Africa/Blantyre", "ბლანტირი" },
            { "timezone.excity.Africa/Djibouti", "ჯიბუტი" },
            { "timezone.excity.Africa/El_Aaiun", "ელ-ააიუნი" },
            { "timezone.excity.Africa/Freetown", "ფრიტაუნი" },
            { "timezone.excity.Africa/Gaborone", "გაბორონე" },
            { "timezone.excity.Africa/Khartoum", "ხარტუმი" },
            { "timezone.excity.Africa/Kinshasa", "კინშასა" },
            { "timezone.excity.Africa/Monrovia", "მონროვია" },
            { "timezone.excity.Africa/Ndjamena", "ნჯამენა" },
            { "timezone.excity.Africa/Sao_Tome", "სენ-ტომე" },
            { "timezone.excity.Africa/Windhoek", "ვინდხუკი" },
            { "timezone.excity.America/Antigua", "ანტიგუა" },
            { "timezone.excity.America/Caracas", "კარაკასი" },
            { "timezone.excity.America/Cayenne", "კაიენა" },
            { "timezone.excity.America/Chicago", "ჩიკაგო" },
            { "timezone.excity.America/Cordoba", "კორდობა" },
            { "timezone.excity.America/Creston", "კრესტონი" },
            { "timezone.excity.America/Curacao", "კიურასაო" },
            { "timezone.excity.America/Detroit", "დეტროიტი" },
            { "timezone.excity.America/Godthab", "გოდთები" },
            { "timezone.excity.America/Grenada", "გრენადა" },
            { "timezone.excity.America/Halifax", "ჰალიფაქსი" },
            { "timezone.excity.America/Iqaluit", "იქალუიტი" },
            { "timezone.excity.America/Jamaica", "იამაიკა" },
            { "timezone.excity.America/Managua", "მანაგუა" },
            { "timezone.excity.America/Marigot", "მარიგო" },
            { "timezone.excity.America/Mendoza", "მენდოზა" },
            { "timezone.excity.America/Moncton", "მონქტონი" },
            { "timezone.excity.America/Noronha", "ნორონია" },
            { "timezone.excity.America/Ojinaga", "ოხინაგა" },
            { "timezone.excity.America/Phoenix", "ფენიქსი" },
            { "timezone.excity.America/Tijuana", "ტიხუანა" },
            { "timezone.excity.America/Toronto", "ტორონტო" },
            { "timezone.excity.America/Tortola", "ტორტოლა" },
            { "timezone.excity.America/Yakutat", "იაკუტატი" },
            { "timezone.excity.Asia/Phnom_Penh", "პნომპენი" },
            { "timezone.excity.Atlantic/Azores", "აზორის კუნძულები" },
            { "timezone.excity.Atlantic/Canary", "კანარი" },
            { "timezone.excity.Atlantic/Faeroe", "ფარერის კუნძულები" },
            { "timezone.excity.Australia/Eucla", "ეუკლა" },
            { "timezone.excity.Australia/Perth", "პერთი" },
            { "timezone.excity.Europe/Belgrade", "ბელგრადი" },
            { "timezone.excity.Europe/Brussels", "ბრიუსელი" },
            { "timezone.excity.Europe/Budapest", "ბუდაპეშტი" },
            { "timezone.excity.Europe/Busingen", "ბუსინგენი" },
            { "timezone.excity.Europe/Chisinau", "კიშინიოვი" },
            { "timezone.excity.Europe/Guernsey", "გერნსი" },
            { "timezone.excity.Europe/Helsinki", "ჰელსინკი" },
            { "timezone.excity.Europe/Istanbul", "სტამბოლი" },
            { "timezone.excity.Europe/Sarajevo", "სარაევო" },
            { "timezone.excity.Indian/Maldives", "მალდივები" },
            { "timezone.excity.Pacific/Chatham", "ჩათამი" },
            { "timezone.excity.Pacific/Fakaofo", "ფაკაოფო" },
            { "timezone.excity.Pacific/Gambier", "გამბიერი" },
            { "timezone.excity.Pacific/Norfolk", "ნორფოლკი" },
            { "timezone.excity.Africa/Bujumbura", "ბუჯუმბურა" },
            { "timezone.excity.Africa/Mogadishu", "მოგადიშუ" },
            { "timezone.excity.America/Anguilla", "ანგილია" },
            { "timezone.excity.America/Asuncion", "ასუნსიონი" },
            { "timezone.excity.America/Barbados", "ბარბადოსი" },
            { "timezone.excity.America/Dominica", "დომინიკა" },
            { "timezone.excity.America/Edmonton", "ედმონტონი" },
            { "timezone.excity.America/Eirunepe", "ეირუნეპე" },
            { "timezone.excity.America/Mazatlan", "მაზატლანი" },
            { "timezone.excity.America/Miquelon", "მიკელონი" },
            { "timezone.excity.America/New_York", "ნიუ-იორკი" },
            { "timezone.excity.America/Resolute", "რეზოლუტე" },
            { "timezone.excity.America/Santarem", "სანტარემი" },
            { "timezone.excity.America/Santiago", "სანტიაგო" },
            { "timezone.excity.America/St_Johns", "სენტ-ჯონსი" },
            { "timezone.excity.America/St_Kitts", "სენტ-კიტსი" },
            { "timezone.excity.America/St_Lucia", "სენტ-ლუსია" },
            { "timezone.excity.America/Winnipeg", "უინიპეგი" },
            { "timezone.excity.Antarctica/Casey", "კეისი" },
            { "timezone.excity.Antarctica/Davis", "დევისი" },
            { "timezone.excity.Antarctica/Syowa", "სიოუა" },
            { "timezone.excity.Antarctica/Troll", "ტროლი" },
            { "timezone.excity.Asia/Krasnoyarsk", "კრასნოიარსკი" },
            { "timezone.excity.Asia/Novosibirsk", "ნოვოსიბირსკი" },
            { "timezone.excity.Asia/Ulaanbaatar", "ულანბატარი" },
            { "timezone.excity.Asia/Vladivostok", "ვლადივოსტოკი" },
            { "timezone.excity.Atlantic/Bermuda", "ბერმუდა" },
            { "timezone.excity.Atlantic/Madeira", "მადეირა" },
            { "timezone.excity.Atlantic/Stanley", "სტენლი" },
            { "timezone.excity.Australia/Darwin", "დარვინი" },
            { "timezone.excity.Australia/Hobart", "ჰობარტი" },
            { "timezone.excity.Australia/Sydney", "სიდნეი" },
            { "timezone.excity.Europe/Amsterdam", "ამსტერდამი" },
            { "timezone.excity.Europe/Astrakhan", "ასტრახანი" },
            { "timezone.excity.Europe/Bucharest", "ბუქარესტი" },
            { "timezone.excity.Europe/Gibraltar", "გიბრალტარი" },
            { "timezone.excity.Europe/Ljubljana", "ლიუბლიანა" },
            { "timezone.excity.Europe/Mariehamn", "მარიჰამნი" },
            { "timezone.excity.Europe/Podgorica", "პოდგორიცა" },
            { "timezone.excity.Europe/Stockholm", "სტოკჰოლმი" },
            { "timezone.excity.Europe/Ulyanovsk", "ულიანოვსკი" },
            { "timezone.excity.Europe/Volgograd", "ვოლგოგრადი" },
            { "timezone.excity.Indian/Christmas", "შობის კუნძული" },
            { "timezone.excity.Indian/Kerguelen", "კერგელენი" },
            { "timezone.excity.Indian/Mauritius", "მავრიკი" },
            { "timezone.excity.Pacific/Auckland", "ოკლენდი" },
            { "timezone.excity.Pacific/Funafuti", "ფუნაფუტი" },
            { "timezone.excity.Pacific/Honolulu", "ჰონოლულუ" },
            { "timezone.excity.Pacific/Pitcairn", "პიტკერნი" },
            { "timezone.excity.Africa/Casablanca", "კასაბლანკა" },
            { "timezone.excity.Africa/Libreville", "ლიბრევილი" },
            { "timezone.excity.Africa/Lubumbashi", "ლუბუმბაში" },
            { "timezone.excity.Africa/Nouakchott", "ნუაკშოტი" },
            { "timezone.excity.Africa/Porto-Novo", "პორტო-ნოვო" },
            { "timezone.excity.America/Anchorage", "ენქორაჯი" },
            { "timezone.excity.America/Araguaina", "არაგუაინა" },
            { "timezone.excity.America/Boa_Vista", "ბოა ვისტა" },
            { "timezone.excity.America/Catamarca", "კატამარკა" },
            { "timezone.excity.America/Chihuahua", "ჩიჰუაჰუა" },
            { "timezone.excity.America/Coyhaique", "კოიჰაიკე" },
            { "timezone.excity.America/Fortaleza", "ფორტალეზა" },
            { "timezone.excity.America/Glace_Bay", "გლეის ბეი" },
            { "timezone.excity.America/Goose_Bay", "გუზ ბეი" },
            { "timezone.excity.America/Guatemala", "გვატემალა" },
            { "timezone.excity.America/Guayaquil", "გუაიაკილი" },
            { "timezone.excity.America/Matamoros", "მატამოროსი" },
            { "timezone.excity.America/Menominee", "მენომინი" },
            { "timezone.excity.America/Monterrey", "მონტერეი" },
            { "timezone.excity.America/Sao_Paulo", "სან-პაულუ" },
            { "timezone.excity.America/St_Thomas", "სენ-ტომასი" },
            { "timezone.excity.America/Vancouver", "ვანკუვერი" },
            { "timezone.excity.Antarctica/Mawson", "მოუსონი" },
            { "timezone.excity.Antarctica/Palmer", "პალმერი" },
            { "timezone.excity.Antarctica/Vostok", "ვოსტოკი" },
            { "timezone.excity.Asia/Kuala_Lumpur", "კუალა-ლუმპური" },
            { "timezone.excity.Asia/Novokuznetsk", "ნოვოკუზნეცკი" },
            { "timezone.excity.Europe/Bratislava", "ბრატისლავა" },
            { "timezone.excity.Europe/Copenhagen", "კოპენჰაგენი" },
            { "timezone.excity.Europe/Luxembourg", "ლუქსემბურგი" },
            { "timezone.excity.Europe/San_Marino", "სან-მარინო" },
            { "timezone.excity.Europe/Simferopol", "სიმფეროპოლი" },
            { "timezone.excity.Pacific/Enderbury", "კანტონი" },
            { "timezone.excity.Pacific/Galapagos", "გალაპაგოსი" },
            { "timezone.excity.Pacific/Kwajalein", "კვაჯალეინი" },
            { "timezone.excity.Pacific/Marquesas", "მარკეზასი" },
            { "timezone.excity.Pacific/Pago_Pago", "პაგო-პაგო" },
            { "timezone.excity.Pacific/Rarotonga", "რაროტონგა" },
            { "timezone.excity.Pacific/Tongatapu", "ტონგატაპუ" },
            { "timezone.excity.Africa/Addis_Ababa", "ადის-აბება" },
            { "timezone.excity.Africa/Brazzaville", "ბრაზავილი" },
            { "timezone.excity.Africa/Ouagadougou", "უაგადუგუ" },
            { "timezone.excity.America/Costa_Rica", "კოსტა-რიკა" },
            { "timezone.excity.America/Grand_Turk", "გრანდ-ტურკი" },
            { "timezone.excity.America/Guadeloupe", "გვადელუპა" },
            { "timezone.excity.America/Hermosillo", "ჰერმოსილო" },
            { "timezone.excity.America/Kralendijk", "კრალენდიიკი" },
            { "timezone.excity.America/Louisville", "ლუისვილი" },
            { "timezone.excity.America/Martinique", "მარტინიკი" },
            { "timezone.excity.America/Metlakatla", "მეტლაკატლა" },
            { "timezone.excity.America/Montevideo", "მონტევიდეო" },
            { "timezone.excity.America/Montserrat", "მონსერატი" },
            { "timezone.excity.America/Paramaribo", "პარამარიბო" },
            { "timezone.excity.America/Rio_Branco", "რიო ბრანკო" },
            { "timezone.excity.America/St_Vincent", "სენ-ვინსენტი" },
            { "timezone.excity.America/Whitehorse", "უაითჰორსი" },
            { "timezone.excity.Antarctica/McMurdo", "მაკმურდო" },
            { "timezone.excity.Antarctica/Rothera", "როთერა" },
            { "timezone.excity.Asia/Srednekolymsk", "სრედნეკოლიმსკი" },
            { "timezone.excity.Asia/Yekaterinburg", "ეკატერინბურგი" },
            { "timezone.excity.Atlantic/Reykjavik", "რეიკიავიკი" },
            { "timezone.excity.Atlantic/St_Helena", "წმ. ელენეს კუნძული" },
            { "timezone.excity.Australia/Adelaide", "ადელაიდა" },
            { "timezone.excity.Australia/Brisbane", "ბრისბეინი" },
            { "timezone.excity.Australia/Lindeman", "ლინდმანი" },
            { "timezone.excity.Europe/Isle_of_Man", "მენის კუნძული" },
            { "timezone.excity.Europe/Kaliningrad", "კალინინგრადი" },
            { "timezone.excity.Pacific/Kiritimati", "კირიტიმატი" },
            { "timezone.excity.Africa/Johannesburg", "იოჰანესბურგი" },
            { "timezone.excity.America/El_Salvador", "სალვადორი" },
            { "timezone.excity.America/Fort_Nelson", "ფორტ-ნელსონი" },
            { "timezone.excity.America/Los_Angeles", "ლოს-ანჯელესი" },
            { "timezone.excity.America/Mexico_City", "მეხიკო" },
            { "timezone.excity.America/Porto_Velho", "პორტუ-ველიო" },
            { "timezone.excity.America/Puerto_Rico", "პუერტო-რიკო" },
            { "timezone.excity.America/Tegucigalpa", "ტეგუჩიგალპა" },
            { "timezone.excity.Arctic/Longyearbyen", "ლონგირბიენი" },
            { "timezone.excity.Atlantic/Cape_Verde", "კაბო-ვერდე" },
            { "timezone.excity.Australia/Lord_Howe", "ლორდ ჰოუი" },
            { "timezone.excity.Australia/Melbourne", "მელბურნი" },
            { "timezone.excity.Indian/Antananarivo", "ანტანანარივუ" },
            { "timezone.excity.Pacific/Guadalcanal", "გვადალკანალი" },
            { "timezone.excity.Africa/Dar_es_Salaam", "დარ-ეს-სალამი" },
            { "timezone.excity.America/Blanc-Sablon", "ბლან-საბლონი" },
            { "timezone.excity.America/Buenos_Aires", "ბუენოს-აირესი" },
            { "timezone.excity.America/Campo_Grande", "კამპო გრანდე" },
            { "timezone.excity.America/Danmarkshavn", "დენმარკშავნი" },
            { "timezone.excity.America/Dawson_Creek", "დოუსონ ქრიკი" },
            { "timezone.excity.America/Indiana/Knox", "ნოქსი, ინდიანა" },
            { "timezone.excity.America/Indianapolis", "ინდიანაპოლისი" },
            { "timezone.excity.America/Punta_Arenas", "პუნტა-არენასი" },
            { "timezone.excity.America/Rankin_Inlet", "რენკინ ინლეტი" },
            { "timezone.excity.America/Scoresbysund", "სკორსბისუნდი" },
            { "timezone.excity.Antarctica/Macquarie", "მექვორი" },
            { "timezone.excity.Pacific/Bougainville", "ბუგენვილი" },
            { "timezone.excity.Pacific/Port_Moresby", "პორტ მორსბი" },
            { "timezone.excity.America/Cambridge_Bay", "კემბრიჯ ბეი" },
            { "timezone.excity.America/Ciudad_Juarez", "სიუდად-ხუარესი" },
            { "timezone.excity.America/Coral_Harbour", "ატიკოკანი" },
            { "timezone.excity.America/Indiana/Vevay", "ვივეი, ინდიანა" },
            { "timezone.excity.America/Lower_Princes", "ლოერ პრინც კვორტერი" },
            { "timezone.excity.America/Port_of_Spain", "პორტ-ოვ-სპეინი" },
            { "timezone.excity.America/Santo_Domingo", "სანტო-დომინგო" },
            { "timezone.excity.America/St_Barthelemy", "სენ-ბართელემი" },
            { "timezone.excity.America/Swift_Current", "სვიფტ კარენტი" },
            { "timezone.excity.Australia/Broken_Hill", "ბროუკენ ჰილი" },
            { "timezone.excity.America/Bahia_Banderas", "ბაჰია ბანდერასი" },
            { "timezone.excity.America/Port-au-Prince", "პორტ-ა-პრინსი" },
            { "timezone.excity.Atlantic/South_Georgia", "სამხრეთ ჯორჯია" },
            { "timezone.excity.America/Argentina/Salta", "სალტა" },
            { "timezone.excity.America/Indiana/Marengo", "მარენგო, ინდიანა" },
            { "timezone.excity.America/Indiana/Winamac", "უინემაკი, ინდიანა" },
            { "timezone.excity.America/Argentina/Tucuman", "ტუკუმანი" },
            { "timezone.excity.America/Argentina/Ushuaia", "უშუაია" },
            { "timezone.excity.America/Indiana/Tell_City", "თელ სითი, ინდიანა" },
            { "timezone.excity.America/Indiana/Vincennes", "ვინსენი, ინდიანა" },
            { "timezone.excity.Antarctica/DumontDUrville", "დიუმონ დ’ურვილი" },
            { "timezone.excity.America/Argentina/La_Rioja", "ლა რიოხა" },
            { "timezone.excity.America/Argentina/San_Juan", "სან ხუანი" },
            { "timezone.excity.America/Argentina/San_Luis", "სან-ლუისი" },
            { "timezone.excity.America/Indiana/Petersburg", "პიტერსბურგი, ინდიანა" },
            { "timezone.excity.America/Kentucky/Monticello", "მონტიჩელო, კენტუკი" },
            { "timezone.excity.America/North_Dakota/Beulah", "ბიულა, ჩრდილოეთი დაკოტა" },
            { "timezone.excity.America/North_Dakota/Center", "ცენტრი, ჩრდილოეთი დაკოტა" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "რიო გალეგოსი" },
            { "timezone.excity.America/North_Dakota/New_Salem", "ნიუ-სალემი, ჩრდილოეთი დაკოტა" },
        };
        return data;
    }
}
