/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_kok extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "ग्रीनविच मध्य वेळ",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "अपिया प्रमाणित वेळ",
               "",
               "अपिया डेलायट वेळ",
               "",
               "अपिया वेळ",
               "",
            };
        final String[] Cook = new String[] {
               "कूक आयलँड प्रमाणित वेळ",
               "",
               "कूक आयलँड अर्द ग्रीष्म वेळ",
               "",
               "कूक आयलँड वेळ",
               "",
            };
        final String[] Cuba = new String[] {
               "क्युबा प्रमाणीत वेळ",
               "CST",
               "क्युबा डेलायट वेळ",
               "CDT",
               "क्युबा वेळ",
               "CT",
            };
        final String[] Fiji = new String[] {
               "फिजी प्रमाणित वेळ",
               "",
               "फिजी ग्रीष्म वेळ",
               "",
               "फिजी वेळ",
               "",
            };
        final String[] Gulf = new String[] {
               "गल्फ प्रमाणित वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "होव्हड प्रमाणित वेळ",
               "",
               "होव्हड ग्रीष्म वेळ",
               "",
               "होव्हड",
               "",
            };
        final String[] Iran = new String[] {
               "इरान प्रमाणित वेळ",
               "",
               "इरान डेलायट वेळ",
               "",
               "इरान",
               "",
            };
        final String[] Niue = new String[] {
               "न्युए वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "ओम्स्क प्रमाणित वेळ",
               "",
               "ओम्स्क ग्रीष्म वेळ",
               "",
               "ओम्स्क वेळ",
               "",
            };
        final String[] Peru = new String[] {
               "पेरू प्रमाणित वेळ",
               "",
               "पेरू ग्रीष्म वेळ",
               "",
               "पेरू वेळ",
               "",
            };
        final String[] Truk = new String[] {
               "चुक वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "वैक आयलँड वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "चिली प्रमाणित वेळ",
               "",
               "चिली ग्रीष्म वेळ",
               "",
               "चिली वेळ",
               "",
            };
        final String[] China = new String[] {
               "चीन प्रमाणित वेळ",
               "CST",
               "चीन डेलायट वेळ",
               "CDT",
               "चीन वेळ",
               "CT",
            };
        final String[] Cocos = new String[] {
               "कोकोस आयलँड वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "डेव्हीस वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "भारतीय प्रमाणित वेळ",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "जपान प्रमाणित वेळ",
               "JST",
               "जपान डेलायट वेळ",
               "JDT",
               "जपान वेळ",
               "JT",
            };
        final String[] Korea = new String[] {
               "कोरियन प्रमाणित वेळ",
               "KST",
               "कोरियन डेलायट वेळ",
               "KST",
               "कोरियन वेळ",
               "KST",
            };
        final String[] Nauru = new String[] {
               "नरू वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "नेपाळ वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "पलाऊ वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "सामोआ प्रमाणित वेळ",
               "SST",
               "सामोआ डेलायट वेळ",
               "SST",
               "सामोआ वेळ",
               "SST",
            };
        final String[] Syowa = new String[] {
               "स्योवा वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "टोंगा प्रमाणित वेळ",
               "",
               "टोंगा ग्रीष्म वेळ",
               "",
               "टोंगा वेळ",
               "",
            };
        final String[] Yukon = new String[] {
               "युकॉन वेळ",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "अलास्का प्रमाणीत वेळ",
               "AKST",
               "अलास्का डेलायट वेळ",
               "AKDT",
               "अलास्का वेळ",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "अमेझोन प्रमाणित वेळ",
               "",
               "अमेझोन ग्रीष्म वेळ",
               "",
               "अमेझोन वेळ",
               "",
            };
        final String[] Azores = new String[] {
               "अझोरेस प्रमाणित वेळ",
               "",
               "अझोरेस ग्रीष्म वेळ",
               "",
               "अझोरेस",
               "",
            };
        final String[] Bhutan = new String[] {
               "भूतान",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "ब्रुनेइ दारूस्सलाम वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "ईस्टर आयलँड प्रमाणित वेळ",
               "",
               "ईस्टर आयलँड ग्रीष्म वेळ",
               "",
               "ईस्टर आयलँड वेळ",
               "",
            };
        final String[] Guyana = new String[] {
               "गुयाना वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "हवाई-अलेयुशिन प्रमाणीत वेळ",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "इज़राइल प्रमाणित वेळ",
               "IST",
               "इज़राइल डेलायट वेळ",
               "IDT",
               "इज़राइल वेळ",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "कोसरे वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "मॉसन वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "मॉस्को प्रमाणित वेळ",
               "MSK",
               "मॉस्को ग्रीष्म वेळ",
               "MSK",
               "मॉस्को वेळ",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "पोनेप वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "ताहिती वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "तैपेई प्रमाणित वेळ",
               "CST",
               "तैपेई डेलायट वेळ",
               "CDT",
               "तैपेई वेळ",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "टुवालू वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "वोस्तोक वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "वालिस आनी फ्यूचूना वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "अरबी प्रमाणित वेळ",
               "",
               "अरबी डेलायट वेळ",
               "",
               "अरबी वेळ",
               "",
            };
        final String[] Armenia = new String[] {
               "आर्मेनिया प्रमाणित वेळ",
               "",
               "आर्मेनिया ग्रीष्म वेळ",
               "",
               "आर्मेनिया वेळ",
               "",
            };
        final String[] Bolivia = new String[] {
               "बोलिव्हिया वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "चॅथम प्रमाणित वेळ",
               "",
               "चॅथम डेलायट वेळ",
               "",
               "चॅथम वेळ",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "समन्वित वैश्विक वेळ",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "इक्वेडोर वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "गाम्बियर वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "जॉर्जिया प्रमाणित वेळ",
               "",
               "जॉर्जिया ग्रीष्म वेळ",
               "",
               "जॉर्जिया वेळ",
               "",
            };
        final String[] Irkutsk = new String[] {
               "ईर्कुटस्क प्रमाणित वेळ",
               "",
               "ईर्कुटस्क ग्रीष्म वेळ",
               "",
               "इर्कुटस्क वेळ",
               "",
            };
        final String[] Magadan = new String[] {
               "मगादान प्रमाणित वेळ",
               "",
               "मगादान ग्रीष्म वेळ",
               "",
               "मगादान वेळ",
               "",
            };
        final String[] Myanmar = new String[] {
               "म्यानमार वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "नॉरफॉक आयलँड प्रमाणित वेळ",
               "",
               "नॉरफॉक आयलँड ग्रीष्म वेळ",
               "",
               "नॉरफॉक आयलँड वेळ",
               "",
            };
        final String[] Noronha = new String[] {
               "फर्नांडो दी नोरोन्हा प्रमाणित वेळ",
               "",
               "फर्नांडो दी नोरोन्हा ग्रीष्म वेळ",
               "",
               "फर्नांडो दी नोरोन्हा वेळ",
               "",
            };
        final String[] Reunion = new String[] {
               "रियुनियन वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "रोथेरा वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "सोलोमन आइलँड्स वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "टोकलाऊ वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "उरुग्वे प्रमाणित वेळ",
               "",
               "उरुग्वे ग्रीष्म वेळ",
               "",
               "उरुग्वे वेळ",
               "",
            };
        final String[] Vanuatu = new String[] {
               "वनातू प्रमाणित वेळ",
               "",
               "वनातू ग्रीष्म वेळ",
               "",
               "वनातू वेळ",
               "",
            };
        final String[] Yakutsk = new String[] {
               "यकुत्स्क प्रमाणित वेळ",
               "",
               "यकुत्स्क ग्रीष्म वेळ",
               "",
               "यकुत्स्क वेळ",
               "",
            };
        final String[] Atlantic = new String[] {
               "अटलांटीक प्रमाणित वेळ",
               "AST",
               "अटलांटीक डेलायट वेळ",
               "AST",
               "अटलांटीक वेळ",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "ब्राझिलिया प्रमाणित वेळ",
               "",
               "ब्राझिलिया ग्रीष्म वेळ",
               "",
               "ब्राझिलिया वेळ",
               "",
            };
        final String[] Chamorro = new String[] {
               "कॅमोरा प्रमाणित वेळ",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "कोलंबिया प्रमाणित वेळ",
               "",
               "कोलंबिया ग्रीष्म वेळ",
               "",
               "कोलंबिया वेळ",
               "",
            };
        final String[] Falkland = new String[] {
               "फॉकलँड आयलँड्स प्रमाणित वेळ",
               "",
               "फॉकलँड आयलँड्स ग्रीष्म वेळ",
               "",
               "फॉकलँड आयलँड्स वेळ",
               "",
            };
        final String[] Malaysia = new String[] {
               "मलेशिया वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "मालदीव वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "उलानबतार प्रमाणित वेळ",
               "",
               "उलानबतार ग्रीष्म वेळ",
               "",
               "उलानबतार वेळ",
               "",
            };
        final String[] Pakistan = new String[] {
               "पाकिस्तान प्रमाणित वेळ",
               "PKT",
               "पाकिस्तान ग्रीष्म वेळ",
               "PKST",
               "पाकिस्तान",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "परागुआ प्रमाणित वेळ",
               "",
               "परागुआ ग्रीष्म वेळ",
               "",
               "परागुआ वेळ",
               "",
            };
        final String[] Pitcairn = new String[] {
               "पिटकॅरन वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "सुरिनाम वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "अर्जेंटिना प्रमाणित वेळ",
               "",
               "अर्जेंटिना ग्रीष्म वेळ",
               "",
               "अर्जेंटिना वेळ",
               "",
            };
        final String[] Christmas = new String[] {
               "क्रिसमस आयलँड वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "गालापागोस वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "हाँग काँग प्रमाणित वेळ",
               "HKT",
               "हाँग काँग ग्रीष्म वेळ",
               "HKST",
               "हाँग काँग वेळ",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "इंडोचीन वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "किर्गिज़स्तान वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "लॉर्ड होवे प्रमाणित वेळ",
               "",
               "लॉर्ड होवे डेलायट वेळ",
               "",
               "लॉर्ड होवे वेळ",
               "",
            };
        final String[] Marquesas = new String[] {
               "मार्किसस वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "मॉरिशस प्रमाणित वेळ",
               "",
               "मॉरिशस ग्रीष्म वेळ",
               "",
               "मॉरिशस वेळ",
               "",
            };
        final String[] Singapore = new String[] {
               "सिंगापूर प्रमाणित वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "वेनेझुएला वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "अजरबैजान प्रमाणित वेळ",
               "",
               "अजरबैजान ग्रीष्म वेळ",
               "",
               "अजरबैजान वेळ",
               "",
            };
        final String[] Bangladesh = new String[] {
               "बांगलादेश प्रमाणित वेळ",
               "",
               "बांगलादेश ग्रीष्म वेळ",
               "",
               "बांगलादेश वेळ",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "केप वर्दे प्रमाणित वेळ",
               "",
               "केप वर्दे ग्रीष्म वेळ",
               "",
               "केप वर्दे वेळ",
               "",
            };
        final String[] East_Timor = new String[] {
               "उदेंत तिमोर वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "कझाखस्तान वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "सेशेल्स वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "तजीकिस्तान वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "उज़्बेकिस्तान प्रमाणित वेळ",
               "",
               "उज़्बेकिस्तान ग्रीष्म वेळ",
               "",
               "उज़्बेकिस्तान वेळ",
               "",
            };
        final String[] Afghanistan = new String[] {
               "अफगानिस्तान वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "क्रास्नोयार्स्क प्रमाणित वेळ",
               "",
               "क्रास्नोयार्स्क ग्रीष्म वेळ",
               "",
               "क्रास्नोयार्स्क वेळ",
               "",
            };
        final String[] New_Zealand = new String[] {
               "न्युझीलॅन्ड प्रमाणित वेळ",
               "NZST",
               "न्युझीलॅन्ड डेलायट वेळ",
               "NZDT",
               "न्युझीलॅन्ड वेळ",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "फिलिपायन प्रमाणित वेळ",
               "PST",
               "फिलिपायन ग्रीष्म वेळ",
               "PDT",
               "फिलिपायन वेळ",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "व्लादिवोस्तोक प्रमाणित वेळ",
               "",
               "व्लादिवोस्तोक ग्रीष्म वेळ",
               "",
               "व्लादिवोस्तोक वेळ",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "हिंद म्हासागर वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "लायन आयलँड वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "न्युफावंडलँड प्रमाणीत वेळ",
               "NST",
               "न्युफावंडलँड डेलायट वेळ",
               "NDT",
               "न्युफावंडलँड वेळ",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "तुर्कमेनिस्तान प्रमाणित वेळ",
               "",
               "तुर्कमेनिस्तान ग्रीष्म वेळ",
               "",
               "तुर्कमेनिस्तान",
               "",
            };
        final String[] French_Guiana = new String[] {
               "फ्रेंच गयाना वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "न्यु कॅलेडोनिया प्रमाणित वेळ",
               "",
               "न्यु कॅलेडोनिया ग्रीष्म वेळ",
               "",
               "न्यु कॅलेडोनिया वेळ",
               "",
            };
        final String[] South_Georgia = new String[] {
               "दक्षिण जॉर्जिया वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "येकातेरिनबर्ग प्रमाणित वेळ",
               "",
               "येकातेरिनबर्ग ग्रीष्म वेळ",
               "",
               "येकातेरिनबर्ग वेळ",
               "",
            };
        final String[] Africa_Central = new String[] {
               "मध्य आफ्रिका वेळ",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "उदेंत आफ्रिका वेळ",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "अस्तंत आफ्रिका वेळ",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "द्युमाँ दूरवीय वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "मध्य युरोपियन प्रमाणित वेळ",
               "CET",
               "मध्य युरोपियन ग्रीष्म वेळ",
               "CEST",
               "मध्य युरोपियन वेळ",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "उदेंत युरोपियन प्रमाणित वेळ",
               "EET",
               "उदेंत युरोपियन ग्रीष्म वेळ",
               "EEST",
               "उदेंत युरोपियन वेळ",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "अस्तंत युरोपियन प्रमाणित वेळ",
               "WET",
               "अस्तंत युरोपियन ग्रीष्म वेळ",
               "WEST",
               "अस्तंत युरोपियन वेळ",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "मेक्सिकन प्रशांत प्रमाणीत वेळ",
               "MST",
               "मेक्सिकन प्रशांत डेलायट वेळ",
               "MDT",
               "मेक्सिकन प्रशांत वेळ",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "दक्षिण आफ्रिका प्रमाणित वेळ",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "मध्य प्रमाणित वेळ",
               "CST",
               "मध्य डेलायट वेळ",
               "CDT",
               "मध्य वेळ",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "उदेंत प्रमाणित वेळ",
               "EST",
               "उदेंत डेलायट वेळ",
               "EST",
               "उदेंत वेळ",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "प्रशांत प्रमाणित वेळ",
               "PST",
               "प्रशांत डेलायट वेळ",
               "PDT",
               "प्रशांत वेळ",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "फ्रेन्च दक्षिण आनी अंटार्क्टिक वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "गिल्बर्ट आयलँड वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "हवाई-अलेयुशिन प्रमाणीत वेळ",
               "HST",
               "हवाई-अलेयुशिन डेलायट वेळ",
               "HDT",
               "हवाई-अलेयुशिन वेळ",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "फिनिक्स आयलँड वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "सेंट पियर आनी मिकलान प्रमाणीत वेळ",
               "",
               "सेंट पियर आनी मिकलान डेलायट वेळ",
               "",
               "सेंट पियर आनी मिकलान वेळ",
               "",
            };
        final String[] America_Mountain = new String[] {
               "पर्वतीय प्रमाणित वेळ",
               "MST",
               "पर्वतीय डेलायट वेळ",
               "MST",
               "पर्वतीय वेळ",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "मार्शल आयलँड वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "पापुआ न्यु गिनी वेळ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "ऑस्ट्रेलीयन मध्य प्रमाणित वेळ",
               "ACST",
               "ऑस्ट्रेलीयन मध्य डेलायट वेळ",
               "ACDT",
               "मध्य ऑस्ट्रेलीया वेळ",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "ऑस्ट्रेलीयन उदेंत प्रमाणित वेळ",
               "AEST",
               "ऑस्ट्रेलीयन उदेंत डेलायट वेळ",
               "AEDT",
               "उदेंत ऑस्ट्रेलीया वेळ",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "ऑस्ट्रेलीयन अस्तंत प्रमाणित वेळ",
               "AWST",
               "ऑस्ट्रेलीयन अस्तंत डेलायट वेळ",
               "AWDT",
               "अस्तंत ऑस्ट्रेलीया वेळ",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "मध्य इंडोनेशिया वेळ",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "उदेंत इंडोनेशिया वेळ",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "अस्तंत इंडोनेशिया वेळ",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "ऑस्ट्रेलीयन मध्य अस्तंत प्रमाणित वेळ",
               "",
               "ऑस्ट्रेलीयन मध्य अस्तंत डेलायट वेळ",
               "",
               "ऑस्ट्रेलीयन मध्य अस्तंत वेळ",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "ग्रीनविच मध्य वेळ",
                    "GMT",
                    "ब्रिटिश ग्रीष्म वेळ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "समन्वित वैश्विक वेळ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "ग्रीनविच मध्य वेळ",
                    "GMT",
                    "आयरिश प्रमाणित वेळ",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "समन्वित वैश्विक वेळ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "समन्वित वैश्विक वेळ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "ग्रीनविच मध्य वेळ",
                    "GMT",
                    "ब्रिटिश ग्रीष्म वेळ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "समन्वित वैश्विक वेळ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "समन्वित वैश्विक वेळ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "समन्वित वैश्विक वेळ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "ग्रीनविच मध्य वेळ",
                    "GMT",
                    "आयरिश प्रमाणित वेळ",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "ग्रीनविच मध्य वेळ",
                    "GMT",
                    "ब्रिटिश ग्रीष्म वेळ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "ग्रीनविच मध्य वेळ",
                    "GMT",
                    "ब्रिटिश ग्रीष्म वेळ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "ग्रीनविच मध्य वेळ",
                    "GMT",
                    "ब्रिटिश ग्रीष्म वेळ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "ग्रीनविच मध्य वेळ",
                    "GMT",
                    "ब्रिटिश ग्रीष्म वेळ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "ग्रीनविच मध्य वेळ",
                    "GMT",
                    "ब्रिटिश ग्रीष्म वेळ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "ऍडन" },
            { "timezone.excity.Asia/Baku", "बाकू" },
            { "timezone.excity.Asia/Dili", "दिली" },
            { "timezone.excity.Asia/Gaza", "गाझा" },
            { "timezone.excity.Asia/Hovd", "होव्हड" },
            { "timezone.excity.Asia/Omsk", "ओम्स्क" },
            { "timezone.excity.Asia/Oral", "ओरल" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "अम्मान" },
            { "timezone.excity.Asia/Aqtau", "ऍक्टो" },
            { "timezone.excity.Asia/Chita", "चिटा" },
            { "timezone.excity.Asia/Dhaka", "ढाका" },
            { "timezone.excity.Asia/Dubai", "दुबय" },
            { "timezone.excity.Asia/Kabul", "काबुल" },
            { "timezone.excity.Asia/Macau", "मकाव" },
            { "timezone.excity.Asia/Qatar", "कतार" },
            { "timezone.excity.Asia/Seoul", "सोल" },
            { "timezone.excity.Asia/Tokyo", "तोक्यो" },
            { "timezone.excity.Asia/Tomsk", "टॉमस्क" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "जुबा" },
            { "timezone.excity.Africa/Lome", "लोम" },
            { "timezone.excity.Asia/Almaty", "अल्माटी" },
            { "timezone.excity.Asia/Anadyr", "अनादिर" },
            { "timezone.excity.Asia/Aqtobe", "अक्टोबे" },
            { "timezone.excity.Asia/Atyrau", "अत्यारो" },
            { "timezone.excity.Asia/Beirut", "बेरूत" },
            { "timezone.excity.Asia/Brunei", "ब्रूनेई" },
            { "timezone.excity.Asia/Hebron", "हेब्रॉन" },
            { "timezone.excity.Asia/Kuwait", "कुवेत" },
            { "timezone.excity.Asia/Manila", "मनिला" },
            { "timezone.excity.Asia/Muscat", "मस्कट" },
            { "timezone.excity.Asia/Riyadh", "रियाध" },
            { "timezone.excity.Asia/Saigon", "हो ची मिन्ह" },
            { "timezone.excity.Asia/Taipei", "तैपेई" },
            { "timezone.excity.Asia/Tehran", "तेहरान" },
            { "timezone.excity.Asia/Urumqi", "उरुम्की" },
            { "timezone.excity.Etc/Unknown", "अज्ञात शार" },
            { "timezone.excity.Europe/Kiev", "कीव" },
            { "timezone.excity.Europe/Oslo", "ओस्लो" },
            { "timezone.excity.Europe/Riga", "रीगा" },
            { "timezone.excity.Europe/Rome", "रोम" },
            { "timezone.excity.Indian/Mahe", "माहे" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "आकरा" },
            { "timezone.excity.Africa/Cairo", "कायरो" },
            { "timezone.excity.Africa/Ceuta", "सेउटा" },
            { "timezone.excity.Africa/Dakar", "डकार" },
            { "timezone.excity.Africa/Lagos", "लागोस" },
            { "timezone.excity.Africa/Tunis", "टुनिस" },
            { "timezone.excity.America/Adak", "अडाक" },
            { "timezone.excity.America/Lima", "लिमा" },
            { "timezone.excity.America/Nome", "नोमे" },
            { "timezone.excity.Asia/Baghdad", "बगदाद" },
            { "timezone.excity.Asia/Bahrain", "बेहरेन" },
            { "timezone.excity.Asia/Bangkok", "बँकॉक" },
            { "timezone.excity.Asia/Barnaul", "बरनौल" },
            { "timezone.excity.Asia/Bishkek", "बिश्केक" },
            { "timezone.excity.Asia/Colombo", "कोलंबो" },
            { "timezone.excity.Asia/Irkutsk", "इर्कुटस्क" },
            { "timezone.excity.Asia/Jakarta", "जकार्ता" },
            { "timezone.excity.Asia/Karachi", "कराची" },
            { "timezone.excity.Asia/Kuching", "कुचींग" },
            { "timezone.excity.Asia/Magadan", "मगादान" },
            { "timezone.excity.Asia/Nicosia", "निकोसिया" },
            { "timezone.excity.Asia/Rangoon", "यानगॉन" },
            { "timezone.excity.Asia/Tbilisi", "तुबलीसी" },
            { "timezone.excity.Asia/Thimphu", "थिम्फू" },
            { "timezone.excity.Asia/Yakutsk", "यकुत्स्क" },
            { "timezone.excity.Asia/Yerevan", "येरेवान" },
            { "timezone.excity.Europe/Kirov", "किरोव" },
            { "timezone.excity.Europe/Malta", "माल्टा" },
            { "timezone.excity.Europe/Minsk", "मिंस्क" },
            { "timezone.excity.Europe/Paris", "पॅरिस" },
            { "timezone.excity.Europe/Sofia", "सोफिया" },
            { "timezone.excity.Europe/Vaduz", "वडुज" },
            { "timezone.excity.Indian/Cocos", "कोकोस" },
            { "timezone.excity.Pacific/Apia", "अपिया" },
            { "timezone.excity.Pacific/Fiji", "फिजी" },
            { "timezone.excity.Pacific/Guam", "गुआम" },
            { "timezone.excity.Pacific/Niue", "नीयू" },
            { "timezone.excity.Pacific/Truk", "चुक" },
            { "timezone.excity.Pacific/Wake", "वैक" },
            { "timezone.excity.Africa/Asmera", "अस्मारा" },
            { "timezone.excity.Africa/Bamako", "बामाको" },
            { "timezone.excity.Africa/Bangui", "बांगी" },
            { "timezone.excity.Africa/Banjul", "बानजुल" },
            { "timezone.excity.Africa/Bissau", "बिसाउ" },
            { "timezone.excity.Africa/Douala", "डौआला" },
            { "timezone.excity.Africa/Harare", "हरारे" },
            { "timezone.excity.Africa/Kigali", "किगाली" },
            { "timezone.excity.Africa/Luanda", "लुआंडा" },
            { "timezone.excity.Africa/Lusaka", "लुसाका" },
            { "timezone.excity.Africa/Malabo", "मलाबो" },
            { "timezone.excity.Africa/Maputo", "मापुटो" },
            { "timezone.excity.Africa/Maseru", "मासेरु" },
            { "timezone.excity.Africa/Niamey", "नियामी" },
            { "timezone.excity.America/Aruba", "अरुबा" },
            { "timezone.excity.America/Bahia", "बहिया" },
            { "timezone.excity.America/Belem", "बेलेम" },
            { "timezone.excity.America/Boise", "बोयस" },
            { "timezone.excity.America/Jujuy", "जुजेय" },
            { "timezone.excity.America/Sitka", "सिट्का" },
            { "timezone.excity.America/Thule", "थुले" },
            { "timezone.excity.Asia/Ashgabat", "अशगाबाट" },
            { "timezone.excity.Asia/Calcutta", "कोलकाता, बॉम्बाईं, पणजी" },
            { "timezone.excity.Asia/Damascus", "दमस्कस" },
            { "timezone.excity.Asia/Dushanbe", "दुशान्बे" },
            { "timezone.excity.Asia/Jayapura", "जायापुरा" },
            { "timezone.excity.Asia/Katmandu", "काठमांडू" },
            { "timezone.excity.Asia/Khandyga", "खा़ंडिगा" },
            { "timezone.excity.Asia/Makassar", "मकास्सार" },
            { "timezone.excity.Asia/Qostanay", "कोस्टानाय" },
            { "timezone.excity.Asia/Sakhalin", "सखलिन" },
            { "timezone.excity.Asia/Shanghai", "शांघाय" },
            { "timezone.excity.Asia/Tashkent", "ताश्कंद" },
            { "timezone.excity.Asia/Ust-Nera", "उस्त नेरा" },
            { "timezone.excity.Europe/Athens", "अथेन्स" },
            { "timezone.excity.Europe/Berlin", "बर्लिन" },
            { "timezone.excity.Europe/Dublin", "डब्लिन" },
            { "timezone.excity.Europe/Jersey", "जर्सी" },
            { "timezone.excity.Europe/Lisbon", "लिस्बन" },
            { "timezone.excity.Europe/London", "लंडन" },
            { "timezone.excity.Europe/Madrid", "माद्रीद" },
            { "timezone.excity.Europe/Monaco", "मोनॅको" },
            { "timezone.excity.Europe/Moscow", "मॉस्को" },
            { "timezone.excity.Europe/Prague", "प्राग" },
            { "timezone.excity.Europe/Samara", "समारा" },
            { "timezone.excity.Europe/Skopje", "स्कोप्जे" },
            { "timezone.excity.Europe/Tirane", "तिराना" },
            { "timezone.excity.Europe/Vienna", "वियेना" },
            { "timezone.excity.Europe/Warsaw", "वारसॉ" },
            { "timezone.excity.Europe/Zagreb", "झाग्रेब" },
            { "timezone.excity.Europe/Zurich", "झुरिच" },
            { "timezone.excity.Indian/Chagos", "चागोस" },
            { "timezone.excity.Indian/Comoro", "कोमोरो" },
            { "timezone.excity.Pacific/Efate", "इफेट" },
            { "timezone.excity.Pacific/Nauru", "नावरू" },
            { "timezone.excity.Pacific/Palau", "पलाऊ" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "अबिदजान" },
            { "timezone.excity.Africa/Algiers", "आल्जियार्स" },
            { "timezone.excity.Africa/Conakry", "कोनाक्रा" },
            { "timezone.excity.Africa/Kampala", "काम्पाला" },
            { "timezone.excity.Africa/Mbabane", "एमबाबेन" },
            { "timezone.excity.Africa/Nairobi", "नायरोबी" },
            { "timezone.excity.Africa/Tripoli", "त्रिपोली" },
            { "timezone.excity.America/Belize", "बेलिझ" },
            { "timezone.excity.America/Bogota", "बोगोटा" },
            { "timezone.excity.America/Cancun", "कानकुन" },
            { "timezone.excity.America/Cayman", "कैमेन" },
            { "timezone.excity.America/Cuiaba", "कुययबा" },
            { "timezone.excity.America/Dawson", "डौसन" },
            { "timezone.excity.America/Denver", "डेन्वेर" },
            { "timezone.excity.America/Guyana", "गुयाना" },
            { "timezone.excity.America/Havana", "हवाना" },
            { "timezone.excity.America/Inuvik", "इनुविक" },
            { "timezone.excity.America/Juneau", "जूनो" },
            { "timezone.excity.America/La_Paz", "ला पाझ" },
            { "timezone.excity.America/Maceio", "मासियो" },
            { "timezone.excity.America/Manaus", "मनौस" },
            { "timezone.excity.America/Merida", "मेरिडा" },
            { "timezone.excity.America/Nassau", "नसाऊ" },
            { "timezone.excity.America/Panama", "पनामा" },
            { "timezone.excity.America/Recife", "रेसीफ" },
            { "timezone.excity.America/Regina", "रेजीना" },
            { "timezone.excity.Asia/Famagusta", "फमागुस्ता" },
            { "timezone.excity.Asia/Hong_Kong", "हाँग काँग" },
            { "timezone.excity.Asia/Jerusalem", "जेरुसालेम" },
            { "timezone.excity.Asia/Kamchatka", "कामचाट्का" },
            { "timezone.excity.Asia/Pontianak", "पोण्टीअनाक" },
            { "timezone.excity.Asia/Pyongyang", "प्योंगयांग" },
            { "timezone.excity.Asia/Qyzylorda", "क्य्ज्यलॉरडा" },
            { "timezone.excity.Asia/Samarkand", "समरकंद" },
            { "timezone.excity.Asia/Singapore", "सिंगापूर" },
            { "timezone.excity.Asia/Vientiane", "व्हिएन्टियन" },
            { "timezone.excity.Europe/Andorra", "अंडोरा" },
            { "timezone.excity.Europe/Saratov", "साराटोव" },
            { "timezone.excity.Europe/Tallinn", "टॅलिन" },
            { "timezone.excity.Europe/Vatican", "वॅटिकन" },
            { "timezone.excity.Europe/Vilnius", "विल्नियस" },
            { "timezone.excity.Indian/Mayotte", "मेयोट" },
            { "timezone.excity.Indian/Reunion", "रियुनियन" },
            { "timezone.excity.Pacific/Easter", "ईस्टर" },
            { "timezone.excity.Pacific/Kosrae", "कोसरे" },
            { "timezone.excity.Pacific/Majuro", "माजुरो" },
            { "timezone.excity.Pacific/Midway", "मिडवे" },
            { "timezone.excity.Pacific/Noumea", "नूमेआ" },
            { "timezone.excity.Pacific/Ponape", "पोह्नपेई" },
            { "timezone.excity.Pacific/Saipan", "सायपान" },
            { "timezone.excity.Pacific/Tahiti", "ताहिती" },
            { "timezone.excity.Pacific/Tarawa", "तारवा" },
            { "timezone.excity.Pacific/Wallis", "वालिस" },
            { "timezone.excity.Africa/Blantyre", "ब्लानटायर" },
            { "timezone.excity.Africa/Djibouti", "जिबूती" },
            { "timezone.excity.Africa/El_Aaiun", "अल आयुन" },
            { "timezone.excity.Africa/Freetown", "फ्रिटावन" },
            { "timezone.excity.Africa/Gaborone", "गाबोरोन" },
            { "timezone.excity.Africa/Khartoum", "खार्टोम" },
            { "timezone.excity.Africa/Kinshasa", "किनशासा" },
            { "timezone.excity.Africa/Monrovia", "मोनरोविया" },
            { "timezone.excity.Africa/Ndjamena", "एनजामेना" },
            { "timezone.excity.Africa/Sao_Tome", "साओ टोम" },
            { "timezone.excity.Africa/Windhoek", "विंडहोक" },
            { "timezone.excity.America/Antigua", "एँटिगुआ" },
            { "timezone.excity.America/Caracas", "कराकस" },
            { "timezone.excity.America/Cayenne", "केइन" },
            { "timezone.excity.America/Chicago", "शिकागो" },
            { "timezone.excity.America/Cordoba", "कोरडोबा" },
            { "timezone.excity.America/Creston", "क्रेस्टोन" },
            { "timezone.excity.America/Curacao", "कुराकाओ" },
            { "timezone.excity.America/Detroit", "डेट्रॉईट" },
            { "timezone.excity.America/Godthab", "नूक" },
            { "timezone.excity.America/Grenada", "ग्रेनॅडा" },
            { "timezone.excity.America/Halifax", "हेलिफॅक्स" },
            { "timezone.excity.America/Iqaluit", "इकालुयीट" },
            { "timezone.excity.America/Jamaica", "जमैका" },
            { "timezone.excity.America/Managua", "मॅनाग्वा" },
            { "timezone.excity.America/Marigot", "मेरीगॉट" },
            { "timezone.excity.America/Mendoza", "मेन्डोझा" },
            { "timezone.excity.America/Moncton", "मोंक्टॉन" },
            { "timezone.excity.America/Noronha", "नोरोन्हा" },
            { "timezone.excity.America/Ojinaga", "ओजिनागा" },
            { "timezone.excity.America/Phoenix", "फिनिक्स" },
            { "timezone.excity.America/Tijuana", "तिजुआना" },
            { "timezone.excity.America/Toronto", "टॉरंटो" },
            { "timezone.excity.America/Tortola", "टोरटोला" },
            { "timezone.excity.America/Yakutat", "याकुटाट" },
            { "timezone.excity.Asia/Phnom_Penh", "फ्नोम पेन्ह" },
            { "timezone.excity.Atlantic/Azores", "अझोरेस" },
            { "timezone.excity.Atlantic/Canary", "कॅनरी" },
            { "timezone.excity.Atlantic/Faeroe", "फैरो" },
            { "timezone.excity.Australia/Eucla", "उक्ला" },
            { "timezone.excity.Australia/Perth", "पर्थ" },
            { "timezone.excity.Europe/Belgrade", "बेलग्रेड" },
            { "timezone.excity.Europe/Brussels", "ब्रुसेल्स" },
            { "timezone.excity.Europe/Budapest", "बुडापेस्ट" },
            { "timezone.excity.Europe/Busingen", "बुसिंजेन" },
            { "timezone.excity.Europe/Chisinau", "चिसीनाऊ" },
            { "timezone.excity.Europe/Guernsey", "गर्नसी" },
            { "timezone.excity.Europe/Helsinki", "हेलसिंकी" },
            { "timezone.excity.Europe/Istanbul", "इस्तंबूल" },
            { "timezone.excity.Europe/Sarajevo", "साराजिवो" },
            { "timezone.excity.Indian/Maldives", "मालदीव" },
            { "timezone.excity.Pacific/Chatham", "चॅथम" },
            { "timezone.excity.Pacific/Fakaofo", "फाकाओफो" },
            { "timezone.excity.Pacific/Gambier", "गाम्बियर" },
            { "timezone.excity.Pacific/Norfolk", "नॉरफोक" },
            { "timezone.excity.Africa/Bujumbura", "बुजुमबुरा" },
            { "timezone.excity.Africa/Mogadishu", "मोगादिशू" },
            { "timezone.excity.America/Anguilla", "अंगुला" },
            { "timezone.excity.America/Asuncion", "असंसियन" },
            { "timezone.excity.America/Barbados", "बारबाडोस" },
            { "timezone.excity.America/Dominica", "डोमिनीका" },
            { "timezone.excity.America/Edmonton", "ऍडमोंटन" },
            { "timezone.excity.America/Eirunepe", "ईरुनेपे" },
            { "timezone.excity.America/Mazatlan", "माझाट्लान" },
            { "timezone.excity.America/Miquelon", "मिक्वेलोन" },
            { "timezone.excity.America/New_York", "न्यु यॉर्क" },
            { "timezone.excity.America/Resolute", "रिसोल्युट" },
            { "timezone.excity.America/Santarem", "सांतारेम" },
            { "timezone.excity.America/Santiago", "सँटियागो" },
            { "timezone.excity.America/St_Johns", "सेंट जॉन्स" },
            { "timezone.excity.America/St_Kitts", "सेंट किट्स" },
            { "timezone.excity.America/St_Lucia", "सेंट लुसीया" },
            { "timezone.excity.America/Winnipeg", "विनीपेग" },
            { "timezone.excity.Antarctica/Casey", "केसी" },
            { "timezone.excity.Antarctica/Davis", "डेव्हीस" },
            { "timezone.excity.Antarctica/Syowa", "स्योवा" },
            { "timezone.excity.Antarctica/Troll", "ट्रोल" },
            { "timezone.excity.Asia/Krasnoyarsk", "क्रास्नोयार्स्क" },
            { "timezone.excity.Asia/Novosibirsk", "नोवोसिबिर्स्क" },
            { "timezone.excity.Asia/Ulaanbaatar", "उलानबतार" },
            { "timezone.excity.Asia/Vladivostok", "व्लादिवोस्तोक" },
            { "timezone.excity.Atlantic/Bermuda", "बर्मुडा" },
            { "timezone.excity.Atlantic/Madeira", "मदिरा" },
            { "timezone.excity.Atlantic/Stanley", "स्टेन्ले" },
            { "timezone.excity.Australia/Darwin", "डार्विन" },
            { "timezone.excity.Australia/Hobart", "होबार्ट" },
            { "timezone.excity.Australia/Sydney", "सिडनी" },
            { "timezone.excity.Europe/Amsterdam", "ऍम्स्टरडॅम" },
            { "timezone.excity.Europe/Astrakhan", "आस्ट्रखन" },
            { "timezone.excity.Europe/Bucharest", "बुखारेस्ट" },
            { "timezone.excity.Europe/Gibraltar", "जिब्राल्टर" },
            { "timezone.excity.Europe/Ljubljana", "जुब्लजाना" },
            { "timezone.excity.Europe/Mariehamn", "मॅरीहाम्न" },
            { "timezone.excity.Europe/Podgorica", "पॉडगोरिका" },
            { "timezone.excity.Europe/Stockholm", "स्टॉकहोम" },
            { "timezone.excity.Europe/Ulyanovsk", "उल्यानोव्स्क" },
            { "timezone.excity.Europe/Volgograd", "व्होल्गोग्राड" },
            { "timezone.excity.Indian/Christmas", "क्रिसमस" },
            { "timezone.excity.Indian/Kerguelen", "केरगुलेन" },
            { "timezone.excity.Indian/Mauritius", "मॉरिशस" },
            { "timezone.excity.Pacific/Auckland", "ऑकलँड" },
            { "timezone.excity.Pacific/Funafuti", "फुनाफुटी" },
            { "timezone.excity.Pacific/Pitcairn", "पिटकॅरन" },
            { "timezone.excity.Africa/Casablanca", "कासाब्लांका" },
            { "timezone.excity.Africa/Libreville", "लिब्रेविले" },
            { "timezone.excity.Africa/Lubumbashi", "लुबुमबाशी" },
            { "timezone.excity.Africa/Nouakchott", "नवाकसुत" },
            { "timezone.excity.Africa/Porto-Novo", "पोर्टो-नोवो" },
            { "timezone.excity.America/Anchorage", "ऐंकरज" },
            { "timezone.excity.America/Araguaina", "अरगुयेना" },
            { "timezone.excity.America/Boa_Vista", "बाओ विस्टा" },
            { "timezone.excity.America/Catamarca", "काटामारका" },
            { "timezone.excity.America/Chihuahua", "चिहुआहुआ" },
            { "timezone.excity.America/Coyhaique", "कोयहायक" },
            { "timezone.excity.America/Fortaleza", "फोर्टालेझा" },
            { "timezone.excity.America/Glace_Bay", "ग्लेस बे" },
            { "timezone.excity.America/Goose_Bay", "गूस बे" },
            { "timezone.excity.America/Guatemala", "ग्वाटेमाला" },
            { "timezone.excity.America/Guayaquil", "ग्वायेकिल" },
            { "timezone.excity.America/Matamoros", "माटामोरोस" },
            { "timezone.excity.America/Menominee", "मेनोमिनी" },
            { "timezone.excity.America/Monterrey", "मोंटेरी" },
            { "timezone.excity.America/Sao_Paulo", "साओ पावलो" },
            { "timezone.excity.America/St_Thomas", "सेंट थॉमस" },
            { "timezone.excity.America/Vancouver", "व्हँकुव्हर" },
            { "timezone.excity.Antarctica/Mawson", "मॉसन" },
            { "timezone.excity.Antarctica/Palmer", "पाल्मेर" },
            { "timezone.excity.Antarctica/Vostok", "वोस्तोक" },
            { "timezone.excity.Asia/Kuala_Lumpur", "कुआलालम्पूर" },
            { "timezone.excity.Asia/Novokuznetsk", "नोवोकुझनेत्स्क" },
            { "timezone.excity.Europe/Bratislava", "ब्राटिस्लाव्हा" },
            { "timezone.excity.Europe/Copenhagen", "कोपनहेगन" },
            { "timezone.excity.Europe/Luxembourg", "लक्सेमबर्ग" },
            { "timezone.excity.Europe/San_Marino", "सॅन मारीनो" },
            { "timezone.excity.Europe/Simferopol", "सिमफरोपोल" },
            { "timezone.excity.Pacific/Enderbury", "कांटोन" },
            { "timezone.excity.Pacific/Galapagos", "गालापागोस" },
            { "timezone.excity.Pacific/Kwajalein", "क्वाजलेन" },
            { "timezone.excity.Pacific/Marquesas", "मार्किसस" },
            { "timezone.excity.Pacific/Pago_Pago", "पागो पागो" },
            { "timezone.excity.Pacific/Rarotonga", "रारोटोंगा" },
            { "timezone.excity.Pacific/Tongatapu", "टोंगाटापू" },
            { "timezone.excity.Africa/Addis_Ababa", "आदीस अबाबा" },
            { "timezone.excity.Africa/Brazzaville", "ब्राझाविले" },
            { "timezone.excity.Africa/Ouagadougou", "ओगादौगो" },
            { "timezone.excity.America/Costa_Rica", "कोस्ता रिका" },
            { "timezone.excity.America/Grand_Turk", "ग्रँड तुर्क" },
            { "timezone.excity.America/Guadeloupe", "ग्वाडेलोप" },
            { "timezone.excity.America/Hermosillo", "हर्मोसिलो" },
            { "timezone.excity.America/Kralendijk", "क्रालेनडीक" },
            { "timezone.excity.America/Louisville", "लुईजविले" },
            { "timezone.excity.America/Martinique", "मार्टिनिक" },
            { "timezone.excity.America/Metlakatla", "मेट्लाकाट्ला" },
            { "timezone.excity.America/Montevideo", "मोंटेव्हिडियो" },
            { "timezone.excity.America/Montserrat", "मॉन्टसेराट" },
            { "timezone.excity.America/Paramaribo", "परामारिबो" },
            { "timezone.excity.America/Rio_Branco", "रियो ब्रांको" },
            { "timezone.excity.America/St_Vincent", "सेंट विन्सेंट" },
            { "timezone.excity.America/Whitehorse", "व्हायटहॉर्स" },
            { "timezone.excity.Antarctica/McMurdo", "मॅकमुर्दो" },
            { "timezone.excity.Antarctica/Rothera", "रोथेरा" },
            { "timezone.excity.Asia/Srednekolymsk", "स्रेदनेकॉलय्मस्क" },
            { "timezone.excity.Asia/Yekaterinburg", "येकातेरिनबर्ग" },
            { "timezone.excity.Atlantic/Reykjavik", "रिक्जेविक" },
            { "timezone.excity.Atlantic/St_Helena", "सें. हेलेना" },
            { "timezone.excity.Australia/Adelaide", "एडिलेड" },
            { "timezone.excity.Australia/Brisbane", "ब्रिस्बेन" },
            { "timezone.excity.Australia/Lindeman", "लिडेमॅन" },
            { "timezone.excity.Europe/Isle_of_Man", "इसले ऑफ मॅन" },
            { "timezone.excity.Europe/Kaliningrad", "कालिनिनग्राड" },
            { "timezone.excity.Pacific/Kiritimati", "किरितिमाती" },
            { "timezone.excity.Africa/Johannesburg", "जोहान्सबर्ग" },
            { "timezone.excity.America/El_Salvador", "एल साल्वाडोर" },
            { "timezone.excity.America/Fort_Nelson", "फोर्ट नेल्सन" },
            { "timezone.excity.America/Los_Angeles", "लॉस एंजलीस" },
            { "timezone.excity.America/Mexico_City", "मेक्सिको शार" },
            { "timezone.excity.America/Porto_Velho", "पोर्टो वेल्हो" },
            { "timezone.excity.America/Puerto_Rico", "पिर्टो रिको" },
            { "timezone.excity.America/Tegucigalpa", "तेगुसिगल्पा" },
            { "timezone.excity.Arctic/Longyearbyen", "लोंगयेअरब्येन" },
            { "timezone.excity.Atlantic/Cape_Verde", "केप वर्दे" },
            { "timezone.excity.Australia/Lord_Howe", "लॉर्ड होवे" },
            { "timezone.excity.Australia/Melbourne", "मेलबर्न" },
            { "timezone.excity.Indian/Antananarivo", "अंटानानारिवो" },
            { "timezone.excity.Pacific/Guadalcanal", "ग्वादालकॅनाल" },
            { "timezone.excity.Africa/Dar_es_Salaam", "दार इ सलाम" },
            { "timezone.excity.America/Blanc-Sablon", "ब्लांक-साब्लोन" },
            { "timezone.excity.America/Buenos_Aires", "ब्यूनस आयर्स" },
            { "timezone.excity.America/Campo_Grande", "कॅम्पो ग्रांड" },
            { "timezone.excity.America/Danmarkshavn", "डेन्मार्कशॉन" },
            { "timezone.excity.America/Dawson_Creek", "डौसन क्रिक" },
            { "timezone.excity.America/Indiana/Knox", "नॉक्स, इंडियाना" },
            { "timezone.excity.America/Indianapolis", "इंडियानापोलीस" },
            { "timezone.excity.America/Punta_Arenas", "पुंटा अरेनास" },
            { "timezone.excity.America/Rankin_Inlet", "रँकिन इनलॅट" },
            { "timezone.excity.America/Scoresbysund", "इटोकॉरटॉर्मीट" },
            { "timezone.excity.Antarctica/Macquarie", "मॅक्वेरी" },
            { "timezone.excity.Pacific/Bougainville", "बोगेनविले" },
            { "timezone.excity.Pacific/Port_Moresby", "पोर्ट मॉरेस्बी" },
            { "timezone.excity.America/Cambridge_Bay", "केंब्रिज बे" },
            { "timezone.excity.America/Ciudad_Juarez", "सिउदाद जुआरेज" },
            { "timezone.excity.America/Coral_Harbour", "अतिकोकॉन" },
            { "timezone.excity.America/Indiana/Vevay", "वेवय, इंडियाना" },
            { "timezone.excity.America/Lower_Princes", "लोवर प्रिंसेस क्वार्टर" },
            { "timezone.excity.America/Port_of_Spain", "पोर्ट ऑफ स्पेन" },
            { "timezone.excity.America/Santo_Domingo", "सांतो डोमिंगो" },
            { "timezone.excity.America/St_Barthelemy", "सेंट बार्थेलेमी" },
            { "timezone.excity.America/Swift_Current", "स्विफ्ट करंट" },
            { "timezone.excity.Australia/Broken_Hill", "ब्रोकन हिल" },
            { "timezone.excity.America/Bahia_Banderas", "बहिया बंदेरस" },
            { "timezone.excity.America/Port-au-Prince", "पोर्ट-औ-प्रिन्स" },
            { "timezone.excity.Atlantic/South_Georgia", "दक्षिण जॉर्जिया" },
            { "timezone.excity.America/Argentina/Salta", "साल्टा" },
            { "timezone.excity.America/Indiana/Marengo", "मारेंगो, इंडियाना" },
            { "timezone.excity.America/Indiana/Winamac", "विनामॅक, इंडियाना" },
            { "timezone.excity.America/Argentina/Tucuman", "टुकुमॅन" },
            { "timezone.excity.America/Argentina/Ushuaia", "उशुआइया" },
            { "timezone.excity.America/Indiana/Tell_City", "टेल सिटी, इंडियाना" },
            { "timezone.excity.America/Indiana/Vincennes", "विंसेनस, इंडियाना" },
            { "timezone.excity.Antarctica/DumontDUrville", "द्युमाँ दूरवीय" },
            { "timezone.excity.America/Argentina/La_Rioja", "ला रियोजा" },
            { "timezone.excity.America/Argentina/San_Juan", "सान जुआन" },
            { "timezone.excity.America/Argentina/San_Luis", "सान लुईस" },
            { "timezone.excity.America/Indiana/Petersburg", "पिटर्सबर्ग, इंडियाना" },
            { "timezone.excity.America/Kentucky/Monticello", "मोंटीसॅलो, केंटुकाय" },
            { "timezone.excity.America/North_Dakota/Beulah", "ब्यूल्लाह, उत्तर डाकोटा" },
            { "timezone.excity.America/North_Dakota/Center", "मध्य, उत्तर डाकोटा" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "रियो गलेगॉस" },
            { "timezone.excity.America/North_Dakota/New_Salem", "न्यु सालेम, उत्तर डाकोटा" },
        };
        return data;
    }
}
