// Package page provides the Chrome DevTools Protocol
// commands, types, and events for the Page domain.
//
// Actions and events related to the inspected page belong to the page
// domain.
//
// Generated by the cdproto-gen command.
package page

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"context"
	"encoding/base64"

	"github.com/chromedp/cdproto/cdp"
	"github.com/chromedp/cdproto/debugger"
	"github.com/chromedp/cdproto/dom"
	"github.com/chromedp/cdproto/io"
	"github.com/chromedp/cdproto/runtime"
)

// AddScriptToEvaluateOnNewDocumentParams evaluates given script in every
// frame upon creation (before loading frame's scripts).
type AddScriptToEvaluateOnNewDocumentParams struct {
	Source                string `json:"source"`
	WorldName             string `json:"worldName,omitempty,omitzero"` // If specified, creates an isolated world with the given name and evaluates given script in it. This world name will be used as the ExecutionContextDescription::name when the corresponding event is emitted.
	IncludeCommandLineAPI bool   `json:"includeCommandLineAPI"`        // Specifies whether command line API should be available to the script, defaults to false.
	RunImmediately        bool   `json:"runImmediately"`               // If true, runs the script immediately on existing execution contexts or worlds. Default: false.
}

// AddScriptToEvaluateOnNewDocument evaluates given script in every frame
// upon creation (before loading frame's scripts).
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-addScriptToEvaluateOnNewDocument
//
// parameters:
//
//	source
func AddScriptToEvaluateOnNewDocument(source string) *AddScriptToEvaluateOnNewDocumentParams {
	return &AddScriptToEvaluateOnNewDocumentParams{
		Source:                source,
		IncludeCommandLineAPI: false,
		RunImmediately:        false,
	}
}

// WithWorldName if specified, creates an isolated world with the given name
// and evaluates given script in it. This world name will be used as the
// ExecutionContextDescription::name when the corresponding event is emitted.
func (p AddScriptToEvaluateOnNewDocumentParams) WithWorldName(worldName string) *AddScriptToEvaluateOnNewDocumentParams {
	p.WorldName = worldName
	return &p
}

// WithIncludeCommandLineAPI specifies whether command line API should be
// available to the script, defaults to false.
func (p AddScriptToEvaluateOnNewDocumentParams) WithIncludeCommandLineAPI(includeCommandLineAPI bool) *AddScriptToEvaluateOnNewDocumentParams {
	p.IncludeCommandLineAPI = includeCommandLineAPI
	return &p
}

// WithRunImmediately if true, runs the script immediately on existing
// execution contexts or worlds. Default: false.
func (p AddScriptToEvaluateOnNewDocumentParams) WithRunImmediately(runImmediately bool) *AddScriptToEvaluateOnNewDocumentParams {
	p.RunImmediately = runImmediately
	return &p
}

// AddScriptToEvaluateOnNewDocumentReturns return values.
type AddScriptToEvaluateOnNewDocumentReturns struct {
	Identifier ScriptIdentifier `json:"identifier,omitempty,omitzero"` // Identifier of the added script.
}

// Do executes Page.addScriptToEvaluateOnNewDocument against the provided context.
//
// returns:
//
//	identifier - Identifier of the added script.
func (p *AddScriptToEvaluateOnNewDocumentParams) Do(ctx context.Context) (identifier ScriptIdentifier, err error) {
	// execute
	var res AddScriptToEvaluateOnNewDocumentReturns
	err = cdp.Execute(ctx, CommandAddScriptToEvaluateOnNewDocument, p, &res)
	if err != nil {
		return "", err
	}

	return res.Identifier, nil
}

// BringToFrontParams brings page to front (activates tab).
type BringToFrontParams struct{}

// BringToFront brings page to front (activates tab).
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-bringToFront
func BringToFront() *BringToFrontParams {
	return &BringToFrontParams{}
}

// Do executes Page.bringToFront against the provided context.
func (p *BringToFrontParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandBringToFront, nil, nil)
}

// CaptureScreenshotParams capture page screenshot.
type CaptureScreenshotParams struct {
	Format                CaptureScreenshotFormat `json:"format,omitempty,omitzero"`  // Image compression format (defaults to png).
	Quality               int64                   `json:"quality,omitempty,omitzero"` // Compression quality from range [0..100] (jpeg only).
	Clip                  *Viewport               `json:"clip,omitempty,omitzero"`    // Capture the screenshot of a given region only.
	FromSurface           bool                    `json:"fromSurface"`                // Capture the screenshot from the surface, rather than the view. Defaults to true.
	CaptureBeyondViewport bool                    `json:"captureBeyondViewport"`      // Capture the screenshot beyond the viewport. Defaults to false.
	OptimizeForSpeed      bool                    `json:"optimizeForSpeed"`           // Optimize image encoding for speed, not for resulting size (defaults to false)
}

// CaptureScreenshot capture page screenshot.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-captureScreenshot
//
// parameters:
func CaptureScreenshot() *CaptureScreenshotParams {
	return &CaptureScreenshotParams{
		FromSurface:           true,
		CaptureBeyondViewport: false,
		OptimizeForSpeed:      false,
	}
}

// WithFormat image compression format (defaults to png).
func (p CaptureScreenshotParams) WithFormat(format CaptureScreenshotFormat) *CaptureScreenshotParams {
	p.Format = format
	return &p
}

// WithQuality compression quality from range [0..100] (jpeg only).
func (p CaptureScreenshotParams) WithQuality(quality int64) *CaptureScreenshotParams {
	p.Quality = quality
	return &p
}

// WithClip capture the screenshot of a given region only.
func (p CaptureScreenshotParams) WithClip(clip *Viewport) *CaptureScreenshotParams {
	p.Clip = clip
	return &p
}

// WithFromSurface capture the screenshot from the surface, rather than the
// view. Defaults to true.
func (p CaptureScreenshotParams) WithFromSurface(fromSurface bool) *CaptureScreenshotParams {
	p.FromSurface = fromSurface
	return &p
}

// WithCaptureBeyondViewport capture the screenshot beyond the viewport.
// Defaults to false.
func (p CaptureScreenshotParams) WithCaptureBeyondViewport(captureBeyondViewport bool) *CaptureScreenshotParams {
	p.CaptureBeyondViewport = captureBeyondViewport
	return &p
}

// WithOptimizeForSpeed optimize image encoding for speed, not for resulting
// size (defaults to false).
func (p CaptureScreenshotParams) WithOptimizeForSpeed(optimizeForSpeed bool) *CaptureScreenshotParams {
	p.OptimizeForSpeed = optimizeForSpeed
	return &p
}

// CaptureScreenshotReturns return values.
type CaptureScreenshotReturns struct {
	Data string `json:"data,omitempty,omitzero"` // Base64-encoded image data.
}

// Do executes Page.captureScreenshot against the provided context.
//
// returns:
//
//	data - Base64-encoded image data.
func (p *CaptureScreenshotParams) Do(ctx context.Context) (data []byte, err error) {
	// execute
	var res CaptureScreenshotReturns
	err = cdp.Execute(ctx, CommandCaptureScreenshot, p, &res)
	if err != nil {
		return nil, err
	}

	// decode
	var dec []byte
	dec, err = base64.StdEncoding.DecodeString(res.Data)
	if err != nil {
		return nil, err
	}
	return dec, nil
}

// CaptureSnapshotParams returns a snapshot of the page as a string. For
// MHTML format, the serialization includes iframes, shadow DOM, external
// resources, and element-inline styles.
type CaptureSnapshotParams struct {
	Format CaptureSnapshotFormat `json:"format,omitempty,omitzero"` // Format (defaults to mhtml).
}

// CaptureSnapshot returns a snapshot of the page as a string. For MHTML
// format, the serialization includes iframes, shadow DOM, external resources,
// and element-inline styles.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-captureSnapshot
//
// parameters:
func CaptureSnapshot() *CaptureSnapshotParams {
	return &CaptureSnapshotParams{}
}

// WithFormat format (defaults to mhtml).
func (p CaptureSnapshotParams) WithFormat(format CaptureSnapshotFormat) *CaptureSnapshotParams {
	p.Format = format
	return &p
}

// CaptureSnapshotReturns return values.
type CaptureSnapshotReturns struct {
	Data string `json:"data,omitempty,omitzero"` // Serialized page data.
}

// Do executes Page.captureSnapshot against the provided context.
//
// returns:
//
//	data - Serialized page data.
func (p *CaptureSnapshotParams) Do(ctx context.Context) (data string, err error) {
	// execute
	var res CaptureSnapshotReturns
	err = cdp.Execute(ctx, CommandCaptureSnapshot, p, &res)
	if err != nil {
		return "", err
	}

	return res.Data, nil
}

// CreateIsolatedWorldParams creates an isolated world for the given frame.
type CreateIsolatedWorldParams struct {
	FrameID             cdp.FrameID `json:"frameId"`                      // Id of the frame in which the isolated world should be created.
	WorldName           string      `json:"worldName,omitempty,omitzero"` // An optional name which is reported in the Execution Context.
	GrantUniveralAccess bool        `json:"grantUniveralAccess"`          // Whether or not universal access should be granted to the isolated world. This is a powerful option, use with caution.
}

// CreateIsolatedWorld creates an isolated world for the given frame.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-createIsolatedWorld
//
// parameters:
//
//	frameID - Id of the frame in which the isolated world should be created.
func CreateIsolatedWorld(frameID cdp.FrameID) *CreateIsolatedWorldParams {
	return &CreateIsolatedWorldParams{
		FrameID:             frameID,
		GrantUniveralAccess: false,
	}
}

// WithWorldName an optional name which is reported in the Execution Context.
func (p CreateIsolatedWorldParams) WithWorldName(worldName string) *CreateIsolatedWorldParams {
	p.WorldName = worldName
	return &p
}

// WithGrantUniveralAccess whether or not universal access should be granted
// to the isolated world. This is a powerful option, use with caution.
func (p CreateIsolatedWorldParams) WithGrantUniveralAccess(grantUniveralAccess bool) *CreateIsolatedWorldParams {
	p.GrantUniveralAccess = grantUniveralAccess
	return &p
}

// CreateIsolatedWorldReturns return values.
type CreateIsolatedWorldReturns struct {
	ExecutionContextID runtime.ExecutionContextID `json:"executionContextId,omitempty,omitzero"` // Execution context of the isolated world.
}

// Do executes Page.createIsolatedWorld against the provided context.
//
// returns:
//
//	executionContextID - Execution context of the isolated world.
func (p *CreateIsolatedWorldParams) Do(ctx context.Context) (executionContextID runtime.ExecutionContextID, err error) {
	// execute
	var res CreateIsolatedWorldReturns
	err = cdp.Execute(ctx, CommandCreateIsolatedWorld, p, &res)
	if err != nil {
		return 0, err
	}

	return res.ExecutionContextID, nil
}

// DisableParams disables page domain notifications.
type DisableParams struct{}

// Disable disables page domain notifications.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-disable
func Disable() *DisableParams {
	return &DisableParams{}
}

// Do executes Page.disable against the provided context.
func (p *DisableParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandDisable, nil, nil)
}

// EnableParams enables page domain notifications.
type EnableParams struct {
	EnableFileChooserOpenedEvent bool `json:"enableFileChooserOpenedEvent"` // If true, the Page.fileChooserOpened event will be emitted regardless of the state set by Page.setInterceptFileChooserDialog command (default: false).
}

// Enable enables page domain notifications.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-enable
//
// parameters:
func Enable() *EnableParams {
	return &EnableParams{
		EnableFileChooserOpenedEvent: false,
	}
}

// WithEnableFileChooserOpenedEvent if true, the Page.fileChooserOpened event
// will be emitted regardless of the state set by
// Page.setInterceptFileChooserDialog command (default: false).
func (p EnableParams) WithEnableFileChooserOpenedEvent(enableFileChooserOpenedEvent bool) *EnableParams {
	p.EnableFileChooserOpenedEvent = enableFileChooserOpenedEvent
	return &p
}

// Do executes Page.enable against the provided context.
func (p *EnableParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandEnable, p, nil)
}

// GetAppManifestParams gets the processed manifest for this current
// document. This API always waits for the manifest to be loaded. If manifestId
// is provided, and it does not match the manifest of the current document, this
// API errors out. If there is not a loaded page, this API errors out
// immediately.
type GetAppManifestParams struct {
	ManifestID string `json:"manifestId,omitempty,omitzero"`
}

// GetAppManifest gets the processed manifest for this current document. This
// API always waits for the manifest to be loaded. If manifestId is provided,
// and it does not match the manifest of the current document, this API errors
// out. If there is not a loaded page, this API errors out immediately.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-getAppManifest
//
// parameters:
func GetAppManifest() *GetAppManifestParams {
	return &GetAppManifestParams{}
}

// WithManifestID [no description].
func (p GetAppManifestParams) WithManifestID(manifestID string) *GetAppManifestParams {
	p.ManifestID = manifestID
	return &p
}

// GetAppManifestReturns return values.
type GetAppManifestReturns struct {
	URL      string              `json:"url,omitempty,omitzero"` // Manifest location.
	Errors   []*AppManifestError `json:"errors,omitempty,omitzero"`
	Data     string              `json:"data,omitempty,omitzero"` // Manifest content.
	Manifest *WebAppManifest     `json:"manifest,omitempty,omitzero"`
}

// Do executes Page.getAppManifest against the provided context.
//
// returns:
//
//	url - Manifest location.
//	errors
//	data - Manifest content.
//	manifest
func (p *GetAppManifestParams) Do(ctx context.Context) (url string, errors []*AppManifestError, data string, manifest *WebAppManifest, err error) {
	// execute
	var res GetAppManifestReturns
	err = cdp.Execute(ctx, CommandGetAppManifest, p, &res)
	if err != nil {
		return "", nil, "", nil, err
	}

	return res.URL, res.Errors, res.Data, res.Manifest, nil
}

// GetInstallabilityErrorsParams [no description].
type GetInstallabilityErrorsParams struct{}

// GetInstallabilityErrors [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-getInstallabilityErrors
func GetInstallabilityErrors() *GetInstallabilityErrorsParams {
	return &GetInstallabilityErrorsParams{}
}

// GetInstallabilityErrorsReturns return values.
type GetInstallabilityErrorsReturns struct {
	InstallabilityErrors []*InstallabilityError `json:"installabilityErrors,omitempty,omitzero"`
}

// Do executes Page.getInstallabilityErrors against the provided context.
//
// returns:
//
//	installabilityErrors
func (p *GetInstallabilityErrorsParams) Do(ctx context.Context) (installabilityErrors []*InstallabilityError, err error) {
	// execute
	var res GetInstallabilityErrorsReturns
	err = cdp.Execute(ctx, CommandGetInstallabilityErrors, nil, &res)
	if err != nil {
		return nil, err
	}

	return res.InstallabilityErrors, nil
}

// GetAppIDParams returns the unique (PWA) app id. Only returns values if the
// feature flag 'WebAppEnableManifestId' is enabled.
type GetAppIDParams struct{}

// GetAppID returns the unique (PWA) app id. Only returns values if the
// feature flag 'WebAppEnableManifestId' is enabled.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-getAppId
func GetAppID() *GetAppIDParams {
	return &GetAppIDParams{}
}

// GetAppIDReturns return values.
type GetAppIDReturns struct {
	AppID         string `json:"appId,omitempty,omitzero"`         // App id, either from manifest's id attribute or computed from start_url
	RecommendedID string `json:"recommendedId,omitempty,omitzero"` // Recommendation for manifest's id attribute to match current id computed from start_url
}

// Do executes Page.getAppId against the provided context.
//
// returns:
//
//	appID - App id, either from manifest's id attribute or computed from start_url
//	recommendedID - Recommendation for manifest's id attribute to match current id computed from start_url
func (p *GetAppIDParams) Do(ctx context.Context) (appID string, recommendedID string, err error) {
	// execute
	var res GetAppIDReturns
	err = cdp.Execute(ctx, CommandGetAppID, nil, &res)
	if err != nil {
		return "", "", err
	}

	return res.AppID, res.RecommendedID, nil
}

// GetAdScriptAncestryParams [no description].
type GetAdScriptAncestryParams struct {
	FrameID cdp.FrameID `json:"frameId"`
}

// GetAdScriptAncestry [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-getAdScriptAncestry
//
// parameters:
//
//	frameID
func GetAdScriptAncestry(frameID cdp.FrameID) *GetAdScriptAncestryParams {
	return &GetAdScriptAncestryParams{
		FrameID: frameID,
	}
}

// GetAdScriptAncestryReturns return values.
type GetAdScriptAncestryReturns struct {
	AdScriptAncestry *AdScriptAncestry `json:"adScriptAncestry,omitempty,omitzero"` // The ancestry chain of ad script identifiers leading to this frame's creation, along with the root script's filterlist rule. The ancestry chain is ordered from the most immediate script (in the frame creation stack) to more distant ancestors (that created the immediately preceding script). Only sent if frame is labelled as an ad and ids are available.
}

// Do executes Page.getAdScriptAncestry against the provided context.
//
// returns:
//
//	adScriptAncestry - The ancestry chain of ad script identifiers leading to this frame's creation, along with the root script's filterlist rule. The ancestry chain is ordered from the most immediate script (in the frame creation stack) to more distant ancestors (that created the immediately preceding script). Only sent if frame is labelled as an ad and ids are available.
func (p *GetAdScriptAncestryParams) Do(ctx context.Context) (adScriptAncestry *AdScriptAncestry, err error) {
	// execute
	var res GetAdScriptAncestryReturns
	err = cdp.Execute(ctx, CommandGetAdScriptAncestry, p, &res)
	if err != nil {
		return nil, err
	}

	return res.AdScriptAncestry, nil
}

// GetFrameTreeParams returns present frame tree structure.
type GetFrameTreeParams struct{}

// GetFrameTree returns present frame tree structure.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-getFrameTree
func GetFrameTree() *GetFrameTreeParams {
	return &GetFrameTreeParams{}
}

// GetFrameTreeReturns return values.
type GetFrameTreeReturns struct {
	FrameTree *FrameTree `json:"frameTree,omitempty,omitzero"` // Present frame tree structure.
}

// Do executes Page.getFrameTree against the provided context.
//
// returns:
//
//	frameTree - Present frame tree structure.
func (p *GetFrameTreeParams) Do(ctx context.Context) (frameTree *FrameTree, err error) {
	// execute
	var res GetFrameTreeReturns
	err = cdp.Execute(ctx, CommandGetFrameTree, nil, &res)
	if err != nil {
		return nil, err
	}

	return res.FrameTree, nil
}

// GetLayoutMetricsParams returns metrics relating to the layouting of the
// page, such as viewport bounds/scale.
type GetLayoutMetricsParams struct{}

// GetLayoutMetrics returns metrics relating to the layouting of the page,
// such as viewport bounds/scale.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-getLayoutMetrics
func GetLayoutMetrics() *GetLayoutMetricsParams {
	return &GetLayoutMetricsParams{}
}

// GetLayoutMetricsReturns return values.
type GetLayoutMetricsReturns struct {
	LayoutViewport    *LayoutViewport `json:"layoutViewport"`    // Deprecated metrics relating to the layout viewport. Is in device pixels. Use cssLayoutViewport instead.
	VisualViewport    *VisualViewport `json:"visualViewport"`    // Deprecated metrics relating to the visual viewport. Is in device pixels. Use cssVisualViewport instead.
	ContentSize       *dom.Rect       `json:"contentSize"`       // Deprecated size of scrollable area. Is in DP. Use cssContentSize instead.
	CSSLayoutViewport *LayoutViewport `json:"cssLayoutViewport"` // Metrics relating to the layout viewport in CSS pixels.
	CSSVisualViewport *VisualViewport `json:"cssVisualViewport"` // Metrics relating to the visual viewport in CSS pixels.
	CSSContentSize    *dom.Rect       `json:"cssContentSize"`    // Size of scrollable area in CSS pixels.
}

// Do executes Page.getLayoutMetrics against the provided context.
//
// returns:
//
//	layoutViewport - Deprecated metrics relating to the layout viewport. Is in device pixels. Use cssLayoutViewport instead.
//	visualViewport - Deprecated metrics relating to the visual viewport. Is in device pixels. Use cssVisualViewport instead.
//	contentSize - Deprecated size of scrollable area. Is in DP. Use cssContentSize instead.
//	cssLayoutViewport - Metrics relating to the layout viewport in CSS pixels.
//	cssVisualViewport - Metrics relating to the visual viewport in CSS pixels.
//	cssContentSize - Size of scrollable area in CSS pixels.
func (p *GetLayoutMetricsParams) Do(ctx context.Context) (layoutViewport *LayoutViewport, visualViewport *VisualViewport, contentSize *dom.Rect, cssLayoutViewport *LayoutViewport, cssVisualViewport *VisualViewport, cssContentSize *dom.Rect, err error) {
	// execute
	var res GetLayoutMetricsReturns
	err = cdp.Execute(ctx, CommandGetLayoutMetrics, nil, &res)
	if err != nil {
		return nil, nil, nil, nil, nil, nil, err
	}

	return res.LayoutViewport, res.VisualViewport, res.ContentSize, res.CSSLayoutViewport, res.CSSVisualViewport, res.CSSContentSize, nil
}

// GetNavigationHistoryParams returns navigation history for the current
// page.
type GetNavigationHistoryParams struct{}

// GetNavigationHistory returns navigation history for the current page.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-getNavigationHistory
func GetNavigationHistory() *GetNavigationHistoryParams {
	return &GetNavigationHistoryParams{}
}

// GetNavigationHistoryReturns return values.
type GetNavigationHistoryReturns struct {
	CurrentIndex int64              `json:"currentIndex,omitempty,omitzero"` // Index of the current navigation history entry.
	Entries      []*NavigationEntry `json:"entries,omitempty,omitzero"`      // Array of navigation history entries.
}

// Do executes Page.getNavigationHistory against the provided context.
//
// returns:
//
//	currentIndex - Index of the current navigation history entry.
//	entries - Array of navigation history entries.
func (p *GetNavigationHistoryParams) Do(ctx context.Context) (currentIndex int64, entries []*NavigationEntry, err error) {
	// execute
	var res GetNavigationHistoryReturns
	err = cdp.Execute(ctx, CommandGetNavigationHistory, nil, &res)
	if err != nil {
		return 0, nil, err
	}

	return res.CurrentIndex, res.Entries, nil
}

// ResetNavigationHistoryParams resets navigation history for the current
// page.
type ResetNavigationHistoryParams struct{}

// ResetNavigationHistory resets navigation history for the current page.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-resetNavigationHistory
func ResetNavigationHistory() *ResetNavigationHistoryParams {
	return &ResetNavigationHistoryParams{}
}

// Do executes Page.resetNavigationHistory against the provided context.
func (p *ResetNavigationHistoryParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandResetNavigationHistory, nil, nil)
}

// GetResourceContentParams returns content of the given resource.
type GetResourceContentParams struct {
	FrameID cdp.FrameID `json:"frameId"` // Frame id to get resource for.
	URL     string      `json:"url"`     // URL of the resource to get content for.
}

// GetResourceContent returns content of the given resource.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-getResourceContent
//
// parameters:
//
//	frameID - Frame id to get resource for.
//	url - URL of the resource to get content for.
func GetResourceContent(frameID cdp.FrameID, url string) *GetResourceContentParams {
	return &GetResourceContentParams{
		FrameID: frameID,
		URL:     url,
	}
}

// GetResourceContentReturns return values.
type GetResourceContentReturns struct {
	Content       string `json:"content,omitempty,omitzero"` // Resource content.
	Base64encoded bool   `json:"base64Encoded"`              // True, if content was served as base64.
}

// Do executes Page.getResourceContent against the provided context.
//
// returns:
//
//	content - Resource content.
func (p *GetResourceContentParams) Do(ctx context.Context) (content []byte, err error) {
	// execute
	var res GetResourceContentReturns
	err = cdp.Execute(ctx, CommandGetResourceContent, p, &res)
	if err != nil {
		return nil, err
	}

	// decode
	var dec []byte
	if res.Base64encoded {
		dec, err = base64.StdEncoding.DecodeString(res.Content)
		if err != nil {
			return nil, err
		}
	} else {
		dec = []byte(res.Content)
	}
	return dec, nil
}

// GetResourceTreeParams returns present frame / resource tree structure.
type GetResourceTreeParams struct{}

// GetResourceTree returns present frame / resource tree structure.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-getResourceTree
func GetResourceTree() *GetResourceTreeParams {
	return &GetResourceTreeParams{}
}

// GetResourceTreeReturns return values.
type GetResourceTreeReturns struct {
	FrameTree *FrameResourceTree `json:"frameTree,omitempty,omitzero"` // Present frame / resource tree structure.
}

// Do executes Page.getResourceTree against the provided context.
//
// returns:
//
//	frameTree - Present frame / resource tree structure.
func (p *GetResourceTreeParams) Do(ctx context.Context) (frameTree *FrameResourceTree, err error) {
	// execute
	var res GetResourceTreeReturns
	err = cdp.Execute(ctx, CommandGetResourceTree, nil, &res)
	if err != nil {
		return nil, err
	}

	return res.FrameTree, nil
}

// HandleJavaScriptDialogParams accepts or dismisses a JavaScript initiated
// dialog (alert, confirm, prompt, or onbeforeunload).
type HandleJavaScriptDialogParams struct {
	Accept     bool   `json:"accept"`                        // Whether to accept or dismiss the dialog.
	PromptText string `json:"promptText,omitempty,omitzero"` // The text to enter into the dialog prompt before accepting. Used only if this is a prompt dialog.
}

// HandleJavaScriptDialog accepts or dismisses a JavaScript initiated dialog
// (alert, confirm, prompt, or onbeforeunload).
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-handleJavaScriptDialog
//
// parameters:
//
//	accept - Whether to accept or dismiss the dialog.
func HandleJavaScriptDialog(accept bool) *HandleJavaScriptDialogParams {
	return &HandleJavaScriptDialogParams{
		Accept: accept,
	}
}

// WithPromptText the text to enter into the dialog prompt before accepting.
// Used only if this is a prompt dialog.
func (p HandleJavaScriptDialogParams) WithPromptText(promptText string) *HandleJavaScriptDialogParams {
	p.PromptText = promptText
	return &p
}

// Do executes Page.handleJavaScriptDialog against the provided context.
func (p *HandleJavaScriptDialogParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandHandleJavaScriptDialog, p, nil)
}

// NavigateParams navigates current page to the given URL.
type NavigateParams struct {
	URL            string         `json:"url"`                               // URL to navigate the page to.
	Referrer       string         `json:"referrer,omitempty,omitzero"`       // Referrer URL.
	TransitionType TransitionType `json:"transitionType,omitempty,omitzero"` // Intended transition type.
	FrameID        cdp.FrameID    `json:"frameId,omitempty,omitzero"`        // Frame id to navigate, if not specified navigates the top frame.
	ReferrerPolicy ReferrerPolicy `json:"referrerPolicy,omitempty,omitzero"` // Referrer-policy used for the navigation.
}

// Navigate navigates current page to the given URL.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-navigate
//
// parameters:
//
//	url - URL to navigate the page to.
func Navigate(url string) *NavigateParams {
	return &NavigateParams{
		URL: url,
	}
}

// WithReferrer referrer URL.
func (p NavigateParams) WithReferrer(referrer string) *NavigateParams {
	p.Referrer = referrer
	return &p
}

// WithTransitionType intended transition type.
func (p NavigateParams) WithTransitionType(transitionType TransitionType) *NavigateParams {
	p.TransitionType = transitionType
	return &p
}

// WithFrameID frame id to navigate, if not specified navigates the top
// frame.
func (p NavigateParams) WithFrameID(frameID cdp.FrameID) *NavigateParams {
	p.FrameID = frameID
	return &p
}

// WithReferrerPolicy referrer-policy used for the navigation.
func (p NavigateParams) WithReferrerPolicy(referrerPolicy ReferrerPolicy) *NavigateParams {
	p.ReferrerPolicy = referrerPolicy
	return &p
}

// NavigateReturns return values.
type NavigateReturns struct {
	FrameID    cdp.FrameID  `json:"frameId,omitempty,omitzero"`   // Frame id that has navigated (or failed to navigate)
	LoaderID   cdp.LoaderID `json:"loaderId,omitempty,omitzero"`  // Loader identifier. This is omitted in case of same-document navigation, as the previously committed loaderId would not change.
	ErrorText  string       `json:"errorText,omitempty,omitzero"` // User friendly error message, present if and only if navigation has failed.
	IsDownload bool         `json:"isDownload"`                   // Whether the navigation resulted in a download.
}

// Do executes Page.navigate against the provided context.
//
// returns:
//
//	frameID - Frame id that has navigated (or failed to navigate)
//	loaderID - Loader identifier. This is omitted in case of same-document navigation, as the previously committed loaderId would not change.
//	errorText - User friendly error message, present if and only if navigation has failed.
//	isDownload - Whether the navigation resulted in a download.
func (p *NavigateParams) Do(ctx context.Context) (frameID cdp.FrameID, loaderID cdp.LoaderID, errorText string, isDownload bool, err error) {
	// execute
	var res NavigateReturns
	err = cdp.Execute(ctx, CommandNavigate, p, &res)
	if err != nil {
		return "", "", "", false, err
	}

	return res.FrameID, res.LoaderID, res.ErrorText, res.IsDownload, nil
}

// NavigateToHistoryEntryParams navigates current page to the given history
// entry.
type NavigateToHistoryEntryParams struct {
	EntryID int64 `json:"entryId"` // Unique id of the entry to navigate to.
}

// NavigateToHistoryEntry navigates current page to the given history entry.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-navigateToHistoryEntry
//
// parameters:
//
//	entryID - Unique id of the entry to navigate to.
func NavigateToHistoryEntry(entryID int64) *NavigateToHistoryEntryParams {
	return &NavigateToHistoryEntryParams{
		EntryID: entryID,
	}
}

// Do executes Page.navigateToHistoryEntry against the provided context.
func (p *NavigateToHistoryEntryParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandNavigateToHistoryEntry, p, nil)
}

// PrintToPDFParams print page as PDF.
type PrintToPDFParams struct {
	Landscape               bool                   `json:"landscape"`                         // Paper orientation. Defaults to false.
	DisplayHeaderFooter     bool                   `json:"displayHeaderFooter"`               // Display header and footer. Defaults to false.
	PrintBackground         bool                   `json:"printBackground"`                   // Print background graphics. Defaults to false.
	Scale                   float64                `json:"scale,omitempty,omitzero"`          // Scale of the webpage rendering. Defaults to 1.
	PaperWidth              float64                `json:"paperWidth,omitempty,omitzero"`     // Paper width in inches. Defaults to 8.5 inches.
	PaperHeight             float64                `json:"paperHeight,omitempty,omitzero"`    // Paper height in inches. Defaults to 11 inches.
	MarginTop               float64                `json:"marginTop"`                         // Top margin in inches. Defaults to 1cm (~0.4 inches).
	MarginBottom            float64                `json:"marginBottom"`                      // Bottom margin in inches. Defaults to 1cm (~0.4 inches).
	MarginLeft              float64                `json:"marginLeft"`                        // Left margin in inches. Defaults to 1cm (~0.4 inches).
	MarginRight             float64                `json:"marginRight"`                       // Right margin in inches. Defaults to 1cm (~0.4 inches).
	PageRanges              string                 `json:"pageRanges,omitempty,omitzero"`     // Paper ranges to print, one based, e.g., '1-5, 8, 11-13'. Pages are printed in the document order, not in the order specified, and no more than once. Defaults to empty string, which implies the entire document is printed. The page numbers are quietly capped to actual page count of the document, and ranges beyond the end of the document are ignored. If this results in no pages to print, an error is reported. It is an error to specify a range with start greater than end.
	HeaderTemplate          string                 `json:"headerTemplate,omitempty,omitzero"` // HTML template for the print header. Should be valid HTML markup with following classes used to inject printing values into them: - date: formatted print date - title: document title - url: document location - pageNumber: current page number - totalPages: total pages in the document  For example, <span class=title></span> would generate span containing the title.
	FooterTemplate          string                 `json:"footerTemplate,omitempty,omitzero"` // HTML template for the print footer. Should use the same format as the headerTemplate.
	PreferCSSPageSize       bool                   `json:"preferCSSPageSize"`                 // Whether or not to prefer page size as defined by css. Defaults to false, in which case the content will be scaled to fit the paper size.
	TransferMode            PrintToPDFTransferMode `json:"transferMode,omitempty,omitzero"`   // return as stream
	GenerateTaggedPDF       bool                   `json:"generateTaggedPDF"`                 // Whether or not to generate tagged (accessible) PDF. Defaults to embedder choice.
	GenerateDocumentOutline bool                   `json:"generateDocumentOutline"`           // Whether or not to embed the document outline into the PDF.
}

// PrintToPDF print page as PDF.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-printToPDF
//
// parameters:
func PrintToPDF() *PrintToPDFParams {
	return &PrintToPDFParams{
		Landscape:               false,
		DisplayHeaderFooter:     false,
		PrintBackground:         false,
		PreferCSSPageSize:       false,
		GenerateTaggedPDF:       false,
		GenerateDocumentOutline: false,
	}
}

// WithLandscape paper orientation. Defaults to false.
func (p PrintToPDFParams) WithLandscape(landscape bool) *PrintToPDFParams {
	p.Landscape = landscape
	return &p
}

// WithDisplayHeaderFooter display header and footer. Defaults to false.
func (p PrintToPDFParams) WithDisplayHeaderFooter(displayHeaderFooter bool) *PrintToPDFParams {
	p.DisplayHeaderFooter = displayHeaderFooter
	return &p
}

// WithPrintBackground print background graphics. Defaults to false.
func (p PrintToPDFParams) WithPrintBackground(printBackground bool) *PrintToPDFParams {
	p.PrintBackground = printBackground
	return &p
}

// WithScale scale of the webpage rendering. Defaults to 1.
func (p PrintToPDFParams) WithScale(scale float64) *PrintToPDFParams {
	p.Scale = scale
	return &p
}

// WithPaperWidth paper width in inches. Defaults to 8.5 inches.
func (p PrintToPDFParams) WithPaperWidth(paperWidth float64) *PrintToPDFParams {
	p.PaperWidth = paperWidth
	return &p
}

// WithPaperHeight paper height in inches. Defaults to 11 inches.
func (p PrintToPDFParams) WithPaperHeight(paperHeight float64) *PrintToPDFParams {
	p.PaperHeight = paperHeight
	return &p
}

// WithMarginTop top margin in inches. Defaults to 1cm (~0.4 inches).
func (p PrintToPDFParams) WithMarginTop(marginTop float64) *PrintToPDFParams {
	p.MarginTop = marginTop
	return &p
}

// WithMarginBottom bottom margin in inches. Defaults to 1cm (~0.4 inches).
func (p PrintToPDFParams) WithMarginBottom(marginBottom float64) *PrintToPDFParams {
	p.MarginBottom = marginBottom
	return &p
}

// WithMarginLeft left margin in inches. Defaults to 1cm (~0.4 inches).
func (p PrintToPDFParams) WithMarginLeft(marginLeft float64) *PrintToPDFParams {
	p.MarginLeft = marginLeft
	return &p
}

// WithMarginRight right margin in inches. Defaults to 1cm (~0.4 inches).
func (p PrintToPDFParams) WithMarginRight(marginRight float64) *PrintToPDFParams {
	p.MarginRight = marginRight
	return &p
}

// WithPageRanges paper ranges to print, one based, e.g., '1-5, 8, 11-13'.
// Pages are printed in the document order, not in the order specified, and no
// more than once. Defaults to empty string, which implies the entire document
// is printed. The page numbers are quietly capped to actual page count of the
// document, and ranges beyond the end of the document are ignored. If this
// results in no pages to print, an error is reported. It is an error to specify
// a range with start greater than end.
func (p PrintToPDFParams) WithPageRanges(pageRanges string) *PrintToPDFParams {
	p.PageRanges = pageRanges
	return &p
}

// WithHeaderTemplate HTML template for the print header. Should be valid
// HTML markup with following classes used to inject printing values into them:
// - date: formatted print date - title: document title - url: document location
// - pageNumber: current page number - totalPages: total pages in the document
// For example, <span class=title></span> would generate span containing the
// title.
func (p PrintToPDFParams) WithHeaderTemplate(headerTemplate string) *PrintToPDFParams {
	p.HeaderTemplate = headerTemplate
	return &p
}

// WithFooterTemplate HTML template for the print footer. Should use the same
// format as the headerTemplate.
func (p PrintToPDFParams) WithFooterTemplate(footerTemplate string) *PrintToPDFParams {
	p.FooterTemplate = footerTemplate
	return &p
}

// WithPreferCSSPageSize whether or not to prefer page size as defined by
// css. Defaults to false, in which case the content will be scaled to fit the
// paper size.
func (p PrintToPDFParams) WithPreferCSSPageSize(preferCSSPageSize bool) *PrintToPDFParams {
	p.PreferCSSPageSize = preferCSSPageSize
	return &p
}

// WithTransferMode return as stream.
func (p PrintToPDFParams) WithTransferMode(transferMode PrintToPDFTransferMode) *PrintToPDFParams {
	p.TransferMode = transferMode
	return &p
}

// WithGenerateTaggedPDF whether or not to generate tagged (accessible) PDF.
// Defaults to embedder choice.
func (p PrintToPDFParams) WithGenerateTaggedPDF(generateTaggedPDF bool) *PrintToPDFParams {
	p.GenerateTaggedPDF = generateTaggedPDF
	return &p
}

// WithGenerateDocumentOutline whether or not to embed the document outline
// into the PDF.
func (p PrintToPDFParams) WithGenerateDocumentOutline(generateDocumentOutline bool) *PrintToPDFParams {
	p.GenerateDocumentOutline = generateDocumentOutline
	return &p
}

// PrintToPDFReturns return values.
type PrintToPDFReturns struct {
	Data   string          `json:"data,omitempty,omitzero"`   // Base64-encoded pdf data. Empty if |returnAsStream| is specified.
	Stream io.StreamHandle `json:"stream,omitempty,omitzero"` // A handle of the stream that holds resulting PDF data.
}

// Do executes Page.printToPDF against the provided context.
//
// returns:
//
//	data - Base64-encoded pdf data. Empty if |returnAsStream| is specified.
//	stream - A handle of the stream that holds resulting PDF data.
func (p *PrintToPDFParams) Do(ctx context.Context) (data []byte, stream io.StreamHandle, err error) {
	// execute
	var res PrintToPDFReturns
	err = cdp.Execute(ctx, CommandPrintToPDF, p, &res)
	if err != nil {
		return nil, "", err
	}

	// decode
	var dec []byte
	dec, err = base64.StdEncoding.DecodeString(res.Data)
	if err != nil {
		return nil, "", err
	}
	return dec, res.Stream, nil
}

// ReloadParams reloads given page optionally ignoring the cache.
type ReloadParams struct {
	IgnoreCache            bool         `json:"ignoreCache"`                               // If true, browser cache is ignored (as if the user pressed Shift+refresh).
	ScriptToEvaluateOnLoad string       `json:"scriptToEvaluateOnLoad,omitempty,omitzero"` // If set, the script will be injected into all frames of the inspected page after reload. Argument will be ignored if reloading dataURL origin.
	LoaderID               cdp.LoaderID `json:"loaderId,omitempty,omitzero"`               // If set, an error will be thrown if the target page's main frame's loader id does not match the provided id. This prevents accidentally reloading an unintended target in case there's a racing navigation.
}

// Reload reloads given page optionally ignoring the cache.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-reload
//
// parameters:
func Reload() *ReloadParams {
	return &ReloadParams{
		IgnoreCache: false,
	}
}

// WithIgnoreCache if true, browser cache is ignored (as if the user pressed
// Shift+refresh).
func (p ReloadParams) WithIgnoreCache(ignoreCache bool) *ReloadParams {
	p.IgnoreCache = ignoreCache
	return &p
}

// WithScriptToEvaluateOnLoad if set, the script will be injected into all
// frames of the inspected page after reload. Argument will be ignored if
// reloading dataURL origin.
func (p ReloadParams) WithScriptToEvaluateOnLoad(scriptToEvaluateOnLoad string) *ReloadParams {
	p.ScriptToEvaluateOnLoad = scriptToEvaluateOnLoad
	return &p
}

// WithLoaderID if set, an error will be thrown if the target page's main
// frame's loader id does not match the provided id. This prevents accidentally
// reloading an unintended target in case there's a racing navigation.
func (p ReloadParams) WithLoaderID(loaderID cdp.LoaderID) *ReloadParams {
	p.LoaderID = loaderID
	return &p
}

// Do executes Page.reload against the provided context.
func (p *ReloadParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandReload, p, nil)
}

// RemoveScriptToEvaluateOnNewDocumentParams removes given script from the
// list.
type RemoveScriptToEvaluateOnNewDocumentParams struct {
	Identifier ScriptIdentifier `json:"identifier"`
}

// RemoveScriptToEvaluateOnNewDocument removes given script from the list.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-removeScriptToEvaluateOnNewDocument
//
// parameters:
//
//	identifier
func RemoveScriptToEvaluateOnNewDocument(identifier ScriptIdentifier) *RemoveScriptToEvaluateOnNewDocumentParams {
	return &RemoveScriptToEvaluateOnNewDocumentParams{
		Identifier: identifier,
	}
}

// Do executes Page.removeScriptToEvaluateOnNewDocument against the provided context.
func (p *RemoveScriptToEvaluateOnNewDocumentParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandRemoveScriptToEvaluateOnNewDocument, p, nil)
}

// ScreencastFrameAckParams acknowledges that a screencast frame has been
// received by the frontend.
type ScreencastFrameAckParams struct {
	SessionID int64 `json:"sessionId"` // Frame number.
}

// ScreencastFrameAck acknowledges that a screencast frame has been received
// by the frontend.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-screencastFrameAck
//
// parameters:
//
//	sessionID - Frame number.
func ScreencastFrameAck(sessionID int64) *ScreencastFrameAckParams {
	return &ScreencastFrameAckParams{
		SessionID: sessionID,
	}
}

// Do executes Page.screencastFrameAck against the provided context.
func (p *ScreencastFrameAckParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandScreencastFrameAck, p, nil)
}

// SearchInResourceParams searches for given string in resource content.
type SearchInResourceParams struct {
	FrameID       cdp.FrameID `json:"frameId"`       // Frame id for resource to search in.
	URL           string      `json:"url"`           // URL of the resource to search in.
	Query         string      `json:"query"`         // String to search for.
	CaseSensitive bool        `json:"caseSensitive"` // If true, search is case sensitive.
	IsRegex       bool        `json:"isRegex"`       // If true, treats string parameter as regex.
}

// SearchInResource searches for given string in resource content.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-searchInResource
//
// parameters:
//
//	frameID - Frame id for resource to search in.
//	url - URL of the resource to search in.
//	query - String to search for.
func SearchInResource(frameID cdp.FrameID, url string, query string) *SearchInResourceParams {
	return &SearchInResourceParams{
		FrameID:       frameID,
		URL:           url,
		Query:         query,
		CaseSensitive: false,
		IsRegex:       false,
	}
}

// WithCaseSensitive if true, search is case sensitive.
func (p SearchInResourceParams) WithCaseSensitive(caseSensitive bool) *SearchInResourceParams {
	p.CaseSensitive = caseSensitive
	return &p
}

// WithIsRegex if true, treats string parameter as regex.
func (p SearchInResourceParams) WithIsRegex(isRegex bool) *SearchInResourceParams {
	p.IsRegex = isRegex
	return &p
}

// SearchInResourceReturns return values.
type SearchInResourceReturns struct {
	Result []*debugger.SearchMatch `json:"result,omitempty,omitzero"` // List of search matches.
}

// Do executes Page.searchInResource against the provided context.
//
// returns:
//
//	result - List of search matches.
func (p *SearchInResourceParams) Do(ctx context.Context) (result []*debugger.SearchMatch, err error) {
	// execute
	var res SearchInResourceReturns
	err = cdp.Execute(ctx, CommandSearchInResource, p, &res)
	if err != nil {
		return nil, err
	}

	return res.Result, nil
}

// SetAdBlockingEnabledParams enable Chrome's experimental ad filter on all
// sites.
type SetAdBlockingEnabledParams struct {
	Enabled bool `json:"enabled"` // Whether to block ads.
}

// SetAdBlockingEnabled enable Chrome's experimental ad filter on all sites.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-setAdBlockingEnabled
//
// parameters:
//
//	enabled - Whether to block ads.
func SetAdBlockingEnabled(enabled bool) *SetAdBlockingEnabledParams {
	return &SetAdBlockingEnabledParams{
		Enabled: enabled,
	}
}

// Do executes Page.setAdBlockingEnabled against the provided context.
func (p *SetAdBlockingEnabledParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetAdBlockingEnabled, p, nil)
}

// SetBypassCSPParams enable page Content Security Policy by-passing.
type SetBypassCSPParams struct {
	Enabled bool `json:"enabled"` // Whether to bypass page CSP.
}

// SetBypassCSP enable page Content Security Policy by-passing.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-setBypassCSP
//
// parameters:
//
//	enabled - Whether to bypass page CSP.
func SetBypassCSP(enabled bool) *SetBypassCSPParams {
	return &SetBypassCSPParams{
		Enabled: enabled,
	}
}

// Do executes Page.setBypassCSP against the provided context.
func (p *SetBypassCSPParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetBypassCSP, p, nil)
}

// GetPermissionsPolicyStateParams get Permissions Policy state on given
// frame.
type GetPermissionsPolicyStateParams struct {
	FrameID cdp.FrameID `json:"frameId"`
}

// GetPermissionsPolicyState get Permissions Policy state on given frame.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-getPermissionsPolicyState
//
// parameters:
//
//	frameID
func GetPermissionsPolicyState(frameID cdp.FrameID) *GetPermissionsPolicyStateParams {
	return &GetPermissionsPolicyStateParams{
		FrameID: frameID,
	}
}

// GetPermissionsPolicyStateReturns return values.
type GetPermissionsPolicyStateReturns struct {
	States []*PermissionsPolicyFeatureState `json:"states,omitempty,omitzero"`
}

// Do executes Page.getPermissionsPolicyState against the provided context.
//
// returns:
//
//	states
func (p *GetPermissionsPolicyStateParams) Do(ctx context.Context) (states []*PermissionsPolicyFeatureState, err error) {
	// execute
	var res GetPermissionsPolicyStateReturns
	err = cdp.Execute(ctx, CommandGetPermissionsPolicyState, p, &res)
	if err != nil {
		return nil, err
	}

	return res.States, nil
}

// GetOriginTrialsParams get Origin Trials on given frame.
type GetOriginTrialsParams struct {
	FrameID cdp.FrameID `json:"frameId"`
}

// GetOriginTrials get Origin Trials on given frame.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-getOriginTrials
//
// parameters:
//
//	frameID
func GetOriginTrials(frameID cdp.FrameID) *GetOriginTrialsParams {
	return &GetOriginTrialsParams{
		FrameID: frameID,
	}
}

// GetOriginTrialsReturns return values.
type GetOriginTrialsReturns struct {
	OriginTrials []*cdp.OriginTrial `json:"originTrials,omitempty,omitzero"`
}

// Do executes Page.getOriginTrials against the provided context.
//
// returns:
//
//	originTrials
func (p *GetOriginTrialsParams) Do(ctx context.Context) (originTrials []*cdp.OriginTrial, err error) {
	// execute
	var res GetOriginTrialsReturns
	err = cdp.Execute(ctx, CommandGetOriginTrials, p, &res)
	if err != nil {
		return nil, err
	}

	return res.OriginTrials, nil
}

// SetFontFamiliesParams set generic font families.
type SetFontFamiliesParams struct {
	FontFamilies *FontFamilies         `json:"fontFamilies"`                  // Specifies font families to set. If a font family is not specified, it won't be changed.
	ForScripts   []*ScriptFontFamilies `json:"forScripts,omitempty,omitzero"` // Specifies font families to set for individual scripts.
}

// SetFontFamilies set generic font families.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-setFontFamilies
//
// parameters:
//
//	fontFamilies - Specifies font families to set. If a font family is not specified, it won't be changed.
func SetFontFamilies(fontFamilies *FontFamilies) *SetFontFamiliesParams {
	return &SetFontFamiliesParams{
		FontFamilies: fontFamilies,
	}
}

// WithForScripts specifies font families to set for individual scripts.
func (p SetFontFamiliesParams) WithForScripts(forScripts []*ScriptFontFamilies) *SetFontFamiliesParams {
	p.ForScripts = forScripts
	return &p
}

// Do executes Page.setFontFamilies against the provided context.
func (p *SetFontFamiliesParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetFontFamilies, p, nil)
}

// SetFontSizesParams set default font sizes.
type SetFontSizesParams struct {
	FontSizes *FontSizes `json:"fontSizes"` // Specifies font sizes to set. If a font size is not specified, it won't be changed.
}

// SetFontSizes set default font sizes.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-setFontSizes
//
// parameters:
//
//	fontSizes - Specifies font sizes to set. If a font size is not specified, it won't be changed.
func SetFontSizes(fontSizes *FontSizes) *SetFontSizesParams {
	return &SetFontSizesParams{
		FontSizes: fontSizes,
	}
}

// Do executes Page.setFontSizes against the provided context.
func (p *SetFontSizesParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetFontSizes, p, nil)
}

// SetDocumentContentParams sets given markup as the document's HTML.
type SetDocumentContentParams struct {
	FrameID cdp.FrameID `json:"frameId"` // Frame id to set HTML for.
	HTML    string      `json:"html"`    // HTML content to set.
}

// SetDocumentContent sets given markup as the document's HTML.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-setDocumentContent
//
// parameters:
//
//	frameID - Frame id to set HTML for.
//	html - HTML content to set.
func SetDocumentContent(frameID cdp.FrameID, html string) *SetDocumentContentParams {
	return &SetDocumentContentParams{
		FrameID: frameID,
		HTML:    html,
	}
}

// Do executes Page.setDocumentContent against the provided context.
func (p *SetDocumentContentParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetDocumentContent, p, nil)
}

// SetLifecycleEventsEnabledParams controls whether page will emit lifecycle
// events.
type SetLifecycleEventsEnabledParams struct {
	Enabled bool `json:"enabled"` // If true, starts emitting lifecycle events.
}

// SetLifecycleEventsEnabled controls whether page will emit lifecycle
// events.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-setLifecycleEventsEnabled
//
// parameters:
//
//	enabled - If true, starts emitting lifecycle events.
func SetLifecycleEventsEnabled(enabled bool) *SetLifecycleEventsEnabledParams {
	return &SetLifecycleEventsEnabledParams{
		Enabled: enabled,
	}
}

// Do executes Page.setLifecycleEventsEnabled against the provided context.
func (p *SetLifecycleEventsEnabledParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetLifecycleEventsEnabled, p, nil)
}

// StartScreencastParams starts sending each frame using the screencastFrame
// event.
type StartScreencastParams struct {
	Format        ScreencastFormat `json:"format,omitempty,omitzero"`        // Image compression format.
	Quality       int64            `json:"quality,omitempty,omitzero"`       // Compression quality from range [0..100].
	MaxWidth      int64            `json:"maxWidth,omitempty,omitzero"`      // Maximum screenshot width.
	MaxHeight     int64            `json:"maxHeight,omitempty,omitzero"`     // Maximum screenshot height.
	EveryNthFrame int64            `json:"everyNthFrame,omitempty,omitzero"` // Send every n-th frame.
}

// StartScreencast starts sending each frame using the screencastFrame event.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-startScreencast
//
// parameters:
func StartScreencast() *StartScreencastParams {
	return &StartScreencastParams{}
}

// WithFormat image compression format.
func (p StartScreencastParams) WithFormat(format ScreencastFormat) *StartScreencastParams {
	p.Format = format
	return &p
}

// WithQuality compression quality from range [0..100].
func (p StartScreencastParams) WithQuality(quality int64) *StartScreencastParams {
	p.Quality = quality
	return &p
}

// WithMaxWidth maximum screenshot width.
func (p StartScreencastParams) WithMaxWidth(maxWidth int64) *StartScreencastParams {
	p.MaxWidth = maxWidth
	return &p
}

// WithMaxHeight maximum screenshot height.
func (p StartScreencastParams) WithMaxHeight(maxHeight int64) *StartScreencastParams {
	p.MaxHeight = maxHeight
	return &p
}

// WithEveryNthFrame send every n-th frame.
func (p StartScreencastParams) WithEveryNthFrame(everyNthFrame int64) *StartScreencastParams {
	p.EveryNthFrame = everyNthFrame
	return &p
}

// Do executes Page.startScreencast against the provided context.
func (p *StartScreencastParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandStartScreencast, p, nil)
}

// StopLoadingParams force the page stop all navigations and pending resource
// fetches.
type StopLoadingParams struct{}

// StopLoading force the page stop all navigations and pending resource
// fetches.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-stopLoading
func StopLoading() *StopLoadingParams {
	return &StopLoadingParams{}
}

// Do executes Page.stopLoading against the provided context.
func (p *StopLoadingParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandStopLoading, nil, nil)
}

// CrashParams crashes renderer on the IO thread, generates minidumps.
type CrashParams struct{}

// Crash crashes renderer on the IO thread, generates minidumps.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-crash
func Crash() *CrashParams {
	return &CrashParams{}
}

// Do executes Page.crash against the provided context.
func (p *CrashParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandCrash, nil, nil)
}

// CloseParams tries to close page, running its beforeunload hooks, if any.
type CloseParams struct{}

// Close tries to close page, running its beforeunload hooks, if any.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-close
func Close() *CloseParams {
	return &CloseParams{}
}

// Do executes Page.close against the provided context.
func (p *CloseParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandClose, nil, nil)
}

// SetWebLifecycleStateParams tries to update the web lifecycle state of the
// page. It will transition the page to the given state according to:
// https://github.com/WICG/web-lifecycle/.
type SetWebLifecycleStateParams struct {
	State SetWebLifecycleStateState `json:"state"` // Target lifecycle state
}

// SetWebLifecycleState tries to update the web lifecycle state of the page.
// It will transition the page to the given state according to:
// https://github.com/WICG/web-lifecycle/.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-setWebLifecycleState
//
// parameters:
//
//	state - Target lifecycle state
func SetWebLifecycleState(state SetWebLifecycleStateState) *SetWebLifecycleStateParams {
	return &SetWebLifecycleStateParams{
		State: state,
	}
}

// Do executes Page.setWebLifecycleState against the provided context.
func (p *SetWebLifecycleStateParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetWebLifecycleState, p, nil)
}

// StopScreencastParams stops sending each frame in the screencastFrame.
type StopScreencastParams struct{}

// StopScreencast stops sending each frame in the screencastFrame.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-stopScreencast
func StopScreencast() *StopScreencastParams {
	return &StopScreencastParams{}
}

// Do executes Page.stopScreencast against the provided context.
func (p *StopScreencastParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandStopScreencast, nil, nil)
}

// ProduceCompilationCacheParams requests backend to produce compilation
// cache for the specified scripts. scripts are appended to the list of scripts
// for which the cache would be produced. The list may be reset during page
// navigation. When script with a matching URL is encountered, the cache is
// optionally produced upon backend discretion, based on internal heuristics.
// See also: Page.compilationCacheProduced.
type ProduceCompilationCacheParams struct {
	Scripts []*CompilationCacheParams `json:"scripts"`
}

// ProduceCompilationCache requests backend to produce compilation cache for
// the specified scripts. scripts are appended to the list of scripts for which
// the cache would be produced. The list may be reset during page navigation.
// When script with a matching URL is encountered, the cache is optionally
// produced upon backend discretion, based on internal heuristics. See also:
// Page.compilationCacheProduced.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-produceCompilationCache
//
// parameters:
//
//	scripts
func ProduceCompilationCache(scripts []*CompilationCacheParams) *ProduceCompilationCacheParams {
	return &ProduceCompilationCacheParams{
		Scripts: scripts,
	}
}

// Do executes Page.produceCompilationCache against the provided context.
func (p *ProduceCompilationCacheParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandProduceCompilationCache, p, nil)
}

// AddCompilationCacheParams seeds compilation cache for given url.
// Compilation cache does not survive cross-process navigation.
type AddCompilationCacheParams struct {
	URL  string `json:"url"`
	Data string `json:"data"` // Base64-encoded data
}

// AddCompilationCache seeds compilation cache for given url. Compilation
// cache does not survive cross-process navigation.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-addCompilationCache
//
// parameters:
//
//	url
//	data - Base64-encoded data
func AddCompilationCache(url string, data string) *AddCompilationCacheParams {
	return &AddCompilationCacheParams{
		URL:  url,
		Data: data,
	}
}

// Do executes Page.addCompilationCache against the provided context.
func (p *AddCompilationCacheParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandAddCompilationCache, p, nil)
}

// ClearCompilationCacheParams clears seeded compilation cache.
type ClearCompilationCacheParams struct{}

// ClearCompilationCache clears seeded compilation cache.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-clearCompilationCache
func ClearCompilationCache() *ClearCompilationCacheParams {
	return &ClearCompilationCacheParams{}
}

// Do executes Page.clearCompilationCache against the provided context.
func (p *ClearCompilationCacheParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandClearCompilationCache, nil, nil)
}

// SetSPCTransactionModeParams sets the Secure Payment Confirmation
// transaction mode.
// https://w3c.github.io/secure-payment-confirmation/#sctn-automation-set-spc-transaction-mode.
type SetSPCTransactionModeParams struct {
	Mode SetSPCTransactionModeMode `json:"mode"`
}

// SetSPCTransactionMode sets the Secure Payment Confirmation transaction
// mode.
// https://w3c.github.io/secure-payment-confirmation/#sctn-automation-set-spc-transaction-mode.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-setSPCTransactionMode
//
// parameters:
//
//	mode
func SetSPCTransactionMode(mode SetSPCTransactionModeMode) *SetSPCTransactionModeParams {
	return &SetSPCTransactionModeParams{
		Mode: mode,
	}
}

// Do executes Page.setSPCTransactionMode against the provided context.
func (p *SetSPCTransactionModeParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetSPCTransactionMode, p, nil)
}

// SetRPHRegistrationModeParams extensions for Custom Handlers API:
// https://html.spec.whatwg.org/multipage/system-state.html#rph-automation.
type SetRPHRegistrationModeParams struct {
	Mode SetRPHRegistrationModeMode `json:"mode"`
}

// SetRPHRegistrationMode extensions for Custom Handlers API:
// https://html.spec.whatwg.org/multipage/system-state.html#rph-automation.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-setRPHRegistrationMode
//
// parameters:
//
//	mode
func SetRPHRegistrationMode(mode SetRPHRegistrationModeMode) *SetRPHRegistrationModeParams {
	return &SetRPHRegistrationModeParams{
		Mode: mode,
	}
}

// Do executes Page.setRPHRegistrationMode against the provided context.
func (p *SetRPHRegistrationModeParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetRPHRegistrationMode, p, nil)
}

// GenerateTestReportParams generates a report for testing.
type GenerateTestReportParams struct {
	Message string `json:"message"`                  // Message to be displayed in the report.
	Group   string `json:"group,omitempty,omitzero"` // Specifies the endpoint group to deliver the report to.
}

// GenerateTestReport generates a report for testing.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-generateTestReport
//
// parameters:
//
//	message - Message to be displayed in the report.
func GenerateTestReport(message string) *GenerateTestReportParams {
	return &GenerateTestReportParams{
		Message: message,
	}
}

// WithGroup specifies the endpoint group to deliver the report to.
func (p GenerateTestReportParams) WithGroup(group string) *GenerateTestReportParams {
	p.Group = group
	return &p
}

// Do executes Page.generateTestReport against the provided context.
func (p *GenerateTestReportParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandGenerateTestReport, p, nil)
}

// WaitForDebuggerParams pauses page execution. Can be resumed using generic
// Runtime.runIfWaitingForDebugger.
type WaitForDebuggerParams struct{}

// WaitForDebugger pauses page execution. Can be resumed using generic
// Runtime.runIfWaitingForDebugger.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-waitForDebugger
func WaitForDebugger() *WaitForDebuggerParams {
	return &WaitForDebuggerParams{}
}

// Do executes Page.waitForDebugger against the provided context.
func (p *WaitForDebuggerParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandWaitForDebugger, nil, nil)
}

// SetInterceptFileChooserDialogParams intercept file chooser requests and
// transfer control to protocol clients. When file chooser interception is
// enabled, native file chooser dialog is not shown. Instead, a protocol event
// Page.fileChooserOpened is emitted.
type SetInterceptFileChooserDialogParams struct {
	Enabled bool `json:"enabled"`
	Cancel  bool `json:"cancel"` // If true, cancels the dialog by emitting relevant events (if any) in addition to not showing it if the interception is enabled (default: false).
}

// SetInterceptFileChooserDialog intercept file chooser requests and transfer
// control to protocol clients. When file chooser interception is enabled,
// native file chooser dialog is not shown. Instead, a protocol event
// Page.fileChooserOpened is emitted.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-setInterceptFileChooserDialog
//
// parameters:
//
//	enabled
func SetInterceptFileChooserDialog(enabled bool) *SetInterceptFileChooserDialogParams {
	return &SetInterceptFileChooserDialogParams{
		Enabled: enabled,
		Cancel:  false,
	}
}

// WithCancel if true, cancels the dialog by emitting relevant events (if
// any) in addition to not showing it if the interception is enabled (default:
// false).
func (p SetInterceptFileChooserDialogParams) WithCancel(cancel bool) *SetInterceptFileChooserDialogParams {
	p.Cancel = cancel
	return &p
}

// Do executes Page.setInterceptFileChooserDialog against the provided context.
func (p *SetInterceptFileChooserDialogParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetInterceptFileChooserDialog, p, nil)
}

// SetPrerenderingAllowedParams enable/disable prerendering manually. This
// command is a short-term solution for https://crbug.com/1440085. See
// https://docs.google.com/document/d/12HVmFxYj5Jc-eJr5OmWsa2bqTJsbgGLKI6ZIyx0_wpA
// for more details. TODO(https://crbug.com/1440085): Remove this once Puppeteer
// supports tab targets.
type SetPrerenderingAllowedParams struct {
	IsAllowed bool `json:"isAllowed"`
}

// SetPrerenderingAllowed enable/disable prerendering manually. This command
// is a short-term solution for https://crbug.com/1440085. See
// https://docs.google.com/document/d/12HVmFxYj5Jc-eJr5OmWsa2bqTJsbgGLKI6ZIyx0_wpA
// for more details. TODO(https://crbug.com/1440085): Remove this once Puppeteer
// supports tab targets.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-setPrerenderingAllowed
//
// parameters:
//
//	isAllowed
func SetPrerenderingAllowed(isAllowed bool) *SetPrerenderingAllowedParams {
	return &SetPrerenderingAllowedParams{
		IsAllowed: isAllowed,
	}
}

// Do executes Page.setPrerenderingAllowed against the provided context.
func (p *SetPrerenderingAllowedParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetPrerenderingAllowed, p, nil)
}

// Command names.
const (
	CommandAddScriptToEvaluateOnNewDocument    = "Page.addScriptToEvaluateOnNewDocument"
	CommandBringToFront                        = "Page.bringToFront"
	CommandCaptureScreenshot                   = "Page.captureScreenshot"
	CommandCaptureSnapshot                     = "Page.captureSnapshot"
	CommandCreateIsolatedWorld                 = "Page.createIsolatedWorld"
	CommandDisable                             = "Page.disable"
	CommandEnable                              = "Page.enable"
	CommandGetAppManifest                      = "Page.getAppManifest"
	CommandGetInstallabilityErrors             = "Page.getInstallabilityErrors"
	CommandGetAppID                            = "Page.getAppId"
	CommandGetAdScriptAncestry                 = "Page.getAdScriptAncestry"
	CommandGetFrameTree                        = "Page.getFrameTree"
	CommandGetLayoutMetrics                    = "Page.getLayoutMetrics"
	CommandGetNavigationHistory                = "Page.getNavigationHistory"
	CommandResetNavigationHistory              = "Page.resetNavigationHistory"
	CommandGetResourceContent                  = "Page.getResourceContent"
	CommandGetResourceTree                     = "Page.getResourceTree"
	CommandHandleJavaScriptDialog              = "Page.handleJavaScriptDialog"
	CommandNavigate                            = "Page.navigate"
	CommandNavigateToHistoryEntry              = "Page.navigateToHistoryEntry"
	CommandPrintToPDF                          = "Page.printToPDF"
	CommandReload                              = "Page.reload"
	CommandRemoveScriptToEvaluateOnNewDocument = "Page.removeScriptToEvaluateOnNewDocument"
	CommandScreencastFrameAck                  = "Page.screencastFrameAck"
	CommandSearchInResource                    = "Page.searchInResource"
	CommandSetAdBlockingEnabled                = "Page.setAdBlockingEnabled"
	CommandSetBypassCSP                        = "Page.setBypassCSP"
	CommandGetPermissionsPolicyState           = "Page.getPermissionsPolicyState"
	CommandGetOriginTrials                     = "Page.getOriginTrials"
	CommandSetFontFamilies                     = "Page.setFontFamilies"
	CommandSetFontSizes                        = "Page.setFontSizes"
	CommandSetDocumentContent                  = "Page.setDocumentContent"
	CommandSetLifecycleEventsEnabled           = "Page.setLifecycleEventsEnabled"
	CommandStartScreencast                     = "Page.startScreencast"
	CommandStopLoading                         = "Page.stopLoading"
	CommandCrash                               = "Page.crash"
	CommandClose                               = "Page.close"
	CommandSetWebLifecycleState                = "Page.setWebLifecycleState"
	CommandStopScreencast                      = "Page.stopScreencast"
	CommandProduceCompilationCache             = "Page.produceCompilationCache"
	CommandAddCompilationCache                 = "Page.addCompilationCache"
	CommandClearCompilationCache               = "Page.clearCompilationCache"
	CommandSetSPCTransactionMode               = "Page.setSPCTransactionMode"
	CommandSetRPHRegistrationMode              = "Page.setRPHRegistrationMode"
	CommandGenerateTestReport                  = "Page.generateTestReport"
	CommandWaitForDebugger                     = "Page.waitForDebugger"
	CommandSetInterceptFileChooserDialog       = "Page.setInterceptFileChooserDialog"
	CommandSetPrerenderingAllowed              = "Page.setPrerenderingAllowed"
)
