/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.dbeaver.Log;

public class JULHandler
extends Handler {
    private final Log log;

    public JULHandler(Log log) {
        this.log = log;
    }

    @Override
    public void publish(LogRecord record) {
        int severity = JULHandler.getSeverity(record.getLevel());
        if (severity == 4 || severity == 2) {
            this.log.log((IStatus)new Status(JULHandler.getSeverity(record.getLevel()), record.getLoggerName(), record.getMessage(), record.getThrown()));
        } else {
            this.log.debug(record.getMessage(), record.getThrown());
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }

    private static int getSeverity(Level level) {
        if (level.intValue() >= Level.SEVERE.intValue()) {
            return 4;
        }
        if (level.intValue() >= Level.WARNING.intValue()) {
            return 2;
        }
        return 8;
    }
}

