/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.spi.model.ContextMetadataModel;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.ServletContextModel;
import org.ops4j.pax.web.service.spi.model.elements.ContainerInitializerModel;
import org.ops4j.pax.web.service.spi.model.elements.ErrorPageModel;
import org.ops4j.pax.web.service.spi.model.elements.EventListenerModel;
import org.ops4j.pax.web.service.spi.model.elements.FilterModel;
import org.ops4j.pax.web.service.spi.model.elements.ServletModel;
import org.ops4j.pax.web.service.spi.model.elements.WebSocketModel;
import org.ops4j.pax.web.service.spi.model.elements.WelcomeFileModel;
import org.ops4j.pax.web.service.spi.task.BatchVisitor;
import org.ops4j.pax.web.service.spi.task.Change;
import org.ops4j.pax.web.service.spi.task.ClearDynamicRegistrationsChange;
import org.ops4j.pax.web.service.spi.task.ContainerInitializerModelChange;
import org.ops4j.pax.web.service.spi.task.ContextMetadataModelChange;
import org.ops4j.pax.web.service.spi.task.ErrorPageModelChange;
import org.ops4j.pax.web.service.spi.task.ErrorPageStateChange;
import org.ops4j.pax.web.service.spi.task.EventListenerModelChange;
import org.ops4j.pax.web.service.spi.task.FilterModelChange;
import org.ops4j.pax.web.service.spi.task.FilterStateChange;
import org.ops4j.pax.web.service.spi.task.MimeAndLocaleMappingChange;
import org.ops4j.pax.web.service.spi.task.OpCode;
import org.ops4j.pax.web.service.spi.task.OsgiContextModelChange;
import org.ops4j.pax.web.service.spi.task.ServletContextModelChange;
import org.ops4j.pax.web.service.spi.task.ServletModelChange;
import org.ops4j.pax.web.service.spi.task.TransactionStateChange;
import org.ops4j.pax.web.service.spi.task.WebSocketModelChange;
import org.ops4j.pax.web.service.spi.task.WelcomeFileModelChange;

public class Batch {
    private final List<Change> operations = new LinkedList<Change>();
    private final String description;
    private String shortDescription;

    public Batch(String description) {
        this.description = description;
    }

    public List<Change> getOperations() {
        return this.operations;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public void addServletContextModel(ServletContextModel servletContextModel) {
        this.operations.add(new ServletContextModelChange(OpCode.ADD, servletContextModel));
    }

    public void addOsgiContextModel(OsgiContextModel osgiContextModel, ServletContextModel servletContextModel) {
        this.operations.add(new OsgiContextModelChange(OpCode.ADD, null, osgiContextModel, servletContextModel));
    }

    public void removeOsgiContextModel(OsgiContextModel osgiContextModel) {
        this.operations.add(new OsgiContextModelChange(OpCode.DELETE, null, osgiContextModel, null));
    }

    public void associateOsgiContextModel(WebContainerContext context, OsgiContextModel osgiContextModel) {
        this.operations.add(new OsgiContextModelChange(OpCode.ASSOCIATE, context, osgiContextModel, null));
    }

    public void disassociateOsgiContextModel(WebContainerContext context, OsgiContextModel osgiContextModel) {
        this.operations.add(new OsgiContextModelChange(OpCode.DISASSOCIATE, context, osgiContextModel, null));
    }

    public void addServletModel(ServletModel model, OsgiContextModel ... newModels) {
        this.operations.add(new ServletModelChange(OpCode.ADD, model, newModels));
    }

    public void removeServletModels(Map<ServletModel, Boolean> toUnregister) {
        this.operations.add(new ServletModelChange(OpCode.DELETE, toUnregister));
    }

    public void addDisabledServletModel(ServletModel model) {
        this.operations.add(new ServletModelChange(OpCode.ADD, model, true, new OsgiContextModel[0]));
    }

    public void enableServletModel(ServletModel model) {
        this.operations.add(new ServletModelChange(OpCode.ENABLE, model, new OsgiContextModel[0]));
    }

    public void disableServletModel(ServletModel model) {
        this.operations.add(new ServletModelChange(OpCode.DISABLE, model, new OsgiContextModel[0]));
    }

    public void addFilterModel(FilterModel model, OsgiContextModel ... newModels) {
        this.operations.add(new FilterModelChange(OpCode.ADD, model, newModels));
    }

    public void removeFilterModels(List<FilterModel> toUnregister) {
        this.operations.add(new FilterModelChange(OpCode.DELETE, toUnregister));
    }

    public void addDisabledFilterModel(FilterModel model) {
        this.operations.add(new FilterModelChange(OpCode.ADD, model, true, new OsgiContextModel[0]));
    }

    public void enableFilterModel(FilterModel model) {
        this.operations.add(new FilterModelChange(OpCode.ENABLE, model, new OsgiContextModel[0]));
    }

    public void disableFilterModel(FilterModel model) {
        this.operations.add(new FilterModelChange(OpCode.DISABLE, model, new OsgiContextModel[0]));
    }

    public void updateFilters(Map<String, TreeMap<FilterModel, List<OsgiContextModel>>> contextFilters, boolean dynamic) {
        this.operations.add(new FilterStateChange(contextFilters, dynamic));
    }

    public void addErrorPageModel(ErrorPageModel model, OsgiContextModel ... newModels) {
        this.operations.add(new ErrorPageModelChange(OpCode.ADD, model, newModels));
    }

    public void removeErrorPageModels(List<ErrorPageModel> toUnregister) {
        this.operations.add(new ErrorPageModelChange(OpCode.DELETE, toUnregister));
    }

    public void addDisabledErrorPageModel(ErrorPageModel model) {
        this.operations.add(new ErrorPageModelChange(OpCode.ADD, model, true, new OsgiContextModel[0]));
    }

    public void enableErrorPageModel(ErrorPageModel model) {
        this.operations.add(new ErrorPageModelChange(OpCode.ENABLE, model, new OsgiContextModel[0]));
    }

    public void disableErrorPageModel(ErrorPageModel model) {
        this.operations.add(new ErrorPageModelChange(OpCode.DISABLE, model, new OsgiContextModel[0]));
    }

    public void updateErrorPages(Map<String, TreeMap<ErrorPageModel, List<OsgiContextModel>>> contextErrorPageModels) {
        this.operations.add(new ErrorPageStateChange(contextErrorPageModels));
    }

    public void addEventListenerModel(EventListenerModel model, OsgiContextModel ... newModels) {
        this.operations.add(new EventListenerModelChange(OpCode.ADD, model, newModels));
    }

    public void removeEventListenerModels(List<EventListenerModel> models) {
        this.operations.add(new EventListenerModelChange(OpCode.DELETE, models));
    }

    public void addContainerInitializerModel(ContainerInitializerModel model, OsgiContextModel ... newModels) {
        this.operations.add(new ContainerInitializerModelChange(OpCode.ADD, model, newModels));
    }

    public void changeContainerInitializerModel(ContainerInitializerModel model) {
        this.operations.add(new ContainerInitializerModelChange(OpCode.MODIFY, model, new OsgiContextModel[0]));
    }

    public void removeContainerInitializerModels(List<ContainerInitializerModel> models) {
        this.operations.add(new ContainerInitializerModelChange(OpCode.DELETE, models));
    }

    public void addWelcomeFileModel(WelcomeFileModel model, OsgiContextModel ... newModels) {
        this.operations.add(new WelcomeFileModelChange(OpCode.ADD, model, newModels));
    }

    public void removeWelcomeFileModel(WelcomeFileModel model) {
        this.operations.add(new WelcomeFileModelChange(OpCode.DELETE, model, new OsgiContextModel[0]));
    }

    public void addWebSocketModel(WebSocketModel model) {
        this.operations.add(new WebSocketModelChange(OpCode.ADD, model, new OsgiContextModel[0]));
    }

    public void addDisabledWebSocketModel(WebSocketModel model) {
        this.operations.add(new WebSocketModelChange(OpCode.ADD, model, true, new OsgiContextModel[0]));
    }

    public void disableWebSocketModel(WebSocketModel model) {
        this.operations.add(new WebSocketModelChange(OpCode.DISABLE, model, new OsgiContextModel[0]));
    }

    public void removeWebSocketModels(Map<WebSocketModel, Boolean> models) {
        this.operations.add(new WebSocketModelChange(OpCode.DELETE, models));
    }

    public void enableWebSocketModel(WebSocketModel model) {
        this.operations.add(new WebSocketModelChange(OpCode.ENABLE, model, new OsgiContextModel[0]));
    }

    public void beginTransaction(String contextPath) {
        this.operations.add(new TransactionStateChange(OpCode.ASSOCIATE, contextPath));
    }

    public void commitTransaction(String contextPath) {
        this.operations.add(new TransactionStateChange(OpCode.DISASSOCIATE, contextPath));
    }

    public void configureMetadata(ContextMetadataModel meta, OsgiContextModel ocm) {
        this.operations.add(new ContextMetadataModelChange(OpCode.ADD, meta, ocm));
    }

    public void configureMimeAndEncodingMappings(Map<String, String> mimeMapping, Map<String, String> localeEncodingMapping, OsgiContextModel ocm) {
        this.operations.add(new MimeAndLocaleMappingChange(OpCode.ADD, mimeMapping, localeEncodingMapping, ocm));
    }

    public void clearDynamicRegistrations(List<OsgiContextModel> contextModels) {
        this.operations.add(new ClearDynamicRegistrationsChange(OpCode.MODIFY, contextModels));
    }

    public void accept(BatchVisitor visitor) {
        for (Change op : this.operations) {
            op.accept(visitor);
        }
    }

    public Batch uninstall(String description) {
        Batch b = new Batch(description);
        ArrayList<Change> reversed = new ArrayList<Change>(this.operations);
        Collections.reverse(reversed);
        for (Change c : reversed) {
            c.uninstall(b.getOperations());
        }
        return b;
    }

    public String toString() {
        return "Batch{\"" + this.description + "\", size=" + this.operations.size() + "}";
    }
}

