## upterm host

Host a terminal session

### Synopsis

Host a terminal session via a reverse SSH tunnel to the Upterm server, linking the IO of the host
and client to a command's IO. Authentication against the Upterm server defaults to using private key files located
at ~/.ssh/id_dsa, ~/.ssh/id_ecdsa, ~/.ssh/id_ed25519, and ~/.ssh/id_rsa. If no private key file is found, it resorts
to reading private keys from the SSH Agent. Absence of private keys in files or SSH Agent generates an on-the-fly
private key. To authorize client connections, specify a authorized_key file with public keys using --authorized-keys.

```
upterm host [flags]
```

### Examples

```
  # Host a terminal session running $SHELL, attaching client's IO to the host's:
  upterm host

  # Accept client connections automatically without prompts:
  upterm host --accept

  # Host a terminal session allowing only specified public key(s) to connect:
  upterm host --authorized-keys PATH_TO_AUTHORIZED_KEY_FILE

  # Host a session executing a custom command:
  upterm host -- docker run --rm -ti ubuntu bash

  # Host a 'tmux new -t pair-programming' session, forcing clients to join with 'tmux attach -t pair-programming':
  upterm host --force-command 'tmux attach -t pair-programming' -- tmux new -t pair-programming

  # Use a different Uptermd server, hosting a session via WebSocket:
  upterm host --server wss://YOUR_UPTERMD_SERVER -- YOUR_COMMAND
```

### Options

```
      --accept                   Automatically accept client connections without prompts.
      --authorized-keys string   Specify a authorize_keys file listing authorized public keys for connection.
      --codeberg-user strings    Authorize specified Codeberg users by allowing their public keys to connect.
  -f, --force-command string     Enforce a specified command for clients to join, and link the command's input/output to the client's terminal.
      --github-user strings      Authorize specified GitHub users by allowing their public keys to connect. Configure GitHub CLI environment variables as needed; see https://cli.github.com/manual/gh_help_environment for details.
      --gitlab-user strings      Authorize specified GitLab users by allowing their public keys to connect.
  -h, --help                     help for host
      --known-hosts string       Specify a file containing known keys for remote hosts (required). (default "/Users/owen/.ssh/known_hosts")
  -i, --private-key strings      Specify private key files for public key authentication with the upterm server (required). (default [/Users/owen/.ssh/id_ed25519])
  -r, --read-only                Host a read-only session, preventing client interaction.
      --server string            Specify the upterm server address (required). Supported protocols: ssh, ws, wss. (default "ssh://uptermd.upterm.dev:22")
      --srht-user strings        Authorize specified SourceHut users by allowing their public keys to connect.
```

### SEE ALSO

* [upterm](upterm.md)	 - Instant Terminal Sharing

###### Auto generated by spf13/cobra on 29-Jul-2025
