use Test;
plan 37;

is v1.2.3, '1.2.3', 'version literal stringification';
is v1.2.3+, '1.2.3+', 'version literal stringification +';
is v1.2.3-, '1.2.3-', 'version literal stringification -';
is v1.*.3,  '1.*.3',  'version literal stringification *';
ok  v1.2.3 eqv v1.2.3, 'eqv works on version literals (+)';
nok v5.2.3 eqv v1.2.3, 'eqv works on version literals (-)';
nok v1.2+  eqv v1.2,   '+ makes a difference in eqv';
nok v1.2-  eqv v1.2,   '- makes a difference in eqv';
ok  v1.2   === v1.2,   'version literals are value types';
nok v1.2   === v1.3,   '=== (-)';
ok  v1.2   ~~  v1.2,   'smart-matching (same)';
nok v1.2   ~~  v6.2,   'smart-matching (different)';
ok  v1.2.0 ~~  v1.2,   'smart-matching treats trailing 0 correctly (left)';
ok  v1.2   ~~  v1.2.0, 'smart-matching treats trailing 0 correctly (right)';
ok  v1.2   ~~  v1.0+,  'smart-matching and plus (+1)';
ok  v1.2   ~~  v1.2+,  'smart-matching and plus (+2)';
nok  v1.2   ~~  v1.0-,  'smart-matching and plus (-1)';
ok  v1.2   ~~  v1.2-,  'smart-matching and plus (-2)';
ok  v5     ~~  v1.2+,  '+ scopes to the whole version, not just the last chunk';
ok  v5     ~~  v5.2-,  '- scopes to the whole version, not just the last chunk';
ok  v5.2.3 ~~  v5.2.*, '* wildcard (1+)';
ok  v5.2   ~~  v5.2.*, '* wildcard (2+)';
nok v5.2.3 ~~  v5.3.*, '* wildcard (-)';
nok v1.2   ~~  v1.3+,  'smart-matching and plus (-)';
ok v1.2   ~~  v1.3-,  'smart-matching and minus (-)';
ok  v1.2.3 ~~  v1,     'smart-matching only cares about the length of the LHS';
nok v1.2.3 ~~  v2,     '... but it can still fail';
is  v1.2   cmp  v1.2,   Same,     'cmp: Same';
is  v1.2   cmp  v3.2,   Less, 'cmp: Less';
is  v1.2   cmp  v0.2,   More, 'cmp: More';
is  v1.2   cmp  v1.10,  Less, "cmp isn't Stringy-based";
ok  v1.2   eqv  v1.2.0, 'trailing zeroes are equivalent';
ok  v1.2.0 eqv  v1.2,   'trailing zeroes are equivalent';
ok  v1.2.0 eqv  v1.2.0.0.0.0.0,   'trailing zeroes are equivalent';

is Version.new(""), '', "can we handle empty string versions";
is Version.new("").gist, 'v', "can we handle empty string versions";
is Version.new(*).gist, 'v*', "can we handle a bare Whatever";

# vim: expandtab shiftwidth=4
