# Announce: Rakudo compiler, Release #186 (2025.10)

On behalf of the Rakudo development team, I’m glad to announce the
October 2025 release of Rakudo #186. Rakudo is an implementation of
the Raku[^1] language.

The source tarball for this release is available from
<https://rakudo.org/files/rakudo>.
Pre-compiled archives will be available shortly.

New in 2025.10:
+ RakuAST:
    + Make UNIT implicits available to dynamic code [4d7234ca]
    + Doc clarification of fix for #5855 [47746a84]
    + Fix indirect methods with feed operators [f6180a31]
    + Remove special handling of '$]' [21dd9921]
    + fix gisting of &?ROUTINE [c9714bf9]
    + don't show signature on regex/rule/token [483307f7]
    + fix deparsing of nameless package-like constructs [0b5bb196] 
    + fix deparsing of rule/token/with leading doc [726c0e8b]

+ Improvements:
    + Make the REPL show lists of Matches better [d6dda7eb]
    + RakuAST - Make UNIT implicits available to dynamic code [4d7234ca]
    + RakuAST: Doc clarification of fix for #5855 (R#5855) [47746a84]

+ Additions:
    + Add exit-ok to Test module [7192f67a]

+ Fixes:
    + Fix Hash return type error message to match Array behavior [a988e79f]
    + Bump NQP to get uint JIT fix [4307ec01]
    + 6.e - Fix overly permissive lookup into CALLER [5147b67f]
    + Make sure .are doesn't infiniloop on lazy lists [49354d04]
    + Restore mention of value in typecheck error [1ac895f1]

The following people contributed to this release:

Will Coleda, David Simon Schultz, Elizabeth Mattijsen, Justin DeVuyst,
Eric Forste, ab5tract, librasteve, Coleman McFarland, rir, Daniel Green,
Pois.Nada, Richard Hainsworth, Tom Browder, quanrong, raiph

This release implements 6.c and 6.d versions of the Raku specification.
6.c version of the language is available if you use the `use v6.c`
version pragma, otherwise 6.d is the default.

Upcoming releases in 2025 will include new functionality that is not
part of 6.c or 6.d specifications, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of
6.c and 6.d specifications will continue to work unchanged. There may
be incremental spec releases this year as well.

If you would like to contribute or get more information, visit
<https://raku.org>, <https://rakudo.org/community>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #raku on Libera.

Additionally, we invite you to make a donation to The Raku Foundation
to sponsor Raku development: <https://donate.perlfoundation.org/>
(put “Raku Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#187), is tentatively scheduled for 2025-11-15.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list, IRC channel or Discord. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <https://raku.org/>
