/*
    SPDX-FileCopyrightText: 2009, 2010, 2011 Alex Richardson <alex.richardson@gmx.de>

    SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/

#ifndef KASTEN_CHARDATAINFORMATION_HPP
#define KASTEN_CHARDATAINFORMATION_HPP

// lib
#include "primitivedatainformation.hpp"

class CharDataInformationMethods
{
public:
    [[nodiscard]]
    static QString staticValueString(quint8 value);
    [[nodiscard]]
    static quint8 fromVariant(const QVariant& value, bool* ok);
    [[nodiscard]]
    static PrimitiveDataType staticType();
    [[nodiscard]]
    static QScriptValue asScriptValue(quint8 value, QScriptEngine* engine, ScriptHandlerInfo* handler);
    [[nodiscard]]
    static QVariant staticToQVariant(quint8 value);

    [[nodiscard]]
    static QWidget* staticCreateEditWidget(QWidget* parent);
    [[nodiscard]]
    static QVariant staticDataFromWidget(const QWidget* w);
    static void staticSetWidgetData(quint8 value, QWidget* w);
};

inline PrimitiveDataType CharDataInformationMethods::staticType()
{
    return PrimitiveDataType::Char;
}

inline QVariant CharDataInformationMethods::staticToQVariant(quint8 value)
{
    return {value};
}

inline quint8 CharDataInformationMethods::fromVariant(const QVariant& value, bool* ok)
{
    Q_CHECK_PTR(ok);
    quint32 tmp = value.toUInt(ok);
    auto result = static_cast<quint8>(tmp);
    if (tmp != quint32(result)) {
        *ok = false; // out of bounds
        return 0;
    }
    return result;
}

#endif /* KASTEN_CHARDATAINFORMATION_HPP */
