/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.addins;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.ui.editors.sql.addins.SQLEditorQuickAssistProcessor;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class SQLEditorQuickFixProcessorDescriptor
extends AbstractDescriptor {
    private static final Log log = Log.getLog(SQLEditorQuickAssistProcessor.class);
    @NotNull
    private final String id;
    @NotNull
    private final AbstractDescriptor.ObjectType implClass;
    @Nullable
    private final Expression enabledWhen;
    @Nullable
    private final Set<String> handledMarkerTypes;

    SQLEditorQuickFixProcessorDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.implClass = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.enabledWhen = SQLEditorQuickFixProcessorDescriptor.getEnablementExpression((IConfigurationElement)config);
        Object[] handledMarkerTypes = config.getChildren("handledMarkerTypes");
        this.handledMarkerTypes = ArrayUtils.isEmpty((Object[])handledMarkerTypes) ? null : Arrays.stream(handledMarkerTypes).map(e -> e.getAttribute("id")).filter(CommonUtils::isNotEmpty).collect(Collectors.toUnmodifiableSet());
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    public boolean isEnabled(@NotNull IWorkbenchSite site) {
        return this.isExpressionTrue(this.enabledWhen, site);
    }

    @Nullable
    public Set<String> getHandledMarkerTypes() {
        return this.handledMarkerTypes;
    }

    @NotNull
    public IQuickAssistProcessor createInstance() throws DBException {
        return (IQuickAssistProcessor)this.implClass.createInstance(IQuickAssistProcessor.class);
    }

    public String toString() {
        return "SQLEditorQuickFixProcessorDescriptor[id: " + this.id + ", class: " + this.implClass.getImplName() + "]";
    }

    public boolean handlesAnnotation(@NotNull Annotation annotation) {
        if (this.handledMarkerTypes == null) {
            return true;
        }
        if (annotation instanceof MarkerAnnotation) {
            IMarker marker;
            block5: {
                MarkerAnnotation markerAnnotation = (MarkerAnnotation)annotation;
                try {
                    marker = markerAnnotation.getMarker();
                    if (!this.handledMarkerTypes.contains(marker.getType())) break block5;
                    return true;
                }
                catch (CoreException e) {
                    log.error((Object)e);
                    return false;
                }
            }
            return this.handledMarkerTypes.stream().anyMatch(t -> {
                try {
                    return marker.isSubtypeOf(t);
                }
                catch (CoreException e) {
                    log.error((Object)e);
                    return false;
                }
            });
        }
        return false;
    }
}

