/* automatically generated by rust-bindgen 0.69.1 */

pub const MDB_FMT_Z: &[u8; 2] = b"z\0";
pub const MDB_SIZE_MAX: u64 = 18446744073709551615;
pub const MDB_VERSION_MAJOR: ::libc::c_uint = 0;
pub const MDB_VERSION_MINOR: ::libc::c_uint = 9;
pub const MDB_VERSION_PATCH: ::libc::c_uint = 70;
pub const MDB_VERSION_DATE: &[u8; 18] = b"December 19, 2015\0";
pub const MDB_FIXEDMAP: ::libc::c_uint = 1;
pub const MDB_NOSUBDIR: ::libc::c_uint = 16384;
pub const MDB_NOSYNC: ::libc::c_uint = 65536;
pub const MDB_RDONLY: ::libc::c_uint = 131072;
pub const MDB_NOMETASYNC: ::libc::c_uint = 262144;
pub const MDB_WRITEMAP: ::libc::c_uint = 524288;
pub const MDB_MAPASYNC: ::libc::c_uint = 1048576;
pub const MDB_NOTLS: ::libc::c_uint = 2097152;
pub const MDB_NOLOCK: ::libc::c_uint = 4194304;
pub const MDB_NORDAHEAD: ::libc::c_uint = 8388608;
pub const MDB_NOMEMINIT: ::libc::c_uint = 16777216;
pub const MDB_PREVSNAPSHOT: ::libc::c_uint = 33554432;
pub const MDB_REVERSEKEY: ::libc::c_uint = 2;
pub const MDB_DUPSORT: ::libc::c_uint = 4;
pub const MDB_INTEGERKEY: ::libc::c_uint = 8;
pub const MDB_DUPFIXED: ::libc::c_uint = 16;
pub const MDB_INTEGERDUP: ::libc::c_uint = 32;
pub const MDB_REVERSEDUP: ::libc::c_uint = 64;
pub const MDB_CREATE: ::libc::c_uint = 262144;
pub const MDB_NOOVERWRITE: ::libc::c_uint = 16;
pub const MDB_NODUPDATA: ::libc::c_uint = 32;
pub const MDB_CURRENT: ::libc::c_uint = 64;
pub const MDB_RESERVE: ::libc::c_uint = 65536;
pub const MDB_APPEND: ::libc::c_uint = 131072;
pub const MDB_APPENDDUP: ::libc::c_uint = 262144;
pub const MDB_MULTIPLE: ::libc::c_uint = 524288;
pub const MDB_CP_COMPACT: ::libc::c_uint = 1;
pub const MDB_SUCCESS: ::libc::c_int = 0;
pub const MDB_KEYEXIST: ::libc::c_int = -30799;
pub const MDB_NOTFOUND: ::libc::c_int = -30798;
pub const MDB_PAGE_NOTFOUND: ::libc::c_int = -30797;
pub const MDB_CORRUPTED: ::libc::c_int = -30796;
pub const MDB_PANIC: ::libc::c_int = -30795;
pub const MDB_VERSION_MISMATCH: ::libc::c_int = -30794;
pub const MDB_INVALID: ::libc::c_int = -30793;
pub const MDB_MAP_FULL: ::libc::c_int = -30792;
pub const MDB_DBS_FULL: ::libc::c_int = -30791;
pub const MDB_READERS_FULL: ::libc::c_int = -30790;
pub const MDB_TLS_FULL: ::libc::c_int = -30789;
pub const MDB_TXN_FULL: ::libc::c_int = -30788;
pub const MDB_CURSOR_FULL: ::libc::c_int = -30787;
pub const MDB_PAGE_FULL: ::libc::c_int = -30786;
pub const MDB_MAP_RESIZED: ::libc::c_int = -30785;
pub const MDB_INCOMPATIBLE: ::libc::c_int = -30784;
pub const MDB_BAD_RSLOT: ::libc::c_int = -30783;
pub const MDB_BAD_TXN: ::libc::c_int = -30782;
pub const MDB_BAD_VALSIZE: ::libc::c_int = -30781;
pub const MDB_BAD_DBI: ::libc::c_int = -30780;
pub const MDB_PROBLEM: ::libc::c_int = -30779;
pub const MDB_LAST_ERRCODE: ::libc::c_int = -30779;
#[doc = "Unsigned type used for mapsize, entry counts and page/transaction IDs.\n\n\tIt is normally size_t, hence the name. Defining MDB_VL32 makes it\n\tuint64_t, but do not try this unless you know what you are doing."]
pub type mdb_size_t = usize;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MDB_env {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MDB_txn {
    _unused: [u8; 0],
}
#[doc = "A handle for an individual database in the DB environment."]
pub type MDB_dbi = ::libc::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MDB_cursor {
    _unused: [u8; 0],
}
#[doc = "Generic structure used for passing keys and data in and out\n of the database.\n\n Values returned from the database are valid only until a subsequent\n update operation, or the end of the transaction. Do not modify or\n free them, they commonly point into the database itself.\n\n Key sizes must be between 1 and #mdb_env_get_maxkeysize() inclusive.\n The same applies to data sizes in databases with the #MDB_DUPSORT flag.\n Other data items can in theory be from 0 to 0xffffffff bytes long."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MDB_val {
    #[doc = "< size of the data item"]
    pub mv_size: usize,
    #[doc = "< address of the data item"]
    pub mv_data: *mut ::libc::c_void,
}
#[doc = "A callback function used to compare two keys in a database"]
pub type MDB_cmp_func = ::std::option::Option<
    unsafe extern "C" fn(a: *const MDB_val, b: *const MDB_val) -> ::libc::c_int,
>;
#[doc = "A callback function used to relocate a position-dependent data item\n in a fixed-address database.\n\n The **newptr** gives the item's desired address in\n the memory map, and **oldptr** gives its previous address. The item's actual\n data resides at the address in **item.** This callback is expected to walk\n through the fields of the record in **item** and modify any\n values based at the **oldptr** address to be relative to the **newptr** address.\n # Arguments\n\n* `item` (direction in, out) - The item that is to be relocated.\n * `oldptr` (direction in) - The previous address.\n * `newptr` (direction in) - The new address to relocate to.\n * `relctx` (direction in) - An application-provided context, set by #mdb_set_relctx().\n This feature is currently unimplemented."]
pub type MDB_rel_func = ::std::option::Option<
    unsafe extern "C" fn(
        item: *mut MDB_val,
        oldptr: *mut ::libc::c_void,
        newptr: *mut ::libc::c_void,
        relctx: *mut ::libc::c_void,
    ),
>;
#[doc = "< Position at first key/data item"]
pub const MDB_FIRST: MDB_cursor_op = 0;
#[doc = "< Position at first data item of current key.\nOnly for #MDB_DUPSORT"]
pub const MDB_FIRST_DUP: MDB_cursor_op = 1;
#[doc = "< Position at key/data pair. Only for #MDB_DUPSORT"]
pub const MDB_GET_BOTH: MDB_cursor_op = 2;
#[doc = "< position at key, nearest data. Only for #MDB_DUPSORT"]
pub const MDB_GET_BOTH_RANGE: MDB_cursor_op = 3;
#[doc = "< Return key/data at current cursor position"]
pub const MDB_GET_CURRENT: MDB_cursor_op = 4;
#[doc = "< Return up to a page of duplicate data items\nfrom current cursor position. Move cursor to prepare\nfor #MDB_NEXT_MULTIPLE. Only for #MDB_DUPFIXED"]
pub const MDB_GET_MULTIPLE: MDB_cursor_op = 5;
#[doc = "< Position at last key/data item"]
pub const MDB_LAST: MDB_cursor_op = 6;
#[doc = "< Position at last data item of current key.\nOnly for #MDB_DUPSORT"]
pub const MDB_LAST_DUP: MDB_cursor_op = 7;
#[doc = "< Position at next data item"]
pub const MDB_NEXT: MDB_cursor_op = 8;
#[doc = "< Position at next data item of current key.\nOnly for #MDB_DUPSORT"]
pub const MDB_NEXT_DUP: MDB_cursor_op = 9;
#[doc = "< Return up to a page of duplicate data items\nfrom next cursor position. Move cursor to prepare\nfor #MDB_NEXT_MULTIPLE. Only for #MDB_DUPFIXED"]
pub const MDB_NEXT_MULTIPLE: MDB_cursor_op = 10;
#[doc = "< Position at first data item of next key"]
pub const MDB_NEXT_NODUP: MDB_cursor_op = 11;
#[doc = "< Position at previous data item"]
pub const MDB_PREV: MDB_cursor_op = 12;
#[doc = "< Position at previous data item of current key.\nOnly for #MDB_DUPSORT"]
pub const MDB_PREV_DUP: MDB_cursor_op = 13;
#[doc = "< Position at last data item of previous key"]
pub const MDB_PREV_NODUP: MDB_cursor_op = 14;
#[doc = "< Position at specified key"]
pub const MDB_SET: MDB_cursor_op = 15;
#[doc = "< Position at specified key, return key + data"]
pub const MDB_SET_KEY: MDB_cursor_op = 16;
#[doc = "< Position at first key greater than or equal to specified key."]
pub const MDB_SET_RANGE: MDB_cursor_op = 17;
#[doc = "< Position at previous page and return up to\na page of duplicate data items. Only for #MDB_DUPFIXED"]
pub const MDB_PREV_MULTIPLE: MDB_cursor_op = 18;
#[doc = "Cursor Get operations.\n\n\tThis is the set of all operations for retrieving data\n\tusing a cursor."]
pub type MDB_cursor_op = ::libc::c_uint;
#[doc = "Statistics for a database in the environment"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MDB_stat {
    #[doc = "< Size of a database page.\nThis is currently the same for all databases."]
    pub ms_psize: ::libc::c_uint,
    #[doc = "< Depth (height) of the B-tree"]
    pub ms_depth: ::libc::c_uint,
    #[doc = "< Number of internal (non-leaf) pages"]
    pub ms_branch_pages: mdb_size_t,
    #[doc = "< Number of leaf pages"]
    pub ms_leaf_pages: mdb_size_t,
    #[doc = "< Number of overflow pages"]
    pub ms_overflow_pages: mdb_size_t,
    #[doc = "< Number of data items"]
    pub ms_entries: mdb_size_t,
}
#[doc = "Information about the environment"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MDB_envinfo {
    #[doc = "< Address of map, if fixed"]
    pub me_mapaddr: *mut ::libc::c_void,
    #[doc = "< Size of the data memory map"]
    pub me_mapsize: mdb_size_t,
    #[doc = "< ID of the last used page"]
    pub me_last_pgno: mdb_size_t,
    #[doc = "< ID of the last committed transaction"]
    pub me_last_txnid: mdb_size_t,
    #[doc = "< max reader slots in the environment"]
    pub me_maxreaders: ::libc::c_uint,
    #[doc = "< max reader slots used in the environment"]
    pub me_numreaders: ::libc::c_uint,
}
extern "C" {
    #[doc = "Return the LMDB library version information.\n\n # Arguments\n\n* `major` (direction out) - if non-NULL, the library major version number is copied here\n * `minor` (direction out) - if non-NULL, the library minor version number is copied here\n * `patch` (direction out) - if non-NULL, the library patch version number is copied here\n # Returns\n\n* `\"version` - string\" The library version as a string"]
    pub fn mdb_version(
        major: *mut ::libc::c_int,
        minor: *mut ::libc::c_int,
        patch: *mut ::libc::c_int,
    ) -> *mut ::libc::c_char;
}
extern "C" {
    #[doc = "Return a string describing a given error code.\n\n This function is a superset of the ANSI C X3.159-1989 (ANSI C) strerror(3)\n function. If the error code is greater than or equal to 0, then the string\n returned by the system function strerror(3) is returned. If the error code\n is less than 0, an error string corresponding to the LMDB library error is\n returned. See errors for a list of LMDB-specific error codes.\n # Arguments\n\n* `err` (direction in) - The error code\n # Returns\n\n* `\"error` - message\" The description of the error"]
    pub fn mdb_strerror(err: ::libc::c_int) -> *mut ::libc::c_char;
}
extern "C" {
    #[doc = "Create an LMDB environment handle.\n\n This function allocates memory for a #MDB_env structure. To release\n the allocated memory and discard the handle, call #mdb_env_close().\n Before the handle may be used, it must be opened using #mdb_env_open().\n Various other options may also need to be set before opening the handle,\n e.g. #mdb_env_set_mapsize(), #mdb_env_set_maxreaders(), #mdb_env_set_maxdbs(),\n depending on usage requirements.\n # Arguments\n\n* `env` (direction out) - The address where the new handle will be stored\n # Returns\n\nA non-zero error value on failure and 0 on success."]
    pub fn mdb_env_create(env: *mut *mut MDB_env) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Open an environment handle.\n\n If this function fails, #mdb_env_close() must be called to discard the #MDB_env handle.\n # Arguments\n\n* `env` (direction in) - An environment handle returned by #mdb_env_create()\n * `path` (direction in) - The directory in which the database files reside. This\n directory must already exist and be writable.\n * `flags` (direction in) - Special options for this environment. This parameter\n must be set to 0 or by bitwise OR'ing together one or more of the\n values described here.\n Flags set by mdb_env_set_flags() are also used.\n <ul>\n\t<li>#MDB_FIXEDMAP\n use a fixed address for the mmap region. This flag must be specified\n when creating the environment, and is stored persistently in the environment.\n\t\tIf successful, the memory map will always reside at the same virtual address\n\t\tand pointers used to reference data items in the database will be constant\n\t\tacross multiple invocations. This option may not always work, depending on\n\t\thow the operating system has allocated memory to shared libraries and other uses.\n\t\tThe feature is highly experimental.\n\t<li>#MDB_NOSUBDIR\n\t\tBy default, LMDB creates its environment in a directory whose\n\t\tpathname is given in **path,** and creates its data and lock files\n\t\tunder that directory. With this option, **path** is used as-is for\n\t\tthe database main data file. The database lock file is the **path**\n\t\twith \"-lock\" appended.\n\t<li>#MDB_RDONLY\n\t\tOpen the environment in read-only mode. No write operations will be\n\t\tallowed. LMDB will still modify the lock file - except on read-only\n\t\tfilesystems, where LMDB does not use locks.\n\t<li>#MDB_WRITEMAP\n\t\tUse a writeable memory map unless MDB_RDONLY is set. This uses\n\t\tfewer mallocs but loses protection from application bugs\n\t\tlike wild pointer writes and other bad updates into the database.\n\t\tThis may be slightly faster for DBs that fit entirely in RAM, but\n\t\tis slower for DBs larger than RAM.\n\t\tIncompatible with nested transactions.\n\t\tDo not mix processes with and without MDB_WRITEMAP on the same\n\t\tenvironment. This can defeat durability (#mdb_env_sync etc).\n\t<li>#MDB_NOMETASYNC\n\t\tFlush system buffers to disk only once per transaction, omit the\n\t\tmetadata flush. Defer that until the system flushes files to disk,\n\t\tor next non-MDB_RDONLY commit or #mdb_env_sync(). This optimization\n\t\tmaintains database integrity, but a system crash may undo the last\n\t\tcommitted transaction. I.e. it preserves the ACI (atomicity,\n\t\tconsistency, isolation) but not D (durability) database property.\n\t\tThis flag may be changed at any time using #mdb_env_set_flags().\n\t<li>#MDB_NOSYNC\n\t\tDon't flush system buffers to disk when committing a transaction.\n\t\tThis optimization means a system crash can corrupt the database or\n\t\tlose the last transactions if buffers are not yet flushed to disk.\n\t\tThe risk is governed by how often the system flushes dirty buffers\n\t\tto disk and how often #mdb_env_sync() is called. However, if the\n\t\tfilesystem preserves write order and the #MDB_WRITEMAP flag is not\n\t\tused, transactions exhibit ACI (atomicity, consistency, isolation)\n\t\tproperties and only lose D (durability). I.e. database integrity\n\t\tis maintained, but a system crash may undo the final transactions.\n\t\tNote that (#MDB_NOSYNC | #MDB_WRITEMAP) leaves the system with no\n\t\thint for when to write transactions to disk, unless #mdb_env_sync()\n\t\tis called. (#MDB_MAPASYNC | #MDB_WRITEMAP) may be preferable.\n\t\tThis flag may be changed at any time using #mdb_env_set_flags().\n\t<li>#MDB_MAPASYNC\n\t\tWhen using #MDB_WRITEMAP, use asynchronous flushes to disk.\n\t\tAs with #MDB_NOSYNC, a system crash can then corrupt the\n\t\tdatabase or lose the last transactions. Calling #mdb_env_sync()\n\t\tensures on-disk database integrity until next commit.\n\t\tThis flag may be changed at any time using #mdb_env_set_flags().\n\t<li>#MDB_NOTLS\n\t\tDon't use Thread-Local Storage. Tie reader locktable slots to\n\t\t#MDB_txn objects instead of to threads. I.e. #mdb_txn_reset() keeps\n\t\tthe slot reserved for the #MDB_txn object. A thread may use parallel\n\t\tread-only transactions. A read-only transaction may span threads if\n\t\tthe user synchronizes its use. Applications that multiplex many\n\t\tuser threads over individual OS threads need this option. Such an\n\t\tapplication must also serialize the write transactions in an OS\n\t\tthread, since LMDB's write locking is unaware of the user threads.\n\t<li>#MDB_NOLOCK\n\t\tDon't do any locking. If concurrent access is anticipated, the\n\t\tcaller must manage all concurrency itself. For proper operation\n\t\tthe caller must enforce single-writer semantics, and must ensure\n\t\tthat no readers are using old transactions while a writer is\n\t\tactive. The simplest approach is to use an exclusive lock so that\n\t\tno readers may be active at all when a writer begins.\n\t<li>#MDB_NORDAHEAD\n\t\tTurn off readahead. Most operating systems perform readahead on\n\t\tread requests by default. This option turns it off if the OS\n\t\tsupports it. Turning it off may help random read performance\n\t\twhen the DB is larger than RAM and system RAM is full.\n\t\tThe option is not implemented on Windows.\n\t<li>#MDB_NOMEMINIT\n\t\tDon't initialize malloc'd memory before writing to unused spaces\n\t\tin the data file. By default, memory for pages written to the data\n\t\tfile is obtained using malloc. While these pages may be reused in\n\t\tsubsequent transactions, freshly malloc'd pages will be initialized\n\t\tto zeroes before use. This avoids persisting leftover data from other\n\t\tcode (that used the heap and subsequently freed the memory) into the\n\t\tdata file. Note that many other system libraries may allocate\n\t\tand free memory from the heap for arbitrary uses. E.g., stdio may\n\t\tuse the heap for file I/O buffers. This initialization step has a\n\t\tmodest performance cost so some applications may want to disable\n\t\tit using this flag. This option can be a problem for applications\n\t\twhich handle sensitive data like passwords, and it makes memory\n\t\tcheckers like Valgrind noisy. This flag is not needed with #MDB_WRITEMAP,\n\t\twhich writes directly to the mmap instead of using malloc for pages. The\n\t\tinitialization is also skipped if #MDB_RESERVE is used; the\n\t\tcaller is expected to overwrite all of the memory that was\n\t\treserved in that case.\n\t\tThis flag may be changed at any time using #mdb_env_set_flags().\n\t<li>#MDB_PREVSNAPSHOT\n\t\tOpen the environment with the previous snapshot rather than the latest\n\t\tone. This loses the latest transaction, but may help work around some\n\t\ttypes of corruption. If opened with write access, this must be the\n\t\tonly process using the environment. This flag is automatically reset\n\t\tafter a write transaction is successfully committed.\n </ul>\n * `mode` (direction in) - The UNIX permissions to set on created files and semaphores.\n This parameter is ignored on Windows.\n # Returns\n\nA non-zero error value on failure and 0 on success. Some possible\n errors are:\n <ul>\n\t<li>#MDB_VERSION_MISMATCH - the version of the LMDB library doesn't match the\n\tversion that created the database environment.\n\t<li>#MDB_INVALID - the environment file headers are corrupted.\n\t<li>ENOENT - the directory specified by the path parameter doesn't exist.\n\t<li>EACCES - the user didn't have permission to access the environment files.\n\t<li>EAGAIN - the environment was locked by another process.\n </ul>"]
    pub fn mdb_env_open(
        env: *mut MDB_env,
        path: *const ::libc::c_char,
        flags: ::libc::c_uint,
        mode: mdb_mode_t,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Copy an LMDB environment to the specified path.\n\n This function may be used to make a backup of an existing environment.\n No lockfile is created, since it gets recreated at need.\n > **Note:** This call can trigger significant file size growth if run in\n parallel with write transactions, because it employs a read-only\n transaction. See long-lived transactions under caveats_sec.\n # Arguments\n\n* `env` (direction in) - An environment handle returned by #mdb_env_create(). It\n must have already been opened successfully.\n * `path` (direction in) - The directory in which the copy will reside. This\n directory must already exist and be writable but must otherwise be\n empty.\n # Returns\n\nA non-zero error value on failure and 0 on success."]
    pub fn mdb_env_copy(env: *mut MDB_env, path: *const ::libc::c_char) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Copy an LMDB environment to the specified file descriptor.\n\n This function may be used to make a backup of an existing environment.\n No lockfile is created, since it gets recreated at need.\n > **Note:** This call can trigger significant file size growth if run in\n parallel with write transactions, because it employs a read-only\n transaction. See long-lived transactions under caveats_sec.\n # Arguments\n\n* `env` (direction in) - An environment handle returned by #mdb_env_create(). It\n must have already been opened successfully.\n * `fd` (direction in) - The filedescriptor to write the copy to. It must\n have already been opened for Write access.\n # Returns\n\nA non-zero error value on failure and 0 on success."]
    pub fn mdb_env_copyfd(env: *mut MDB_env, fd: mdb_filehandle_t) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Copy an LMDB environment to the specified path, with options.\n\n This function may be used to make a backup of an existing environment.\n No lockfile is created, since it gets recreated at need.\n > **Note:** This call can trigger significant file size growth if run in\n parallel with write transactions, because it employs a read-only\n transaction. See long-lived transactions under caveats_sec.\n # Arguments\n\n* `env` (direction in) - An environment handle returned by #mdb_env_create(). It\n must have already been opened successfully.\n * `path` (direction in) - The directory in which the copy will reside. This\n directory must already exist and be writable but must otherwise be\n empty.\n * `flags` (direction in) - Special options for this operation. This parameter\n must be set to 0 or by bitwise OR'ing together one or more of the\n values described here.\n <ul>\n\t<li>#MDB_CP_COMPACT - Perform compaction while copying: omit free\n\t\tpages and sequentially renumber all pages in output. This option\n\t\tconsumes more CPU and runs more slowly than the default.\n\t\tCurrently it fails if the environment has suffered a page leak.\n </ul>\n # Returns\n\nA non-zero error value on failure and 0 on success."]
    pub fn mdb_env_copy2(
        env: *mut MDB_env,
        path: *const ::libc::c_char,
        flags: ::libc::c_uint,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Copy an LMDB environment to the specified file descriptor,\n\twith options.\n\n This function may be used to make a backup of an existing environment.\n No lockfile is created, since it gets recreated at need. See\n #mdb_env_copy2() for further details.\n > **Note:** This call can trigger significant file size growth if run in\n parallel with write transactions, because it employs a read-only\n transaction. See long-lived transactions under caveats_sec.\n # Arguments\n\n* `env` (direction in) - An environment handle returned by #mdb_env_create(). It\n must have already been opened successfully.\n * `fd` (direction in) - The filedescriptor to write the copy to. It must\n have already been opened for Write access.\n * `flags` (direction in) - Special options for this operation.\n See #mdb_env_copy2() for options.\n # Returns\n\nA non-zero error value on failure and 0 on success."]
    pub fn mdb_env_copyfd2(
        env: *mut MDB_env,
        fd: mdb_filehandle_t,
        flags: ::libc::c_uint,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Return statistics about the LMDB environment.\n\n # Arguments\n\n* `env` (direction in) - An environment handle returned by #mdb_env_create()\n * `stat` (direction out) - The address of an #MDB_stat structure\n \twhere the statistics will be copied"]
    pub fn mdb_env_stat(env: *mut MDB_env, stat: *mut MDB_stat) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Return information about the LMDB environment.\n\n # Arguments\n\n* `env` (direction in) - An environment handle returned by #mdb_env_create()\n * `stat` (direction out) - The address of an #MDB_envinfo structure\n \twhere the information will be copied"]
    pub fn mdb_env_info(env: *mut MDB_env, stat: *mut MDB_envinfo) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Flush the data buffers to disk.\n\n Data is always written to disk when #mdb_txn_commit() is called,\n but the operating system may keep it buffered. LMDB always flushes\n the OS buffers upon commit as well, unless the environment was\n opened with #MDB_NOSYNC or in part #MDB_NOMETASYNC. This call is\n not valid if the environment was opened with #MDB_RDONLY.\n # Arguments\n\n* `env` (direction in) - An environment handle returned by #mdb_env_create()\n * `force` (direction in) - If non-zero, force a synchronous flush. Otherwise\n if the environment has the #MDB_NOSYNC flag set the flushes\n\twill be omitted, and with #MDB_MAPASYNC they will be asynchronous.\n # Returns\n\nA non-zero error value on failure and 0 on success. Some possible\n errors are:\n <ul>\n\t<li>EACCES - the environment is read-only.\n\t<li>EINVAL - an invalid parameter was specified.\n\t<li>EIO - an error occurred during synchronization.\n </ul>"]
    pub fn mdb_env_sync(env: *mut MDB_env, force: ::libc::c_int) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Close the environment and release the memory map.\n\n Only a single thread may call this function. All transactions, databases,\n and cursors must already be closed before calling this function. Attempts to\n use any such handles after calling this function will cause a SIGSEGV.\n The environment handle will be freed and must not be used again after this call.\n # Arguments\n\n* `env` (direction in) - An environment handle returned by #mdb_env_create()"]
    pub fn mdb_env_close(env: *mut MDB_env);
}
extern "C" {
    #[doc = "Set environment flags.\n\n This may be used to set some flags in addition to those from\n #mdb_env_open(), or to unset these flags. If several threads\n change the flags at the same time, the result is undefined.\n # Arguments\n\n* `env` (direction in) - An environment handle returned by #mdb_env_create()\n * `flags` (direction in) - The flags to change, bitwise OR'ed together\n * `onoff` (direction in) - A non-zero value sets the flags, zero clears them.\n # Returns\n\nA non-zero error value on failure and 0 on success. Some possible\n errors are:\n <ul>\n\t<li>EINVAL - an invalid parameter was specified.\n </ul>"]
    pub fn mdb_env_set_flags(
        env: *mut MDB_env,
        flags: ::libc::c_uint,
        onoff: ::libc::c_int,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Get environment flags.\n\n # Arguments\n\n* `env` (direction in) - An environment handle returned by #mdb_env_create()\n * `flags` (direction out) - The address of an integer to store the flags\n # Returns\n\nA non-zero error value on failure and 0 on success. Some possible\n errors are:\n <ul>\n\t<li>EINVAL - an invalid parameter was specified.\n </ul>"]
    pub fn mdb_env_get_flags(env: *mut MDB_env, flags: *mut ::libc::c_uint) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Return the path that was used in #mdb_env_open().\n\n # Arguments\n\n* `env` (direction in) - An environment handle returned by #mdb_env_create()\n * `path` (direction out) - Address of a string pointer to contain the path. This\n is the actual string in the environment, not a copy. It should not be\n altered in any way.\n # Returns\n\nA non-zero error value on failure and 0 on success. Some possible\n errors are:\n <ul>\n\t<li>EINVAL - an invalid parameter was specified.\n </ul>"]
    pub fn mdb_env_get_path(env: *mut MDB_env, path: *mut *const ::libc::c_char) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Return the filedescriptor for the given environment.\n\n This function may be called after fork(), so the descriptor can be\n closed before exec*(). Other LMDB file descriptors have FD_CLOEXEC.\n (Until LMDB 0.9.18, only the lockfile had that.)\n\n # Arguments\n\n* `env` (direction in) - An environment handle returned by #mdb_env_create()\n * `fd` (direction out) - Address of a mdb_filehandle_t to contain the descriptor.\n # Returns\n\nA non-zero error value on failure and 0 on success. Some possible\n errors are:\n <ul>\n\t<li>EINVAL - an invalid parameter was specified.\n </ul>"]
    pub fn mdb_env_get_fd(env: *mut MDB_env, fd: *mut mdb_filehandle_t) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Set the size of the memory map to use for this environment.\n\n The size should be a multiple of the OS page size. The default is\n 10485760 bytes. The size of the memory map is also the maximum size\n of the database. The value should be chosen as large as possible,\n to accommodate future growth of the database.\n This function should be called after #mdb_env_create() and before #mdb_env_open().\n It may be called at later times if no transactions are active in\n this process. Note that the library does not check for this condition,\n the caller must ensure it explicitly.\n\n The new size takes effect immediately for the current process but\n will not be persisted to any others until a write transaction has been\n committed by the current process. Also, only mapsize increases are\n persisted into the environment.\n\n If the mapsize is increased by another process, and data has grown\n beyond the range of the current mapsize, #mdb_txn_begin() will\n return #MDB_MAP_RESIZED. This function may be called with a size\n of zero to adopt the new size.\n\n Any attempt to set a size smaller than the space already consumed\n by the environment will be silently changed to the current size of the used space.\n # Arguments\n\n* `env` (direction in) - An environment handle returned by #mdb_env_create()\n * `size` (direction in) - The size in bytes\n # Returns\n\nA non-zero error value on failure and 0 on success. Some possible\n errors are:\n <ul>\n\t<li>EINVAL - an invalid parameter was specified, or the environment has\n \tan active write transaction.\n </ul>"]
    pub fn mdb_env_set_mapsize(env: *mut MDB_env, size: mdb_size_t) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Set the maximum number of threads/reader slots for the environment.\n\n This defines the number of slots in the lock table that is used to track readers in the\n the environment. The default is 126.\n Starting a read-only transaction normally ties a lock table slot to the\n current thread until the environment closes or the thread exits. If\n MDB_NOTLS is in use, #mdb_txn_begin() instead ties the slot to the\n MDB_txn object until it or the #MDB_env object is destroyed.\n This function may only be called after #mdb_env_create() and before #mdb_env_open().\n # Arguments\n\n* `env` (direction in) - An environment handle returned by #mdb_env_create()\n * `readers` (direction in) - The maximum number of reader lock table slots\n # Returns\n\nA non-zero error value on failure and 0 on success. Some possible\n errors are:\n <ul>\n\t<li>EINVAL - an invalid parameter was specified, or the environment is already open.\n </ul>"]
    pub fn mdb_env_set_maxreaders(env: *mut MDB_env, readers: ::libc::c_uint) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Get the maximum number of threads/reader slots for the environment.\n\n # Arguments\n\n* `env` (direction in) - An environment handle returned by #mdb_env_create()\n * `readers` (direction out) - Address of an integer to store the number of readers\n # Returns\n\nA non-zero error value on failure and 0 on success. Some possible\n errors are:\n <ul>\n\t<li>EINVAL - an invalid parameter was specified.\n </ul>"]
    pub fn mdb_env_get_maxreaders(env: *mut MDB_env, readers: *mut ::libc::c_uint)
        -> ::libc::c_int;
}
extern "C" {
    #[doc = "Set the maximum number of named databases for the environment.\n\n This function is only needed if multiple databases will be used in the\n environment. Simpler applications that use the environment as a single\n unnamed database can ignore this option.\n This function may only be called after #mdb_env_create() and before #mdb_env_open().\n\n Currently a moderate number of slots are cheap but a huge number gets\n expensive: 7-120 words per transaction, and every #mdb_dbi_open()\n does a linear search of the opened slots.\n # Arguments\n\n* `env` (direction in) - An environment handle returned by #mdb_env_create()\n * `dbs` (direction in) - The maximum number of databases\n # Returns\n\nA non-zero error value on failure and 0 on success. Some possible\n errors are:\n <ul>\n\t<li>EINVAL - an invalid parameter was specified, or the environment is already open.\n </ul>"]
    pub fn mdb_env_set_maxdbs(env: *mut MDB_env, dbs: MDB_dbi) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Get the maximum size of keys and #MDB_DUPSORT data we can write.\n\n Depends on the compile-time constant #MDB_MAXKEYSIZE. Default 511.\n See MDB_val.\n # Arguments\n\n* `env` (direction in) - An environment handle returned by #mdb_env_create()\n # Returns\n\nThe maximum size of a key we can write"]
    pub fn mdb_env_get_maxkeysize(env: *mut MDB_env) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Set application information associated with the #MDB_env.\n\n # Arguments\n\n* `env` (direction in) - An environment handle returned by #mdb_env_create()\n * `ctx` (direction in) - An arbitrary pointer for whatever the application needs.\n # Returns\n\nA non-zero error value on failure and 0 on success."]
    pub fn mdb_env_set_userctx(env: *mut MDB_env, ctx: *mut ::libc::c_void) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Get the application information associated with the #MDB_env.\n\n # Arguments\n\n* `env` (direction in) - An environment handle returned by #mdb_env_create()\n # Returns\n\nThe pointer set by #mdb_env_set_userctx()."]
    pub fn mdb_env_get_userctx(env: *mut MDB_env) -> *mut ::libc::c_void;
}
#[doc = "A callback function for most LMDB assert() failures,\n called before printing the message and aborting.\n\n # Arguments\n\n* `env` (direction in) - An environment handle returned by #mdb_env_create().\n * `msg` (direction in) - The assertion message, not including newline."]
pub type MDB_assert_func =
    ::std::option::Option<unsafe extern "C" fn(env: *mut MDB_env, msg: *const ::libc::c_char)>;
extern "C" {
    #[doc = "Set or reset the assert() callback of the environment.\n Disabled if liblmdb is built with NDEBUG.\n > **Note:** This hack should become obsolete as lmdb's error handling matures.\n # Arguments\n\n* `env` (direction in) - An environment handle returned by #mdb_env_create().\n * `func` (direction in) - An #MDB_assert_func function, or 0.\n # Returns\n\nA non-zero error value on failure and 0 on success."]
    pub fn mdb_env_set_assert(env: *mut MDB_env, func: MDB_assert_func) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Create a transaction for use with the environment.\n\n The transaction handle may be discarded using #mdb_txn_abort() or #mdb_txn_commit().\n > **Note:** A transaction and its cursors must only be used by a single\n thread, and a thread may only have a single transaction at a time.\n If #MDB_NOTLS is in use, this does not apply to read-only transactions.\n > **Note:** Cursors may not span transactions.\n # Arguments\n\n* `env` (direction in) - An environment handle returned by #mdb_env_create()\n * `parent` (direction in) - If this parameter is non-NULL, the new transaction\n will be a nested transaction, with the transaction indicated by **parent**\n as its parent. Transactions may be nested to any level. A parent\n transaction and its cursors may not issue any other operations than\n mdb_txn_commit and mdb_txn_abort while it has active child transactions.\n * `flags` (direction in) - Special options for this transaction. This parameter\n must be set to 0 or by bitwise OR'ing together one or more of the\n values described here.\n <ul>\n\t<li>#MDB_RDONLY\n\t\tThis transaction will not perform any write operations.\n\t<li>#MDB_NOSYNC\n\t\tDon't flush system buffers to disk when committing this transaction.\n\t<li>#MDB_NOMETASYNC\n\t\tFlush system buffers but omit metadata flush when committing this transaction.\n </ul>\n * `txn` (direction out) - Address where the new #MDB_txn handle will be stored\n # Returns\n\nA non-zero error value on failure and 0 on success. Some possible\n errors are:\n <ul>\n\t<li>#MDB_PANIC - a fatal error occurred earlier and the environment\n\t\tmust be shut down.\n\t<li>#MDB_MAP_RESIZED - another process wrote data beyond this MDB_env's\n\t\tmapsize and this environment's map must be resized as well.\n\t\tSee #mdb_env_set_mapsize().\n\t<li>#MDB_READERS_FULL - a read-only transaction was requested and\n\t\tthe reader lock table is full. See #mdb_env_set_maxreaders().\n\t<li>ENOMEM - out of memory.\n </ul>"]
    pub fn mdb_txn_begin(
        env: *mut MDB_env,
        parent: *mut MDB_txn,
        flags: ::libc::c_uint,
        txn: *mut *mut MDB_txn,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Returns the transaction's #MDB_env\n\n # Arguments\n\n* `txn` (direction in) - A transaction handle returned by #mdb_txn_begin()"]
    pub fn mdb_txn_env(txn: *mut MDB_txn) -> *mut MDB_env;
}
extern "C" {
    #[doc = "Return the transaction's ID.\n\n This returns the identifier associated with this transaction. For a\n read-only transaction, this corresponds to the snapshot being read;\n concurrent readers will frequently have the same transaction ID.\n\n # Arguments\n\n* `txn` (direction in) - A transaction handle returned by #mdb_txn_begin()\n # Returns\n\nA transaction ID, valid if input is an active transaction."]
    pub fn mdb_txn_id(txn: *mut MDB_txn) -> mdb_size_t;
}
extern "C" {
    #[doc = "Commit all the operations of a transaction into the database.\n\n The transaction handle is freed. It and its cursors must not be used\n again after this call, except with #mdb_cursor_renew().\n > **Note:** Earlier documentation incorrectly said all cursors would be freed.\n Only write-transactions free cursors.\n # Arguments\n\n* `txn` (direction in) - A transaction handle returned by #mdb_txn_begin()\n # Returns\n\nA non-zero error value on failure and 0 on success. Some possible\n errors are:\n <ul>\n\t<li>EINVAL - an invalid parameter was specified.\n\t<li>ENOSPC - no more disk space.\n\t<li>EIO - a low-level I/O error occurred while writing.\n\t<li>ENOMEM - out of memory.\n </ul>"]
    pub fn mdb_txn_commit(txn: *mut MDB_txn) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Abandon all the operations of the transaction instead of saving them.\n\n The transaction handle is freed. It and its cursors must not be used\n again after this call, except with #mdb_cursor_renew().\n > **Note:** Earlier documentation incorrectly said all cursors would be freed.\n Only write-transactions free cursors.\n # Arguments\n\n* `txn` (direction in) - A transaction handle returned by #mdb_txn_begin()"]
    pub fn mdb_txn_abort(txn: *mut MDB_txn);
}
extern "C" {
    #[doc = "Reset a read-only transaction.\n\n Abort the transaction like #mdb_txn_abort(), but keep the transaction\n handle. #mdb_txn_renew() may reuse the handle. This saves allocation\n overhead if the process will start a new read-only transaction soon,\n and also locking overhead if #MDB_NOTLS is in use. The reader table\n lock is released, but the table slot stays tied to its thread or\n #MDB_txn. Use mdb_txn_abort() to discard a reset handle, and to free\n its lock table slot if MDB_NOTLS is in use.\n Cursors opened within the transaction must not be used\n again after this call, except with #mdb_cursor_renew().\n Reader locks generally don't interfere with writers, but they keep old\n versions of database pages allocated. Thus they prevent the old pages\n from being reused when writers commit new data, and so under heavy load\n the database size may grow much more rapidly than otherwise.\n # Arguments\n\n* `txn` (direction in) - A transaction handle returned by #mdb_txn_begin()"]
    pub fn mdb_txn_reset(txn: *mut MDB_txn);
}
extern "C" {
    #[doc = "Renew a read-only transaction.\n\n This acquires a new reader lock for a transaction handle that had been\n released by #mdb_txn_reset(). It must be called before a reset transaction\n may be used again.\n # Arguments\n\n* `txn` (direction in) - A transaction handle returned by #mdb_txn_begin()\n # Returns\n\nA non-zero error value on failure and 0 on success. Some possible\n errors are:\n <ul>\n\t<li>#MDB_PANIC - a fatal error occurred earlier and the environment\n\t\tmust be shut down.\n\t<li>EINVAL - an invalid parameter was specified.\n </ul>"]
    pub fn mdb_txn_renew(txn: *mut MDB_txn) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Open a database in the environment.\n\n A database handle denotes the name and parameters of a database,\n independently of whether such a database exists.\n The database handle may be discarded by calling #mdb_dbi_close().\n The old database handle is returned if the database was already open.\n The handle may only be closed once.\n\n The database handle will be private to the current transaction until\n the transaction is successfully committed. If the transaction is\n aborted the handle will be closed automatically.\n After a successful commit the handle will reside in the shared\n environment, and may be used by other transactions.\n\n This function must not be called from multiple concurrent\n transactions in the same process. A transaction that uses\n this function must finish (either commit or abort) before\n any other transaction in the process may use this function.\n\n To use named databases (with name != NULL), #mdb_env_set_maxdbs()\n must be called before opening the environment. Database names are\n keys in the unnamed database, and may be read but not written.\n\n # Arguments\n\n* `txn` (direction in) - A transaction handle returned by #mdb_txn_begin()\n * `name` (direction in) - The name of the database to open. If only a single\n \tdatabase is needed in the environment, this value may be NULL.\n * `flags` (direction in) - Special options for this database. This parameter\n must be set to 0 or by bitwise OR'ing together one or more of the\n values described here.\n <ul>\n\t<li>#MDB_REVERSEKEY\n\t\tKeys are strings to be compared in reverse order, from the end\n\t\tof the strings to the beginning. By default, Keys are treated as strings and\n\t\tcompared from beginning to end.\n\t<li>#MDB_DUPSORT\n\t\tDuplicate keys may be used in the database. (Or, from another perspective,\n\t\tkeys may have multiple data items, stored in sorted order.) By default\n\t\tkeys must be unique and may have only a single data item.\n\t<li>#MDB_INTEGERKEY\n\t\tKeys are binary integers in native byte order, either unsigned int\n\t\tor #mdb_size_t, and will be sorted as such.\n\t\t(lmdb expects 32-bit int <= size_t <= 32/64-bit mdb_size_t.)\n\t\tThe keys must all be of the same size.\n\t<li>#MDB_DUPFIXED\n\t\tThis flag may only be used in combination with #MDB_DUPSORT. This option\n\t\ttells the library that the data items for this database are all the same\n\t\tsize, which allows further optimizations in storage and retrieval. When\n\t\tall data items are the same size, the #MDB_GET_MULTIPLE, #MDB_NEXT_MULTIPLE\n\t\tand #MDB_PREV_MULTIPLE cursor operations may be used to retrieve multiple\n\t\titems at once.\n\t<li>#MDB_INTEGERDUP\n\t\tThis option specifies that duplicate data items are binary integers,\n\t\tsimilar to #MDB_INTEGERKEY keys.\n\t<li>#MDB_REVERSEDUP\n\t\tThis option specifies that duplicate data items should be compared as\n\t\tstrings in reverse order.\n\t<li>#MDB_CREATE\n\t\tCreate the named database if it doesn't exist. This option is not\n\t\tallowed in a read-only transaction or a read-only environment.\n </ul>\n * `dbi` (direction out) - Address where the new #MDB_dbi handle will be stored\n # Returns\n\nA non-zero error value on failure and 0 on success. Some possible\n errors are:\n <ul>\n\t<li>#MDB_NOTFOUND - the specified database doesn't exist in the environment\n\t\tand #MDB_CREATE was not specified.\n\t<li>#MDB_DBS_FULL - too many databases have been opened. See #mdb_env_set_maxdbs().\n </ul>"]
    pub fn mdb_dbi_open(
        txn: *mut MDB_txn,
        name: *const ::libc::c_char,
        flags: ::libc::c_uint,
        dbi: *mut MDB_dbi,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Retrieve statistics for a database.\n\n # Arguments\n\n* `txn` (direction in) - A transaction handle returned by #mdb_txn_begin()\n * `dbi` (direction in) - A database handle returned by #mdb_dbi_open()\n * `stat` (direction out) - The address of an #MDB_stat structure\n \twhere the statistics will be copied\n # Returns\n\nA non-zero error value on failure and 0 on success. Some possible\n errors are:\n <ul>\n\t<li>EINVAL - an invalid parameter was specified.\n </ul>"]
    pub fn mdb_stat(txn: *mut MDB_txn, dbi: MDB_dbi, stat: *mut MDB_stat) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Retrieve the DB flags for a database handle.\n\n # Arguments\n\n* `txn` (direction in) - A transaction handle returned by #mdb_txn_begin()\n * `dbi` (direction in) - A database handle returned by #mdb_dbi_open()\n * `flags` (direction out) - Address where the flags will be returned.\n # Returns\n\nA non-zero error value on failure and 0 on success."]
    pub fn mdb_dbi_flags(
        txn: *mut MDB_txn,
        dbi: MDB_dbi,
        flags: *mut ::libc::c_uint,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Close a database handle. Normally unnecessary. Use with care:\n\n This call is not mutex protected. Handles should only be closed by\n a single thread, and only if no other threads are going to reference\n the database handle or one of its cursors any further. Do not close\n a handle if an existing transaction has modified its database.\n Doing so can cause misbehavior from database corruption to errors\n like MDB_BAD_VALSIZE (since the DB name is gone).\n\n Closing a database handle is not necessary, but lets #mdb_dbi_open()\n reuse the handle value. Usually it's better to set a bigger\n #mdb_env_set_maxdbs(), unless that value would be large.\n\n # Arguments\n\n* `env` (direction in) - An environment handle returned by #mdb_env_create()\n * `dbi` (direction in) - A database handle returned by #mdb_dbi_open()"]
    pub fn mdb_dbi_close(env: *mut MDB_env, dbi: MDB_dbi);
}
extern "C" {
    #[doc = "Empty or delete+close a database.\n\n See #mdb_dbi_close() for restrictions about closing the DB handle.\n # Arguments\n\n* `txn` (direction in) - A transaction handle returned by #mdb_txn_begin()\n * `dbi` (direction in) - A database handle returned by #mdb_dbi_open()\n * `del` (direction in) - 0 to empty the DB, 1 to delete it from the\n environment and close the DB handle.\n # Returns\n\nA non-zero error value on failure and 0 on success."]
    pub fn mdb_drop(txn: *mut MDB_txn, dbi: MDB_dbi, del: ::libc::c_int) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Set a custom key comparison function for a database.\n\n The comparison function is called whenever it is necessary to compare a\n key specified by the application with a key currently stored in the database.\n If no comparison function is specified, and no special key flags were specified\n with #mdb_dbi_open(), the keys are compared lexically, with shorter keys collating\n before longer keys.\n This function must be called before any data access functions are used,\n otherwise data corruption may occur. The same comparison function must be used by every\n program accessing the database, every time the database is used.\n # Arguments\n\n* `txn` (direction in) - A transaction handle returned by #mdb_txn_begin()\n * `dbi` (direction in) - A database handle returned by #mdb_dbi_open()\n * `cmp` (direction in) - A #MDB_cmp_func function\n # Returns\n\nA non-zero error value on failure and 0 on success. Some possible\n errors are:\n <ul>\n\t<li>EINVAL - an invalid parameter was specified.\n </ul>"]
    pub fn mdb_set_compare(txn: *mut MDB_txn, dbi: MDB_dbi, cmp: MDB_cmp_func) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Set a custom data comparison function for a #MDB_DUPSORT database.\n\n This comparison function is called whenever it is necessary to compare a data\n item specified by the application with a data item currently stored in the database.\n This function only takes effect if the database was opened with the #MDB_DUPSORT\n flag.\n If no comparison function is specified, and no special key flags were specified\n with #mdb_dbi_open(), the data items are compared lexically, with shorter items collating\n before longer items.\n This function must be called before any data access functions are used,\n otherwise data corruption may occur. The same comparison function must be used by every\n program accessing the database, every time the database is used.\n # Arguments\n\n* `txn` (direction in) - A transaction handle returned by #mdb_txn_begin()\n * `dbi` (direction in) - A database handle returned by #mdb_dbi_open()\n * `cmp` (direction in) - A #MDB_cmp_func function\n # Returns\n\nA non-zero error value on failure and 0 on success. Some possible\n errors are:\n <ul>\n\t<li>EINVAL - an invalid parameter was specified.\n </ul>"]
    pub fn mdb_set_dupsort(txn: *mut MDB_txn, dbi: MDB_dbi, cmp: MDB_cmp_func) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Set a relocation function for a #MDB_FIXEDMAP database.\n\n The relocation function is called whenever it is necessary to move the data\n of an item to a different position in the database (e.g. through tree\n balancing operations, shifts as a result of adds or deletes, etc.). It is\n intended to allow address/position-dependent data items to be stored in\n a database in an environment opened with the #MDB_FIXEDMAP option.\n Currently the relocation feature is unimplemented and setting\n this function has no effect.\n # Arguments\n\n* `txn` (direction in) - A transaction handle returned by #mdb_txn_begin()\n * `dbi` (direction in) - A database handle returned by #mdb_dbi_open()\n * `rel` (direction in) - A #MDB_rel_func function\n # Returns\n\nA non-zero error value on failure and 0 on success. Some possible\n errors are:\n <ul>\n\t<li>EINVAL - an invalid parameter was specified.\n </ul>"]
    pub fn mdb_set_relfunc(txn: *mut MDB_txn, dbi: MDB_dbi, rel: MDB_rel_func) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Set a context pointer for a #MDB_FIXEDMAP database's relocation function.\n\n See #mdb_set_relfunc and #MDB_rel_func for more details.\n # Arguments\n\n* `txn` (direction in) - A transaction handle returned by #mdb_txn_begin()\n * `dbi` (direction in) - A database handle returned by #mdb_dbi_open()\n * `ctx` (direction in) - An arbitrary pointer for whatever the application needs.\n It will be passed to the callback function set by #mdb_set_relfunc\n as its **relctx** parameter whenever the callback is invoked.\n # Returns\n\nA non-zero error value on failure and 0 on success. Some possible\n errors are:\n <ul>\n\t<li>EINVAL - an invalid parameter was specified.\n </ul>"]
    pub fn mdb_set_relctx(
        txn: *mut MDB_txn,
        dbi: MDB_dbi,
        ctx: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Get items from a database.\n\n This function retrieves key/data pairs from the database. The address\n and length of the data associated with the specified **key** are returned\n in the structure to which **data** refers.\n If the database supports duplicate keys (#MDB_DUPSORT) then the\n first data item for the key will be returned. Retrieval of other\n items requires the use of #mdb_cursor_get().\n\n > **Note:** The memory pointed to by the returned values is owned by the\n database. The caller need not dispose of the memory, and may not\n modify it in any way. For values returned in a read-only transaction\n any modification attempts will cause a SIGSEGV.\n > **Note:** Values returned from the database are valid only until a\n subsequent update operation, or the end of the transaction.\n # Arguments\n\n* `txn` (direction in) - A transaction handle returned by #mdb_txn_begin()\n * `dbi` (direction in) - A database handle returned by #mdb_dbi_open()\n * `key` (direction in) - The key to search for in the database\n * `data` (direction out) - The data corresponding to the key\n # Returns\n\nA non-zero error value on failure and 0 on success. Some possible\n errors are:\n <ul>\n\t<li>#MDB_NOTFOUND - the key was not in the database.\n\t<li>EINVAL - an invalid parameter was specified.\n </ul>"]
    pub fn mdb_get(
        txn: *mut MDB_txn,
        dbi: MDB_dbi,
        key: *mut MDB_val,
        data: *mut MDB_val,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Store items into a database.\n\n This function stores key/data pairs in the database. The default behavior\n is to enter the new key/data pair, replacing any previously existing key\n if duplicates are disallowed, or adding a duplicate data item if\n duplicates are allowed (#MDB_DUPSORT).\n # Arguments\n\n* `txn` (direction in) - A transaction handle returned by #mdb_txn_begin()\n * `dbi` (direction in) - A database handle returned by #mdb_dbi_open()\n * `key` (direction in) - The key to store in the database\n * `data` (direction in, out) - The data to store\n * `flags` (direction in) - Special options for this operation. This parameter\n must be set to 0 or by bitwise OR'ing together one or more of the\n values described here.\n <ul>\n\t<li>#MDB_NODUPDATA - enter the new key/data pair only if it does not\n\t\talready appear in the database. This flag may only be specified\n\t\tif the database was opened with #MDB_DUPSORT. The function will\n\t\treturn #MDB_KEYEXIST if the key/data pair already appears in the\n\t\tdatabase.\n\t<li>#MDB_NOOVERWRITE - enter the new key/data pair only if the key\n\t\tdoes not already appear in the database. The function will return\n\t\t#MDB_KEYEXIST if the key already appears in the database, even if\n\t\tthe database supports duplicates (#MDB_DUPSORT). The **data**\n\t\tparameter will be set to point to the existing item.\n\t<li>#MDB_RESERVE - reserve space for data of the given size, but\n\t\tdon't copy the given data. Instead, return a pointer to the\n\t\treserved space, which the caller can fill in later - before\n\t\tthe next update operation or the transaction ends. This saves\n\t\tan extra memcpy if the data is being generated later.\n\t\tLMDB does nothing else with this memory, the caller is expected\n\t\tto modify all of the space requested. This flag must not be\n\t\tspecified if the database was opened with #MDB_DUPSORT.\n\t<li>#MDB_APPEND - append the given key/data pair to the end of the\n\t\tdatabase. This option allows fast bulk loading when keys are\n\t\talready known to be in the correct order. Loading unsorted keys\n\t\twith this flag will cause a #MDB_KEYEXIST error.\n\t<li>#MDB_APPENDDUP - as above, but for sorted dup data.\n </ul>\n # Returns\n\nA non-zero error value on failure and 0 on success. Some possible\n errors are:\n <ul>\n\t<li>#MDB_MAP_FULL - the database is full, see #mdb_env_set_mapsize().\n\t<li>#MDB_TXN_FULL - the transaction has too many dirty pages.\n\t<li>EACCES - an attempt was made to write in a read-only transaction.\n\t<li>EINVAL - an invalid parameter was specified.\n </ul>"]
    pub fn mdb_put(
        txn: *mut MDB_txn,
        dbi: MDB_dbi,
        key: *mut MDB_val,
        data: *mut MDB_val,
        flags: ::libc::c_uint,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Delete items from a database.\n\n This function removes key/data pairs from the database.\n If the database does not support sorted duplicate data items\n (#MDB_DUPSORT) the data parameter is ignored.\n If the database supports sorted duplicates and the data parameter\n is NULL, all of the duplicate data items for the key will be\n deleted. Otherwise, if the data parameter is non-NULL\n only the matching data item will be deleted.\n This function will return #MDB_NOTFOUND if the specified key/data\n pair is not in the database.\n # Arguments\n\n* `txn` (direction in) - A transaction handle returned by #mdb_txn_begin()\n * `dbi` (direction in) - A database handle returned by #mdb_dbi_open()\n * `key` (direction in) - The key to delete from the database\n * `data` (direction in) - The data to delete\n # Returns\n\nA non-zero error value on failure and 0 on success. Some possible\n errors are:\n <ul>\n\t<li>EACCES - an attempt was made to write in a read-only transaction.\n\t<li>EINVAL - an invalid parameter was specified.\n </ul>"]
    pub fn mdb_del(
        txn: *mut MDB_txn,
        dbi: MDB_dbi,
        key: *mut MDB_val,
        data: *mut MDB_val,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Create a cursor handle.\n\n A cursor is associated with a specific transaction and database.\n A cursor cannot be used when its database handle is closed. Nor\n when its transaction has ended, except with #mdb_cursor_renew().\n It can be discarded with #mdb_cursor_close().\n A cursor in a write-transaction can be closed before its transaction\n ends, and will otherwise be closed when its transaction ends.\n A cursor in a read-only transaction must be closed explicitly, before\n or after its transaction ends. It can be reused with\n #mdb_cursor_renew() before finally closing it.\n > **Note:** Earlier documentation said that cursors in every transaction\n were closed when the transaction committed or aborted.\n # Arguments\n\n* `txn` (direction in) - A transaction handle returned by #mdb_txn_begin()\n * `dbi` (direction in) - A database handle returned by #mdb_dbi_open()\n * `cursor` (direction out) - Address where the new #MDB_cursor handle will be stored\n # Returns\n\nA non-zero error value on failure and 0 on success. Some possible\n errors are:\n <ul>\n\t<li>EINVAL - an invalid parameter was specified.\n </ul>"]
    pub fn mdb_cursor_open(
        txn: *mut MDB_txn,
        dbi: MDB_dbi,
        cursor: *mut *mut MDB_cursor,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Close a cursor handle.\n\n The cursor handle will be freed and must not be used again after this call.\n Its transaction must still be live if it is a write-transaction.\n # Arguments\n\n* `cursor` (direction in) - A cursor handle returned by #mdb_cursor_open()"]
    pub fn mdb_cursor_close(cursor: *mut MDB_cursor);
}
extern "C" {
    #[doc = "Renew a cursor handle.\n\n A cursor is associated with a specific transaction and database.\n Cursors that are only used in read-only\n transactions may be re-used, to avoid unnecessary malloc/free overhead.\n The cursor may be associated with a new read-only transaction, and\n referencing the same database handle as it was created with.\n This may be done whether the previous transaction is live or dead.\n # Arguments\n\n* `txn` (direction in) - A transaction handle returned by #mdb_txn_begin()\n * `cursor` (direction in) - A cursor handle returned by #mdb_cursor_open()\n # Returns\n\nA non-zero error value on failure and 0 on success. Some possible\n errors are:\n <ul>\n\t<li>EINVAL - an invalid parameter was specified.\n </ul>"]
    pub fn mdb_cursor_renew(txn: *mut MDB_txn, cursor: *mut MDB_cursor) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Return the cursor's transaction handle.\n\n # Arguments\n\n* `cursor` (direction in) - A cursor handle returned by #mdb_cursor_open()"]
    pub fn mdb_cursor_txn(cursor: *mut MDB_cursor) -> *mut MDB_txn;
}
extern "C" {
    #[doc = "Return the cursor's database handle.\n\n # Arguments\n\n* `cursor` (direction in) - A cursor handle returned by #mdb_cursor_open()"]
    pub fn mdb_cursor_dbi(cursor: *mut MDB_cursor) -> MDB_dbi;
}
extern "C" {
    #[doc = "Retrieve by cursor.\n\n This function retrieves key/data pairs from the database. The address and length\n of the key are returned in the object to which **key** refers (except for the\n case of the #MDB_SET option, in which the **key** object is unchanged), and\n the address and length of the data are returned in the object to which **data**\n refers.\n See #mdb_get() for restrictions on using the output values.\n # Arguments\n\n* `cursor` (direction in) - A cursor handle returned by #mdb_cursor_open()\n * `key` (direction in, out) - The key for a retrieved item\n * `data` (direction in, out) - The data of a retrieved item\n * `op` (direction in) - A cursor operation #MDB_cursor_op\n # Returns\n\nA non-zero error value on failure and 0 on success. Some possible\n errors are:\n <ul>\n\t<li>#MDB_NOTFOUND - no matching key found.\n\t<li>EINVAL - an invalid parameter was specified.\n </ul>"]
    pub fn mdb_cursor_get(
        cursor: *mut MDB_cursor,
        key: *mut MDB_val,
        data: *mut MDB_val,
        op: MDB_cursor_op,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Store by cursor.\n\n This function stores key/data pairs into the database.\n The cursor is positioned at the new item, or on failure usually near it.\n > **Note:** Earlier documentation incorrectly said errors would leave the\n state of the cursor unchanged.\n # Arguments\n\n* `cursor` (direction in) - A cursor handle returned by #mdb_cursor_open()\n * `key` (direction in) - The key operated on.\n * `data` (direction in) - The data operated on.\n * `flags` (direction in) - Options for this operation. This parameter\n must be set to 0 or one of the values described here.\n <ul>\n\t<li>#MDB_CURRENT - replace the item at the current cursor position.\n\t\tThe **key** parameter must still be provided, and must match it.\n\t\tIf using sorted duplicates (#MDB_DUPSORT) the data item must still\n\t\tsort into the same place. This is intended to be used when the\n\t\tnew data is the same size as the old. Otherwise it will simply\n\t\tperform a delete of the old record followed by an insert.\n\t<li>#MDB_NODUPDATA - enter the new key/data pair only if it does not\n\t\talready appear in the database. This flag may only be specified\n\t\tif the database was opened with #MDB_DUPSORT. The function will\n\t\treturn #MDB_KEYEXIST if the key/data pair already appears in the\n\t\tdatabase.\n\t<li>#MDB_NOOVERWRITE - enter the new key/data pair only if the key\n\t\tdoes not already appear in the database. The function will return\n\t\t#MDB_KEYEXIST if the key already appears in the database, even if\n\t\tthe database supports duplicates (#MDB_DUPSORT).\n\t<li>#MDB_RESERVE - reserve space for data of the given size, but\n\t\tdon't copy the given data. Instead, return a pointer to the\n\t\treserved space, which the caller can fill in later - before\n\t\tthe next update operation or the transaction ends. This saves\n\t\tan extra memcpy if the data is being generated later. This flag\n\t\tmust not be specified if the database was opened with #MDB_DUPSORT.\n\t<li>#MDB_APPEND - append the given key/data pair to the end of the\n\t\tdatabase. No key comparisons are performed. This option allows\n\t\tfast bulk loading when keys are already known to be in the\n\t\tcorrect order. Loading unsorted keys with this flag will cause\n\t\ta #MDB_KEYEXIST error.\n\t<li>#MDB_APPENDDUP - as above, but for sorted dup data.\n\t<li>#MDB_MULTIPLE - store multiple contiguous data elements in a\n\t\tsingle request. This flag may only be specified if the database\n\t\twas opened with #MDB_DUPFIXED. The **data** argument must be an\n\t\tarray of two MDB_vals. The mv_size of the first MDB_val must be\n\t\tthe size of a single data element. The mv_data of the first MDB_val\n\t\tmust point to the beginning of the array of contiguous data elements.\n\t\tThe mv_size of the second MDB_val must be the count of the number\n\t\tof data elements to store. On return this field will be set to\n\t\tthe count of the number of elements actually written. The mv_data\n\t\tof the second MDB_val is unused.\n </ul>\n # Returns\n\nA non-zero error value on failure and 0 on success. Some possible\n errors are:\n <ul>\n\t<li>#MDB_MAP_FULL - the database is full, see #mdb_env_set_mapsize().\n\t<li>#MDB_TXN_FULL - the transaction has too many dirty pages.\n\t<li>EACCES - an attempt was made to write in a read-only transaction.\n\t<li>EINVAL - an invalid parameter was specified.\n </ul>"]
    pub fn mdb_cursor_put(
        cursor: *mut MDB_cursor,
        key: *mut MDB_val,
        data: *mut MDB_val,
        flags: ::libc::c_uint,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Delete current key/data pair\n\n This function deletes the key/data pair to which the cursor refers.\n This does not invalidate the cursor, so operations such as MDB_NEXT\n can still be used on it.\n Both MDB_NEXT and MDB_GET_CURRENT will return the same record after\n this operation.\n # Arguments\n\n* `cursor` (direction in) - A cursor handle returned by #mdb_cursor_open()\n * `flags` (direction in) - Options for this operation. This parameter\n must be set to 0 or one of the values described here.\n <ul>\n\t<li>#MDB_NODUPDATA - delete all of the data items for the current key.\n\t\tThis flag may only be specified if the database was opened with #MDB_DUPSORT.\n </ul>\n # Returns\n\nA non-zero error value on failure and 0 on success. Some possible\n errors are:\n <ul>\n\t<li>EACCES - an attempt was made to write in a read-only transaction.\n\t<li>EINVAL - an invalid parameter was specified.\n </ul>"]
    pub fn mdb_cursor_del(cursor: *mut MDB_cursor, flags: ::libc::c_uint) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Return count of duplicates for current key.\n\n This call is only valid on databases that support sorted duplicate\n data items #MDB_DUPSORT.\n # Arguments\n\n* `cursor` (direction in) - A cursor handle returned by #mdb_cursor_open()\n * `countp` (direction out) - Address where the count will be stored\n # Returns\n\nA non-zero error value on failure and 0 on success. Some possible\n errors are:\n <ul>\n\t<li>EINVAL - cursor is not initialized, or an invalid parameter was specified.\n </ul>"]
    pub fn mdb_cursor_count(cursor: *mut MDB_cursor, countp: *mut mdb_size_t) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Compare two data items according to a particular database.\n\n This returns a comparison as if the two data items were keys in the\n specified database.\n # Arguments\n\n* `txn` (direction in) - A transaction handle returned by #mdb_txn_begin()\n * `dbi` (direction in) - A database handle returned by #mdb_dbi_open()\n * `a` (direction in) - The first item to compare\n * `b` (direction in) - The second item to compare\n # Returns\n\n< 0 if a < b, 0 if a == b, > 0 if a > b"]
    pub fn mdb_cmp(
        txn: *mut MDB_txn,
        dbi: MDB_dbi,
        a: *const MDB_val,
        b: *const MDB_val,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Compare two data items according to a particular database.\n\n This returns a comparison as if the two items were data items of\n the specified database. The database must have the #MDB_DUPSORT flag.\n # Arguments\n\n* `txn` (direction in) - A transaction handle returned by #mdb_txn_begin()\n * `dbi` (direction in) - A database handle returned by #mdb_dbi_open()\n * `a` (direction in) - The first item to compare\n * `b` (direction in) - The second item to compare\n # Returns\n\n< 0 if a < b, 0 if a == b, > 0 if a > b"]
    pub fn mdb_dcmp(
        txn: *mut MDB_txn,
        dbi: MDB_dbi,
        a: *const MDB_val,
        b: *const MDB_val,
    ) -> ::libc::c_int;
}
#[doc = "A callback function used to print a message from the library.\n\n # Arguments\n\n* `msg` (direction in) - The string to be printed.\n * `ctx` (direction in) - An arbitrary context pointer for the callback.\n # Returns\n\n< 0 on failure, >= 0 on success."]
pub type MDB_msg_func = ::std::option::Option<
    unsafe extern "C" fn(msg: *const ::libc::c_char, ctx: *mut ::libc::c_void) -> ::libc::c_int,
>;
extern "C" {
    #[doc = "Dump the entries in the reader lock table.\n\n # Arguments\n\n* `env` (direction in) - An environment handle returned by #mdb_env_create()\n * `func` (direction in) - A #MDB_msg_func function\n * `ctx` (direction in) - Anything the message function needs\n # Returns\n\n< 0 on failure, >= 0 on success."]
    pub fn mdb_reader_list(
        env: *mut MDB_env,
        func: MDB_msg_func,
        ctx: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = "Check for stale entries in the reader lock table.\n\n # Arguments\n\n* `env` (direction in) - An environment handle returned by #mdb_env_create()\n * `dead` (direction out) - Number of stale slots that were cleared\n # Returns\n\n0 on success, non-zero on failure."]
    pub fn mdb_reader_check(env: *mut MDB_env, dead: *mut ::libc::c_int) -> ::libc::c_int;
}
