#!/bin/sh -f

# This tiny script scans ../aclocal.m4 (which should be generated by
# autoreconf --install) and pulls in the master copies of macro files
# consulted. These files can be cached in ../m4/ for use on target
# that have only the basic macros.

# To use, remove any currently-cached versions, regenerate aclocal.m4,
# and run ./refresh.sh

set -e

for u in $(grep 'http.*ax' ../aclocal.m4 | tr -d '#'); do
    f=$(echo "${u}" | sed 's!https://www.gnu.org/software/autoconf-archive/!!' | sed 's!\.html!!')
    wget2 --output-document="${f}.m4" \
	  "http://git.savannah.gnu.org/gitweb/?p=autoconf-archive.git;a=blob_plain;f=m4/${f}.m4"
done
