#!/usr/bin/perl

print "// WARNING: this is an autogenerated file. Any change might be overwritten!\n";
use strict;
my %grps, my %secs, my %hints;
$grps{"ANY"} = '';

for(<>)
{
	chomp;
	(my $sec, my $pred) = split(/,/);
	next if $sec eq "GTK" or $sec eq "Qt" or $sec eq "GNOME" or $sec eq "KDE" or $sec eq "XFCE" or $sec eq "Java" or $sec eq "ConsoleOnly";
	# key is sanitized name of the filter set or ANY for no filters
	my $key = $pred;
	$key=~ s/\W//g;
	$key = "ANY" if(!$key);
	$secs{$sec}=$key;
	$hints{$sec}=$pred;
	if($key && !defined($grps{$key}))
	{
		$pred=~s/ or /", "|", "/g;
		$pred=~s/;/", "/g;
		$grps{$key}=$pred;
	}

}

print "LPCSTR $_\[\] = { \"$grps{$_}\", \"|\", NULL };\n" for(sort keys %grps);
# start of the list, the end of the list are 
print <<LSTART

namespace spec {

// statically presorted list of categories. See fdomenu.cc for details.
tListMeta menuinfo[] =
{
LSTART
;

my @cats = sort(keys %secs,
"Accessibility",
"Settings",
"Screensavers",
"Accessories",
"Development",
"Education",
"Game",
"Graphics",
"Multimedia",
"Audio",
"Video",
"AudioVideo",
"Network",
"Office",
"Science",
"System",
"WINE",
"Editors",
"Utility",
"Other"
);
for(@cats)
{
	my $ptr = $secs{$_} ? "(char**) &$secs{$_}" : "NULL";
	print "// TRANSLATORS: This is a menu category name from freedesktop.org. Please add spaces as needed but no double-quotes.".($hints{$_} ? " Context: $hints{$_}\n" : "\n");
	print "    { N_(\"$_\"), \"$_\", \"folder\", $ptr, 0, 0}";
	print $_ eq $cats[-1] ? "\n" : ",\n";
}
print "};
}
";
