/* ibus-1.0.vapi generated by vapigen, do not modify. */

[CCode (gir_namespace = "IBus", gir_version = "1.0")]
namespace IBus {
	[CCode (cheader_filename = "ibus.h")]
	public class AttrList : IBus.Serializable {
		public weak GLib.Array attributes;
		[CCode (has_construct_function = false)]
		public AttrList ();
		public void append (IBus.Attribute attr);
		public unowned IBus.Attribute @get (uint index);
	}
	[CCode (cheader_filename = "ibus.h")]
	public class Attribute : IBus.Serializable {
		public uint end_index;
		public uint start_index;
		public uint type;
		public uint value;
		[CCode (has_construct_function = false)]
		public Attribute (uint type, uint value, uint start_index, uint end_index);
		public uint get_attr_type ();
		public uint get_end_index ();
		public uint get_start_index ();
		public uint get_value ();
	}
	[CCode (cheader_filename = "ibus.h")]
	public class Bus : IBus.Object {
		[CCode (has_construct_function = false)]
		public Bus ();
		public bool add_match (string rule);
		public async void add_match_async (string rule, int timeout_msec, GLib.Cancellable cancellable);
		public bool add_match_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public unowned IBus.InputContext create_input_context (string client_name);
		public async void create_input_context_async (string client_name, int timeout_msec, GLib.Cancellable cancellable);
		public unowned IBus.InputContext create_input_context_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public unowned string current_input_context ();
		public async void current_input_context_async (int timeout_msec, GLib.Cancellable cancellable);
		public unowned string current_input_context_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public bool exit (bool restart);
		public async void exit_async (bool restart, int timeout_msec, GLib.Cancellable cancellable);
		public bool exit_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public unowned IBus.Config get_config ();
		public unowned GLib.DBusConnection get_connection ();
		public unowned IBus.EngineDesc get_global_engine ();
		public async void get_global_engine_async (int timeout_msec, GLib.Cancellable cancellable);
		public unowned IBus.EngineDesc get_global_engine_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public string get_name_owner (string name);
		public async void get_name_owner_async (string name, int timeout_msec, GLib.Cancellable cancellable);
		public unowned string get_name_owner_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public bool get_use_global_engine ();
		public async void get_use_global_engine_async (int timeout_msec, GLib.Cancellable cancellable);
		public bool get_use_global_engine_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public bool get_use_sys_layout ();
		public async void get_use_sys_layout_async (int timeout_msec, GLib.Cancellable cancellable);
		public bool get_use_sys_layout_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public unowned string hello ();
		public bool is_connected ();
		public bool is_global_engine_enabled ();
		public async void is_global_engine_enabled_async (int timeout_msec, GLib.Cancellable cancellable);
		public bool is_global_engine_enabled_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public GLib.List<IBus.EngineDesc> list_active_engines ();
		public async void list_active_engines_async (int timeout_msec, GLib.Cancellable cancellable);
		public unowned GLib.List list_active_engines_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public GLib.List<IBus.EngineDesc> list_engines ();
		public async void list_engines_async (int timeout_msec, GLib.Cancellable cancellable);
		public unowned GLib.List list_engines_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public GLib.List<string> list_names ();
		public unowned GLib.List list_queued_owners (string name);
		public bool name_has_owner (string name);
		public async void name_has_owner_async (string name, int timeout_msec, GLib.Cancellable cancellable);
		public bool name_has_owner_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public bool register_component (IBus.Component component);
		public async void register_component_async (IBus.Component component, int timeout_msec, GLib.Cancellable cancellable);
		public bool register_component_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public uint release_name (string name);
		public async void release_name_async (string name, int timeout_msec, GLib.Cancellable cancellable);
		public uint release_name_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public bool remove_match (string rule);
		public async void remove_match_async (string rule, int timeout_msec, GLib.Cancellable cancellable);
		public bool remove_match_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public uint32 request_name (string name, uint32 flags);
		public async void request_name_async (string name, uint flags, int timeout_msec, GLib.Cancellable cancellable);
		public uint request_name_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public bool set_global_engine (string global_engine);
		public async void set_global_engine_async (string global_engine, int timeout_msec, GLib.Cancellable cancellable);
		public bool set_global_engine_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public void set_watch_dbus_signal (bool watch);
		public void set_watch_ibus_signal (bool watch);
		public virtual signal void connected ();
		public virtual signal void disconnected ();
		public virtual signal void global_engine_changed (string p0);
		public virtual signal void name_owner_changed (string p0, string p1, string p2);
	}
	[CCode (cheader_filename = "ibus.h")]
	public class Component : IBus.Serializable {
		public void* pdummy;
		[CCode (has_construct_function = false)]
		public Component (string name, string description, string version, string license, string author, string homepage, string exec, string textdomain);
		public void add_engine (IBus.EngineDesc engine);
		public void add_observed_path (string path, bool access_fs);
		public bool check_modification ();
		[CCode (has_construct_function = false)]
		public Component.from_file (string filename);
		[CCode (has_construct_function = false)]
		public Component.from_xml_node (IBus.XMLNode node);
		public unowned string get_author ();
		public unowned string get_description ();
		public unowned GLib.List get_engines ();
		public unowned string get_exec ();
		public unowned string get_homepage ();
		public unowned string get_license ();
		public unowned string get_name ();
		public unowned string get_textdomain ();
		public unowned string get_version ();
		public void output (GLib.StringBuilder output, int indent);
		public void output_engines (GLib.StringBuilder output, int indent);
		[CCode (has_construct_function = false)]
		public Component.varargs (...);
		public string author { get; construct; }
		public string description { get; construct; }
		public string exec { get; construct; }
		public string homepage { get; construct; }
		public string license { get; construct; }
		public string name { get; construct; }
		public string textdomain { get; construct; }
		public string version { get; construct; }
	}
	[CCode (cheader_filename = "ibus.h")]
	public class Config : IBus.Proxy, GLib.DBusInterface, GLib.Initable, GLib.AsyncInitable {
		[CCode (has_construct_function = false)]
		public Config (GLib.DBusConnection connection, GLib.Cancellable cancellable) throws GLib.Error;
		[CCode (has_construct_function = false, type = "void")]
		public async Config.@async (GLib.DBusConnection connection, GLib.Cancellable cancellable) throws GLib.Error;
		public GLib.Variant get_value (string section, string name);
		public async void get_value_async (string section, string name, int timeout_ms, GLib.Cancellable cancellable);
		public unowned GLib.Variant get_value_async_finish (GLib.AsyncResult _result) throws GLib.Error;
		public unowned GLib.Variant get_values (string section);
		public async void get_values_async (string section, int timeout_ms, GLib.Cancellable cancellable);
		public unowned GLib.Variant get_values_async_finish (GLib.AsyncResult _result) throws GLib.Error;
		public bool set_value (string section, string name, GLib.Variant value);
		public async void set_value_async (string section, string name, GLib.Variant value, int timeout_ms, GLib.Cancellable cancellable);
		public bool set_value_async_finish (GLib.AsyncResult _result) throws GLib.Error;
		public bool unset (string section, string name);
		public virtual signal void value_changed (string p0, string p1, GLib.Variant p2);
	}
	[CCode (cheader_filename = "ibus.h")]
	public class ConfigService : IBus.Service {
		[CCode (has_construct_function = false)]
		public ConfigService (GLib.DBusConnection connection);
		[NoWrapper]
		public virtual GLib.Variant get_value (string section, string name) throws GLib.Error;
		[NoWrapper]
		public virtual unowned GLib.Variant get_values (string section) throws GLib.Error;
		[NoWrapper]
		public virtual bool set_value (string section, string name, GLib.Variant value) throws GLib.Error;
		[NoWrapper]
		public virtual bool unset_value (string section, string name) throws GLib.Error;
		public void value_changed (string section, string name, GLib.Variant value);
	}
	[CCode (cheader_filename = "ibus.h")]
	public class Engine : IBus.Service {
		public uint client_capabilities;
		public weak IBus.Rectangle cursor_area;
		public bool enabled;
		public bool has_focus;
		[CCode (has_construct_function = false)]
		public Engine (string engine_name, string object_path, GLib.DBusConnection connection);
		public void commit_text (IBus.Text text);
		public void delete_surrounding_text (int offset, uint nchars);
		public void forward_key_event (uint keyval, uint keycode, uint state);
		public unowned string get_name ();
		public void get_surrounding_text (out unowned IBus.Text text, out uint cursor_pos, out uint anchor_pos);
		public void hide_auxiliary_text ();
		public void hide_lookup_table ();
		public void hide_preedit_text ();
		public void register_properties (IBus.PropList prop_list);
		public void show_auxiliary_text ();
		public void show_lookup_table ();
		public void show_preedit_text ();
		[CCode (has_construct_function = false)]
		public Engine.type (GLib.Type engine_type, string engine_name, string object_path, GLib.DBusConnection connection);
		public void update_auxiliary_text (IBus.Text text, bool visible);
		public void update_lookup_table (IBus.LookupTable lookup_table, bool visible);
		public void update_lookup_table_fast (IBus.LookupTable lookup_table, bool visible);
		public void update_preedit_text (IBus.Text text, uint cursor_pos, bool visible);
		public void update_preedit_text_with_mode (IBus.Text text, uint cursor_pos, bool visible, IBus.PreeditFocusMode mode);
		public void update_property (IBus.Property prop);
		[NoAccessorMethod]
		public string engine_name { owned get; construct; }
		public virtual signal void cancel_hand_writing (uint n_strokes);
		public virtual signal void candidate_clicked (uint index, uint button, uint state);
		public virtual signal void cursor_down ();
		public virtual signal void cursor_up ();
		public virtual signal void disable ();
		public virtual signal void enable ();
		public virtual signal void focus_in ();
		public virtual signal void focus_out ();
		public virtual signal void page_down ();
		public virtual signal void page_up ();
		public virtual signal void process_hand_writing_event (void* coordinates, uint coordinates_len);
		public virtual signal bool process_key_event (uint keyval, uint keycode, uint state);
		public virtual signal void property_activate (string prop_name, uint prop_state);
		public virtual signal void property_hide (string prop_name);
		public virtual signal void property_show (string prop_name);
		public virtual signal void reset ();
		public virtual signal void set_capabilities (uint caps);
		public virtual signal void set_cursor_location (int x, int y, int w, int h);
		public virtual signal void set_surrounding_text (GLib.Object text, uint cursor_index, uint anchor_pos);
	}
	[CCode (cheader_filename = "ibus.h")]
	public class EngineDesc : IBus.Serializable {
		[CCode (has_construct_function = false)]
		public EngineDesc (string name, string longname, string description, string language, string license, string author, string icon, string layout);
		[CCode (has_construct_function = false)]
		public EngineDesc.from_xml_node (IBus.XMLNode node);
		public unowned string get_author ();
		public unowned string get_description ();
		public unowned string get_hotkeys ();
		public unowned string get_icon ();
		public unowned string get_language ();
		public unowned string get_layout ();
		public unowned string get_license ();
		public unowned string get_longname ();
		public unowned string get_name ();
		public uint get_rank ();
		public unowned string get_symbol ();
		public void output (GLib.StringBuilder output, int indent);
		[CCode (has_construct_function = false)]
		public EngineDesc.varargs (...);
		public string author { get; construct; }
		public string description { get; construct; }
		public string hotkeys { get; construct; }
		public string icon { get; construct; }
		public string language { get; construct; }
		public string layout { get; construct; }
		public string license { get; construct; }
		public string longname { get; construct; }
		public string name { get; construct; }
		public uint rank { get; construct; }
		public string symbol { get; construct; }
	}
	[CCode (cheader_filename = "ibus.h")]
	public class Factory : IBus.Service {
		[CCode (has_construct_function = false)]
		public Factory (GLib.DBusConnection connection);
		public void add_engine (string engine_name, GLib.Type engine_type);
		public virtual signal unowned IBus.Engine create_engine (string engine_name);
	}
	[CCode (cheader_filename = "ibus.h")]
	public class HotkeyProfile : IBus.Serializable {
		[CCode (has_construct_function = false)]
		public HotkeyProfile ();
		public bool add_hotkey (uint keyval, uint modifiers, GLib.Quark event);
		public bool add_hotkey_from_string (string str, GLib.Quark event);
		public GLib.Quark filter_key_event (uint keyval, uint modifiers, uint prev_keyval, uint prev_modifiers);
		public void foreach_hotkey (GLib.TraverseFunc func);
		public GLib.Quark lookup_hotkey (uint keyval, uint modifiers);
		public bool remove_hotkey (uint keyval, uint modifiers);
		public bool remove_hotkey_by_event (GLib.Quark event);
		public virtual signal void trigger (uint event, void* user_data);
	}
	[CCode (cheader_filename = "ibus.h")]
	public class InputContext : IBus.Proxy, GLib.DBusInterface, GLib.Initable, GLib.AsyncInitable {
		[CCode (has_construct_function = false)]
		public InputContext (string path, GLib.DBusConnection connection, GLib.Cancellable cancellable) throws GLib.Error;
		[CCode (has_construct_function = false, type = "void")]
		public async InputContext.@async (string path, GLib.DBusConnection connection, GLib.Cancellable cancellable) throws GLib.Error;
		public void cancel_hand_writing (uint n_strokes);
		public void disable ();
		public void enable ();
		public void focus_in ();
		public void focus_out ();
		public unowned IBus.EngineDesc get_engine ();
		public async void get_engine_async (int timeout_msec, GLib.Cancellable cancellable);
		public unowned IBus.EngineDesc get_engine_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public static unowned IBus.InputContext get_input_context (string path, GLib.DBusConnection connection);
		public static async void get_input_context_async (string path, GLib.DBusConnection connection, GLib.Cancellable cancellable);
		public static unowned IBus.InputContext get_input_context_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public bool is_enabled ();
		public async void is_enabled_async (int timeout_msec, GLib.Cancellable cancellable);
		public bool is_enabled_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public bool needs_surrounding_text ();
		public void process_hand_writing_event (double coordinates, uint coordinates_len);
		public bool process_key_event (uint32 keyval, uint32 keycode, uint32 state);
		public async void process_key_event_async (uint32 keyval, uint32 keycode, uint32 state, int timeout_msec, GLib.Cancellable cancellable);
		public bool process_key_event_async_finish (GLib.AsyncResult res) throws GLib.Error;
		public void property_activate (string prop_name, uint32 state);
		public void reset ();
		public void set_capabilities (uint32 capabilities);
		public void set_cursor_location (int32 x, int32 y, int32 w, int32 h);
		public void set_engine (string name);
		public void set_surrounding_text (IBus.Text text, uint32 cursor_pos, uint32 anchor_pos);
		public void set_xkb_engines (GLib.List list);
		public virtual signal void commit_text (IBus.Text p0);
		public virtual signal void cursor_down_lookup_table ();
		public virtual signal void cursor_up_lookup_table ();
		public virtual signal void delete_surrounding_text (int p0, uint p1);
		public virtual signal void disabled ();
		public virtual signal void enabled ();
		public virtual signal void forward_key_event (uint p0, uint p1, uint p2);
		public virtual signal void hide_auxiliary_text ();
		public virtual signal void hide_lookup_table ();
		public virtual signal void hide_preedit_text ();
		public virtual signal void page_down_lookup_table ();
		public virtual signal void page_up_lookup_table ();
		public virtual signal void register_properties (IBus.PropList p0);
		public virtual signal void show_auxiliary_text ();
		public virtual signal void show_lookup_table ();
		public virtual signal void show_preedit_text ();
		public virtual signal void update_auxiliary_text (IBus.Text p0, bool p1);
		public virtual signal void update_lookup_table (IBus.LookupTable p0, bool p1);
		public virtual signal void update_preedit_text (IBus.Text p0, uint p1, bool p2);
		public virtual signal void update_property (IBus.Property p0);
	}
	[CCode (cheader_filename = "ibus.h")]
	public class Keymap : IBus.Object {
		[CCode (array_length = false)]
		public weak uint[] keymap;
		public weak string name;
		[CCode (has_construct_function = false)]
		public Keymap (string name);
		public static unowned IBus.Keymap @get (string name);
		public uint lookup_keysym (uint16 keycode, uint32 state);
	}
	[CCode (cheader_filename = "ibus.h")]
	public class LookupTable : IBus.Serializable {
		public weak GLib.Array candidates;
		public uint cursor_pos;
		public bool cursor_visible;
		public weak GLib.Array labels;
		public int orientation;
		public uint page_size;
		public bool round;
		[CCode (has_construct_function = false)]
		public LookupTable (uint page_size, uint cursor_pos, bool cursor_visible, bool round);
		public void append_candidate (IBus.Text text);
		public void append_label (IBus.Text text);
		public void clear ();
		public bool cursor_down ();
		public bool cursor_up ();
		public unowned IBus.Text get_candidate (uint index);
		public uint get_cursor_in_page ();
		public uint get_cursor_pos ();
		public unowned IBus.Text get_label (uint index);
		public uint get_number_of_candidates ();
		public int get_orientation ();
		public uint get_page_size ();
		public bool is_cursor_visible ();
		public bool is_round ();
		public bool page_down ();
		public bool page_up ();
		public void set_cursor_pos (uint cursor_pos);
		public void set_cursor_visible (bool visible);
		public void set_label (uint index, IBus.Text text);
		public void set_orientation (int orientation);
		public void set_page_size (uint page_size);
		public void set_round (bool round);
	}
	[CCode (cheader_filename = "ibus.h")]
	public class Object : GLib.InitiallyUnowned {
		public uint32 flags;
		[CCode (has_construct_function = false)]
		public Object ();
		[HasEmitter]
		public virtual signal void destroy ();
	}
	[CCode (cheader_filename = "ibus.h")]
	public class ObservedPath : IBus.Serializable {
		public bool is_dir;
		public bool is_exist;
		public long mtime;
		public weak string path;
		[CCode (has_construct_function = false)]
		public ObservedPath (string path, bool fill_stat);
		public bool check_modification ();
		[CCode (has_construct_function = false)]
		public ObservedPath.from_xml_node (IBus.XMLNode node, bool fill_stat);
		public void output (GLib.StringBuilder output, int indent);
		public unowned GLib.List traverse ();
	}
	[CCode (cheader_filename = "ibus.h")]
	public class PanelService : IBus.Service {
		[CCode (has_construct_function = false)]
		public PanelService (GLib.DBusConnection connection);
		public void candidate_clicked (uint index, uint button, uint state);
		public void cursor_down ();
		public void cursor_up ();
		public void page_down ();
		public void page_up ();
		public void property_activate (string prop_name, uint prop_state);
		public void property_hide (string prop_name);
		public void property_show (string prop_name);
		public virtual signal void cursor_down_lookup_table ();
		public virtual signal void cursor_up_lookup_table ();
		public virtual signal void focus_in (string input_context_path);
		public virtual signal void focus_out (string input_context_path);
		public virtual signal void hide_auxiliary_text ();
		public virtual signal void hide_language_bar ();
		public virtual signal void hide_lookup_table ();
		public virtual signal void hide_preedit_text ();
		public virtual signal void page_down_lookup_table ();
		public virtual signal void page_up_lookup_table ();
		public virtual signal void register_properties (IBus.PropList prop_list);
		public virtual signal void reset ();
		public virtual signal void set_cursor_location (int x, int y, int w, int h);
		public virtual signal void show_auxiliary_text ();
		public virtual signal void show_language_bar ();
		public virtual signal void show_lookup_table ();
		public virtual signal void show_preedit_text ();
		public virtual signal void start_setup ();
		public virtual signal void state_changed ();
		public virtual signal void update_auxiliary_text (IBus.Text text, bool visible);
		public virtual signal void update_lookup_table (IBus.LookupTable lookup_table, bool visible);
		public virtual signal void update_preedit_text (IBus.Text text, uint cursor_pos, bool visible);
		public virtual signal void update_property (IBus.Property prop);
	}
	[CCode (cheader_filename = "ibus.h")]
	public class PropList : IBus.Serializable {
		public weak GLib.Array properties;
		[CCode (has_construct_function = false)]
		public PropList ();
		public void append (IBus.Property prop);
		public unowned IBus.Property @get (uint index);
		public bool update_property (IBus.Property prop);
	}
	[CCode (cheader_filename = "ibus.h")]
	public class Property : IBus.Serializable {
		public weak string icon;
		public weak string key;
		public weak IBus.Text label;
		public bool sensitive;
		public uint state;
		public weak IBus.PropList sub_props;
		public weak IBus.Text tooltip;
		public uint type;
		public bool visible;
		[CCode (has_construct_function = false)]
		public Property (string key, IBus.PropType type, IBus.Text? label, string? icon, IBus.Text? tooltip, bool sensitive, bool visible, IBus.PropState state, IBus.PropList? prop_list);
		public unowned string get_icon ();
		public unowned string get_key ();
		public unowned IBus.Text get_label ();
		public IBus.PropType get_prop_type ();
		public bool get_sensitive ();
		public IBus.PropState get_state ();
		public unowned IBus.PropList get_sub_props ();
		public unowned IBus.Text get_tooltip ();
		public bool get_visible ();
		public void set_icon (string icon);
		public void set_label (IBus.Text label);
		public void set_symbol (IBus.Text symbol);
		public void set_sensitive (bool sensitive);
		public void set_state (IBus.PropState state);
		public void set_sub_props (IBus.PropList prop_list);
		public void set_tooltip (IBus.Text tooltip);
		public void set_visible (bool visible);
		public bool update (IBus.Property prop_update);
	}
	[CCode (cheader_filename = "ibus.h")]
	public class Proxy : GLib.DBusProxy, GLib.DBusInterface, GLib.Initable, GLib.AsyncInitable {
		public uint32 flags;
		public bool own;
		[CCode (has_construct_function = false)]
		protected Proxy ();
		[HasEmitter]
		public virtual signal void destroy ();
	}
	[CCode (cheader_filename = "ibus.h")]
	[Compact]
	public class Rectangle {
		public int height;
		public int width;
		public int x;
		public int y;
	}
	[CCode (cheader_filename = "ibus.h")]
	public class Serializable : IBus.Object {
		[CCode (has_construct_function = false)]
		public Serializable ();
		public virtual bool copy ();
		public virtual int deserialize (GLib.Variant variant);
		public unowned GLib.Variant get_qattachment (GLib.Quark key);
		public void remove_qattachment (GLib.Quark key);
		public virtual bool serialize ();
		public void set_qattachment (GLib.Quark key, GLib.Variant value);
	}
	[CCode (cheader_filename = "ibus.h")]
	public class Service : IBus.Object {
		[CCode (has_construct_function = false)]
		public Service (GLib.DBusConnection connection, string path);
		[CCode (cname = "ibus_service_class_add_interfaces")]
		public class bool add_interfaces (string xml_data);
		public bool emit_signal (string dest_bus_name, string interface_name, string signal_name, GLib.Variant parameters) throws GLib.Error;
		public unowned GLib.DBusConnection get_connection ();
		public unowned string get_object_path ();
		public bool register (GLib.DBusConnection connection) throws GLib.Error;
		[NoWrapper]
		public virtual unowned GLib.Variant service_get_property (GLib.DBusConnection connection, string sender, string object_path, string interface_name, string property_name) throws GLib.Error;
		[NoWrapper]
		public virtual void service_method_call (GLib.DBusConnection connection, string sender, string object_path, string interface_name, string method_name, GLib.Variant parameters, GLib.DBusMethodInvocation invocation);
		[NoWrapper]
		public virtual bool service_set_property (GLib.DBusConnection connection, string sender, string object_path, string interface_name, string property_name, GLib.Variant value) throws GLib.Error;
		public void unregister (GLib.DBusConnection connection);
		public GLib.DBusConnection connection { get; construct; }
		public string object_path { get; construct; }
	}
	[CCode (cheader_filename = "ibus.h")]
	public class Text : IBus.Serializable {
		public weak IBus.AttrList attrs;
		public bool is_static;
		public weak string text;
		[CCode (has_construct_function = false)]
		protected Text ();
		public void append_attribute (uint type, uint value, uint start_index, int end_index);
		[CCode (has_construct_function = false)]
		public Text.from_printf (string fmt);
		[CCode (has_construct_function = false)]
		public Text.from_static_string (string str);
		[CCode (has_construct_function = false)]
		public Text.from_string (string str);
		[CCode (has_construct_function = false)]
		public Text.from_ucs4 (unichar str);
		[CCode (has_construct_function = false)]
		public Text.from_unichar (unichar c);
		public unowned IBus.AttrList get_attributes ();
		public bool get_is_static ();
		public uint get_length ();
		public unowned string get_text ();
	}
	[CCode (cheader_filename = "ibus.h")]
	public class XKBConfigRegistry : IBus.Object {
		[CCode (has_construct_function = false)]
		public XKBConfigRegistry ();
		public unowned GLib.HashTable get_layout_desc ();
		public unowned GLib.HashTable get_layout_lang ();
		public unowned GLib.HashTable get_layout_list ();
		public unowned GLib.HashTable get_variant_desc ();
		public unowned string layout_desc_get_desc (string layout);
		public unowned GLib.List layout_lang_get_langs (string layout);
		public unowned GLib.List layout_list_get_variants (string layout);
		public unowned string variant_desc_get_desc (string variant);
	}
	[CCode (cheader_filename = "ibus.h")]
	[Compact]
	public class XMLNode {
		public weak string attributes;
		public weak string name;
		public weak GLib.List sub_nodes;
		public weak string text;
	}
	[CCode (cheader_filename = "ibus.h", cprefix = "IBUS_ATTR_TYPE_", has_type_id = false)]
	public enum AttrType {
		UNDERLINE,
		FOREGROUND,
		BACKGROUND
	}
	[CCode (cheader_filename = "ibus.h", cprefix = "IBUS_ATTR_UNDERLINE_", has_type_id = false)]
	public enum AttrUnderline {
		NONE,
		SINGLE,
		DOUBLE,
		LOW,
		ERROR
	}
	[CCode (cheader_filename = "ibus.h", cprefix = "IBUS_BUS_NAME_FLAG_", has_type_id = false)]
	public enum BusNameFlag {
		ALLOW_REPLACEMENT,
		REPLACE_EXISTING,
		DO_NOT_QUEUE
	}
	[CCode (cheader_filename = "ibus.h", cprefix = "IBUS_BUS_REQUEST_NAME_REPLY_", has_type_id = false)]
	public enum BusRequestNameReply {
		PRIMARY_OWNER,
		IN_QUEUE,
		EXISTS,
		ALREADY_OWNER
	}
	[CCode (cheader_filename = "ibus.h", cprefix = "IBUS_BUS_START_REPLY_", has_type_id = false)]
	public enum BusStartServiceByNameReply {
		SUCCESS,
		ALREADY_RUNNING
	}
	[CCode (cheader_filename = "ibus.h", cprefix = "IBUS_CAP_", has_type_id = false)]
	public enum Capabilite {
		PREEDIT_TEXT,
		AUXILIARY_TEXT,
		LOOKUP_TABLE,
		FOCUS,
		PROPERTY,
		SURROUNDING_TEXT
	}
	[CCode (cheader_filename = "ibus.h", cprefix = "IBUS_ERROR_NO_", has_type_id = false)]
	public enum Error {
		ENGINE
	}
	[CCode (cheader_filename = "ibus.h", cprefix = "IBUS_", has_type_id = false)]
	public enum ModifierType {
		SHIFT_MASK,
		LOCK_MASK,
		CONTROL_MASK,
		MOD1_MASK,
		MOD2_MASK,
		MOD3_MASK,
		MOD4_MASK,
		MOD5_MASK,
		BUTTON1_MASK,
		BUTTON2_MASK,
		BUTTON3_MASK,
		BUTTON4_MASK,
		BUTTON5_MASK,
		HANDLED_MASK,
		FORWARD_MASK,
		IGNORED_MASK,
		SUPER_MASK,
		HYPER_MASK,
		META_MASK,
		RELEASE_MASK,
		MODIFIER_MASK
	}
	[CCode (cheader_filename = "ibus.h", cprefix = "IBUS_", has_type_id = false)]
	public enum ObjectFlags {
		IN_DESTRUCTION,
		DESTROYED,
		RESERVED_1,
		RESERVED_2
	}
	[CCode (cheader_filename = "ibus.h", cprefix = "IBUS_ORIENTATION_", has_type_id = false)]
	public enum Orientation {
		HORIZONTAL,
		VERTICAL,
		SYSTEM
	}
	[CCode (cheader_filename = "ibus.h", cprefix = "IBUS_ENGINE_PREEDIT_", has_type_id = false)]
	public enum PreeditFocusMode {
		CLEAR,
		COMMIT
	}
	[CCode (cheader_filename = "ibus.h", cprefix = "IBUS_PRELOAD_ENGINE_MODE_", has_type_id = false)]
	public enum PreloadEngineMode {
		USER,
		LANG_RELATIVE
	}
	[CCode (cheader_filename = "ibus.h", cprefix = "PROP_STATE_", has_type_id = false)]
	public enum PropState {
		UNCHECKED,
		CHECKED,
		INCONSISTENT
	}
	[CCode (cheader_filename = "ibus.h", cprefix = "PROP_TYPE_", has_type_id = false)]
	public enum PropType {
		NORMAL,
		TOGGLE,
		RADIO,
		MENU,
		SEPARATOR
	}
	[CCode (cheader_filename = "ibus.h", has_target = false)]
	public delegate void FreeFunc (void* object);
	[CCode (cheader_filename = "ibus.h", has_target = false)]
	public delegate void ObjectDestroyFunc (IBus.Object p1);
	[CCode (cheader_filename = "ibus.h", has_target = false)]
	public delegate bool SerializableCopyFunc (IBus.Serializable dest, IBus.Serializable src);
	[CCode (cheader_filename = "ibus.h", has_target = false)]
	public delegate int SerializableDeserializeFunc (IBus.Serializable serializable, GLib.Variant variant);
	[CCode (cheader_filename = "ibus.h", has_target = false)]
	public delegate bool SerializableSerializeFunc (IBus.Serializable serializable, GLib.VariantBuilder builder);
	[CCode (cheader_filename = "ibus.h")]
	public const int @0;
	[CCode (cheader_filename = "ibus.h")]
	public const int @1;
	[CCode (cheader_filename = "ibus.h")]
	public const int @2;
	[CCode (cheader_filename = "ibus.h")]
	public const int @3;
	[CCode (cheader_filename = "ibus.h")]
	public const int @3270_AltCursor;
	[CCode (cheader_filename = "ibus.h")]
	public const int @3270_Attn;
	[CCode (cheader_filename = "ibus.h")]
	public const int @3270_BackTab;
	[CCode (cheader_filename = "ibus.h")]
	public const int @3270_ChangeScreen;
	[CCode (cheader_filename = "ibus.h")]
	public const int @3270_Copy;
	[CCode (cheader_filename = "ibus.h")]
	public const int @3270_CursorBlink;
	[CCode (cheader_filename = "ibus.h")]
	public const int @3270_CursorSelect;
	[CCode (cheader_filename = "ibus.h")]
	public const int @3270_DeleteWord;
	[CCode (cheader_filename = "ibus.h")]
	public const int @3270_Duplicate;
	[CCode (cheader_filename = "ibus.h")]
	public const int @3270_Enter;
	[CCode (cheader_filename = "ibus.h")]
	public const int @3270_EraseEOF;
	[CCode (cheader_filename = "ibus.h")]
	public const int @3270_EraseInput;
	[CCode (cheader_filename = "ibus.h")]
	public const int @3270_ExSelect;
	[CCode (cheader_filename = "ibus.h")]
	public const int @3270_FieldMark;
	[CCode (cheader_filename = "ibus.h")]
	public const int @3270_Ident;
	[CCode (cheader_filename = "ibus.h")]
	public const int @3270_Jump;
	[CCode (cheader_filename = "ibus.h")]
	public const int @3270_KeyClick;
	[CCode (cheader_filename = "ibus.h")]
	public const int @3270_Left2;
	[CCode (cheader_filename = "ibus.h")]
	public const int @3270_PA1;
	[CCode (cheader_filename = "ibus.h")]
	public const int @3270_PA2;
	[CCode (cheader_filename = "ibus.h")]
	public const int @3270_PA3;
	[CCode (cheader_filename = "ibus.h")]
	public const int @3270_Play;
	[CCode (cheader_filename = "ibus.h")]
	public const int @3270_PrintScreen;
	[CCode (cheader_filename = "ibus.h")]
	public const int @3270_Quit;
	[CCode (cheader_filename = "ibus.h")]
	public const int @3270_Record;
	[CCode (cheader_filename = "ibus.h")]
	public const int @3270_Reset;
	[CCode (cheader_filename = "ibus.h")]
	public const int @3270_Right2;
	[CCode (cheader_filename = "ibus.h")]
	public const int @3270_Rule;
	[CCode (cheader_filename = "ibus.h")]
	public const int @3270_Setup;
	[CCode (cheader_filename = "ibus.h")]
	public const int @3270_Test;
	[CCode (cheader_filename = "ibus.h")]
	public const int @4;
	[CCode (cheader_filename = "ibus.h")]
	public const int @5;
	[CCode (cheader_filename = "ibus.h")]
	public const int @6;
	[CCode (cheader_filename = "ibus.h")]
	public const int @7;
	[CCode (cheader_filename = "ibus.h")]
	public const int @8;
	[CCode (cheader_filename = "ibus.h")]
	public const int @9;
	[CCode (cheader_filename = "ibus.h")]
	public const int A;
	[CCode (cheader_filename = "ibus.h")]
	public const int AE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Aacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int Abelowdot;
	[CCode (cheader_filename = "ibus.h")]
	public const int Abreve;
	[CCode (cheader_filename = "ibus.h")]
	public const int Abreveacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int Abrevebelowdot;
	[CCode (cheader_filename = "ibus.h")]
	public const int Abrevegrave;
	[CCode (cheader_filename = "ibus.h")]
	public const int Abrevehook;
	[CCode (cheader_filename = "ibus.h")]
	public const int Abrevetilde;
	[CCode (cheader_filename = "ibus.h")]
	public const int AccessX_Enable;
	[CCode (cheader_filename = "ibus.h")]
	public const int AccessX_Feedback_Enable;
	[CCode (cheader_filename = "ibus.h")]
	public const int Acircumflex;
	[CCode (cheader_filename = "ibus.h")]
	public const int Acircumflexacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int Acircumflexbelowdot;
	[CCode (cheader_filename = "ibus.h")]
	public const int Acircumflexgrave;
	[CCode (cheader_filename = "ibus.h")]
	public const int Acircumflexhook;
	[CCode (cheader_filename = "ibus.h")]
	public const int Acircumflextilde;
	[CCode (cheader_filename = "ibus.h")]
	public const int Adiaeresis;
	[CCode (cheader_filename = "ibus.h")]
	public const int Agrave;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ahook;
	[CCode (cheader_filename = "ibus.h")]
	public const int Alt_L;
	[CCode (cheader_filename = "ibus.h")]
	public const int Alt_R;
	[CCode (cheader_filename = "ibus.h")]
	public const int Amacron;
	[CCode (cheader_filename = "ibus.h")]
	public const int Aogonek;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_0;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_1;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_2;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_3;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_4;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_5;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_6;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_7;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_8;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_9;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_ain;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_alef;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_alefmaksura;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_beh;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_comma;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_dad;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_dal;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_damma;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_dammatan;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_ddal;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_farsi_yeh;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_fatha;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_fathatan;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_feh;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_fullstop;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_gaf;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_ghain;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_ha;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_hah;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_hamza;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_hamza_above;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_hamza_below;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_hamzaonalef;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_hamzaonwaw;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_hamzaonyeh;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_hamzaunderalef;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_heh;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_heh_doachashmee;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_heh_goal;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_jeem;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_jeh;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_kaf;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_kasra;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_kasratan;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_keheh;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_khah;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_lam;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_madda_above;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_maddaonalef;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_meem;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_noon;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_noon_ghunna;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_peh;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_percent;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_qaf;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_question_mark;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_ra;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_rreh;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_sad;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_seen;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_semicolon;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_shadda;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_sheen;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_sukun;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_superscript_alef;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_switch;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_tah;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_tatweel;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_tcheh;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_teh;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_tehmarbuta;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_thal;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_theh;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_tteh;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_veh;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_waw;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_yeh;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_yeh_baree;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_zah;
	[CCode (cheader_filename = "ibus.h")]
	public const int Arabic_zain;
	[CCode (cheader_filename = "ibus.h")]
	public const int Aring;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_AT;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_AYB;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_BEN;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_CHA;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_DA;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_DZA;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_E;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_FE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_GHAT;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_GIM;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_HI;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_HO;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_INI;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_JE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_KE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_KEN;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_KHE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_LYUN;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_MEN;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_NU;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_O;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_PE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_PYUR;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_RA;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_RE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_SE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_SHA;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_TCHE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_TO;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_TSA;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_TSO;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_TYUN;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_VEV;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_VO;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_VYUN;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_YECH;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_ZA;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_ZHE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_accent;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_amanak;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_apostrophe;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_at;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_ayb;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_ben;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_but;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_cha;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_da;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_dza;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_e;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_exclam;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_fe;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_full_stop;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_ghat;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_gim;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_hi;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_ho;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_hyphen;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_ini;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_je;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_ke;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_ken;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_khe;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_ligature_ew;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_lyun;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_men;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_nu;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_o;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_paruyk;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_pe;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_pyur;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_question;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_ra;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_re;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_se;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_separation_mark;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_sha;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_shesht;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_tche;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_to;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_tsa;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_tso;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_tyun;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_verjaket;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_vev;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_vo;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_vyun;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_yech;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_yentamna;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_za;
	[CCode (cheader_filename = "ibus.h")]
	public const int Armenian_zhe;
	[CCode (cheader_filename = "ibus.h")]
	public const int Atilde;
	[CCode (cheader_filename = "ibus.h")]
	public const int AudibleBell_Enable;
	[CCode (cheader_filename = "ibus.h")]
	public const int B;
	[CCode (cheader_filename = "ibus.h")]
	public const int Babovedot;
	[CCode (cheader_filename = "ibus.h")]
	public const int BackSpace;
	[CCode (cheader_filename = "ibus.h")]
	public const int Begin;
	[CCode (cheader_filename = "ibus.h")]
	public const int BounceKeys_Enable;
	[CCode (cheader_filename = "ibus.h")]
	public const int Break;
	[CCode (cheader_filename = "ibus.h")]
	public const int Byelorussian_SHORTU;
	[CCode (cheader_filename = "ibus.h")]
	public const int Byelorussian_shortu;
	[CCode (cheader_filename = "ibus.h")]
	public const int C;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cabovedot;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cancel;
	[CCode (cheader_filename = "ibus.h")]
	public const int Caps_Lock;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ccaron;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ccedilla;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ccircumflex;
	[CCode (cheader_filename = "ibus.h")]
	public const int Clear;
	[CCode (cheader_filename = "ibus.h")]
	public const int Codeinput;
	[CCode (cheader_filename = "ibus.h")]
	public const int ColonSign;
	[CCode (cheader_filename = "ibus.h")]
	public const int Control_L;
	[CCode (cheader_filename = "ibus.h")]
	public const int Control_R;
	[CCode (cheader_filename = "ibus.h")]
	public const int CruzeiroSign;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_A;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_BE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_CHE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_CHE_descender;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_CHE_vertstroke;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_DE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_DZHE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_E;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_EF;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_EL;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_EM;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_EN;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_EN_descender;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_ER;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_ES;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_GHE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_GHE_bar;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_HA;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_HARDSIGN;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_HA_descender;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_I;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_IE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_IO;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_I_macron;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_JE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_KA;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_KA_descender;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_KA_vertstroke;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_LJE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_NJE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_O;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_O_bar;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_PE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_SCHWA;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_SHA;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_SHCHA;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_SHHA;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_SHORTI;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_SOFTSIGN;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_TE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_TSE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_U;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_U_macron;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_U_straight;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_U_straight_bar;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_VE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_YA;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_YERU;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_YU;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_ZE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_ZHE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_ZHE_descender;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_a;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_be;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_che;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_che_descender;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_che_vertstroke;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_de;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_dzhe;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_e;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_ef;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_el;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_em;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_en;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_en_descender;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_er;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_es;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_ghe;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_ghe_bar;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_ha;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_ha_descender;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_hardsign;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_i;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_i_macron;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_ie;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_io;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_je;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_ka;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_ka_descender;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_ka_vertstroke;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_lje;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_nje;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_o;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_o_bar;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_pe;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_schwa;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_sha;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_shcha;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_shha;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_shorti;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_softsign;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_te;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_tse;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_u;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_u_macron;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_u_straight;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_u_straight_bar;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_ve;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_ya;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_yeru;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_yu;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_ze;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_zhe;
	[CCode (cheader_filename = "ibus.h")]
	public const int Cyrillic_zhe_descender;
	[CCode (cheader_filename = "ibus.h")]
	public const int D;
	[CCode (cheader_filename = "ibus.h")]
	public const int Dabovedot;
	[CCode (cheader_filename = "ibus.h")]
	public const int Dcaron;
	[CCode (cheader_filename = "ibus.h")]
	public const int Delete;
	[CCode (cheader_filename = "ibus.h")]
	public const int DongSign;
	[CCode (cheader_filename = "ibus.h")]
	public const int Down;
	[CCode (cheader_filename = "ibus.h")]
	public const int Dstroke;
	[CCode (cheader_filename = "ibus.h")]
	public const int E;
	[CCode (cheader_filename = "ibus.h")]
	public const int ENG;
	[CCode (cheader_filename = "ibus.h")]
	public const int ETH;
	[CCode (cheader_filename = "ibus.h")]
	public const int Eabovedot;
	[CCode (cheader_filename = "ibus.h")]
	public const int Eacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ebelowdot;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ecaron;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ecircumflex;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ecircumflexacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ecircumflexbelowdot;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ecircumflexgrave;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ecircumflexhook;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ecircumflextilde;
	[CCode (cheader_filename = "ibus.h")]
	public const int EcuSign;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ediaeresis;
	[CCode (cheader_filename = "ibus.h")]
	public const int Egrave;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ehook;
	[CCode (cheader_filename = "ibus.h")]
	public const int Eisu_Shift;
	[CCode (cheader_filename = "ibus.h")]
	public const int Eisu_toggle;
	[CCode (cheader_filename = "ibus.h")]
	public const int Emacron;
	[CCode (cheader_filename = "ibus.h")]
	public const int End;
	[CCode (cheader_filename = "ibus.h")]
	public const int Eogonek;
	[CCode (cheader_filename = "ibus.h")]
	public const int Escape;
	[CCode (cheader_filename = "ibus.h")]
	public const int Eth;
	[CCode (cheader_filename = "ibus.h")]
	public const int Etilde;
	[CCode (cheader_filename = "ibus.h")]
	public const int EuroSign;
	[CCode (cheader_filename = "ibus.h")]
	public const int Execute;
	[CCode (cheader_filename = "ibus.h")]
	public const int F;
	[CCode (cheader_filename = "ibus.h")]
	public const int F1;
	[CCode (cheader_filename = "ibus.h")]
	public const int F10;
	[CCode (cheader_filename = "ibus.h")]
	public const int F11;
	[CCode (cheader_filename = "ibus.h")]
	public const int F12;
	[CCode (cheader_filename = "ibus.h")]
	public const int F13;
	[CCode (cheader_filename = "ibus.h")]
	public const int F14;
	[CCode (cheader_filename = "ibus.h")]
	public const int F15;
	[CCode (cheader_filename = "ibus.h")]
	public const int F16;
	[CCode (cheader_filename = "ibus.h")]
	public const int F17;
	[CCode (cheader_filename = "ibus.h")]
	public const int F18;
	[CCode (cheader_filename = "ibus.h")]
	public const int F19;
	[CCode (cheader_filename = "ibus.h")]
	public const int F2;
	[CCode (cheader_filename = "ibus.h")]
	public const int F20;
	[CCode (cheader_filename = "ibus.h")]
	public const int F21;
	[CCode (cheader_filename = "ibus.h")]
	public const int F22;
	[CCode (cheader_filename = "ibus.h")]
	public const int F23;
	[CCode (cheader_filename = "ibus.h")]
	public const int F24;
	[CCode (cheader_filename = "ibus.h")]
	public const int F25;
	[CCode (cheader_filename = "ibus.h")]
	public const int F26;
	[CCode (cheader_filename = "ibus.h")]
	public const int F27;
	[CCode (cheader_filename = "ibus.h")]
	public const int F28;
	[CCode (cheader_filename = "ibus.h")]
	public const int F29;
	[CCode (cheader_filename = "ibus.h")]
	public const int F3;
	[CCode (cheader_filename = "ibus.h")]
	public const int F30;
	[CCode (cheader_filename = "ibus.h")]
	public const int F31;
	[CCode (cheader_filename = "ibus.h")]
	public const int F32;
	[CCode (cheader_filename = "ibus.h")]
	public const int F33;
	[CCode (cheader_filename = "ibus.h")]
	public const int F34;
	[CCode (cheader_filename = "ibus.h")]
	public const int F35;
	[CCode (cheader_filename = "ibus.h")]
	public const int F4;
	[CCode (cheader_filename = "ibus.h")]
	public const int F5;
	[CCode (cheader_filename = "ibus.h")]
	public const int F6;
	[CCode (cheader_filename = "ibus.h")]
	public const int F7;
	[CCode (cheader_filename = "ibus.h")]
	public const int F8;
	[CCode (cheader_filename = "ibus.h")]
	public const int F9;
	[CCode (cheader_filename = "ibus.h")]
	public const int FFrancSign;
	[CCode (cheader_filename = "ibus.h")]
	public const int Fabovedot;
	[CCode (cheader_filename = "ibus.h")]
	public const int Farsi_0;
	[CCode (cheader_filename = "ibus.h")]
	public const int Farsi_1;
	[CCode (cheader_filename = "ibus.h")]
	public const int Farsi_2;
	[CCode (cheader_filename = "ibus.h")]
	public const int Farsi_3;
	[CCode (cheader_filename = "ibus.h")]
	public const int Farsi_4;
	[CCode (cheader_filename = "ibus.h")]
	public const int Farsi_5;
	[CCode (cheader_filename = "ibus.h")]
	public const int Farsi_6;
	[CCode (cheader_filename = "ibus.h")]
	public const int Farsi_7;
	[CCode (cheader_filename = "ibus.h")]
	public const int Farsi_8;
	[CCode (cheader_filename = "ibus.h")]
	public const int Farsi_9;
	[CCode (cheader_filename = "ibus.h")]
	public const int Farsi_yeh;
	[CCode (cheader_filename = "ibus.h")]
	public const int Find;
	[CCode (cheader_filename = "ibus.h")]
	public const int First_Virtual_Screen;
	[CCode (cheader_filename = "ibus.h")]
	public const int G;
	[CCode (cheader_filename = "ibus.h")]
	public const int Gabovedot;
	[CCode (cheader_filename = "ibus.h")]
	public const int Gbreve;
	[CCode (cheader_filename = "ibus.h")]
	public const int Gcaron;
	[CCode (cheader_filename = "ibus.h")]
	public const int Gcedilla;
	[CCode (cheader_filename = "ibus.h")]
	public const int Gcircumflex;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_an;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_ban;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_can;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_char;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_chin;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_cil;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_don;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_en;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_fi;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_gan;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_ghan;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_hae;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_har;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_he;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_hie;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_hoe;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_in;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_jhan;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_jil;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_kan;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_khar;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_las;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_man;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_nar;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_on;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_par;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_phar;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_qar;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_rae;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_san;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_shin;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_tan;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_tar;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_un;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_vin;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_we;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_xan;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_zen;
	[CCode (cheader_filename = "ibus.h")]
	public const int Georgian_zhar;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_ALPHA;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_ALPHAaccent;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_BETA;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_CHI;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_DELTA;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_EPSILON;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_EPSILONaccent;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_ETA;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_ETAaccent;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_GAMMA;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_IOTA;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_IOTAaccent;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_IOTAdiaeresis;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_IOTAdieresis;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_KAPPA;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_LAMBDA;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_LAMDA;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_MU;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_NU;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_OMEGA;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_OMEGAaccent;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_OMICRON;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_OMICRONaccent;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_PHI;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_PI;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_PSI;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_RHO;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_SIGMA;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_TAU;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_THETA;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_UPSILON;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_UPSILONaccent;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_UPSILONdieresis;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_XI;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_ZETA;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_accentdieresis;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_alpha;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_alphaaccent;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_beta;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_chi;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_delta;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_epsilon;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_epsilonaccent;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_eta;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_etaaccent;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_finalsmallsigma;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_gamma;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_horizbar;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_iota;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_iotaaccent;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_iotaaccentdieresis;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_iotadieresis;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_kappa;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_lambda;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_lamda;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_mu;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_nu;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_omega;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_omegaaccent;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_omicron;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_omicronaccent;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_phi;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_pi;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_psi;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_rho;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_sigma;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_switch;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_tau;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_theta;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_upsilon;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_upsilonaccent;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_upsilonaccentdieresis;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_upsilondieresis;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_xi;
	[CCode (cheader_filename = "ibus.h")]
	public const int Greek_zeta;
	[CCode (cheader_filename = "ibus.h")]
	public const int H;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_A;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_AE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_AraeA;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_AraeAE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_Banja;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_Cieuc;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_Codeinput;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_Dikeud;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_E;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_EO;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_EU;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_End;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_Hanja;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_Hieuh;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_I;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_Ieung;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_J_Cieuc;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_J_Dikeud;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_J_Hieuh;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_J_Ieung;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_J_Jieuj;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_J_Khieuq;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_J_Kiyeog;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_J_KiyeogSios;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_J_KkogjiDalrinIeung;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_J_Mieum;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_J_Nieun;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_J_NieunHieuh;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_J_NieunJieuj;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_J_PanSios;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_J_Phieuf;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_J_Pieub;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_J_PieubSios;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_J_Rieul;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_J_RieulHieuh;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_J_RieulKiyeog;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_J_RieulMieum;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_J_RieulPhieuf;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_J_RieulPieub;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_J_RieulSios;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_J_RieulTieut;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_J_Sios;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_J_SsangKiyeog;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_J_SsangSios;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_J_Tieut;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_J_YeorinHieuh;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_Jamo;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_Jeonja;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_Jieuj;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_Khieuq;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_Kiyeog;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_KiyeogSios;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_KkogjiDalrinIeung;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_Mieum;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_MultipleCandidate;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_Nieun;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_NieunHieuh;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_NieunJieuj;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_O;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_OE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_PanSios;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_Phieuf;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_Pieub;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_PieubSios;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_PostHanja;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_PreHanja;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_PreviousCandidate;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_Rieul;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_RieulHieuh;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_RieulKiyeog;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_RieulMieum;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_RieulPhieuf;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_RieulPieub;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_RieulSios;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_RieulTieut;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_RieulYeorinHieuh;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_Romaja;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_SingleCandidate;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_Sios;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_Special;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_SsangDikeud;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_SsangJieuj;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_SsangKiyeog;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_SsangPieub;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_SsangSios;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_Start;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_SunkyeongeumMieum;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_SunkyeongeumPhieuf;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_SunkyeongeumPieub;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_Tieut;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_U;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_WA;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_WAE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_WE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_WEO;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_WI;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_YA;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_YAE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_YE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_YEO;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_YI;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_YO;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_YU;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_YeorinHieuh;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hangul_switch;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hankaku;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hcircumflex;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hebrew_switch;
	[CCode (cheader_filename = "ibus.h")]
	public const int Help;
	[CCode (cheader_filename = "ibus.h")]
	public const int Henkan;
	[CCode (cheader_filename = "ibus.h")]
	public const int Henkan_Mode;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hiragana;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hiragana_Katakana;
	[CCode (cheader_filename = "ibus.h")]
	public const int Home;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hstroke;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hyper_L;
	[CCode (cheader_filename = "ibus.h")]
	public const int Hyper_R;
	[CCode (cheader_filename = "ibus.h")]
	public const int I;
	[CCode (cheader_filename = "ibus.h")]
	public const string INTERFACE_CONFIG;
	[CCode (cheader_filename = "ibus.h")]
	public const string INTERFACE_ENGINE;
	[CCode (cheader_filename = "ibus.h")]
	public const string INTERFACE_FACTORY;
	[CCode (cheader_filename = "ibus.h")]
	public const string INTERFACE_IBUS;
	[CCode (cheader_filename = "ibus.h")]
	public const string INTERFACE_INPUT_CONTEXT;
	[CCode (cheader_filename = "ibus.h")]
	public const string INTERFACE_NOTIFICATIONS;
	[CCode (cheader_filename = "ibus.h")]
	public const string INTERFACE_PANEL;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Center_Object;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Continuous_Underline;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Discontinuous_Underline;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Emphasize;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Enter;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Fast_Cursor_Down;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Fast_Cursor_Left;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Fast_Cursor_Right;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Fast_Cursor_Up;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_First_Group;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_First_Group_Lock;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Group_Latch;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Group_Lock;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Group_Shift;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Last_Group;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Last_Group_Lock;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Left_Tab;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Level2_Latch;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Level3_Latch;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Level3_Lock;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Level3_Shift;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Level5_Latch;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Level5_Lock;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Level5_Shift;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Lock;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Move_Line_Down;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Move_Line_Up;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Next_Group;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Next_Group_Lock;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Partial_Line_Down;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Partial_Line_Up;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Partial_Space_Left;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Partial_Space_Right;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Prev_Group;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Prev_Group_Lock;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Release_Both_Margins;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Release_Margin_Left;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Release_Margin_Right;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Set_Margin_Left;
	[CCode (cheader_filename = "ibus.h")]
	public const int ISO_Set_Margin_Right;
	[CCode (cheader_filename = "ibus.h")]
	public const int Iabovedot;
	[CCode (cheader_filename = "ibus.h")]
	public const int Iacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ibelowdot;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ibreve;
	[CCode (cheader_filename = "ibus.h")]
	public const int Icircumflex;
	[CCode (cheader_filename = "ibus.h")]
	public const int Idiaeresis;
	[CCode (cheader_filename = "ibus.h")]
	public const int Igrave;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ihook;
	[CCode (cheader_filename = "ibus.h")]
	public const int Imacron;
	[CCode (cheader_filename = "ibus.h")]
	public const int Insert;
	[CCode (cheader_filename = "ibus.h")]
	public const int Iogonek;
	[CCode (cheader_filename = "ibus.h")]
	public const int Itilde;
	[CCode (cheader_filename = "ibus.h")]
	public const int J;
	[CCode (cheader_filename = "ibus.h")]
	public const int Jcircumflex;
	[CCode (cheader_filename = "ibus.h")]
	public const int K;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_0;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_1;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_2;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_3;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_4;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_5;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_6;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_7;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_8;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_9;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_Add;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_Begin;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_Decimal;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_Delete;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_Divide;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_Down;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_End;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_Enter;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_Equal;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_F1;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_F2;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_F3;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_F4;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_Home;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_Insert;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_Left;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_Multiply;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_Next;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_Page_Down;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_Page_Up;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_Prior;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_Right;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_Separator;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_Space;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_Subtract;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_Tab;
	[CCode (cheader_filename = "ibus.h")]
	public const int KP_Up;
	[CCode (cheader_filename = "ibus.h")]
	public const int Kana_Lock;
	[CCode (cheader_filename = "ibus.h")]
	public const int Kana_Shift;
	[CCode (cheader_filename = "ibus.h")]
	public const int Kanji;
	[CCode (cheader_filename = "ibus.h")]
	public const int Kanji_Bangou;
	[CCode (cheader_filename = "ibus.h")]
	public const int Katakana;
	[CCode (cheader_filename = "ibus.h")]
	public const int Kcedilla;
	[CCode (cheader_filename = "ibus.h")]
	public const int Korean_Won;
	[CCode (cheader_filename = "ibus.h")]
	public const int L;
	[CCode (cheader_filename = "ibus.h")]
	public const int L1;
	[CCode (cheader_filename = "ibus.h")]
	public const int L10;
	[CCode (cheader_filename = "ibus.h")]
	public const int L2;
	[CCode (cheader_filename = "ibus.h")]
	public const int L3;
	[CCode (cheader_filename = "ibus.h")]
	public const int L4;
	[CCode (cheader_filename = "ibus.h")]
	public const int L5;
	[CCode (cheader_filename = "ibus.h")]
	public const int L6;
	[CCode (cheader_filename = "ibus.h")]
	public const int L7;
	[CCode (cheader_filename = "ibus.h")]
	public const int L8;
	[CCode (cheader_filename = "ibus.h")]
	public const int L9;
	[CCode (cheader_filename = "ibus.h")]
	public const int Lacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int Last_Virtual_Screen;
	[CCode (cheader_filename = "ibus.h")]
	public const int Lbelowdot;
	[CCode (cheader_filename = "ibus.h")]
	public const int Lcaron;
	[CCode (cheader_filename = "ibus.h")]
	public const int Lcedilla;
	[CCode (cheader_filename = "ibus.h")]
	public const int Left;
	[CCode (cheader_filename = "ibus.h")]
	public const int Linefeed;
	[CCode (cheader_filename = "ibus.h")]
	public const int LiraSign;
	[CCode (cheader_filename = "ibus.h")]
	public const int Lstroke;
	[CCode (cheader_filename = "ibus.h")]
	public const int M;
	[CCode (cheader_filename = "ibus.h")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "ibus.h")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "ibus.h")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "ibus.h")]
	public const int Mabovedot;
	[CCode (cheader_filename = "ibus.h")]
	public const int Macedonia_DSE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Macedonia_GJE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Macedonia_KJE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Macedonia_dse;
	[CCode (cheader_filename = "ibus.h")]
	public const int Macedonia_gje;
	[CCode (cheader_filename = "ibus.h")]
	public const int Macedonia_kje;
	[CCode (cheader_filename = "ibus.h")]
	public const int Mae_Koho;
	[CCode (cheader_filename = "ibus.h")]
	public const int Massyo;
	[CCode (cheader_filename = "ibus.h")]
	public const int Menu;
	[CCode (cheader_filename = "ibus.h")]
	public const int Meta_L;
	[CCode (cheader_filename = "ibus.h")]
	public const int Meta_R;
	[CCode (cheader_filename = "ibus.h")]
	public const int MillSign;
	[CCode (cheader_filename = "ibus.h")]
	public const int Mode_switch;
	[CCode (cheader_filename = "ibus.h")]
	public const int MouseKeys_Accel_Enable;
	[CCode (cheader_filename = "ibus.h")]
	public const int MouseKeys_Enable;
	[CCode (cheader_filename = "ibus.h")]
	public const int Muhenkan;
	[CCode (cheader_filename = "ibus.h")]
	public const int Multi_key;
	[CCode (cheader_filename = "ibus.h")]
	public const int MultipleCandidate;
	[CCode (cheader_filename = "ibus.h")]
	public const int N;
	[CCode (cheader_filename = "ibus.h")]
	public const int Nacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int NairaSign;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ncaron;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ncedilla;
	[CCode (cheader_filename = "ibus.h")]
	public const int NewSheqelSign;
	[CCode (cheader_filename = "ibus.h")]
	public const int Next;
	[CCode (cheader_filename = "ibus.h")]
	public const int Next_Virtual_Screen;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ntilde;
	[CCode (cheader_filename = "ibus.h")]
	public const int Num_Lock;
	[CCode (cheader_filename = "ibus.h")]
	public const int O;
	[CCode (cheader_filename = "ibus.h")]
	public const int OE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Oacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int Obarred;
	[CCode (cheader_filename = "ibus.h")]
	public const int Obelowdot;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ocaron;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ocircumflex;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ocircumflexacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ocircumflexbelowdot;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ocircumflexgrave;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ocircumflexhook;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ocircumflextilde;
	[CCode (cheader_filename = "ibus.h")]
	public const int Odiaeresis;
	[CCode (cheader_filename = "ibus.h")]
	public const int Odoubleacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ograve;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ohook;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ohorn;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ohornacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ohornbelowdot;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ohorngrave;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ohornhook;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ohorntilde;
	[CCode (cheader_filename = "ibus.h")]
	public const int Omacron;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ooblique;
	[CCode (cheader_filename = "ibus.h")]
	public const int Oslash;
	[CCode (cheader_filename = "ibus.h")]
	public const int Otilde;
	[CCode (cheader_filename = "ibus.h")]
	public const int Overlay1_Enable;
	[CCode (cheader_filename = "ibus.h")]
	public const int Overlay2_Enable;
	[CCode (cheader_filename = "ibus.h")]
	public const int P;
	[CCode (cheader_filename = "ibus.h")]
	public const string PATH_CONFIG;
	[CCode (cheader_filename = "ibus.h")]
	public const string PATH_FACTORY;
	[CCode (cheader_filename = "ibus.h")]
	public const string PATH_IBUS;
	[CCode (cheader_filename = "ibus.h")]
	public const string PATH_INPUT_CONTEXT;
	[CCode (cheader_filename = "ibus.h")]
	public const string PATH_NOTIFICATIONS;
	[CCode (cheader_filename = "ibus.h")]
	public const string PATH_PANEL;
	[CCode (cheader_filename = "ibus.h")]
	public const int Pabovedot;
	[CCode (cheader_filename = "ibus.h")]
	public const int Page_Down;
	[CCode (cheader_filename = "ibus.h")]
	public const int Page_Up;
	[CCode (cheader_filename = "ibus.h")]
	public const int Pause;
	[CCode (cheader_filename = "ibus.h")]
	public const int PesetaSign;
	[CCode (cheader_filename = "ibus.h")]
	public const int Pointer_Accelerate;
	[CCode (cheader_filename = "ibus.h")]
	public const int Pointer_Button1;
	[CCode (cheader_filename = "ibus.h")]
	public const int Pointer_Button2;
	[CCode (cheader_filename = "ibus.h")]
	public const int Pointer_Button3;
	[CCode (cheader_filename = "ibus.h")]
	public const int Pointer_Button4;
	[CCode (cheader_filename = "ibus.h")]
	public const int Pointer_Button5;
	[CCode (cheader_filename = "ibus.h")]
	public const int Pointer_Button_Dflt;
	[CCode (cheader_filename = "ibus.h")]
	public const int Pointer_DblClick1;
	[CCode (cheader_filename = "ibus.h")]
	public const int Pointer_DblClick2;
	[CCode (cheader_filename = "ibus.h")]
	public const int Pointer_DblClick3;
	[CCode (cheader_filename = "ibus.h")]
	public const int Pointer_DblClick4;
	[CCode (cheader_filename = "ibus.h")]
	public const int Pointer_DblClick5;
	[CCode (cheader_filename = "ibus.h")]
	public const int Pointer_DblClick_Dflt;
	[CCode (cheader_filename = "ibus.h")]
	public const int Pointer_DfltBtnNext;
	[CCode (cheader_filename = "ibus.h")]
	public const int Pointer_DfltBtnPrev;
	[CCode (cheader_filename = "ibus.h")]
	public const int Pointer_Down;
	[CCode (cheader_filename = "ibus.h")]
	public const int Pointer_DownLeft;
	[CCode (cheader_filename = "ibus.h")]
	public const int Pointer_DownRight;
	[CCode (cheader_filename = "ibus.h")]
	public const int Pointer_Drag1;
	[CCode (cheader_filename = "ibus.h")]
	public const int Pointer_Drag2;
	[CCode (cheader_filename = "ibus.h")]
	public const int Pointer_Drag3;
	[CCode (cheader_filename = "ibus.h")]
	public const int Pointer_Drag4;
	[CCode (cheader_filename = "ibus.h")]
	public const int Pointer_Drag5;
	[CCode (cheader_filename = "ibus.h")]
	public const int Pointer_Drag_Dflt;
	[CCode (cheader_filename = "ibus.h")]
	public const int Pointer_EnableKeys;
	[CCode (cheader_filename = "ibus.h")]
	public const int Pointer_Left;
	[CCode (cheader_filename = "ibus.h")]
	public const int Pointer_Right;
	[CCode (cheader_filename = "ibus.h")]
	public const int Pointer_Up;
	[CCode (cheader_filename = "ibus.h")]
	public const int Pointer_UpLeft;
	[CCode (cheader_filename = "ibus.h")]
	public const int Pointer_UpRight;
	[CCode (cheader_filename = "ibus.h")]
	public const int Prev_Virtual_Screen;
	[CCode (cheader_filename = "ibus.h")]
	public const int PreviousCandidate;
	[CCode (cheader_filename = "ibus.h")]
	public const int Print;
	[CCode (cheader_filename = "ibus.h")]
	public const int Prior;
	[CCode (cheader_filename = "ibus.h")]
	public const int Q;
	[CCode (cheader_filename = "ibus.h")]
	public const int R;
	[CCode (cheader_filename = "ibus.h")]
	public const int R1;
	[CCode (cheader_filename = "ibus.h")]
	public const int R10;
	[CCode (cheader_filename = "ibus.h")]
	public const int R11;
	[CCode (cheader_filename = "ibus.h")]
	public const int R12;
	[CCode (cheader_filename = "ibus.h")]
	public const int R13;
	[CCode (cheader_filename = "ibus.h")]
	public const int R14;
	[CCode (cheader_filename = "ibus.h")]
	public const int R15;
	[CCode (cheader_filename = "ibus.h")]
	public const int R2;
	[CCode (cheader_filename = "ibus.h")]
	public const int R3;
	[CCode (cheader_filename = "ibus.h")]
	public const int R4;
	[CCode (cheader_filename = "ibus.h")]
	public const int R5;
	[CCode (cheader_filename = "ibus.h")]
	public const int R6;
	[CCode (cheader_filename = "ibus.h")]
	public const int R7;
	[CCode (cheader_filename = "ibus.h")]
	public const int R8;
	[CCode (cheader_filename = "ibus.h")]
	public const int R9;
	[CCode (cheader_filename = "ibus.h")]
	public const int Racute;
	[CCode (cheader_filename = "ibus.h")]
	public const int Rcaron;
	[CCode (cheader_filename = "ibus.h")]
	public const int Rcedilla;
	[CCode (cheader_filename = "ibus.h")]
	public const int Redo;
	[CCode (cheader_filename = "ibus.h")]
	public const int RepeatKeys_Enable;
	[CCode (cheader_filename = "ibus.h")]
	public const int Return;
	[CCode (cheader_filename = "ibus.h")]
	public const int Right;
	[CCode (cheader_filename = "ibus.h")]
	public const int Romaji;
	[CCode (cheader_filename = "ibus.h")]
	public const int RupeeSign;
	[CCode (cheader_filename = "ibus.h")]
	public const int S;
	[CCode (cheader_filename = "ibus.h")]
	public const int SCHWA;
	[CCode (cheader_filename = "ibus.h")]
	public const string SERVICE_CONFIG;
	[CCode (cheader_filename = "ibus.h")]
	public const string SERVICE_IBUS;
	[CCode (cheader_filename = "ibus.h")]
	public const string SERVICE_NOTIFICATIONS;
	[CCode (cheader_filename = "ibus.h")]
	public const string SERVICE_PANEL;
	[CCode (cheader_filename = "ibus.h")]
	public const int Sabovedot;
	[CCode (cheader_filename = "ibus.h")]
	public const int Sacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int Scaron;
	[CCode (cheader_filename = "ibus.h")]
	public const int Scedilla;
	[CCode (cheader_filename = "ibus.h")]
	public const int Scircumflex;
	[CCode (cheader_filename = "ibus.h")]
	public const int Scroll_Lock;
	[CCode (cheader_filename = "ibus.h")]
	public const int Select;
	[CCode (cheader_filename = "ibus.h")]
	public const int Serbian_DJE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Serbian_DZE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Serbian_JE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Serbian_LJE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Serbian_NJE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Serbian_TSHE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Serbian_dje;
	[CCode (cheader_filename = "ibus.h")]
	public const int Serbian_dze;
	[CCode (cheader_filename = "ibus.h")]
	public const int Serbian_je;
	[CCode (cheader_filename = "ibus.h")]
	public const int Serbian_lje;
	[CCode (cheader_filename = "ibus.h")]
	public const int Serbian_nje;
	[CCode (cheader_filename = "ibus.h")]
	public const int Serbian_tshe;
	[CCode (cheader_filename = "ibus.h")]
	public const int Shift_L;
	[CCode (cheader_filename = "ibus.h")]
	public const int Shift_Lock;
	[CCode (cheader_filename = "ibus.h")]
	public const int Shift_R;
	[CCode (cheader_filename = "ibus.h")]
	public const int SingleCandidate;
	[CCode (cheader_filename = "ibus.h")]
	public const int SlowKeys_Enable;
	[CCode (cheader_filename = "ibus.h")]
	public const int StickyKeys_Enable;
	[CCode (cheader_filename = "ibus.h")]
	public const int Super_L;
	[CCode (cheader_filename = "ibus.h")]
	public const int Super_R;
	[CCode (cheader_filename = "ibus.h")]
	public const int Sys_Req;
	[CCode (cheader_filename = "ibus.h")]
	public const int T;
	[CCode (cheader_filename = "ibus.h")]
	public const int THORN;
	[CCode (cheader_filename = "ibus.h")]
	public const int Tab;
	[CCode (cheader_filename = "ibus.h")]
	public const int Tabovedot;
	[CCode (cheader_filename = "ibus.h")]
	public const int Tcaron;
	[CCode (cheader_filename = "ibus.h")]
	public const int Tcedilla;
	[CCode (cheader_filename = "ibus.h")]
	public const int Terminate_Server;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_baht;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_bobaimai;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_chochan;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_chochang;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_choching;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_chochoe;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_dochada;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_dodek;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_fofa;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_fofan;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_hohip;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_honokhuk;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_khokhai;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_khokhon;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_khokhuat;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_khokhwai;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_khorakhang;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_kokai;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_lakkhangyao;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_lekchet;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_lekha;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_lekhok;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_lekkao;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_leknung;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_lekpaet;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_leksam;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_leksi;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_leksong;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_leksun;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_lochula;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_loling;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_lu;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_maichattawa;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_maiek;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_maihanakat;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_maihanakat_maitho;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_maitaikhu;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_maitho;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_maitri;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_maiyamok;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_moma;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_ngongu;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_nikhahit;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_nonen;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_nonu;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_oang;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_paiyannoi;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_phinthu;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_phophan;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_phophung;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_phosamphao;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_popla;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_rorua;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_ru;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_saraa;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_saraaa;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_saraae;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_saraaimaimalai;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_saraaimaimuan;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_saraam;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_sarae;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_sarai;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_saraii;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_sarao;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_sarau;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_saraue;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_sarauee;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_sarauu;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_sorusi;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_sosala;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_soso;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_sosua;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_thanthakhat;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_thonangmontho;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_thophuthao;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_thothahan;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_thothan;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_thothong;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_thothung;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_topatak;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_totao;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_wowaen;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_yoyak;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thai_yoying;
	[CCode (cheader_filename = "ibus.h")]
	public const int Thorn;
	[CCode (cheader_filename = "ibus.h")]
	public const int Touroku;
	[CCode (cheader_filename = "ibus.h")]
	public const int Tslash;
	[CCode (cheader_filename = "ibus.h")]
	public const int U;
	[CCode (cheader_filename = "ibus.h")]
	public const int Uacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ubelowdot;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ubreve;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ucircumflex;
	[CCode (cheader_filename = "ibus.h")]
	public const int Udiaeresis;
	[CCode (cheader_filename = "ibus.h")]
	public const int Udoubleacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ugrave;
	[CCode (cheader_filename = "ibus.h")]
	public const int Uhook;
	[CCode (cheader_filename = "ibus.h")]
	public const int Uhorn;
	[CCode (cheader_filename = "ibus.h")]
	public const int Uhornacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int Uhornbelowdot;
	[CCode (cheader_filename = "ibus.h")]
	public const int Uhorngrave;
	[CCode (cheader_filename = "ibus.h")]
	public const int Uhornhook;
	[CCode (cheader_filename = "ibus.h")]
	public const int Uhorntilde;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ukrainian_GHE_WITH_UPTURN;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ukrainian_I;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ukrainian_IE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ukrainian_YI;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ukrainian_ghe_with_upturn;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ukrainian_i;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ukrainian_ie;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ukrainian_yi;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ukranian_I;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ukranian_JE;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ukranian_YI;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ukranian_i;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ukranian_je;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ukranian_yi;
	[CCode (cheader_filename = "ibus.h")]
	public const int Umacron;
	[CCode (cheader_filename = "ibus.h")]
	public const int Undo;
	[CCode (cheader_filename = "ibus.h")]
	public const int Uogonek;
	[CCode (cheader_filename = "ibus.h")]
	public const int Up;
	[CCode (cheader_filename = "ibus.h")]
	public const int Uring;
	[CCode (cheader_filename = "ibus.h")]
	public const int Utilde;
	[CCode (cheader_filename = "ibus.h")]
	public const int V;
	[CCode (cheader_filename = "ibus.h")]
	public const int VoidSymbol;
	[CCode (cheader_filename = "ibus.h")]
	public const int W;
	[CCode (cheader_filename = "ibus.h")]
	public const int Wacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int Wcircumflex;
	[CCode (cheader_filename = "ibus.h")]
	public const int Wdiaeresis;
	[CCode (cheader_filename = "ibus.h")]
	public const int Wgrave;
	[CCode (cheader_filename = "ibus.h")]
	public const int WonSign;
	[CCode (cheader_filename = "ibus.h")]
	public const int X;
	[CCode (cheader_filename = "ibus.h")]
	public const int Xabovedot;
	[CCode (cheader_filename = "ibus.h")]
	public const int Y;
	[CCode (cheader_filename = "ibus.h")]
	public const int Yacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ybelowdot;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ycircumflex;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ydiaeresis;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ygrave;
	[CCode (cheader_filename = "ibus.h")]
	public const int Yhook;
	[CCode (cheader_filename = "ibus.h")]
	public const int Ytilde;
	[CCode (cheader_filename = "ibus.h")]
	public const int Z;
	[CCode (cheader_filename = "ibus.h")]
	public const int Zabovedot;
	[CCode (cheader_filename = "ibus.h")]
	public const int Zacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int Zcaron;
	[CCode (cheader_filename = "ibus.h")]
	public const int Zen_Koho;
	[CCode (cheader_filename = "ibus.h")]
	public const int Zenkaku;
	[CCode (cheader_filename = "ibus.h")]
	public const int Zenkaku_Hankaku;
	[CCode (cheader_filename = "ibus.h")]
	public const int Zstroke;
	[CCode (cheader_filename = "ibus.h")]
	public const int a;
	[CCode (cheader_filename = "ibus.h")]
	public const int aacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int abelowdot;
	[CCode (cheader_filename = "ibus.h")]
	public const int abovedot;
	[CCode (cheader_filename = "ibus.h")]
	public const int abreve;
	[CCode (cheader_filename = "ibus.h")]
	public const int abreveacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int abrevebelowdot;
	[CCode (cheader_filename = "ibus.h")]
	public const int abrevegrave;
	[CCode (cheader_filename = "ibus.h")]
	public const int abrevehook;
	[CCode (cheader_filename = "ibus.h")]
	public const int abrevetilde;
	[CCode (cheader_filename = "ibus.h")]
	public const int acircumflex;
	[CCode (cheader_filename = "ibus.h")]
	public const int acircumflexacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int acircumflexbelowdot;
	[CCode (cheader_filename = "ibus.h")]
	public const int acircumflexgrave;
	[CCode (cheader_filename = "ibus.h")]
	public const int acircumflexhook;
	[CCode (cheader_filename = "ibus.h")]
	public const int acircumflextilde;
	[CCode (cheader_filename = "ibus.h")]
	public const int acute;
	[CCode (cheader_filename = "ibus.h")]
	public const int adiaeresis;
	[CCode (cheader_filename = "ibus.h")]
	public const int ae;
	[CCode (cheader_filename = "ibus.h")]
	public const int agrave;
	[CCode (cheader_filename = "ibus.h")]
	public const int ahook;
	[CCode (cheader_filename = "ibus.h")]
	public const int amacron;
	[CCode (cheader_filename = "ibus.h")]
	public const int ampersand;
	[CCode (cheader_filename = "ibus.h")]
	public const int aogonek;
	[CCode (cheader_filename = "ibus.h")]
	public const int apostrophe;
	[CCode (cheader_filename = "ibus.h")]
	public const int approxeq;
	[CCode (cheader_filename = "ibus.h")]
	public const int approximate;
	[CCode (cheader_filename = "ibus.h")]
	public const int aring;
	[CCode (cheader_filename = "ibus.h")]
	public const int asciicircum;
	[CCode (cheader_filename = "ibus.h")]
	public const int asciitilde;
	[CCode (cheader_filename = "ibus.h")]
	public const int asterisk;
	[CCode (cheader_filename = "ibus.h")]
	public const int at;
	[CCode (cheader_filename = "ibus.h")]
	public const int atilde;
	[CCode (cheader_filename = "ibus.h")]
	public const int b;
	[CCode (cheader_filename = "ibus.h")]
	public const int babovedot;
	[CCode (cheader_filename = "ibus.h")]
	public const int backslash;
	[CCode (cheader_filename = "ibus.h")]
	public const int ballotcross;
	[CCode (cheader_filename = "ibus.h")]
	public const int bar;
	[CCode (cheader_filename = "ibus.h")]
	public const int because;
	[CCode (cheader_filename = "ibus.h")]
	public const int blank;
	[CCode (cheader_filename = "ibus.h")]
	public const int botintegral;
	[CCode (cheader_filename = "ibus.h")]
	public const int botleftparens;
	[CCode (cheader_filename = "ibus.h")]
	public const int botleftsqbracket;
	[CCode (cheader_filename = "ibus.h")]
	public const int botleftsummation;
	[CCode (cheader_filename = "ibus.h")]
	public const int botrightparens;
	[CCode (cheader_filename = "ibus.h")]
	public const int botrightsqbracket;
	[CCode (cheader_filename = "ibus.h")]
	public const int botrightsummation;
	[CCode (cheader_filename = "ibus.h")]
	public const int bott;
	[CCode (cheader_filename = "ibus.h")]
	public const int botvertsummationconnector;
	[CCode (cheader_filename = "ibus.h")]
	public const int braceleft;
	[CCode (cheader_filename = "ibus.h")]
	public const int braceright;
	[CCode (cheader_filename = "ibus.h")]
	public const int bracketleft;
	[CCode (cheader_filename = "ibus.h")]
	public const int bracketright;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_blank;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dot_1;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dot_10;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dot_2;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dot_3;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dot_4;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dot_5;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dot_6;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dot_7;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dot_8;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dot_9;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_12;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_123;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1234;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_12345;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_123456;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1234567;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_12345678;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1234568;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_123457;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1234578;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_123458;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_12346;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_123467;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1234678;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_123468;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_12347;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_123478;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_12348;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1235;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_12356;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_123567;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1235678;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_123568;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_12357;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_123578;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_12358;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1236;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_12367;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_123678;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_12368;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1237;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_12378;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1238;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_124;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1245;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_12456;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_124567;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1245678;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_124568;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_12457;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_124578;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_12458;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1246;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_12467;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_124678;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_12468;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1247;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_12478;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1248;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_125;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1256;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_12567;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_125678;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_12568;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1257;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_12578;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1258;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_126;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1267;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_12678;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1268;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_127;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1278;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_128;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_13;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_134;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1345;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_13456;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_134567;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1345678;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_134568;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_13457;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_134578;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_13458;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1346;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_13467;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_134678;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_13468;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1347;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_13478;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1348;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_135;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1356;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_13567;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_135678;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_13568;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1357;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_13578;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1358;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_136;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1367;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_13678;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1368;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_137;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1378;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_138;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_14;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_145;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1456;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_14567;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_145678;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_14568;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1457;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_14578;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1458;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_146;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1467;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_14678;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1468;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_147;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1478;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_148;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_15;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_156;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1567;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_15678;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1568;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_157;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1578;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_158;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_16;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_167;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_1678;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_168;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_17;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_178;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_18;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_2;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_23;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_234;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_2345;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_23456;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_234567;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_2345678;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_234568;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_23457;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_234578;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_23458;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_2346;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_23467;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_234678;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_23468;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_2347;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_23478;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_2348;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_235;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_2356;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_23567;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_235678;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_23568;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_2357;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_23578;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_2358;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_236;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_2367;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_23678;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_2368;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_237;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_2378;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_238;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_24;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_245;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_2456;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_24567;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_245678;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_24568;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_2457;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_24578;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_2458;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_246;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_2467;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_24678;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_2468;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_247;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_2478;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_248;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_25;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_256;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_2567;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_25678;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_2568;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_257;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_2578;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_258;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_26;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_267;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_2678;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_268;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_27;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_278;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_28;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_3;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_34;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_345;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_3456;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_34567;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_345678;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_34568;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_3457;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_34578;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_3458;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_346;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_3467;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_34678;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_3468;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_347;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_3478;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_348;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_35;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_356;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_3567;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_35678;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_3568;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_357;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_3578;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_358;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_36;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_367;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_3678;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_368;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_37;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_378;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_38;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_4;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_45;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_456;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_4567;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_45678;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_4568;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_457;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_4578;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_458;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_46;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_467;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_4678;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_468;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_47;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_478;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_48;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_5;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_56;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_567;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_5678;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_568;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_57;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_578;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_58;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_6;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_67;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_678;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_68;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_7;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_78;
	[CCode (cheader_filename = "ibus.h")]
	public const int braille_dots_8;
	[CCode (cheader_filename = "ibus.h")]
	public const int breve;
	[CCode (cheader_filename = "ibus.h")]
	public const int brokenbar;
	[CCode (cheader_filename = "ibus.h")]
	public const int c;
	[CCode (cheader_filename = "ibus.h")]
	public const int cabovedot;
	[CCode (cheader_filename = "ibus.h")]
	public const int cacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int careof;
	[CCode (cheader_filename = "ibus.h")]
	public const int caret;
	[CCode (cheader_filename = "ibus.h")]
	public const int caron;
	[CCode (cheader_filename = "ibus.h")]
	public const int ccaron;
	[CCode (cheader_filename = "ibus.h")]
	public const int ccedilla;
	[CCode (cheader_filename = "ibus.h")]
	public const int ccircumflex;
	[CCode (cheader_filename = "ibus.h")]
	public const int cedilla;
	[CCode (cheader_filename = "ibus.h")]
	public const int cent;
	[CCode (cheader_filename = "ibus.h")]
	public const int checkerboard;
	[CCode (cheader_filename = "ibus.h")]
	public const int checkmark;
	[CCode (cheader_filename = "ibus.h")]
	public const int circle;
	[CCode (cheader_filename = "ibus.h")]
	public const int club;
	[CCode (cheader_filename = "ibus.h")]
	public const int colon;
	[CCode (cheader_filename = "ibus.h")]
	public const int comma;
	[CCode (cheader_filename = "ibus.h")]
	public const int containsas;
	[CCode (cheader_filename = "ibus.h")]
	public const int copyright;
	[CCode (cheader_filename = "ibus.h")]
	public const int cr;
	[CCode (cheader_filename = "ibus.h")]
	public const int crossinglines;
	[CCode (cheader_filename = "ibus.h")]
	public const int cuberoot;
	[CCode (cheader_filename = "ibus.h")]
	public const int currency;
	[CCode (cheader_filename = "ibus.h")]
	public const int cursor;
	[CCode (cheader_filename = "ibus.h")]
	public const int d;
	[CCode (cheader_filename = "ibus.h")]
	public const int dabovedot;
	[CCode (cheader_filename = "ibus.h")]
	public const int dagger;
	[CCode (cheader_filename = "ibus.h")]
	public const int dcaron;
	[CCode (cheader_filename = "ibus.h")]
	public const int dead_abovecomma;
	[CCode (cheader_filename = "ibus.h")]
	public const int dead_abovedot;
	[CCode (cheader_filename = "ibus.h")]
	public const int dead_abovereversedcomma;
	[CCode (cheader_filename = "ibus.h")]
	public const int dead_abovering;
	[CCode (cheader_filename = "ibus.h")]
	public const int dead_acute;
	[CCode (cheader_filename = "ibus.h")]
	public const int dead_belowbreve;
	[CCode (cheader_filename = "ibus.h")]
	public const int dead_belowcircumflex;
	[CCode (cheader_filename = "ibus.h")]
	public const int dead_belowdiaeresis;
	[CCode (cheader_filename = "ibus.h")]
	public const int dead_belowdot;
	[CCode (cheader_filename = "ibus.h")]
	public const int dead_belowmacron;
	[CCode (cheader_filename = "ibus.h")]
	public const int dead_belowring;
	[CCode (cheader_filename = "ibus.h")]
	public const int dead_belowtilde;
	[CCode (cheader_filename = "ibus.h")]
	public const int dead_breve;
	[CCode (cheader_filename = "ibus.h")]
	public const int dead_caron;
	[CCode (cheader_filename = "ibus.h")]
	public const int dead_cedilla;
	[CCode (cheader_filename = "ibus.h")]
	public const int dead_circumflex;
	[CCode (cheader_filename = "ibus.h")]
	public const int dead_dasia;
	[CCode (cheader_filename = "ibus.h")]
	public const int dead_diaeresis;
	[CCode (cheader_filename = "ibus.h")]
	public const int dead_doubleacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int dead_grave;
	[CCode (cheader_filename = "ibus.h")]
	public const int dead_hook;
	[CCode (cheader_filename = "ibus.h")]
	public const int dead_horn;
	[CCode (cheader_filename = "ibus.h")]
	public const int dead_iota;
	[CCode (cheader_filename = "ibus.h")]
	public const int dead_macron;
	[CCode (cheader_filename = "ibus.h")]
	public const int dead_ogonek;
	[CCode (cheader_filename = "ibus.h")]
	public const int dead_perispomeni;
	[CCode (cheader_filename = "ibus.h")]
	public const int dead_psili;
	[CCode (cheader_filename = "ibus.h")]
	public const int dead_semivoiced_sound;
	[CCode (cheader_filename = "ibus.h")]
	public const int dead_stroke;
	[CCode (cheader_filename = "ibus.h")]
	public const int dead_tilde;
	[CCode (cheader_filename = "ibus.h")]
	public const int dead_voiced_sound;
	[CCode (cheader_filename = "ibus.h")]
	public const int decimalpoint;
	[CCode (cheader_filename = "ibus.h")]
	public const int degree;
	[CCode (cheader_filename = "ibus.h")]
	public const int diaeresis;
	[CCode (cheader_filename = "ibus.h")]
	public const int diamond;
	[CCode (cheader_filename = "ibus.h")]
	public const int digitspace;
	[CCode (cheader_filename = "ibus.h")]
	public const int dintegral;
	[CCode (cheader_filename = "ibus.h")]
	public const int division;
	[CCode (cheader_filename = "ibus.h")]
	public const int dollar;
	[CCode (cheader_filename = "ibus.h")]
	public const int doubbaselinedot;
	[CCode (cheader_filename = "ibus.h")]
	public const int doubleacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int doubledagger;
	[CCode (cheader_filename = "ibus.h")]
	public const int doublelowquotemark;
	[CCode (cheader_filename = "ibus.h")]
	public const int downarrow;
	[CCode (cheader_filename = "ibus.h")]
	public const int downcaret;
	[CCode (cheader_filename = "ibus.h")]
	public const int downshoe;
	[CCode (cheader_filename = "ibus.h")]
	public const int downstile;
	[CCode (cheader_filename = "ibus.h")]
	public const int downtack;
	[CCode (cheader_filename = "ibus.h")]
	public const int dstroke;
	[CCode (cheader_filename = "ibus.h")]
	public const int e;
	[CCode (cheader_filename = "ibus.h")]
	public const int eabovedot;
	[CCode (cheader_filename = "ibus.h")]
	public const int eacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int ebelowdot;
	[CCode (cheader_filename = "ibus.h")]
	public const int ecaron;
	[CCode (cheader_filename = "ibus.h")]
	public const int ecircumflex;
	[CCode (cheader_filename = "ibus.h")]
	public const int ecircumflexacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int ecircumflexbelowdot;
	[CCode (cheader_filename = "ibus.h")]
	public const int ecircumflexgrave;
	[CCode (cheader_filename = "ibus.h")]
	public const int ecircumflexhook;
	[CCode (cheader_filename = "ibus.h")]
	public const int ecircumflextilde;
	[CCode (cheader_filename = "ibus.h")]
	public const int ediaeresis;
	[CCode (cheader_filename = "ibus.h")]
	public const int egrave;
	[CCode (cheader_filename = "ibus.h")]
	public const int ehook;
	[CCode (cheader_filename = "ibus.h")]
	public const int eightsubscript;
	[CCode (cheader_filename = "ibus.h")]
	public const int eightsuperior;
	[CCode (cheader_filename = "ibus.h")]
	public const int elementof;
	[CCode (cheader_filename = "ibus.h")]
	public const int ellipsis;
	[CCode (cheader_filename = "ibus.h")]
	public const int em3space;
	[CCode (cheader_filename = "ibus.h")]
	public const int em4space;
	[CCode (cheader_filename = "ibus.h")]
	public const int emacron;
	[CCode (cheader_filename = "ibus.h")]
	public const int emdash;
	[CCode (cheader_filename = "ibus.h")]
	public const int emfilledcircle;
	[CCode (cheader_filename = "ibus.h")]
	public const int emfilledrect;
	[CCode (cheader_filename = "ibus.h")]
	public const int emopencircle;
	[CCode (cheader_filename = "ibus.h")]
	public const int emopenrectangle;
	[CCode (cheader_filename = "ibus.h")]
	public const int emptyset;
	[CCode (cheader_filename = "ibus.h")]
	public const int emspace;
	[CCode (cheader_filename = "ibus.h")]
	public const int endash;
	[CCode (cheader_filename = "ibus.h")]
	public const int enfilledcircbullet;
	[CCode (cheader_filename = "ibus.h")]
	public const int enfilledsqbullet;
	[CCode (cheader_filename = "ibus.h")]
	public const int eng;
	[CCode (cheader_filename = "ibus.h")]
	public const int enopencircbullet;
	[CCode (cheader_filename = "ibus.h")]
	public const int enopensquarebullet;
	[CCode (cheader_filename = "ibus.h")]
	public const int enspace;
	[CCode (cheader_filename = "ibus.h")]
	public const int eogonek;
	[CCode (cheader_filename = "ibus.h")]
	public const int equal;
	[CCode (cheader_filename = "ibus.h")]
	public const int eth;
	[CCode (cheader_filename = "ibus.h")]
	public const int etilde;
	[CCode (cheader_filename = "ibus.h")]
	public const int exclam;
	[CCode (cheader_filename = "ibus.h")]
	public const int exclamdown;
	[CCode (cheader_filename = "ibus.h")]
	public const int f;
	[CCode (cheader_filename = "ibus.h")]
	public const int fabovedot;
	[CCode (cheader_filename = "ibus.h")]
	public const int femalesymbol;
	[CCode (cheader_filename = "ibus.h")]
	public const int ff;
	[CCode (cheader_filename = "ibus.h")]
	public const int figdash;
	[CCode (cheader_filename = "ibus.h")]
	public const int filledlefttribullet;
	[CCode (cheader_filename = "ibus.h")]
	public const int filledrectbullet;
	[CCode (cheader_filename = "ibus.h")]
	public const int filledrighttribullet;
	[CCode (cheader_filename = "ibus.h")]
	public const int filledtribulletdown;
	[CCode (cheader_filename = "ibus.h")]
	public const int filledtribulletup;
	[CCode (cheader_filename = "ibus.h")]
	public const int fiveeighths;
	[CCode (cheader_filename = "ibus.h")]
	public const int fivesixths;
	[CCode (cheader_filename = "ibus.h")]
	public const int fivesubscript;
	[CCode (cheader_filename = "ibus.h")]
	public const int fivesuperior;
	[CCode (cheader_filename = "ibus.h")]
	public const int fourfifths;
	[CCode (cheader_filename = "ibus.h")]
	public const int foursubscript;
	[CCode (cheader_filename = "ibus.h")]
	public const int foursuperior;
	[CCode (cheader_filename = "ibus.h")]
	public const int fourthroot;
	[CCode (cheader_filename = "ibus.h")]
	public const int function;
	[CCode (cheader_filename = "ibus.h")]
	public const int g;
	[CCode (cheader_filename = "ibus.h")]
	public const int gabovedot;
	[CCode (cheader_filename = "ibus.h")]
	public const int gbreve;
	[CCode (cheader_filename = "ibus.h")]
	public const int gcaron;
	[CCode (cheader_filename = "ibus.h")]
	public const int gcedilla;
	[CCode (cheader_filename = "ibus.h")]
	public const int gcircumflex;
	[CCode (cheader_filename = "ibus.h")]
	public const int grave;
	[CCode (cheader_filename = "ibus.h")]
	public const int greater;
	[CCode (cheader_filename = "ibus.h")]
	public const int greaterthanequal;
	[CCode (cheader_filename = "ibus.h")]
	public const int guillemotleft;
	[CCode (cheader_filename = "ibus.h")]
	public const int guillemotright;
	[CCode (cheader_filename = "ibus.h")]
	public const int h;
	[CCode (cheader_filename = "ibus.h")]
	public const int hairspace;
	[CCode (cheader_filename = "ibus.h")]
	public const int hcircumflex;
	[CCode (cheader_filename = "ibus.h")]
	public const int heart;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_aleph;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_ayin;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_bet;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_beth;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_chet;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_dalet;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_daleth;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_doublelowline;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_finalkaph;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_finalmem;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_finalnun;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_finalpe;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_finalzade;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_finalzadi;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_gimel;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_gimmel;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_he;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_het;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_kaph;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_kuf;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_lamed;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_mem;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_nun;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_pe;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_qoph;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_resh;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_samech;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_samekh;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_shin;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_taf;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_taw;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_tet;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_teth;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_waw;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_yod;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_zade;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_zadi;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_zain;
	[CCode (cheader_filename = "ibus.h")]
	public const int hebrew_zayin;
	[CCode (cheader_filename = "ibus.h")]
	public const int hexagram;
	[CCode (cheader_filename = "ibus.h")]
	public const int horizconnector;
	[CCode (cheader_filename = "ibus.h")]
	public const int horizlinescan1;
	[CCode (cheader_filename = "ibus.h")]
	public const int horizlinescan3;
	[CCode (cheader_filename = "ibus.h")]
	public const int horizlinescan5;
	[CCode (cheader_filename = "ibus.h")]
	public const int horizlinescan7;
	[CCode (cheader_filename = "ibus.h")]
	public const int horizlinescan9;
	[CCode (cheader_filename = "ibus.h")]
	public const int hstroke;
	[CCode (cheader_filename = "ibus.h")]
	public const int ht;
	[CCode (cheader_filename = "ibus.h")]
	public const int hyphen;
	[CCode (cheader_filename = "ibus.h")]
	public const int i;
	[CCode (cheader_filename = "ibus.h")]
	public const int iacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int ibelowdot;
	[CCode (cheader_filename = "ibus.h")]
	public const int ibreve;
	[CCode (cheader_filename = "ibus.h")]
	public const int icircumflex;
	[CCode (cheader_filename = "ibus.h")]
	public const int identical;
	[CCode (cheader_filename = "ibus.h")]
	public const int idiaeresis;
	[CCode (cheader_filename = "ibus.h")]
	public const int idotless;
	[CCode (cheader_filename = "ibus.h")]
	public const int ifonlyif;
	[CCode (cheader_filename = "ibus.h")]
	public const int igrave;
	[CCode (cheader_filename = "ibus.h")]
	public const int ihook;
	[CCode (cheader_filename = "ibus.h")]
	public const int imacron;
	[CCode (cheader_filename = "ibus.h")]
	public const int implies;
	[CCode (cheader_filename = "ibus.h")]
	public const int includedin;
	[CCode (cheader_filename = "ibus.h")]
	public const int includes;
	[CCode (cheader_filename = "ibus.h")]
	public const int infinity;
	[CCode (cheader_filename = "ibus.h")]
	public const int integral;
	[CCode (cheader_filename = "ibus.h")]
	public const int intersection;
	[CCode (cheader_filename = "ibus.h")]
	public const int iogonek;
	[CCode (cheader_filename = "ibus.h")]
	public const int itilde;
	[CCode (cheader_filename = "ibus.h")]
	public const int j;
	[CCode (cheader_filename = "ibus.h")]
	public const int jcircumflex;
	[CCode (cheader_filename = "ibus.h")]
	public const int jot;
	[CCode (cheader_filename = "ibus.h")]
	public const int k;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_A;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_CHI;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_E;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_FU;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_HA;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_HE;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_HI;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_HO;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_HU;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_I;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_KA;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_KE;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_KI;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_KO;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_KU;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_MA;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_ME;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_MI;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_MO;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_MU;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_N;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_NA;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_NE;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_NI;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_NO;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_NU;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_O;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_RA;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_RE;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_RI;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_RO;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_RU;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_SA;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_SE;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_SHI;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_SO;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_SU;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_TA;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_TE;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_TI;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_TO;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_TSU;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_TU;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_U;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_WA;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_WO;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_YA;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_YO;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_YU;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_a;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_closingbracket;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_comma;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_conjunctive;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_e;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_fullstop;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_i;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_middledot;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_o;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_openingbracket;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_switch;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_tsu;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_tu;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_u;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_ya;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_yo;
	[CCode (cheader_filename = "ibus.h")]
	public const int kana_yu;
	[CCode (cheader_filename = "ibus.h")]
	public const int kappa;
	[CCode (cheader_filename = "ibus.h")]
	public const int kcedilla;
	[CCode (cheader_filename = "ibus.h")]
	public const int kra;
	[CCode (cheader_filename = "ibus.h")]
	public const int l;
	[CCode (cheader_filename = "ibus.h")]
	public const int lacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int latincross;
	[CCode (cheader_filename = "ibus.h")]
	public const int lbelowdot;
	[CCode (cheader_filename = "ibus.h")]
	public const int lcaron;
	[CCode (cheader_filename = "ibus.h")]
	public const int lcedilla;
	[CCode (cheader_filename = "ibus.h")]
	public const int leftanglebracket;
	[CCode (cheader_filename = "ibus.h")]
	public const int leftarrow;
	[CCode (cheader_filename = "ibus.h")]
	public const int leftcaret;
	[CCode (cheader_filename = "ibus.h")]
	public const int leftdoublequotemark;
	[CCode (cheader_filename = "ibus.h")]
	public const int leftmiddlecurlybrace;
	[CCode (cheader_filename = "ibus.h")]
	public const int leftopentriangle;
	[CCode (cheader_filename = "ibus.h")]
	public const int leftpointer;
	[CCode (cheader_filename = "ibus.h")]
	public const int leftradical;
	[CCode (cheader_filename = "ibus.h")]
	public const int leftshoe;
	[CCode (cheader_filename = "ibus.h")]
	public const int leftsinglequotemark;
	[CCode (cheader_filename = "ibus.h")]
	public const int leftt;
	[CCode (cheader_filename = "ibus.h")]
	public const int lefttack;
	[CCode (cheader_filename = "ibus.h")]
	public const int less;
	[CCode (cheader_filename = "ibus.h")]
	public const int lessthanequal;
	[CCode (cheader_filename = "ibus.h")]
	public const int lf;
	[CCode (cheader_filename = "ibus.h")]
	public const int logicaland;
	[CCode (cheader_filename = "ibus.h")]
	public const int logicalor;
	[CCode (cheader_filename = "ibus.h")]
	public const int lowleftcorner;
	[CCode (cheader_filename = "ibus.h")]
	public const int lowrightcorner;
	[CCode (cheader_filename = "ibus.h")]
	public const int lstroke;
	[CCode (cheader_filename = "ibus.h")]
	public const int m;
	[CCode (cheader_filename = "ibus.h")]
	public const int mabovedot;
	[CCode (cheader_filename = "ibus.h")]
	public const int macron;
	[CCode (cheader_filename = "ibus.h")]
	public const int malesymbol;
	[CCode (cheader_filename = "ibus.h")]
	public const int maltesecross;
	[CCode (cheader_filename = "ibus.h")]
	public const int marker;
	[CCode (cheader_filename = "ibus.h")]
	public const int masculine;
	[CCode (cheader_filename = "ibus.h")]
	public const int minus;
	[CCode (cheader_filename = "ibus.h")]
	public const int minutes;
	[CCode (cheader_filename = "ibus.h")]
	public const int mu;
	[CCode (cheader_filename = "ibus.h")]
	public const int multiply;
	[CCode (cheader_filename = "ibus.h")]
	public const int musicalflat;
	[CCode (cheader_filename = "ibus.h")]
	public const int musicalsharp;
	[CCode (cheader_filename = "ibus.h")]
	public const int n;
	[CCode (cheader_filename = "ibus.h")]
	public const int nabla;
	[CCode (cheader_filename = "ibus.h")]
	public const int nacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int ncaron;
	[CCode (cheader_filename = "ibus.h")]
	public const int ncedilla;
	[CCode (cheader_filename = "ibus.h")]
	public const int ninesubscript;
	[CCode (cheader_filename = "ibus.h")]
	public const int ninesuperior;
	[CCode (cheader_filename = "ibus.h")]
	public const int nl;
	[CCode (cheader_filename = "ibus.h")]
	public const int nobreakspace;
	[CCode (cheader_filename = "ibus.h")]
	public const int notapproxeq;
	[CCode (cheader_filename = "ibus.h")]
	public const int notelementof;
	[CCode (cheader_filename = "ibus.h")]
	public const int notequal;
	[CCode (cheader_filename = "ibus.h")]
	public const int notidentical;
	[CCode (cheader_filename = "ibus.h")]
	public const int notsign;
	[CCode (cheader_filename = "ibus.h")]
	public const int ntilde;
	[CCode (cheader_filename = "ibus.h")]
	public const int numbersign;
	[CCode (cheader_filename = "ibus.h")]
	public const int numerosign;
	[CCode (cheader_filename = "ibus.h")]
	public const int o;
	[CCode (cheader_filename = "ibus.h")]
	public const int oacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int obarred;
	[CCode (cheader_filename = "ibus.h")]
	public const int obelowdot;
	[CCode (cheader_filename = "ibus.h")]
	public const int ocaron;
	[CCode (cheader_filename = "ibus.h")]
	public const int ocircumflex;
	[CCode (cheader_filename = "ibus.h")]
	public const int ocircumflexacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int ocircumflexbelowdot;
	[CCode (cheader_filename = "ibus.h")]
	public const int ocircumflexgrave;
	[CCode (cheader_filename = "ibus.h")]
	public const int ocircumflexhook;
	[CCode (cheader_filename = "ibus.h")]
	public const int ocircumflextilde;
	[CCode (cheader_filename = "ibus.h")]
	public const int odiaeresis;
	[CCode (cheader_filename = "ibus.h")]
	public const int odoubleacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int oe;
	[CCode (cheader_filename = "ibus.h")]
	public const int ogonek;
	[CCode (cheader_filename = "ibus.h")]
	public const int ograve;
	[CCode (cheader_filename = "ibus.h")]
	public const int ohook;
	[CCode (cheader_filename = "ibus.h")]
	public const int ohorn;
	[CCode (cheader_filename = "ibus.h")]
	public const int ohornacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int ohornbelowdot;
	[CCode (cheader_filename = "ibus.h")]
	public const int ohorngrave;
	[CCode (cheader_filename = "ibus.h")]
	public const int ohornhook;
	[CCode (cheader_filename = "ibus.h")]
	public const int ohorntilde;
	[CCode (cheader_filename = "ibus.h")]
	public const int omacron;
	[CCode (cheader_filename = "ibus.h")]
	public const int oneeighth;
	[CCode (cheader_filename = "ibus.h")]
	public const int onefifth;
	[CCode (cheader_filename = "ibus.h")]
	public const int onehalf;
	[CCode (cheader_filename = "ibus.h")]
	public const int onequarter;
	[CCode (cheader_filename = "ibus.h")]
	public const int onesixth;
	[CCode (cheader_filename = "ibus.h")]
	public const int onesubscript;
	[CCode (cheader_filename = "ibus.h")]
	public const int onesuperior;
	[CCode (cheader_filename = "ibus.h")]
	public const int onethird;
	[CCode (cheader_filename = "ibus.h")]
	public const int ooblique;
	[CCode (cheader_filename = "ibus.h")]
	public const int openrectbullet;
	[CCode (cheader_filename = "ibus.h")]
	public const int openstar;
	[CCode (cheader_filename = "ibus.h")]
	public const int opentribulletdown;
	[CCode (cheader_filename = "ibus.h")]
	public const int opentribulletup;
	[CCode (cheader_filename = "ibus.h")]
	public const int ordfeminine;
	[CCode (cheader_filename = "ibus.h")]
	public const int oslash;
	[CCode (cheader_filename = "ibus.h")]
	public const int otilde;
	[CCode (cheader_filename = "ibus.h")]
	public const int overbar;
	[CCode (cheader_filename = "ibus.h")]
	public const int overline;
	[CCode (cheader_filename = "ibus.h")]
	public const int p;
	[CCode (cheader_filename = "ibus.h")]
	public const int pabovedot;
	[CCode (cheader_filename = "ibus.h")]
	public const int paragraph;
	[CCode (cheader_filename = "ibus.h")]
	public const int parenleft;
	[CCode (cheader_filename = "ibus.h")]
	public const int parenright;
	[CCode (cheader_filename = "ibus.h")]
	public const int partdifferential;
	[CCode (cheader_filename = "ibus.h")]
	public const int partialderivative;
	[CCode (cheader_filename = "ibus.h")]
	public const int percent;
	[CCode (cheader_filename = "ibus.h")]
	public const int period;
	[CCode (cheader_filename = "ibus.h")]
	public const int periodcentered;
	[CCode (cheader_filename = "ibus.h")]
	public const int phonographcopyright;
	[CCode (cheader_filename = "ibus.h")]
	public const int plus;
	[CCode (cheader_filename = "ibus.h")]
	public const int plusminus;
	[CCode (cheader_filename = "ibus.h")]
	public const int prescription;
	[CCode (cheader_filename = "ibus.h")]
	public const int prolongedsound;
	[CCode (cheader_filename = "ibus.h")]
	public const int punctspace;
	[CCode (cheader_filename = "ibus.h")]
	public const int q;
	[CCode (cheader_filename = "ibus.h")]
	public const int quad;
	[CCode (cheader_filename = "ibus.h")]
	public const int question;
	[CCode (cheader_filename = "ibus.h")]
	public const int questiondown;
	[CCode (cheader_filename = "ibus.h")]
	public const int quotedbl;
	[CCode (cheader_filename = "ibus.h")]
	public const int quoteleft;
	[CCode (cheader_filename = "ibus.h")]
	public const int quoteright;
	[CCode (cheader_filename = "ibus.h")]
	public const int r;
	[CCode (cheader_filename = "ibus.h")]
	public const int racute;
	[CCode (cheader_filename = "ibus.h")]
	public const int radical;
	[CCode (cheader_filename = "ibus.h")]
	public const int rcaron;
	[CCode (cheader_filename = "ibus.h")]
	public const int rcedilla;
	[CCode (cheader_filename = "ibus.h")]
	public const int registered;
	[CCode (cheader_filename = "ibus.h")]
	public const int rightanglebracket;
	[CCode (cheader_filename = "ibus.h")]
	public const int rightarrow;
	[CCode (cheader_filename = "ibus.h")]
	public const int rightcaret;
	[CCode (cheader_filename = "ibus.h")]
	public const int rightdoublequotemark;
	[CCode (cheader_filename = "ibus.h")]
	public const int rightmiddlecurlybrace;
	[CCode (cheader_filename = "ibus.h")]
	public const int rightmiddlesummation;
	[CCode (cheader_filename = "ibus.h")]
	public const int rightopentriangle;
	[CCode (cheader_filename = "ibus.h")]
	public const int rightpointer;
	[CCode (cheader_filename = "ibus.h")]
	public const int rightshoe;
	[CCode (cheader_filename = "ibus.h")]
	public const int rightsinglequotemark;
	[CCode (cheader_filename = "ibus.h")]
	public const int rightt;
	[CCode (cheader_filename = "ibus.h")]
	public const int righttack;
	[CCode (cheader_filename = "ibus.h")]
	public const int s;
	[CCode (cheader_filename = "ibus.h")]
	public const int sabovedot;
	[CCode (cheader_filename = "ibus.h")]
	public const int sacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int scaron;
	[CCode (cheader_filename = "ibus.h")]
	public const int scedilla;
	[CCode (cheader_filename = "ibus.h")]
	public const int schwa;
	[CCode (cheader_filename = "ibus.h")]
	public const int scircumflex;
	[CCode (cheader_filename = "ibus.h")]
	public const int script_switch;
	[CCode (cheader_filename = "ibus.h")]
	public const int seconds;
	[CCode (cheader_filename = "ibus.h")]
	public const int section;
	[CCode (cheader_filename = "ibus.h")]
	public const int semicolon;
	[CCode (cheader_filename = "ibus.h")]
	public const int semivoicedsound;
	[CCode (cheader_filename = "ibus.h")]
	public const int seveneighths;
	[CCode (cheader_filename = "ibus.h")]
	public const int sevensubscript;
	[CCode (cheader_filename = "ibus.h")]
	public const int sevensuperior;
	[CCode (cheader_filename = "ibus.h")]
	public const int signaturemark;
	[CCode (cheader_filename = "ibus.h")]
	public const int signifblank;
	[CCode (cheader_filename = "ibus.h")]
	public const int similarequal;
	[CCode (cheader_filename = "ibus.h")]
	public const int singlelowquotemark;
	[CCode (cheader_filename = "ibus.h")]
	public const int sixsubscript;
	[CCode (cheader_filename = "ibus.h")]
	public const int sixsuperior;
	[CCode (cheader_filename = "ibus.h")]
	public const int slash;
	[CCode (cheader_filename = "ibus.h")]
	public const int soliddiamond;
	[CCode (cheader_filename = "ibus.h")]
	public const int space;
	[CCode (cheader_filename = "ibus.h")]
	public const int squareroot;
	[CCode (cheader_filename = "ibus.h")]
	public const int ssharp;
	[CCode (cheader_filename = "ibus.h")]
	public const int sterling;
	[CCode (cheader_filename = "ibus.h")]
	public const int stricteq;
	[CCode (cheader_filename = "ibus.h")]
	public const int t;
	[CCode (cheader_filename = "ibus.h")]
	public const int tabovedot;
	[CCode (cheader_filename = "ibus.h")]
	public const int tcaron;
	[CCode (cheader_filename = "ibus.h")]
	public const int tcedilla;
	[CCode (cheader_filename = "ibus.h")]
	public const int telephone;
	[CCode (cheader_filename = "ibus.h")]
	public const int telephonerecorder;
	[CCode (cheader_filename = "ibus.h")]
	public const int therefore;
	[CCode (cheader_filename = "ibus.h")]
	public const int thinspace;
	[CCode (cheader_filename = "ibus.h")]
	public const int thorn;
	[CCode (cheader_filename = "ibus.h")]
	public const int threeeighths;
	[CCode (cheader_filename = "ibus.h")]
	public const int threefifths;
	[CCode (cheader_filename = "ibus.h")]
	public const int threequarters;
	[CCode (cheader_filename = "ibus.h")]
	public const int threesubscript;
	[CCode (cheader_filename = "ibus.h")]
	public const int threesuperior;
	[CCode (cheader_filename = "ibus.h")]
	public const int tintegral;
	[CCode (cheader_filename = "ibus.h")]
	public const int topintegral;
	[CCode (cheader_filename = "ibus.h")]
	public const int topleftparens;
	[CCode (cheader_filename = "ibus.h")]
	public const int topleftradical;
	[CCode (cheader_filename = "ibus.h")]
	public const int topleftsqbracket;
	[CCode (cheader_filename = "ibus.h")]
	public const int topleftsummation;
	[CCode (cheader_filename = "ibus.h")]
	public const int toprightparens;
	[CCode (cheader_filename = "ibus.h")]
	public const int toprightsqbracket;
	[CCode (cheader_filename = "ibus.h")]
	public const int toprightsummation;
	[CCode (cheader_filename = "ibus.h")]
	public const int topt;
	[CCode (cheader_filename = "ibus.h")]
	public const int topvertsummationconnector;
	[CCode (cheader_filename = "ibus.h")]
	public const int trademark;
	[CCode (cheader_filename = "ibus.h")]
	public const int trademarkincircle;
	[CCode (cheader_filename = "ibus.h")]
	public const int tslash;
	[CCode (cheader_filename = "ibus.h")]
	public const int twofifths;
	[CCode (cheader_filename = "ibus.h")]
	public const int twosubscript;
	[CCode (cheader_filename = "ibus.h")]
	public const int twosuperior;
	[CCode (cheader_filename = "ibus.h")]
	public const int twothirds;
	[CCode (cheader_filename = "ibus.h")]
	public const int u;
	[CCode (cheader_filename = "ibus.h")]
	public const int uacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int ubelowdot;
	[CCode (cheader_filename = "ibus.h")]
	public const int ubreve;
	[CCode (cheader_filename = "ibus.h")]
	public const int ucircumflex;
	[CCode (cheader_filename = "ibus.h")]
	public const int udiaeresis;
	[CCode (cheader_filename = "ibus.h")]
	public const int udoubleacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int ugrave;
	[CCode (cheader_filename = "ibus.h")]
	public const int uhook;
	[CCode (cheader_filename = "ibus.h")]
	public const int uhorn;
	[CCode (cheader_filename = "ibus.h")]
	public const int uhornacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int uhornbelowdot;
	[CCode (cheader_filename = "ibus.h")]
	public const int uhorngrave;
	[CCode (cheader_filename = "ibus.h")]
	public const int uhornhook;
	[CCode (cheader_filename = "ibus.h")]
	public const int uhorntilde;
	[CCode (cheader_filename = "ibus.h")]
	public const int umacron;
	[CCode (cheader_filename = "ibus.h")]
	public const int underbar;
	[CCode (cheader_filename = "ibus.h")]
	public const int underscore;
	[CCode (cheader_filename = "ibus.h")]
	public const int union;
	[CCode (cheader_filename = "ibus.h")]
	public const int uogonek;
	[CCode (cheader_filename = "ibus.h")]
	public const int uparrow;
	[CCode (cheader_filename = "ibus.h")]
	public const int upcaret;
	[CCode (cheader_filename = "ibus.h")]
	public const int upleftcorner;
	[CCode (cheader_filename = "ibus.h")]
	public const int uprightcorner;
	[CCode (cheader_filename = "ibus.h")]
	public const int upshoe;
	[CCode (cheader_filename = "ibus.h")]
	public const int upstile;
	[CCode (cheader_filename = "ibus.h")]
	public const int uptack;
	[CCode (cheader_filename = "ibus.h")]
	public const int uring;
	[CCode (cheader_filename = "ibus.h")]
	public const int utilde;
	[CCode (cheader_filename = "ibus.h")]
	public const int v;
	[CCode (cheader_filename = "ibus.h")]
	public const int variation;
	[CCode (cheader_filename = "ibus.h")]
	public const int vertbar;
	[CCode (cheader_filename = "ibus.h")]
	public const int vertconnector;
	[CCode (cheader_filename = "ibus.h")]
	public const int voicedsound;
	[CCode (cheader_filename = "ibus.h")]
	public const int vt;
	[CCode (cheader_filename = "ibus.h")]
	public const int w;
	[CCode (cheader_filename = "ibus.h")]
	public const int wacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int wcircumflex;
	[CCode (cheader_filename = "ibus.h")]
	public const int wdiaeresis;
	[CCode (cheader_filename = "ibus.h")]
	public const int wgrave;
	[CCode (cheader_filename = "ibus.h")]
	public const int x;
	[CCode (cheader_filename = "ibus.h")]
	public const int xabovedot;
	[CCode (cheader_filename = "ibus.h")]
	public const int y;
	[CCode (cheader_filename = "ibus.h")]
	public const int yacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int ybelowdot;
	[CCode (cheader_filename = "ibus.h")]
	public const int ycircumflex;
	[CCode (cheader_filename = "ibus.h")]
	public const int ydiaeresis;
	[CCode (cheader_filename = "ibus.h")]
	public const int yen;
	[CCode (cheader_filename = "ibus.h")]
	public const int ygrave;
	[CCode (cheader_filename = "ibus.h")]
	public const int yhook;
	[CCode (cheader_filename = "ibus.h")]
	public const int ytilde;
	[CCode (cheader_filename = "ibus.h")]
	public const int z;
	[CCode (cheader_filename = "ibus.h")]
	public const int zabovedot;
	[CCode (cheader_filename = "ibus.h")]
	public const int zacute;
	[CCode (cheader_filename = "ibus.h")]
	public const int zcaron;
	[CCode (cheader_filename = "ibus.h")]
	public const int zerosubscript;
	[CCode (cheader_filename = "ibus.h")]
	public const int zerosuperior;
	[CCode (cheader_filename = "ibus.h")]
	public const int zstroke;
	[CCode (cheader_filename = "ibus.h")]
	public static unowned IBus.Attribute attr_background_new (uint color, uint start_index, uint end_index);
	[CCode (cheader_filename = "ibus.h")]
	public static unowned IBus.Attribute attr_foreground_new (uint color, uint start_index, uint end_index);
	[CCode (cheader_filename = "ibus.h")]
	public static unowned IBus.Attribute attr_underline_new (uint underline_type, uint start_index, uint end_index);
	[CCode (cheader_filename = "ibus.h")]
	public static GLib.Quark error_quark ();
	[CCode (cheader_filename = "ibus.h")]
	public static void free_strv (string strv);
	[CCode (cheader_filename = "ibus.h")]
	public static unowned string get_address ();
	[CCode (cheader_filename = "ibus.h")]
	public static long get_daemon_uid ();
	[CCode (cheader_filename = "ibus.h")]
	public static unowned string get_default_bridge_engine_name ();
	[CCode (cheader_filename = "ibus.h")]
	public static unowned string get_language_name (string _locale);
	[CCode (cheader_filename = "ibus.h")]
	public static unowned string get_local_machine_id ();
	[CCode (cheader_filename = "ibus.h")]
	public static unowned string get_socket_path ();
	[CCode (cheader_filename = "ibus.h")]
	public static int get_timeout ();
	[CCode (cheader_filename = "ibus.h")]
	public static unowned string get_user_name ();
	[CCode (cheader_filename = "ibus.h")]
	public static void init ();
	[CCode (cheader_filename = "ibus.h")]
	public static bool key_event_from_string (string str, uint keyval, uint modifiers);
	[CCode (cheader_filename = "ibus.h")]
	public static unowned string key_event_to_string (uint keyval, uint modifiers);
	[CCode (cheader_filename = "ibus.h")]
	public static uint keyval_from_name (string keyval_name);
	[CCode (cheader_filename = "ibus.h")]
	public static unowned string keyval_name (uint keyval);
	[CCode (cheader_filename = "ibus.h")]
	public static unichar keyval_to_unicode (uint keyval);
	[CCode (cheader_filename = "ibus.h")]
	public static void main ();
	[CCode (cheader_filename = "ibus.h")]
	public static void quit ();
	[CCode (cheader_filename = "ibus.h")]
	public static void set_display (string display);
	[CCode (cheader_filename = "ibus.h")]
	public static void set_log_handler (bool verbose);
	[CCode (cheader_filename = "ibus.h")]
	public static uint unicode_to_keyval (unichar wc);
	[CCode (cheader_filename = "ibus.h")]
	public static bool use_bridge_hotkey ();
	[CCode (cheader_filename = "ibus.h")]
	public static void write_address (string address);
	[CCode (cheader_filename = "ibus.h")]
	public static void xml_free (IBus.XMLNode node);
	[CCode (cheader_filename = "ibus.h")]
	public static void xml_output (IBus.XMLNode node, GLib.StringBuilder output);
	[CCode (cheader_filename = "ibus.h")]
	public static unowned IBus.XMLNode xml_parse_buffer (string buffer);
	[CCode (cheader_filename = "ibus.h")]
	public static unowned IBus.XMLNode xml_parse_file (string name);
}
