#define RX_PULSESHAPER_GAIN        32767.000000f
#define RX_PULSESHAPER_COEFF_SETS  48
static const complexi16_t rx_pulseshaper[RX_PULSESHAPER_COEFF_SETS][27] =
{
    {
        {       0,        0},     /* Filter 0 */
        {      35,      -11},
        {     -67,     -109},
        {      91,      -91},
        {     -80,      -49},
        {      54,     -166},
        {    -151,      -11},
        {     -65,     -413},
        {    -138,       57},
        {    -766,    -1055},
        {     843,     -987},
        {   -1372,     -699},
        {    1529,    -6372},
        {   10574,        0},
        {    2468,    10282},
        {   -5839,     2975},
        {   -1000,    -1171},
        {    -763,     1050},
        {   -1205,     -499},
        {      23,     -147},
        {    -416,       32},
        {     -46,     -144},
        {    -149,       91},
        {     -66,      -66},
        {     -67,      110},
        {    -122,      -39},
        {      -2,       36}
    },
    {
        {       0,        0},     /* Filter 1 */
        {      32,      -10},
        {     -68,     -111},
        {      89,      -89},
        {     -84,      -51},
        {      53,     -163},
        {    -160,      -12},
        {     -65,     -411},
        {    -158,       65},
        {    -778,    -1070},
        {     825,     -966},
        {   -1452,     -739},
        {    1554,    -6476},
        {   10621,        0},
        {    2457,    10234},
        {   -5743,     2926},
        {    -942,    -1103},
        {    -778,     1071},
        {   -1186,     -491},
        {      20,     -126},
        {    -418,       32},
        {     -44,     -135},
        {    -151,       92},
        {     -63,      -63},
        {     -69,      112},
        {    -119,      -38},
        {      -3,       40}
    },
    {
        {       0,        0},     /* Filter 2 */
        {      29,       -9},
        {     -69,     -113},
        {      87,      -87},
        {     -88,      -54},
        {      52,     -161},
        {    -169,      -13},
        {     -64,     -409},
        {    -179,       74},
        {    -789,    -1086},
        {     807,     -944},
        {   -1533,     -781},
        {    1579,    -6580},
        {   10667,        0},
        {    2445,    10184},
        {   -5647,     2877},
        {    -885,    -1036},
        {    -793,     1091},
        {   -1167,     -483},
        {      16,     -105},
        {    -418,       32},
        {     -41,     -126},
        {    -153,       94},
        {     -59,      -59},
        {     -70,      115},
        {    -116,      -38},
        {      -3,       43}
    },
    {
        {       0,        0},     /* Filter 3 */
        {      26,       -8},
        {     -71,     -116},
        {      84,      -84},
        {     -92,      -56},
        {      51,     -157},
        {    -178,      -14},
        {     -64,     -407},
        {    -199,       82},
        {    -799,    -1101},
        {     787,     -922},
        {   -1615,     -823},
        {    1604,    -6683},
        {   10711,        0},
        {    2432,    10132},
        {   -5550,     2828},
        {    -828,     -970},
        {    -806,     1110},
        {   -1148,     -475},
        {      13,      -84},
        {    -418,       32},
        {     -38,     -118},
        {    -155,       95},
        {     -56,      -56},
        {     -71,      117},
        {    -114,      -37},
        {      -3,       45}
    },
    {
        {       0,        0},     /* Filter 4 */
        {      23,       -7},
        {     -72,     -118},
        {      82,      -82},
        {     -96,      -59},
        {      50,     -154},
        {    -187,      -14},
        {     -64,     -404},
        {    -221,       91},
        {    -810,    -1115},
        {     767,     -898},
        {   -1698,     -865},
        {    1629,    -6786},
        {   10753,        0},
        {    2419,    10079},
        {   -5453,     2778},
        {    -773,     -905},
        {    -819,     1128},
        {   -1128,     -467},
        {      10,      -64},
        {    -418,       32},
        {     -35,     -109},
        {    -157,       96},
        {     -52,      -52},
        {     -73,      119},
        {    -111,      -36},
        {      -3,       48}
    },
    {
        {       0,        0},     /* Filter 5 */
        {      20,       -6},
        {     -73,     -120},
        {      79,      -79},
        {    -100,      -61},
        {      49,     -151},
        {    -196,      -15},
        {     -63,     -401},
        {    -242,      100},
        {    -820,    -1129},
        {     745,     -873},
        {   -1781,     -907},
        {    1653,    -6888},
        {   10792,        0},
        {    2406,    10024},
        {   -5356,     2729},
        {    -718,     -841},
        {    -831,     1145},
        {   -1108,     -459},
        {       7,      -44},
        {    -418,       32},
        {     -32,     -100},
        {    -158,       97},
        {     -49,      -49},
        {     -74,      121},
        {    -108,      -35},
        {      -4,       51}
    },
    {
        {       0,        0},     /* Filter 6 */
        {      16,       -5},
        {     -74,     -121},
        {      77,      -77},
        {    -104,      -63},
        {      47,     -147},
        {    -205,      -16},
        {     -63,     -398},
        {    -264,      109},
        {    -830,    -1142},
        {     723,     -847},
        {   -1866,     -951},
        {    1678,    -6989},
        {   10830,        0},
        {    2392,     9967},
        {   -5259,     2679},
        {    -664,     -777},
        {    -843,     1160},
        {   -1088,     -450},
        {       3,      -24},
        {    -417,       32},
        {     -29,      -92},
        {    -160,       98},
        {     -45,      -45},
        {     -75,      123},
        {    -105,      -34},
        {      -4,       54}
    },
    {
        {       0,        0},     /* Filter 7 */
        {      13,       -4},
        {     -75,     -123},
        {      74,      -74},
        {    -108,      -66},
        {      46,     -143},
        {    -214,      -16},
        {     -62,     -394},
        {    -285,      118},
        {    -839,    -1155},
        {     700,     -820},
        {   -1951,     -994},
        {    1702,    -7090},
        {   10866,        0},
        {    2378,     9908},
        {   -5161,     2630},
        {    -610,     -715},
        {    -854,     1175},
        {   -1067,     -442},
        {       0,       -5},
        {    -416,       32},
        {     -27,      -83},
        {    -161,       98},
        {     -41,      -41},
        {     -76,      125},
        {    -102,      -33},
        {      -4,       56}
    },
    {
        {       0,        0},     /* Filter 8 */
        {      10,       -3},
        {     -76,     -125},
        {      72,      -72},
        {    -111,      -68},
        {      45,     -139},
        {    -222,      -17},
        {     -61,     -389},
        {    -307,      127},
        {    -848,    -1167},
        {     676,     -792},
        {   -2038,    -1038},
        {    1726,    -7190},
        {   10900,        0},
        {    2364,     9848},
        {   -5064,     2580},
        {    -558,     -653},
        {    -864,     1189},
        {   -1046,     -433},
        {      -2,       13},
        {    -414,       32},
        {     -24,      -75},
        {    -162,       99},
        {     -38,      -38},
        {     -77,      127},
        {     -99,      -32},
        {      -4,       59}
    },
    {
        {       0,        0},     /* Filter 9 */
        {       6,       -2},
        {     -77,     -127},
        {      69,      -69},
        {    -115,      -70},
        {      43,     -135},
        {    -231,      -18},
        {     -60,     -384},
        {    -330,      136},
        {    -857,    -1179},
        {     652,     -763},
        {   -2125,    -1082},
        {    1750,    -7290},
        {   10932,        0},
        {    2349,     9786},
        {   -4966,     2530},
        {    -506,     -592},
        {    -873,     1202},
        {   -1025,     -424},
        {      -5,       31},
        {    -412,       32},
        {     -21,      -66},
        {    -162,       99},
        {     -34,      -34},
        {     -78,      128},
        {     -96,      -31},
        {      -4,       62}
    },
    {
        {       0,        0},     /* Filter 10 */
        {       3,       -1},
        {     -78,     -128},
        {      66,      -66},
        {    -118,      -72},
        {      42,     -130},
        {    -240,      -18},
        {     -60,     -379},
        {    -352,      146},
        {    -865,    -1191},
        {     626,     -733},
        {   -2212,    -1127},
        {    1774,    -7389},
        {   10962,        0},
        {    2334,     9723},
        {   -4868,     2480},
        {    -455,     -533},
        {    -881,     1213},
        {   -1003,     -415},
        {      -7,       49},
        {    -410,       32},
        {     -18,      -58},
        {    -163,      100},
        {     -30,      -30},
        {     -79,      130},
        {     -93,      -30},
        {      -5,       64}
    },
    {
        {       0,        0},     /* Filter 11 */
        {       0,        0},
        {     -79,     -130},
        {      63,      -63},
        {    -122,      -74},
        {      41,     -126},
        {    -248,      -19},
        {     -59,     -373},
        {    -375,      155},
        {    -873,    -1201},
        {     599,     -702},
        {   -2301,    -1172},
        {    1797,    -7487},
        {   10990,        0},
        {    2318,     9658},
        {   -4770,     2430},
        {    -405,     -474},
        {    -889,     1224},
        {    -981,     -406},
        {     -10,       67},
        {    -407,       32},
        {     -16,      -49},
        {    -164,      100},
        {     -27,      -27},
        {     -80,      131},
        {     -90,      -29},
        {      -5,       66}
    },
    {
        {       0,        0},     /* Filter 12 */
        {      -3,        1},
        {     -80,     -131},
        {      60,      -60},
        {    -125,      -76},
        {      39,     -121},
        {    -257,      -20},
        {     -58,     -367},
        {    -398,      164},
        {    -880,    -1211},
        {     572,     -670},
        {   -2390,    -1217},
        {    1820,    -7584},
        {   11016,        0},
        {    2302,     9591},
        {   -4672,     2380},
        {    -355,     -416},
        {    -896,     1234},
        {    -959,     -397},
        {     -13,       84},
        {    -405,       31},
        {     -13,      -41},
        {    -164,      100},
        {     -23,      -23},
        {     -81,      133},
        {     -86,      -28},
        {      -5,       69}
    },
    {
        {       0,        0},     /* Filter 13 */
        {      -6,        2},
        {     -81,     -132},
        {      57,      -57},
        {    -128,      -78},
        {      37,     -116},
        {    -265,      -20},
        {     -57,     -361},
        {    -421,      174},
        {    -887,    -1221},
        {     543,     -636},
        {   -2480,    -1263},
        {    1844,    -7680},
        {   11040,        0},
        {    2286,     9523},
        {   -4574,     2330},
        {    -307,     -359},
        {    -903,     1243},
        {    -937,     -388},
        {     -16,      101},
        {    -401,       31},
        {     -10,      -33},
        {    -164,      100},
        {     -19,      -19},
        {     -82,      134},
        {     -83,      -27},
        {      -5,       71}
    },
    {
        {       0,        0},     /* Filter 14 */
        {     -10,        3},
        {     -81,     -133},
        {      54,      -54},
        {    -131,      -80},
        {      36,     -111},
        {    -273,      -21},
        {     -56,     -354},
        {    -444,      183},
        {    -893,    -1230},
        {     514,     -602},
        {   -2570,    -1309},
        {    1866,    -7776},
        {   11062,        0},
        {    2269,     9453},
        {   -4476,     2281},
        {    -259,     -303},
        {    -908,     1251},
        {    -914,     -378},
        {     -18,      118},
        {    -398,       31},
        {      -8,      -25},
        {    -164,      100},
        {     -15,      -15},
        {     -82,      135},
        {     -80,      -26},
        {      -5,       73}
    },
    {
        {       0,        0},     /* Filter 15 */
        {     -13,        4},
        {     -82,     -134},
        {      51,      -51},
        {    -134,      -82},
        {      34,     -105},
        {    -281,      -22},
        {     -54,     -346},
        {    -467,      193},
        {    -899,    -1238},
        {     484,     -567},
        {   -2661,    -1356},
        {    1889,    -7871},
        {   11082,        0},
        {    2252,     9381},
        {   -4378,     2231},
        {    -212,     -248},
        {    -914,     1258},
        {    -891,     -369},
        {     -21,      134},
        {    -394,       31},
        {      -5,      -17},
        {    -164,      100},
        {     -12,      -12},
        {     -83,      136},
        {     -76,      -25},
        {      -5,       75}
    },
    {
        {       0,        0},     /* Filter 16 */
        {     -17,        5},
        {     -83,     -135},
        {      48,      -48},
        {    -137,      -84},
        {      32,     -100},
        {    -289,      -22},
        {     -53,     -338},
        {    -490,      203},
        {    -905,    -1245},
        {     453,     -530},
        {   -2753,    -1402},
        {    1912,    -7964},
        {   11099,        0},
        {    2234,     9309},
        {   -4281,     2181},
        {    -166,     -194},
        {    -918,     1264},
        {    -868,     -359},
        {     -23,      149},
        {    -390,       30},
        {      -3,       -9},
        {    -163,      100},
        {      -8,       -8},
        {     -84,      137},
        {     -73,      -23},
        {      -6,       77}
    },
    {
        {       0,        0},     /* Filter 17 */
        {     -20,        6},
        {     -83,     -136},
        {      45,      -45},
        {    -139,      -85},
        {      30,      -94},
        {    -297,      -23},
        {     -52,     -330},
        {    -514,      213},
        {    -910,    -1252},
        {     421,     -493},
        {   -2845,    -1449},
        {    1934,    -8057},
        {   11115,        0},
        {    2217,     9234},
        {   -4183,     2131},
        {    -120,     -141},
        {    -922,     1269},
        {    -845,     -350},
        {     -26,      164},
        {    -385,       30},
        {       0,       -1},
        {    -163,      100},
        {      -4,       -4},
        {     -84,      137},
        {     -70,      -22},
        {      -6,       79}
    },
    {
        {       0,        0},     /* Filter 18 */
        {     -24,        7},
        {     -84,     -137},
        {      41,      -41},
        {    -142,      -87},
        {      28,      -88},
        {    -305,      -24},
        {     -50,     -321},
        {    -537,      222},
        {    -914,    -1258},
        {     388,     -454},
        {   -2938,    -1497},
        {    1956,    -8149},
        {   11129,        0},
        {    2198,     9158},
        {   -4085,     2081},
        {     -76,      -89},
        {    -925,     1273},
        {    -822,     -340},
        {     -28,      179},
        {    -380,       29},
        {       2,        6},
        {    -162,       99},
        {       0,        0},
        {     -84,      138},
        {     -66,      -21},
        {      -6,       81}
    },
    {
        {       0,        0},     /* Filter 19 */
        {     -27,        9},
        {     -84,     -138},
        {      38,      -38},
        {    -144,      -88},
        {      26,      -82},
        {    -312,      -24},
        {     -49,     -312},
        {    -561,      232},
        {    -918,    -1264},
        {     354,     -415},
        {   -3031,    -1544},
        {    1978,    -8239},
        {   11140,        0},
        {    2180,     9081},
        {   -3988,     2032},
        {     -32,      -38},
        {    -927,     1276},
        {    -798,     -330},
        {     -30,      193},
        {    -375,       29},
        {       4,       13},
        {    -161,       99},
        {       2,        2},
        {     -85,      138},
        {     -63,      -20},
        {      -6,       82}
    },
    {
        {       0,        0},     /* Filter 20 */
        {     -31,       10},
        {     -85,     -138},
        {      34,      -34},
        {    -147,      -90},
        {      24,      -76},
        {    -319,      -25},
        {     -47,     -302},
        {    -585,      242},
        {    -922,    -1269},
        {     319,     -374},
        {   -3125,    -1592},
        {    1999,    -8329},
        {   11149,        0},
        {    2161,     9003},
        {   -3891,     1982},
        {       9,       11},
        {    -929,     1279},
        {    -775,     -321},
        {     -32,      207},
        {    -370,       29},
        {       6,       21},
        {    -160,       98},
        {       6,        6},
        {     -85,      139},
        {     -59,      -19},
        {      -6,       84}
    },
    {
        {       0,        0},     /* Filter 21 */
        {     -34,       11},
        {     -85,     -139},
        {      31,      -31},
        {    -149,      -91},
        {      22,      -70},
        {    -326,      -25},
        {     -46,     -292},
        {    -609,      252},
        {    -924,    -1273},
        {     284,     -332},
        {   -3220,    -1640},
        {    2020,    -8417},
        {   11157,        0},
        {    2142,     8923},
        {   -3794,     1933},
        {      51,       60},
        {    -930,     1280},
        {    -751,     -311},
        {     -35,      221},
        {    -365,       28},
        {       9,       28},
        {    -159,       97},
        {      10,       10},
        {     -85,      139},
        {     -56,      -18},
        {      -6,       85}
    },
    {
        {       0,        0},     /* Filter 22 */
        {     -38,       12},
        {     -85,     -139},
        {      28,      -28},
        {    -151,      -92},
        {      20,      -63},
        {    -333,      -26},
        {     -44,     -281},
        {    -632,      262},
        {    -927,    -1276},
        {     247,     -290},
        {   -3314,    -1689},
        {    2041,    -8505},
        {   11162,        0},
        {    2122,     8842},
        {   -3697,     1884},
        {      92,      108},
        {    -931,     1281},
        {    -727,     -301},
        {     -37,      234},
        {    -359,       28},
        {      11,       35},
        {    -158,       96},
        {      13,       13},
        {     -85,      139},
        {     -52,      -17},
        {      -6,       87}
    },
    {
        {       0,        0},     /* Filter 23 */
        {     -41,       13},
        {     -85,     -139},
        {      24,      -24},
        {    -153,      -93},
        {      18,      -56},
        {    -340,      -26},
        {     -42,     -270},
        {    -656,      271},
        {    -929,    -1278},
        {     210,     -246},
        {   -3410,    -1737},
        {    2062,    -8591},
        {   11165,        0},
        {    2103,     8759},
        {   -3601,     1835},
        {     132,      155},
        {    -931,     1281},
        {    -704,     -291},
        {     -39,      246},
        {    -353,       27},
        {      13,       43},
        {    -156,       96},
        {      17,       17},
        {     -85,      139},
        {     -49,      -15},
        {      -6,       88}
    },
    {
        {       0,        0},     /* Filter 24 */
        {     -45,       14},
        {     -85,     -139},
        {      21,      -21},
        {    -155,      -95},
        {      16,      -50},
        {    -347,      -27},
        {     -40,     -258},
        {    -680,      281},
        {    -930,    -1280},
        {     172,     -201},
        {   -3505,    -1786},
        {    2082,    -8676},
        {   11166,        0},
        {    2082,     8676},
        {   -3505,     1786},
        {     172,      201},
        {    -930,     1280},
        {    -680,     -281},
        {     -40,      258},
        {    -347,       27},
        {      16,       50},
        {    -155,       95},
        {      21,       21},
        {     -85,      139},
        {     -45,      -14},
        {      -7,       89}
    },
    {
        {       0,        0},     /* Filter 25 */
        {     -49,       15},
        {     -85,     -139},
        {      17,      -17},
        {    -156,      -96},
        {      13,      -43},
        {    -353,      -27},
        {     -39,     -246},
        {    -704,      291},
        {    -931,    -1281},
        {     132,     -155},
        {   -3601,    -1835},
        {    2103,    -8759},
        {   11165,        0},
        {    2062,     8591},
        {   -3410,     1737},
        {     210,      246},
        {    -929,     1278},
        {    -656,     -271},
        {     -42,      270},
        {    -340,       26},
        {      18,       56},
        {    -153,       93},
        {      24,       24},
        {     -85,      139},
        {     -41,      -13},
        {      -7,       91}
    },
    {
        {       0,        0},     /* Filter 26 */
        {     -52,       17},
        {     -85,     -139},
        {      13,      -13},
        {    -158,      -96},
        {      11,      -35},
        {    -359,      -28},
        {     -37,     -234},
        {    -727,      301},
        {    -931,    -1281},
        {      92,     -108},
        {   -3697,    -1884},
        {    2122,    -8842},
        {   11162,        0},
        {    2041,     8505},
        {   -3314,     1689},
        {     247,      290},
        {    -927,     1276},
        {    -632,     -262},
        {     -44,      281},
        {    -333,       26},
        {      20,       63},
        {    -151,       92},
        {      28,       28},
        {     -85,      139},
        {     -38,      -12},
        {      -7,       92}
    },
    {
        {       0,        0},     /* Filter 27 */
        {     -56,       18},
        {     -85,     -139},
        {      10,      -10},
        {    -159,      -97},
        {       9,      -28},
        {    -365,      -28},
        {     -35,     -221},
        {    -751,      311},
        {    -930,    -1280},
        {      51,      -60},
        {   -3794,    -1933},
        {    2142,    -8923},
        {   11157,        0},
        {    2020,     8417},
        {   -3220,     1640},
        {     284,      332},
        {    -924,     1273},
        {    -609,     -252},
        {     -46,      292},
        {    -326,       25},
        {      22,       70},
        {    -149,       91},
        {      31,       31},
        {     -85,      139},
        {     -34,      -11},
        {      -7,       93}
    },
    {
        {       0,        0},     /* Filter 28 */
        {     -59,       19},
        {     -85,     -139},
        {       6,       -6},
        {    -160,      -98},
        {       6,      -21},
        {    -370,      -29},
        {     -32,     -207},
        {    -775,      321},
        {    -929,    -1279},
        {       9,      -11},
        {   -3891,    -1982},
        {    2161,    -9003},
        {   11149,        0},
        {    1999,     8329},
        {   -3125,     1592},
        {     319,      374},
        {    -922,     1269},
        {    -585,     -242},
        {     -47,      302},
        {    -319,       25},
        {      24,       76},
        {    -147,       90},
        {      34,       34},
        {     -85,      138},
        {     -31,      -10},
        {      -7,       94}
    },
    {
        {       0,        0},     /* Filter 29 */
        {     -63,       20},
        {     -85,     -138},
        {       2,       -2},
        {    -161,      -99},
        {       4,      -13},
        {    -375,      -29},
        {     -30,     -193},
        {    -798,      330},
        {    -927,    -1276},
        {     -32,       38},
        {   -3988,    -2032},
        {    2180,    -9081},
        {   11140,        0},
        {    1978,     8239},
        {   -3031,     1544},
        {     354,      415},
        {    -918,     1264},
        {    -561,     -232},
        {     -49,      312},
        {    -312,       24},
        {      26,       82},
        {    -144,       88},
        {      38,       38},
        {     -84,      138},
        {     -27,       -9},
        {      -7,       94}
    },
    {
        {       0,        0},     /* Filter 30 */
        {     -66,       21},
        {     -84,     -138},
        {       0,        0},
        {    -162,      -99},
        {       2,       -6},
        {    -380,      -29},
        {     -28,     -179},
        {    -822,      340},
        {    -925,    -1273},
        {     -76,       89},
        {   -4085,    -2081},
        {    2198,    -9158},
        {   11129,        0},
        {    1956,     8149},
        {   -2938,     1497},
        {     388,      454},
        {    -914,     1258},
        {    -537,     -222},
        {     -50,      321},
        {    -305,       24},
        {      28,       88},
        {    -142,       87},
        {      41,       41},
        {     -84,      137},
        {     -24,       -7},
        {      -7,       95}
    },
    {
        {       0,        0},     /* Filter 31 */
        {     -70,       22},
        {     -84,     -137},
        {      -4,        4},
        {    -163,     -100},
        {       0,        1},
        {    -385,      -30},
        {     -26,     -164},
        {    -845,      350},
        {    -922,    -1269},
        {    -120,      141},
        {   -4183,    -2131},
        {    2217,    -9234},
        {   11115,        0},
        {    1934,     8057},
        {   -2845,     1449},
        {     421,      493},
        {    -910,     1252},
        {    -514,     -213},
        {     -52,      330},
        {    -297,       23},
        {      30,       94},
        {    -139,       85},
        {      45,       45},
        {     -83,      136},
        {     -20,       -6},
        {      -7,       96}
    },
    {
        {       0,        0},     /* Filter 32 */
        {     -73,       23},
        {     -84,     -137},
        {      -8,        8},
        {    -163,     -100},
        {      -3,        9},
        {    -390,      -30},
        {     -23,     -149},
        {    -868,      359},
        {    -918,    -1264},
        {    -166,      194},
        {   -4281,    -2181},
        {    2234,    -9309},
        {   11099,        0},
        {    1912,     7964},
        {   -2753,     1402},
        {     453,      530},
        {    -905,     1245},
        {    -490,     -203},
        {     -53,      338},
        {    -289,       22},
        {      32,      100},
        {    -137,       84},
        {      48,       48},
        {     -83,      135},
        {     -17,       -5},
        {      -7,       96}
    },
    {
        {       0,        0},     /* Filter 33 */
        {     -76,       25},
        {     -83,     -136},
        {     -12,       12},
        {    -164,     -100},
        {      -5,       17},
        {    -394,      -31},
        {     -21,     -134},
        {    -891,      369},
        {    -914,    -1258},
        {    -212,      248},
        {   -4378,    -2231},
        {    2252,    -9381},
        {   11082,        0},
        {    1889,     7871},
        {   -2661,     1356},
        {     484,      567},
        {    -899,     1238},
        {    -467,     -193},
        {     -54,      346},
        {    -281,       22},
        {      34,      105},
        {    -134,       82},
        {      51,       51},
        {     -82,      134},
        {     -13,       -4},
        {      -7,       97}
    },
    {
        {       0,        0},     /* Filter 34 */
        {     -80,       26},
        {     -82,     -135},
        {     -15,       15},
        {    -164,     -100},
        {      -8,       25},
        {    -398,      -31},
        {     -18,     -118},
        {    -914,      378},
        {    -908,    -1251},
        {    -259,      303},
        {   -4476,    -2281},
        {    2269,    -9453},
        {   11062,        0},
        {    1866,     7776},
        {   -2570,     1309},
        {     514,      602},
        {    -893,     1230},
        {    -444,     -183},
        {     -56,      354},
        {    -273,       21},
        {      36,      111},
        {    -131,       80},
        {      54,       54},
        {     -81,      133},
        {     -10,       -3},
        {      -7,       97}
    },
    {
        {       0,        0},     /* Filter 35 */
        {     -83,       27},
        {     -82,     -134},
        {     -19,       19},
        {    -164,     -100},
        {     -10,       33},
        {    -401,      -31},
        {     -16,     -101},
        {    -937,      388},
        {    -903,    -1243},
        {    -307,      359},
        {   -4574,    -2330},
        {    2286,    -9523},
        {   11040,        0},
        {    1844,     7680},
        {   -2480,     1263},
        {     543,      636},
        {    -887,     1221},
        {    -421,     -174},
        {     -57,      361},
        {    -265,       20},
        {      37,      116},
        {    -128,       78},
        {      57,       57},
        {     -81,      132},
        {      -6,       -2},
        {      -7,       97}
    },
    {
        {       0,        0},     /* Filter 36 */
        {     -86,       28},
        {     -81,     -133},
        {     -23,       23},
        {    -164,     -100},
        {     -13,       41},
        {    -405,      -31},
        {     -13,      -84},
        {    -959,      397},
        {    -896,    -1234},
        {    -355,      416},
        {   -4672,    -2380},
        {    2302,    -9591},
        {   11016,        0},
        {    1820,     7584},
        {   -2390,     1217},
        {     572,      670},
        {    -880,     1211},
        {    -398,     -164},
        {     -58,      367},
        {    -257,       20},
        {      39,      121},
        {    -125,       76},
        {      60,       60},
        {     -80,      131},
        {      -3,       -1},
        {      -7,       98}
    },
    {
        {       0,        0},     /* Filter 37 */
        {     -90,       29},
        {     -80,     -131},
        {     -27,       27},
        {    -164,     -100},
        {     -16,       49},
        {    -407,      -32},
        {     -10,      -67},
        {    -981,      406},
        {    -889,    -1224},
        {    -405,      474},
        {   -4770,    -2430},
        {    2318,    -9658},
        {   10990,        0},
        {    1797,     7487},
        {   -2301,     1172},
        {     599,      702},
        {    -873,     1201},
        {    -375,     -155},
        {     -59,      373},
        {    -248,       19},
        {      41,      126},
        {    -122,       74},
        {      63,       63},
        {     -79,      130},
        {       0,        0},
        {      -7,       98}
    },
    {
        {       0,        0},     /* Filter 38 */
        {     -93,       30},
        {     -79,     -130},
        {     -30,       30},
        {    -163,     -100},
        {     -18,       58},
        {    -410,      -32},
        {      -7,      -49},
        {   -1003,      415},
        {    -881,    -1213},
        {    -455,      533},
        {   -4868,    -2480},
        {    2334,    -9723},
        {   10962,        0},
        {    1774,     7389},
        {   -2212,     1127},
        {     626,      733},
        {    -865,     1191},
        {    -352,     -146},
        {     -60,      379},
        {    -240,       18},
        {      42,      130},
        {    -118,       72},
        {      66,       66},
        {     -78,      128},
        {       3,        1},
        {      -7,       98}
    },
    {
        {       0,        0},     /* Filter 39 */
        {     -96,       31},
        {     -78,     -128},
        {     -34,       34},
        {    -162,      -99},
        {     -21,       66},
        {    -412,      -32},
        {      -5,      -31},
        {   -1025,      424},
        {    -873,    -1202},
        {    -506,      592},
        {   -4966,    -2530},
        {    2349,    -9786},
        {   10932,        0},
        {    1750,     7290},
        {   -2125,     1082},
        {     652,      763},
        {    -857,     1179},
        {    -330,     -136},
        {     -60,      384},
        {    -231,       18},
        {      43,      135},
        {    -115,       70},
        {      69,       69},
        {     -77,      127},
        {       6,        2},
        {      -7,       98}
    },
    {
        {       0,        0},     /* Filter 40 */
        {     -99,       32},
        {     -77,     -127},
        {     -38,       38},
        {    -162,      -99},
        {     -24,       75},
        {    -414,      -32},
        {      -2,      -13},
        {   -1046,      433},
        {    -864,    -1189},
        {    -558,      653},
        {   -5064,    -2580},
        {    2364,    -9848},
        {   10900,        0},
        {    1726,     7190},
        {   -2038,     1038},
        {     676,      792},
        {    -848,     1167},
        {    -307,     -127},
        {     -61,      389},
        {    -222,       17},
        {      45,      139},
        {    -111,       68},
        {      72,       72},
        {     -76,      125},
        {      10,        3},
        {      -7,       98}
    },
    {
        {       0,        0},     /* Filter 41 */
        {    -102,       33},
        {     -76,     -125},
        {     -41,       41},
        {    -161,      -98},
        {     -27,       83},
        {    -416,      -32},
        {       0,        5},
        {   -1067,      442},
        {    -854,    -1175},
        {    -610,      715},
        {   -5161,    -2630},
        {    2378,    -9908},
        {   10866,        0},
        {    1702,     7090},
        {   -1951,      994},
        {     700,      820},
        {    -839,     1155},
        {    -285,     -118},
        {     -62,      394},
        {    -214,       16},
        {      46,      143},
        {    -108,       66},
        {      74,       74},
        {     -75,      123},
        {      13,        4},
        {      -7,       97}
    },
    {
        {       0,        0},     /* Filter 42 */
        {    -105,       34},
        {     -75,     -123},
        {     -45,       45},
        {    -160,      -98},
        {     -29,       92},
        {    -417,      -32},
        {       3,       24},
        {   -1088,      450},
        {    -843,    -1160},
        {    -664,      777},
        {   -5259,    -2679},
        {    2392,    -9967},
        {   10830,        0},
        {    1678,     6989},
        {   -1866,      951},
        {     723,      847},
        {    -830,     1142},
        {    -264,     -109},
        {     -63,      398},
        {    -205,       16},
        {      47,      147},
        {    -104,       63},
        {      77,       77},
        {     -74,      121},
        {      16,        5},
        {      -7,       97}
    },
    {
        {       0,        0},     /* Filter 43 */
        {    -108,       35},
        {     -74,     -121},
        {     -49,       49},
        {    -158,      -97},
        {     -32,      100},
        {    -418,      -32},
        {       7,       44},
        {   -1108,      459},
        {    -831,    -1145},
        {    -718,      841},
        {   -5356,    -2729},
        {    2406,   -10024},
        {   10792,        0},
        {    1653,     6888},
        {   -1781,      907},
        {     745,      873},
        {    -820,     1129},
        {    -242,     -100},
        {     -63,      401},
        {    -196,       15},
        {      49,      151},
        {    -100,       61},
        {      79,       79},
        {     -73,      120},
        {      20,        6},
        {      -7,       97}
    },
    {
        {       0,        0},     /* Filter 44 */
        {    -111,       36},
        {     -73,     -119},
        {     -52,       52},
        {    -157,      -96},
        {     -35,      109},
        {    -418,      -32},
        {      10,       64},
        {   -1128,      467},
        {    -819,    -1128},
        {    -773,      905},
        {   -5453,    -2778},
        {    2419,   -10079},
        {   10753,        0},
        {    1629,     6786},
        {   -1698,      865},
        {     767,      898},
        {    -810,     1115},
        {    -221,      -91},
        {     -64,      404},
        {    -187,       14},
        {      50,      154},
        {     -96,       59},
        {      82,       82},
        {     -72,      118},
        {      23,        7},
        {      -7,       96}
    },
    {
        {       0,        0},     /* Filter 45 */
        {    -114,       37},
        {     -71,     -117},
        {     -56,       56},
        {    -155,      -95},
        {     -38,      118},
        {    -418,      -32},
        {      13,       84},
        {   -1148,      475},
        {    -806,    -1110},
        {    -828,      970},
        {   -5550,    -2828},
        {    2432,   -10132},
        {   10711,        0},
        {    1604,     6683},
        {   -1615,      823},
        {     787,      922},
        {    -799,     1101},
        {    -199,      -82},
        {     -64,      407},
        {    -178,       14},
        {      51,      157},
        {     -92,       56},
        {      84,       84},
        {     -71,      116},
        {      26,        8},
        {      -7,       96}
    },
    {
        {       0,        0},     /* Filter 46 */
        {    -116,       38},
        {     -70,     -115},
        {     -59,       59},
        {    -153,      -94},
        {     -41,      126},
        {    -418,      -32},
        {      16,      105},
        {   -1167,      483},
        {    -793,    -1091},
        {    -885,     1036},
        {   -5647,    -2877},
        {    2445,   -10184},
        {   10667,        0},
        {    1579,     6580},
        {   -1533,      781},
        {     807,      944},
        {    -789,     1086},
        {    -179,      -74},
        {     -64,      409},
        {    -169,       13},
        {      52,      161},
        {     -88,       54},
        {      87,       87},
        {     -69,      113},
        {      29,        9},
        {      -7,       95}
    },
    {
        {       0,        0},     /* Filter 47 */
        {    -119,       38},
        {     -69,     -112},
        {     -63,       63},
        {    -151,      -92},
        {     -44,      135},
        {    -418,      -32},
        {      20,      126},
        {   -1186,      491},
        {    -778,    -1071},
        {    -942,     1103},
        {   -5743,    -2926},
        {    2457,   -10234},
        {   10621,        0},
        {    1554,     6476},
        {   -1452,      739},
        {     825,      966},
        {    -778,     1070},
        {    -158,      -65},
        {     -65,      411},
        {    -160,       12},
        {      53,      163},
        {     -84,       51},
        {      89,       89},
        {     -68,      111},
        {      32,       10},
        {      -7,       94}
    }
};
